/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.flow;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.pd.web.dto.PdSpFlowDTO;
import com.kingdee.shr.pd.web.enums.PdFlowStatusEnum;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdStatusEnum;
import com.kingdee.shr.pd.web.handler.flow.PdFlowListHandler;
import com.kingdee.shr.pd.web.util.PdUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class PdFlowListHandler4MyStart
extends PdFlowListHandler {
    private static final String LOG_HEAD = "wdpd_" + PdFlowListHandler4MyStart.class.getSimpleName() + "_";

    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        FilterInfo filterInfo = new FilterInfo();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        String personId = userInfo.getPerson().getId().toString();
        String existsSql = "select 1 from CT_MP_pdSpFlowNote n,CT_MP_PdSpFlowNoteHandler h where n.FID = h.CFspFlowNoteId and n.CFISFIRST = 1 and h.CFPERSONID = '" + personId + "' and n.CFSPFLOWID = \"T0\".fid ";
        filterInfo.getFilterItems().add(new FilterItemInfo("ID", (Object)existsSql, CompareType.EXISTS));
        return filterInfo;
    }

    public void myStartDeleteAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        Set<String> flowIdSet = PdUtil.split(request.getParameter("ids"));
        this.checkDelete(flowIdSet);
        this.doDel(flowIdSet);
        this.success();
    }

    public void myStartDeleteCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Set<String> idSet = PdUtil.split(request.getParameter("ids"));
        this.checkDelete(idSet);
        this.success();
    }

    private void checkDelete(Set<String> flowIdSet) throws ShrWebBizException {
        Map<String, PdSpFlowDTO> flowMap = this.checkNotNull(flowIdSet);
        for (String id : flowIdSet) {
            if (!this.person_id.equals(flowMap.get(id).getPid())) {
                throw new ShrWebBizException("\u767b\u5f55\u4eba\u975e\u6d41\u7a0b\u521b\u5efa\u4eba\uff01");
            }
            if (!PdFlowStatusEnum.editable().stream().noneMatch(e -> e.getValue().equals(((PdSpFlowDTO)flowMap.get(id)).getStatus()))) continue;
            throw new ShrWebBizException(PdFlowStatusEnum.editable().stream().map(PdFlowStatusEnum::getAlias).collect(Collectors.joining("\u3001")) + "\u72b6\u6001\uff0c\u624d\u53ef\u4ee5\u5220\u9664\uff01");
        }
    }

    private void doDel(Set<String> flowIdSet) throws BOSException, SQLException {
        String flowIdStr = PdUtil.in(flowIdSet);
        String updatePdSql = "/*dialect*/ update CT_MP_pdPerson    set CFSTATUS = '" + PdSpFlowPdStatusEnum.EVALUATED.getValue() + "', " + "       FLASTUPDATEUSERID = '" + this.user_id + "', " + "       FLASTUPDATETIME = sysdate " + "where FID in (select flowPd.CFPDID from CT_MP_pdSpFlowPd flowPd where flowPd.CFSPFLOWID in (" + flowIdStr + ")) ";
        String delHandlerSql = "/*dialect*/ delete from CT_MP_PdSpFlowNoteHandler h where h.CFspFlowNoteId in (select n.FID from CT_MP_pdSpFlowNote n where n.CFSPFLOWID in (" + flowIdStr + "))";
        String delNoteSql = "/*dialect*/ delete from CT_MP_pdSpFlowNote where CFSPFLOWID in (" + flowIdStr + ")";
        String delFlowPdSql = "/*dialect*/ delete from CT_MP_pdSpFlowPd where CFSPFLOWID in (" + flowIdStr + ")";
        String delFlowSql = "/*dialect*/ delete from CT_MP_pdSpFlow where FID in (" + flowIdStr + ")";
        ArrayList stmsSql = Lists.newArrayList((Object[])new String[]{updatePdSql, delHandlerSql, delNoteSql, delFlowPdSql, delFlowSql});
        this.component.tx(stmsSql, null);
    }
}

