/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.group;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.pd.web.dto.group.PdGroupDTO;
import com.kingdee.shr.pd.web.enums.PdSortGroupStatusEnum;
import com.kingdee.shr.pd.web.server.PdSpComponent;
import com.kingdee.shr.pd.web.util.PdUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.ui.ModelMap;

public class PdGroupListHandler
extends ListHandler {
    private static final String LOG_HEAD = "wdpd_" + PdGroupListHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final String user_id = this.ctx.getCaller().toString();
    private final PdSpComponent component = new PdSpComponent(this.ctx);

    public void qyAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Set<String> ids = PdUtil.split(request.getParameter("ids"));
        this.doUpdate(ids, PdSortGroupStatusEnum.ENALBE);
        HashMap result2 = Maps.newHashMap();
        this.writeSuccessData(result2);
    }

    private void doUpdate(Set<String> ids, PdSortGroupStatusEnum target) throws ShrWebBizException {
        String selectSql = "select FID id, FNAME_L2 name, CFSTATUS status from CT_MP_PdGroupConfig where FID in (" + PdUtil.in(ids) + ")";
        List<PdGroupDTO> list = this.component.selectList(selectSql, PdGroupDTO.class);
        if (CollectionUtils.isEmpty(list)) {
            throw new ShrWebBizException("\u7fa4\u4f53\u4e0d\u5b58\u5728\uff01");
        }
        Map<String, PdGroupDTO> map = list.stream().collect(Collectors.toMap(PdGroupDTO::getId, v -> v, (v1, v2) -> v2));
        for (String id : ids) {
            PdGroupDTO dto = map.get(id);
            if (dto == null) {
                throw new ShrWebBizException("\u7fa4\u4f53\u4e0d\u5b58\u5728\uff01" + id);
            }
            if (!target.getValue().equals(dto.getStatus())) continue;
            throw new ShrWebBizException(dto.getName() + "\uff0c\u7fa4\u4f53\u5df2" + target.getAlias());
        }
        String updateSql = "/*dialect*/ update CT_MP_PdGroupConfig set CFSTATUS = '" + target.getValue() + "', FLASTUPDATEUSERID = '" + this.user_id + "', FLASTUPDATETIME = sysdate where FID in (" + PdUtil.in(ids) + ")";
        try {
            DbUtil.execute((Context)this.ctx, (String)updateSql);
        }
        catch (Exception e) {
            throw new ShrWebBizException("\u6267\u884c\u66f4\u65b0\u5f02\u5e38 e = " + e.getMessage());
        }
    }

    public void jyAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        Set<String> ids = PdUtil.split(request.getParameter("ids"));
        this.doUpdate(ids, PdSortGroupStatusEnum.DISABLE);
        HashMap result2 = Maps.newHashMap();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }
}

