/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.pjr;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.pd.web.dto.EffectResult;
import com.kingdee.shr.pd.web.dto.PdFlowNoticeDTO;
import com.kingdee.shr.pd.web.dto.PdPjPdDTO;
import com.kingdee.shr.pd.web.dto.PdSortGroupDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteHandlerDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowPdDTO;
import com.kingdee.shr.pd.web.dto.PdStaffDTO;
import com.kingdee.shr.pd.web.dto.PdSubmitEffectDTO;
import com.kingdee.shr.pd.web.dto.req.PdSubmitEffectRequestDTO;
import com.kingdee.shr.pd.web.dto.req.PdSubmitSpRequestDTO;
import com.kingdee.shr.pd.web.dto.req.inner.PdSortGroupRequestDTO;
import com.kingdee.shr.pd.web.enums.PdFlowFromEnum;
import com.kingdee.shr.pd.web.enums.PdFlowStatusEnum;
import com.kingdee.shr.pd.web.enums.PdFlowXpCommentEnum;
import com.kingdee.shr.pd.web.enums.PdNoteStatusEnum;
import com.kingdee.shr.pd.web.enums.PdNoticeContentEnum;
import com.kingdee.shr.pd.web.enums.PdSortGroupStatusEnum;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdResultEnum;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdStatusEnum;
import com.kingdee.shr.pd.web.rule.PdRule;
import com.kingdee.shr.pd.web.rule.PdRuleResult;
import com.kingdee.shr.pd.web.server.PdSpComponent;
import com.kingdee.shr.pd.web.util.PdUtil;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public class PdPjrSubmitEffectListHandler
extends ListHandler {
    private static final String LOG_HEAD = "wdpd_" + PdPjrSubmitEffectListHandler.class.getSimpleName() + "_";
    private static final String FLOW_NAME_TEMPLATE = "\u8bf7\u5ba1\u6279[{0}]\u63d0\u4ea4\u7684[{1}]\u7fa4\u4f53\u7279\u6b8a\u6d41\u7a0b\u7533\u8bf7";
    private static final String BOSTYPE_FLOW = "53A7C40F";
    private static final String BOSTYPE_FLOW_NOTE = "F31E48A1";
    private static final String BOSTYPE_FLOW_NOTE_HANDLER = "24E1DF69";
    private static final String BOSTYPE_FLOW_PD = "08C70663";
    private static final Map<String, String> DICT = Maps.newHashMap();
    private final Context ctx = SHRContext.getInstance().getContext();
    private final String person_id = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString();
    private final String person_name = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getName();
    private final String user_id = this.ctx.getCaller().toString();
    private final String user_name = ContextUtil.getCurrentUserInfo((Context)this.ctx).getName();
    private final PdSpComponent component = new PdSpComponent(this.ctx);

    protected void afterGetListData(HttpServletRequest request, HttpServletResponse response, GridDataEntity gridDataEntity) throws SHRWebException {
        this.setData(gridDataEntity);
        super.afterGetListData(request, response, gridDataEntity);
    }

    private void setData(GridDataEntity gridDataEntity) {
        List rowsData;
        if (gridDataEntity != null && CollectionUtils.isNotEmpty((Collection)(rowsData = gridDataEntity.getRows()))) {
            int i = 1;
            for (Map rowData : rowsData) {
                rowData.put("SN", String.valueOf(i++));
            }
        }
    }

    public void effectAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        Set<String> ids = PdUtil.split(request.getParameter("ids"));
        List<PdPjPdDTO> pdList = this.initData(ids);
        this.checkNotNull(ids, pdList);
        this.checkBiz(pdList);
        EffectResult effectResult = this.submitEffect(pdList);
        HashMap result2 = Maps.newHashMap();
        result2.put("result", "200");
        result2.put("ruleCode", effectResult.getIsAllPass());
        result2.put("ruleData", effectResult.getFailRuleList());
        result2.put("ids", effectResult.getNotPassPdList().stream().map(PdPjPdDTO::getPdId).collect(Collectors.joining(",")));
        this.writeSuccessData(result2);
    }

    private EffectResult submitEffect(List<PdPjPdDTO> pdList) throws BOSException, SQLException {
        ArrayList ruleList = Lists.newArrayList();
        ArrayList success = Lists.newArrayList();
        ArrayList failure = Lists.newArrayList();
        Map gid2PdResultsMap = pdList.stream().collect(Collectors.groupingBy(PdPjPdDTO::getGid, Collectors.mapping(PdPjPdDTO::getPdResult, Collectors.toList())));
        gid2PdResultsMap.forEach((gid, pdResults) -> {
            PdRuleResult ruleResult = PdRule.execute(gid, DICT.get(gid), pdResults);
            if (ruleResult.isPass()) {
                success.add(gid);
            } else {
                ruleList.add(ruleResult);
                failure.add(gid);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)success)) {
            List<PdPjPdDTO> list = pdList.stream().filter(pd -> success.contains(pd.getGid())).collect(Collectors.toList());
            this.component.tx(null, this.component.collectUpdatePdStatusMap(list));
        }
        EffectResult effectResult = new EffectResult();
        effectResult.setNotPassPdList(pdList.stream().filter(pd -> failure.contains(pd.getGid())).collect(Collectors.toList()));
        effectResult.setFailRuleList(ruleList);
        effectResult.setIsAllPass(CollectionUtils.isEmpty((Collection)ruleList) ? "1" : "0");
        return effectResult;
    }

    public void effectCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String reqData = request.getParameter("reqData");
        List reqList = JSON.parseArray((String)reqData, PdSubmitEffectRequestDTO.class);
        if (this.doSvae(reqList)) {
            Set<String> ids = reqList.stream().map(PdSubmitEffectRequestDTO::getId).collect(Collectors.toSet());
            List<PdPjPdDTO> pdList = this.initData(ids);
            this.checkNotNull(ids, pdList);
            this.checkBiz(pdList);
        }
        this.success();
    }

    private boolean doSvae(List<PdSubmitEffectRequestDTO> list) throws ShrWebBizException {
        if (this.checkForSave(list)) {
            String sql = "/*dialect*/ UPDATE CT_MP_PDPERSON SET CFSTATUS          = '" + PdSpFlowPdStatusEnum.EVALUATED.getValue() + "', " + "    CFRESULT          = ?, " + "    CFRESULT_EXPLAIN  = ?, " + "    CFXP_IDEA         = ?, " + "    CFXP_IDEA_EXPLAIN = ?, " + "    CFLast_result     = ?, " + "    CFLast_xp_idea    = ?, " + "    FLASTUPDATEUSERID='" + this.user_id + "', " + "    FLASTUPDATETIME   = sysdate " + "WHERE FID = ?";
            ArrayList params = Lists.newArrayList();
            list.forEach(dto -> params.add(new Object[]{dto.getPdResult(), dto.getPdResultDesc(), dto.getXpIdea(), dto.getXpIdeaDesc(), PdSpFlowPdResultEnum.aliasOf(dto.getPdResult()), PdFlowXpCommentEnum.aliasOf(dto.getXpIdea()), dto.getId()}));
            try {
                DbUtil.executeBatch((Context)this.ctx, (String)sql, (List)params);
            }
            catch (Exception e) {
                throw new ShrWebBizException("\u4fdd\u5b58\u6570\u636e\u5f02\u5e38\uff01 e = " + e.getMessage());
            }
        }
        return true;
    }

    private boolean checkForSave(List<PdSubmitEffectRequestDTO> list) throws ShrWebBizException {
        if (CollectionUtils.isEmpty(list)) {
            throw new ShrWebBizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        for (PdSubmitEffectRequestDTO dto : list) {
            if (StringUtils.isBlank((String)dto.getId())) {
                throw new ShrWebBizException("\u8bf7\u6c42ID\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((String)dto.getPdResult())) {
                throw new ShrWebBizException("\u76d8\u70b9\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String xpComment = dto.getXpIdea();
            if (StringUtils.isBlank((String)xpComment)) {
                throw new ShrWebBizException("\u7eed\u8058\u5efa\u8bae\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!PdFlowXpCommentEnum.descRequired().stream().anyMatch(e -> e.getValue().equals(xpComment)) || !StringUtils.isBlank((String)dto.getXpIdeaDesc())) continue;
            throw new ShrWebBizException(PdFlowXpCommentEnum.descRequired().stream().map(PdFlowXpCommentEnum::getAlias).collect(Collectors.joining("\u3001")) + "\u7eed\u8058\u5efa\u8bae\uff0c\u7eed\u8058\u5efa\u8bae\u8bf4\u660e\u5fc5\u586b\uff01");
        }
        return true;
    }

    private void success() throws SHRWebException {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private List<PdPjPdDTO> initData(Set<String> reqPdIdSet) {
        String pdSql = "select pd.CFPLAN_MANAGEID schemeId,        pd.FID             pdId,        pd.CFSTATUS        status,        p.FID              pid,        p.FNAME_L2         pname,        g.FID              gid,        g.FNAME_L2         gname,        shr.FID            shrId,        shr.FNAME_L2       shrName,        shr.FNUMBER        shrNumber,        pd.CFPJRID         pjrId,        pd.CFRESULT        pdResult,        pd.CFGrade         pdReferTotalScore from CT_MP_pdPerson pd          left join T_BD_Person p on pd.CFPERSONID = p.FID          left join T_BD_Person shr on pd.CFSHRID = shr.FID          left join CT_MP_pdGroupConfig g on pd.CFSORT_GROUPID = g.FID and g.CFSTATUS = '" + PdSortGroupStatusEnum.ENALBE.getValue() + "' " + "where pd.FID in (" + PdUtil.in(reqPdIdSet) + ")";
        List<PdPjPdDTO> pdList = this.component.selectList(pdSql, PdPjPdDTO.class);
        pdList.forEach(pd -> {
            double score = 0.0;
            try {
                score = Double.parseDouble(pd.getPdReferTotalScore());
            }
            catch (Exception exception) {
                // empty catch block
            }
            pd.setPdReferTotalScoreDouble(score);
        });
        String pdHrSql = "select pdHr.CFPDID pdId, pdHr.CFPERSONID personId, p.FNAME_L2 personName, p.FNUMBER personNumber from CT_MP_PdPersonHr pdHr          left join T_BD_person p on pdHr.CFPERSONID = p.FID where CFPDID in (" + PdUtil.in(reqPdIdSet) + ")";
        List<PdStaffDTO> pdHrList = this.component.selectList(pdHrSql, PdStaffDTO.class);
        Map<String, List<PdStaffDTO>> pdHrMap = pdHrList.stream().collect(Collectors.groupingBy(PdStaffDTO::getPdId));
        pdList.forEach(pd -> pd.setHrList(pdHrMap.getOrDefault(pd.getPdId(), Lists.newArrayList())));
        DICT.putAll(pdList.stream().collect(Collectors.toMap(PdPjPdDTO::getPdId, o -> StringUtils.isNotBlank((String)o.getPname()) ? o.getPname() : "", (k1, k2) -> k1)));
        DICT.putAll(pdList.stream().collect(Collectors.toMap(PdPjPdDTO::getGid, o -> StringUtils.isNotBlank((String)o.getGname()) ? o.getGname() : "", (k1, k2) -> k1)));
        return pdList;
    }

    private void checkNotNull(Set<String> reqPdIdSet, List<PdPjPdDTO> pdList) throws ShrWebBizException {
        if (CollectionUtils.isEmpty(reqPdIdSet)) {
            throw new ShrWebBizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        Map<String, PdPjPdDTO> pdMap = PdUtil.listToMap(pdList, PdPjPdDTO::getPdId);
        HashMap msgMap = Maps.newHashMap();
        reqPdIdSet.forEach(pdId -> {
            HashSet set = Sets.newHashSet();
            PdPjPdDTO pd = (PdPjPdDTO)pdMap.get(pdId);
            if (pd == null) {
                set.add("\u76d8\u70b9\u4e0d\u5b58\u5728");
                msgMap.put(pdId, set);
                return;
            }
            if (StringUtils.isBlank((String)pd.getSchemeId())) {
                set.add("\u76d8\u70b9\u65b9\u6848\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isBlank((String)pd.getGid())) {
                set.add("\u6392\u5e8f\u7fa4\u4f53\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isBlank((String)pd.getPid())) {
                set.add("\u76d8\u70b9\u5458\u5de5\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isBlank((String)pd.getPjrId())) {
                set.add("\u8bc4\u4ef7\u4eba\u4e0d\u5b58\u5728");
            }
            if (CollectionUtils.isEmpty(pd.getHrList())) {
                set.add("Hr\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isBlank((String)pd.getStatus())) {
                set.add("\u72b6\u6001\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isBlank((String)pd.getPdResult())) {
                set.add("\u76d8\u70b9\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            msgMap.put(pdId, set);
        });
        StringBuilder msg = new StringBuilder("");
        for (Map.Entry entry : msgMap.entrySet()) {
            String pdId2 = (String)entry.getKey();
            Set msgSet = (Set)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)msgSet)) continue;
            msg.append(PdUtil.joinCommaEnd(DICT, Sets.newHashSet((Object[])new String[]{pdId2}))).append(Joiner.on((String)"\u3001").join((Iterable)msgSet)).append("\uff01<br>");
        }
        if (StringUtils.isNotBlank((String)msg.toString())) {
            throw new ShrWebBizException(msg.toString());
        }
        if (pdList.stream().map(PdPjPdDTO::getSchemeId).distinct().count() > 1L) {
            throw new ShrWebBizException("\u76d8\u70b9\u4fe1\u606f\u5fc5\u987b\u5f52\u5c5e\u540c\u4e00\u76d8\u70b9\u65b9\u6848\uff01");
        }
    }

    private void checkBiz(List<PdPjPdDTO> pdList) throws ShrWebBizException {
        this.checkPjr(pdList);
        this.checkShr(pdList);
        this.checkStatus(pdList);
        this.checkGroupContains(pdList);
    }

    private void checkPjr(List<PdPjPdDTO> pdList) throws ShrWebBizException {
        HashSet set = Sets.newHashSet();
        pdList.forEach(pd -> {
            if (!pd.getPjrId().equals(this.person_id)) {
                set.add(pd.getPdId());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            throw new ShrWebBizException(PdUtil.joinCommaEnd(DICT, set) + "\u8bc4\u4ef7\u4eba\u975e\u5f53\u524d\u767b\u5f55\u4eba\uff01");
        }
    }

    private void checkShr(List<PdPjPdDTO> pdList) throws ShrWebBizException {
        Map gid2PdListMap = pdList.stream().collect(Collectors.groupingBy(PdPjPdDTO::getGid, Collectors.toList()));
        HashSet set = Sets.newHashSet();
        gid2PdListMap.forEach((k, v) -> {
            if (v.stream().map(PdPjPdDTO::getShrId).distinct().count() > 1L) {
                set.add(k);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            throw new ShrWebBizException("\u6392\u5e8f\u7fa4\u4f53" + PdUtil.joinCommaEnd(DICT, set) + "\u5ba1\u6838\u4eba\u5fc5\u987b\u4e3a\u540c\u4e00\u4e2a\u4eba\u6216\u90fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkStatus(List<PdPjPdDTO> pdList) throws ShrWebBizException {
        HashSet set = Sets.newHashSet();
        ArrayList allowStatus = Lists.newArrayList((Object[])new String[]{PdSpFlowPdStatusEnum.UNEVALUATE.getValue(), PdSpFlowPdStatusEnum.EVALUATED.getValue()});
        pdList.forEach(pd -> {
            if (!allowStatus.contains(pd.getStatus())) {
                set.add(pd.getPdId());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            throw new ShrWebBizException(PdUtil.joinCommaEnd(DICT, set) + "\u672a\u786e\u8ba4\u8bc4\u4ef7!");
        }
    }

    private void checkGroupContains(List<PdPjPdDTO> pdList) throws ShrWebBizException {
        Set<String> gidSet = pdList.stream().map(PdPjPdDTO::getGid).collect(Collectors.toSet());
        String schemeId = pdList.get(0).getSchemeId();
        String selectPdSql = "select pd.FID      pdId,        pd.CFSTATUS status,        p.FNAME_L2  pname,        g.FID       gid,        g.FNAME_L2  gname from CT_MP_pdPerson pd          join CT_MP_pdGroupConfig g on pd.CFSORT_GROUPID = g.FID          left join T_BD_Person p on pd.CFPERSONID = p.FID where pd.CFPJRID = '" + this.person_id + "' " + "   and pd.CFSTATUS in (" + PdUtil.in(Sets.newHashSet((Object[])new String[]{PdSpFlowPdStatusEnum.UNEVALUATE.getValue(), PdSpFlowPdStatusEnum.EVALUATED.getValue()})) + ") " + "   and pd.CFPLAN_MANAGEID = '" + schemeId + "' " + "   and g.FID in (" + PdUtil.in(gidSet) + ") ";
        List<PdPjPdDTO> existPdList = this.component.selectList(selectPdSql, PdPjPdDTO.class);
        DICT.putAll(existPdList.stream().collect(Collectors.toMap(PdPjPdDTO::getPdId, o -> StringUtils.isNotBlank((String)o.getPname()) ? o.getPname() : "", (k1, k2) -> k1)));
        Map gid2PdIdsMap = pdList.stream().collect(Collectors.groupingBy(PdPjPdDTO::getGid, Collectors.mapping(PdPjPdDTO::getPdId, Collectors.toList())));
        Map existGid2PdIdsMap = existPdList.stream().collect(Collectors.groupingBy(PdPjPdDTO::getGid, Collectors.mapping(PdPjPdDTO::getPdId, Collectors.toList())));
        Map<String, String> existPdId2pdStatusMap = existPdList.stream().collect(Collectors.toMap(PdPjPdDTO::getPdId, o -> StringUtils.isNotBlank((String)o.getStatus()) ? o.getStatus() : "", (k1, k2) -> k1));
        HashMap msgMap = Maps.newHashMap();
        gid2PdIdsMap.forEach((gid, pdIdList) -> {
            List shouldExistPdIdList = (List)existGid2PdIdsMap.get(gid);
            if (CollectionUtils.isEmpty((Collection)shouldExistPdIdList)) {
                msgMap.put(gid, "\u4e0d\u5b58\u5728\uff01");
            } else {
                List lessList = ListUtils.removeAll((Collection)shouldExistPdIdList, (Collection)pdIdList);
                if (CollectionUtils.isNotEmpty((Collection)lessList)) {
                    String msg = PdUtil.join(DICT, Sets.newHashSet((Iterable)lessList)) + "\u672a\u52fe\u9009\uff01";
                    List unEvalList = lessList.stream().filter(id -> PdSpFlowPdStatusEnum.UNEVALUATE.getValue().equals(existPdId2pdStatusMap.get(id))).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(unEvalList)) {
                        msg = msg + "\u5458\u5de5" + PdUtil.join(DICT, Sets.newHashSet(unEvalList)) + "\u672a\u8bc4\u4ef7\uff01";
                    }
                    msgMap.put(gid, msg);
                    return;
                }
                List moreList = ListUtils.removeAll((Collection)pdIdList, (Collection)shouldExistPdIdList);
                if (CollectionUtils.isNotEmpty((Collection)moreList)) {
                    msgMap.put(gid, "\u5458\u5de5" + PdUtil.join(DICT, Sets.newHashSet((Iterable)moreList)) + "\u975e\u5f53\u524d\u7fa4\u4f53\uff01");
                }
            }
        });
        if (MapUtils.isNotEmpty((Map)msgMap)) {
            StringBuilder msg = new StringBuilder();
            for (Map.Entry entry : msgMap.entrySet()) {
                msg.append("\u6392\u5e8f\u7fa4\u4f53").append("[").append(DICT.getOrDefault(entry.getKey(), (String)entry.getKey())).append("]\uff0c").append((String)entry.getValue()).append("<br>");
            }
            throw new ShrWebBizException(msg.toString());
        }
    }

    public void spAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        PdSubmitSpRequestDTO reqDTO = this.component.parseJson(request.getParameter("reqData"), PdSubmitSpRequestDTO.class);
        Set<String> reqPdIdSet = PdUtil.toSet(reqDTO.getPdIdList());
        List<PdPjPdDTO> pdList = this.initData(reqPdIdSet);
        this.checkNotNull(reqPdIdSet, pdList);
        this.checkBiz(pdList);
        EffectResult effectResult = this.submitEffect(pdList);
        if ("1".equals(effectResult.getIsAllPass())) {
            this.success();
        } else {
            Map<String, PdSortGroupDTO> existSortGroupMap = this.checkSubmitSp(reqDTO.getSortGroupList());
            Map<String, PdSubmitEffectDTO> submitEffectMap = this.fillUp(reqDTO.getSortGroupList(), existSortGroupMap, effectResult);
            this.doSubmitSp(submitEffectMap, pdList);
            this.success();
        }
    }

    private Map<String, PdSubmitEffectDTO> fillUp(List<PdSortGroupRequestDTO> reqSortGroupList, Map<String, PdSortGroupDTO> existSortGroupMap, EffectResult effectResult) throws ShrWebBizException {
        Map<String, PdRuleResult> failResultMap = PdUtil.listToMap(effectResult.getFailRuleList(), PdRuleResult::getGid);
        Map<String, List<PdPjPdDTO>> pdListMap = effectResult.getNotPassPdList().stream().collect(Collectors.groupingBy(PdPjPdDTO::getGid));
        HashMap result2 = Maps.newHashMap();
        for (PdSortGroupRequestDTO req : reqSortGroupList) {
            String gid = req.getGid();
            PdSortGroupDTO exist = existSortGroupMap.get(gid);
            List<PdPjPdDTO> sub = pdListMap.getOrDefault(gid, Lists.newArrayList());
            PdSubmitEffectDTO dto = new PdSubmitEffectDTO();
            dto.setGid(gid);
            if ("1".equals(exist.getIsHr())) {
                Map<String, PdPjPdDTO> subPdMap = PdUtil.listToMap(sub, PdPjPdDTO::getPdId);
                String pdIdForSelectHr = sub.stream().sorted(Comparator.comparing(PdPjPdDTO::getPdReferTotalScoreDouble).reversed()).map(PdPjPdDTO::getPdId).limit(1L).collect(Collectors.joining());
                exist.setHrList(subPdMap.get(pdIdForSelectHr).getHrList());
            }
            if ("1".equals(exist.getIsShr())) {
                exist.setShrId(sub.get(0).getShrId());
                exist.setShrName(sub.get(0).getShrName());
                exist.setShrNumber(sub.get(0).getShrNumber());
            }
            dto.setSortGroup(exist);
            dto.setResult(failResultMap.get(gid).getSummary());
            dto.setReason(req.getReason());
            dto.setPdIdList(sub.stream().map(PdPjPdDTO::getPdId).collect(Collectors.toList()));
            result2.put(gid, dto);
        }
        return result2;
    }

    private Map<String, PdSortGroupDTO> checkSubmitSp(List<PdSortGroupRequestDTO> reqList) throws ShrWebBizException {
        if (CollectionUtils.isEmpty(reqList) || reqList.stream().anyMatch(g -> StringUtils.isBlank((String)g.getReason()))) {
            throw new ShrWebBizException("\u8bf7\u586b\u5199\u539f\u56e0\uff01");
        }
        Set<String> reqIds = reqList.stream().map(PdSortGroupRequestDTO::getGid).collect(Collectors.toSet());
        String sortGroupSql = "select g.FID               id,        g.FNAME_L2          name,        g.CFISHR            isHr,        g.CFISSHR           isShr,        g.CFISSPECIFYSHR    isSpecifyShr,        g.CFSPECIFYSHRID    specifyShrId,        specifyShr.FNAME_L2 specifyShrName,        specifyShr.FNUMBER  specifyShrNumber from CT_MP_pdGroupConfig g          left join T_BD_Person specifyShr on g.CFSPECIFYSHRID = specifyShr.FID where g.CFSTATUS = '" + PdSortGroupStatusEnum.ENALBE.getValue() + "' " + "  and g.FID in (" + PdUtil.in(reqIds) + ")";
        List<PdSortGroupDTO> existList = this.component.selectList(sortGroupSql, PdSortGroupDTO.class);
        System.out.println(LOG_HEAD + "checkSp() existList = " + JSON.toJSONString(existList));
        if (CollectionUtils.isEmpty(existList)) {
            throw new ShrWebBizException("\u6392\u5e8f\u7fa4\u4f53\u5f02\u5e38\uff0c\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff01");
        }
        Map<String, PdSortGroupDTO> existMap = existList.stream().collect(Collectors.toMap(PdSortGroupDTO::getId, v -> v, (v1, v2) -> v2));
        for (PdSortGroupRequestDTO req : reqList) {
            String gid = req.getGid();
            if (StringUtils.isBlank((String)gid)) {
                throw new ShrWebBizException("\u6392\u5e8f\u7fa4\u4f53\u5f02\u5e38\uff0cID\u4e3a\u7a7a\uff01");
            }
            PdSortGroupDTO dto = existMap.get(gid);
            if (dto == null) {
                throw new ShrWebBizException("\u6392\u5e8f\u7fa4\u4f53\u5f02\u5e38\uff0c\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff01");
            }
            if (!("1".equals(dto.getIsHr()) || "1".equals(dto.getIsShr()) || "1".equals(dto.getIsSpecifyShr()))) {
                throw new ShrWebBizException("\u6392\u5e8f\u7fa4\u4f53\u5f02\u5e38\uff0c\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6d41\u7a0b\u8282\u70b9\uff01");
            }
            if (!"1".equals(dto.getIsSpecifyShr()) || !StringUtils.isBlank((String)dto.getSpecifyShrId())) continue;
            throw new ShrWebBizException("\u6392\u5e8f\u7fa4\u4f53\u5f02\u5e38\uff0c\u6307\u5b9a\u5ba1\u6838\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return existMap;
    }

    private void doSubmitSp(Map<String, PdSubmitEffectDTO> submitEffectMap, List<PdPjPdDTO> pdList) throws BOSException, SQLException {
        String schemeId = pdList.get(0).getSchemeId();
        Set<String> pdIdSet = submitEffectMap.values().stream().map(PdSubmitEffectDTO::getPdIdList).flatMap(Collection::stream).collect(Collectors.toSet());
        String insertSpFlowSql = "/*dialect*/ insert into CT_MP_pdSpFlow (FID, CFPDSCHEMEID, CFSTATUS, CFAPPLYDATE, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FNAME_L2, CFRESULT, CFREASON, CFGname, CFPersonID) values (?, '" + schemeId + "', '" + PdFlowStatusEnum.NO_APPROVAL.getValue() + "', sysdate, '" + this.user_id + "', sysdate, '" + this.user_id + "', sysdate, ?, ?, ?, ?, '" + this.person_id + "')";
        String insertSpFlowNoteSql = "/*dialect*/ insert into CT_MP_pdSpFlowNote (FID, CFSPFLOWID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FNAME_L2, CFISFIRST, CFISCURR, CFSTATUS, CFSORTCODE, CFHANDLERID, CFHANDLETIME, CFCOMMENT) values (?, ?, '" + this.user_id + "', sysdate, '" + this.user_id + "', sysdate, ? ,?, ?, ?, ?, ?, to_date(?, 'yyyy-mm-dd hh24:mi:ss'), ?)";
        String insertSpFlowNoteHandlerSql = "/*dialect*/ insert into CT_MP_pdSpFlowNoteHandler (FID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, CFSPFLOWNOTEID, CFPERSONID) values (?, '" + this.user_id + "', sysdate, '" + this.user_id + "', sysdate, ? ,?)";
        String insertSpFlowPdSql = "/*dialect*/ insert into CT_MP_pdSpFlowPd (FID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, CFSPFLOWID, CFPDID) values (?, '" + this.user_id + "', sysdate, '" + this.user_id + "', sysdate ,?, ?)";
        String updatePdSql = "/*dialect*/ update CT_MP_pdPerson set CFSTATUS          = '" + PdSpFlowPdStatusEnum.APPROVING.getValue() + "', " + "    FLASTUPDATEUSERID = '" + this.user_id + "', " + "    FLASTUPDATETIME   = sysdate " + "where FID in (" + PdUtil.in(pdIdSet) + ")";
        ArrayList flowContainer = Lists.newArrayList();
        ArrayList noteContainer = Lists.newArrayList();
        ArrayList handlerContainer = Lists.newArrayList();
        ArrayList flowPdContainer = Lists.newArrayList();
        ArrayList noticeCollector = Lists.newArrayList();
        Map<String, String> gid2SpFlowIdMap = this.collectFlow(submitEffectMap, flowContainer);
        this.collectNote(submitEffectMap, gid2SpFlowIdMap, noteContainer, handlerContainer, noticeCollector);
        this.collectflowPd(submitEffectMap, gid2SpFlowIdMap, flowPdContainer);
        ArrayList stmtSqls = Lists.newArrayList();
        HashMap psSqlMap = Maps.newHashMap();
        stmtSqls.add(updatePdSql);
        psSqlMap.put(insertSpFlowSql, this.listOfInsertFlow(flowContainer));
        psSqlMap.put(insertSpFlowNoteSql, this.listOfInsertNote(noteContainer));
        psSqlMap.put(insertSpFlowNoteHandlerSql, this.listOfInsertNoteHandler(handlerContainer));
        psSqlMap.put(insertSpFlowPdSql, this.listOfInsertFlowPd(flowPdContainer));
        if (this.component.tx(stmtSqls, psSqlMap)) {
            Map groupMap = noticeCollector.stream().collect(Collectors.groupingBy(PdFlowNoticeDTO::getFlowId, Collectors.toList()));
            String template = this.component.getTemplate(PdNoticeContentEnum.FLOW_PASS);
            groupMap.forEach((flowId, list) -> {
                Set<String> toUsers = list.stream().map(PdFlowNoticeDTO::getHandlerNumber).collect(Collectors.toSet());
                String message = MessageFormat.format(template, this.person_name, ((PdFlowNoticeDTO)list.get(0)).getFlowGname());
                String url = this.component.getUrl(PdFlowFromEnum.AP, (String)flowId);
                this.component.notice(toUsers, message, url);
            });
        }
    }

    private Map<String, String> collectFlow(Map<String, PdSubmitEffectDTO> map, List<PdSpFlowDTO> flowContainer) {
        HashMap gid2SpFlowIdMap = Maps.newHashMap();
        map.forEach((gid, dto) -> {
            String gname = dto.getSortGroup().getName();
            String flowName = MessageFormat.format(FLOW_NAME_TEMPLATE, this.user_name, gname);
            PdSpFlowDTO flow = this.newFlow(flowName, dto.getResult(), dto.getReason(), gname);
            flowContainer.add(flow);
            gid2SpFlowIdMap.put(gid, flow.getId());
        });
        return gid2SpFlowIdMap;
    }

    private void collectNote(Map<String, PdSubmitEffectDTO> submitEffectMap, Map<String, String> gid2flowIdMap, List<PdSpFlowNoteDTO> noteContainer, List<PdSpFlowNoteHandlerDTO> handlerContainer, List<PdFlowNoticeDTO> noticeCollector) {
        submitEffectMap.forEach((gid, dto) -> {
            String flowId = (String)gid2flowIdMap.get(gid);
            PdSpFlowNoteDTO firstNote = this.firstNote(this.user_name, flowId);
            noteContainer.add(firstNote);
            handlerContainer.add(this.newHandler(firstNote.getId(), this.person_id));
            int sortCode = 1;
            boolean picked = false;
            HashSet currHandlers = Sets.newHashSet();
            PdSortGroupDTO sortGroup = dto.getSortGroup();
            if ("1".equals(sortGroup.getIsHr())) {
                String noteName = sortGroup.getHrList().stream().map(PdStaffDTO::getPersonName).collect(Collectors.joining("\u3001"));
                PdSpFlowNoteDTO hrNote = this.newNote(noteName, flowId, "0", "1", PdNoteStatusEnum.UNSUBMIT.getValue(), ++sortCode);
                noteContainer.add(hrNote);
                for (PdStaffDTO hr : sortGroup.getHrList()) {
                    handlerContainer.add(this.newHandler(hrNote.getId(), hr.getPersonId()));
                    currHandlers.add(hr.getPersonNumber());
                }
                picked = true;
            }
            if ("1".equals(sortGroup.getIsShr())) {
                boolean isCurrNote = !picked;
                PdSpFlowNoteDTO shrNote = this.newNote(sortGroup.getShrName(), flowId, "0", isCurrNote ? "1" : "0", PdNoteStatusEnum.UNSUBMIT.getValue(), ++sortCode);
                noteContainer.add(shrNote);
                handlerContainer.add(this.newHandler(shrNote.getId(), sortGroup.getShrId()));
                if (isCurrNote) {
                    currHandlers.add(sortGroup.getShrNumber());
                }
                picked = true;
            }
            if ("1".equals(sortGroup.getIsSpecifyShr())) {
                boolean isCurrNote = !picked;
                PdSpFlowNoteDTO specifyShrNote = this.newNote(sortGroup.getSpecifyShrName(), flowId, "0", isCurrNote ? "1" : "0", PdNoteStatusEnum.UNSUBMIT.getValue(), ++sortCode);
                noteContainer.add(specifyShrNote);
                handlerContainer.add(this.newHandler(specifyShrNote.getId(), sortGroup.getSpecifyShrId()));
                if (isCurrNote) {
                    currHandlers.add(sortGroup.getSpecifyShrNumber());
                }
            }
            currHandlers.forEach(h -> {
                PdFlowNoticeDTO noticeDTO = new PdFlowNoticeDTO();
                noticeDTO.setFlowId(flowId);
                noticeDTO.setFlowGname(dto.getSortGroup().getName());
                noticeDTO.setHandlerNumber((String)h);
                noticeCollector.add(noticeDTO);
            });
        });
    }

    private void collectflowPd(Map<String, PdSubmitEffectDTO> submitEffectMap, Map<String, String> gid2SpFlowIdMap, List<PdSpFlowPdDTO> spFlowPdContainer) {
        submitEffectMap.forEach((k, v) -> v.getPdIdList().forEach(pdId -> spFlowPdContainer.add(this.newPd((String)gid2SpFlowIdMap.get(k), (String)pdId))));
    }

    private PdSpFlowDTO newFlow(String name, String result2, String reason, String gname) {
        PdSpFlowDTO dto = new PdSpFlowDTO();
        dto.setId(BOSUuid.create((String)BOSTYPE_FLOW).toString());
        dto.setName(name);
        dto.setGname(gname);
        dto.setResult(result2);
        dto.setReason(reason);
        return dto;
    }

    private PdSpFlowNoteDTO firstNote(String name, String flowId) {
        PdSpFlowNoteDTO note = this.newNote(name, flowId, "1", "0", PdNoteStatusEnum.SUBMITTED.getValue(), 1);
        note.setHandler(this.person_id);
        note.setHandleTime(PdUtil.currTime());
        note.setSpComment("\u901a\u8fc7\u3002");
        return note;
    }

    private PdSpFlowNoteDTO newNote(String name, String flowId, String isFirst, String isCurr, String status, int sortCode) {
        PdSpFlowNoteDTO dto = new PdSpFlowNoteDTO();
        dto.setId(BOSUuid.create((String)BOSTYPE_FLOW_NOTE).toString());
        dto.setSpFlowId(flowId);
        dto.setName(name);
        dto.setIsFirst(isFirst);
        dto.setIsCurr(isCurr);
        dto.setStatus(status);
        dto.setSortCode(String.valueOf(sortCode));
        return dto;
    }

    private PdSpFlowNoteHandlerDTO newHandler(String noteId, String personId) {
        PdSpFlowNoteHandlerDTO handler = new PdSpFlowNoteHandlerDTO();
        handler.setId(BOSUuid.create((String)BOSTYPE_FLOW_NOTE_HANDLER).toString());
        handler.setNoteId(noteId);
        handler.setHandlerId(personId);
        return handler;
    }

    private PdSpFlowPdDTO newPd(String spFlowId, String pdId) {
        PdSpFlowPdDTO dto = new PdSpFlowPdDTO();
        dto.setId(BOSUuid.create((String)BOSTYPE_FLOW_PD).toString());
        dto.setFlowId(spFlowId);
        dto.setPdId(pdId);
        return dto;
    }

    private List<Object[]> listOfInsertFlow(List<PdSpFlowDTO> spFlowList) {
        ArrayList list = Lists.newArrayList();
        spFlowList.forEach(dto -> list.add(new Object[]{dto.getId(), dto.getName(), dto.getResult(), dto.getReason(), dto.getGname()}));
        return list;
    }

    private List<Object[]> listOfInsertNote(List<PdSpFlowNoteDTO> spFlowNoteContainer) {
        ArrayList list = Lists.newArrayList();
        spFlowNoteContainer.forEach(dto -> list.add(new Object[]{dto.getId(), dto.getSpFlowId(), dto.getName(), dto.getIsFirst(), dto.getIsCurr(), dto.getStatus(), dto.getSortCode(), dto.getHandler(), dto.getHandleTime(), dto.getSpComment()}));
        return list;
    }

    private List<Object[]> listOfInsertNoteHandler(List<PdSpFlowNoteHandlerDTO> handlerList) {
        ArrayList list = Lists.newArrayList();
        handlerList.forEach(dto -> list.add(new Object[]{dto.getId(), dto.getNoteId(), dto.getHandlerId()}));
        return list;
    }

    private List<Object[]> listOfInsertFlowPd(List<PdSpFlowPdDTO> spFlowPdContainer) {
        ArrayList list = Lists.newArrayList();
        spFlowPdContainer.forEach(dto -> list.add(new Object[]{dto.getId(), dto.getFlowId(), dto.getPdId()}));
        return list;
    }
}

