/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.server;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.pd.web.dto.PdFlowDTO;
import com.kingdee.shr.pd.web.dto.PdFlowNoticeDTO;
import com.kingdee.shr.pd.web.dto.PdPjPdDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowFullDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteHandlerDTO;
import com.kingdee.shr.pd.web.enums.PdFlowFromEnum;
import com.kingdee.shr.pd.web.enums.PdNoteStatusEnum;
import com.kingdee.shr.pd.web.enums.PdNoticeContentEnum;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdStatusEnum;
import com.kingdee.shr.pd.web.util.PdUtil;
import com.kingdee.shr.pd.web.util.PdWeChatUtil;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PdSpComponent {
    private static final String LOG_HEAD = "wdpd_" + PdSpComponent.class.getSimpleName() + "_";
    private static final boolean is_prod = false;
    Context ctx;

    public PdSpComponent(Context ctx) {
        this.ctx = ctx;
    }

    public String getUrl(PdFlowFromEnum fe, String flowId) {
        String fid = "";
        try {
            fid = Base64.encodeString((String)(fe.getValue() + flowId));
            fid = URLEncoder.encode(fid, "UTF-8");
        }
        catch (Exception e) {
            System.out.println(LOG_HEAD + "getUrl() \u8f6c\u7801\u5f02\u5e38 e = " + e.getMessage());
        }
        return "https://uat-hr.rainbowcn.com/shr/pdr.do?fid=" + fid;
    }

    public int notice(Set<String> numbers, String message, String url) {
        try {
            String number = "140850|26969";
            System.out.println(LOG_HEAD + "notice() number = " + number + ", message = " + message);
            PdWeChatUtil.send(number, message, url);
            return numbers.size();
        }
        catch (Exception e) {
            System.out.println(LOG_HEAD + "notice() \u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
            return 0;
        }
    }

    public String getTemplate(PdNoticeContentEnum en) {
        String sql = "select FDESCRIPTION_L2 from CT_SYS_EKVARIABLE where CFSTATE = '1' and FNUMBER = '" + en.getCode() + "' ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                String content = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)content)) continue;
                return content;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return en.getText();
    }

    public boolean tx(List<String> stmtSqls, Map<String, List<Object[]>> psSqlMap) throws BOSException, SQLException {
        if (CollectionUtils.isEmpty((Collection)stmtSqls)) {
            stmtSqls = Lists.newArrayList();
        }
        if (MapUtils.isEmpty((Map)psSqlMap)) {
            psSqlMap = Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty((Collection)stmtSqls) && MapUtils.isEmpty((Map)psSqlMap)) {
            return false;
        }
        Connection conn = null;
        ArrayList stmtList = Lists.newArrayList();
        ArrayList psList = Lists.newArrayList();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            System.out.println(LOG_HEAD + "tx() \u83b7\u53d6DB\u8fde\u63a5\u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        try {
            for (String string : stmtSqls) {
                if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                Statement stmt = conn.createStatement();
                stmt.execute(string);
                System.out.println(LOG_HEAD + "tx() \u6267\u884c stmtSql = " + string);
                stmtList.add(stmt);
            }
            for (Map.Entry entry : psSqlMap.entrySet()) {
                String sql = (String)entry.getKey();
                if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                List paramList = (List)entry.getValue();
                PreparedStatement ps = this.prepare(conn, sql, paramList);
                ps.executeBatch();
                System.out.println(LOG_HEAD + "tx() \u6267\u884c psSql = " + JSON.toJSONString((Object)entry));
                psList.add(ps);
            }
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            System.out.println(LOG_HEAD + "tx() \u6279\u91cf\u6267\u884cSQL\u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
            throw new BOSException("sql execute tx exception : ", (Throwable)e);
        }
        finally {
            for (Statement stmt : stmtList) {
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            }
            for (Statement ps : psList) {
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
            }
        }
        return true;
    }

    private PreparedStatement prepare(Connection conn, String sql, List<Object[]> paramList) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        for (Object[] objArr : paramList) {
            for (int i = 0; i < objArr.length; ++i) {
                if (objArr[i] != null) {
                    ps.setObject(i + 1, objArr[i]);
                    continue;
                }
                ps.setNull(i + 1, 12);
            }
            ps.addBatch();
        }
        return ps;
    }

    public <T> List<T> selectList(String sql, Class<T> clz) {
        ArrayList list = Lists.newArrayList();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                Field[] fields;
                T t = clz.newInstance();
                for (Field field : fields = t.getClass().getDeclaredFields()) {
                    if (!field.getType().equals(String.class)) continue;
                    field.setAccessible(true);
                    String fieldValue = "";
                    try {
                        fieldValue = rs.getString(field.getName());
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    field.set(t, fieldValue);
                }
                list.add(t);
            }
        }
        catch (Exception e) {
            System.out.println(LOG_HEAD + "selectList() \u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return list;
    }

    public <T> T selectOne(String sql, Class<T> clz) {
        block5: {
            try {
                Field[] fields;
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                if (!rs.next()) break block5;
                T t = clz.newInstance();
                for (Field field : fields = t.getClass().getDeclaredFields()) {
                    if (!field.getType().equals(String.class)) continue;
                    field.setAccessible(true);
                    String fieldValue = "";
                    try {
                        fieldValue = rs.getString(field.getName());
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    field.set(t, fieldValue);
                }
                return t;
            }
            catch (Exception e) {
                System.out.println(LOG_HEAD + "selectOne() \u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    public <T> T parseJson(String json, Class<T> clz) throws ShrWebBizException {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new ShrWebBizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        try {
            return (T)JSON.parseObject((String)json, clz);
        }
        catch (Exception e) {
            throw new ShrWebBizException("\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff01");
        }
    }

    public Map<String, List<PdSpFlowNoteHandlerDTO>> mapFlowId2CurrNoteHandlers(Set<String> ids) {
        String sql = "select f.FID      flowId,        h.FID      handlerId,        p.FNUMBER  handlerNumber,        p.FNAME_L2 handlerName from CT_MP_pdSpFlow f          join CT_MP_pdSpFlowNote n on f.FID = n.CFSPFLOWID and n.CFISCURR = 1          join CT_MP_pdSpFlowNoteHandler h on n.FID = h.CFSPFLOWNOTEID          join T_BD_PERSON p on h.CFPERSONID = p.FID where f.FID in (" + PdUtil.in(ids) + ") " + "order by h.FID";
        return this.selectList(sql, PdSpFlowNoteHandlerDTO.class).stream().collect(Collectors.groupingBy(PdSpFlowNoteHandlerDTO::getFlowId));
    }

    public Map<String, PdSpFlowDTO> mapSpFlow(Set<String> idSet) {
        String sql = "select f.FID id, FNAME_L2 name, f.CFSTATUS status, f.CFRESULT result, f.CFREASON reason, f.CFPERSONID pid from CT_MP_pdSpFlow f where f.FID in (" + PdUtil.in(idSet) + ")";
        List<PdSpFlowDTO> list = this.selectList(sql, PdSpFlowDTO.class);
        return PdUtil.listToMap(list, PdSpFlowDTO::getId);
    }

    public Map<String, List<Object[]>> collectUpdatePdStatusMap(List<PdPjPdDTO> pdList) {
        String sql = "/*dialect*/ update CT_MP_pdPerson set CFSTATUS = ?, FLASTUPDATEUSERID = '" + this.ctx.getCaller().toString() + "', FLASTUPDATETIME = sysdate where FID = ?";
        ArrayList params = Lists.newArrayList();
        pdList.forEach(pd -> {
            PdSpFlowPdStatusEnum statusEnum = StringUtils.isNotBlank((CharSequence)pd.getShrId()) ? PdSpFlowPdStatusEnum.AUDITING : PdSpFlowPdStatusEnum.AUDITED;
            params.add(new Object[]{statusEnum.getValue(), pd.getPdId()});
        });
        HashMap map = Maps.newHashMap();
        map.put(sql, params);
        return map;
    }

    public Map<String, List<Object[]>> getUpdatePdStatusMap(String spFlowId) {
        String selectSql = "select pd.FID pdId, pd.CFSHRID shrId from CT_MP_pdSpFlowPd fpd, CT_MP_pdPerson pd where fpd.CFPDID = pd.FID and CFSPFLOWID = '" + spFlowId + "' ";
        return this.collectUpdatePdStatusMap(this.selectList(selectSql, PdPjPdDTO.class));
    }

    public PdSpFlowFullDTO flow(String flowId) {
        String selectFlowSql = "select flow.FID                                                                             id,        flow.FNAME_L2                                                                        name,        flow.CFGname                                                                         gname,        flow.CFSTATUS                                                                        status,        flow.CFRESULT                                                                        result,        flow.CFREASON                                                                        reason,        p.FID                                                                                pid,        p.FNAME_L2                                                                           pname,        p.FNUMBER                                                                            pnumber from CT_MP_pdSpFlow flow          left join T_BD_Person p on flow.CFPERSONID = p.FID where flow.FID = '" + flowId + "' ";
        PdSpFlowDTO flow = this.selectOne(selectFlowSql, PdSpFlowDTO.class);
        String selectNoteSql = "select n.FID                                            id,        n.FNAME_L2                                       name,        n.CFSPFLOWID                                     spFlowId,        n.CFSORTCODE                                     sortCode,        n.CFSTATUS                                       status,        n.CFISFIRST                                      isFirst,        n.CFISCURR                                       isCurr,        p.FNAME_L2                                       handler,        to_char(n.CFHANDLETIME, 'yyyy-mm-dd hh24:mi:ss') handleTime,        n.CFCOMMENT                                      spComment from CT_MP_pdSpFlowNote n          left join T_BD_Person p on n.CFHANDLERID = p.FID where CFSPFLOWID = '" + flowId + "' " + "order by n.CFSORTCODE ";
        List<PdSpFlowNoteDTO> notes = this.selectList(selectNoteSql, PdSpFlowNoteDTO.class);
        notes.forEach(n -> n.setStatusName(PdNoteStatusEnum.aliasOf(n.getStatus())));
        String selectFlowPdSql = "select pd.FID                                                                         pdId,        pd.CFDEPARTMENT_NAME                                                           dept,        pd.CFPOSITION_NAME                                                             pos,        p.FNUMBER                                                                      pnumber,        p.FNAME_L2                                                                     pname,        pd.CFGRADE                                                                     total,        pd.CFKPI_GRADE                                                                 lastYearKpi,        pd.CFEVERYDAY_PERFORMANCE                                                      lastYearDaily,        pd.CFYESTERYEAR_RESULT                                                         lastYearResultEnum,        pd.CFFRONTYEAR_RESULT                                                          yearBeforeLastResultEnum,        pd.CFREMARK                                                                    remark,        pd.CFRESULT                                                                    resultEnum,        pd.CFRESULT_EXPLAIN                                                            resultDesc,        pd.CFXP_IDEA                                                                   xpEnum,        pd.CFXP_IDEA_EXPLAIN                                                           xpDesc,        pd.CFSALARY_RANK                                                               payGrade,        pd.CFRANK_DATE                                                                 serveGradeDate,        pd.CFDUTY_DATE                                                                 servePosDate,        pd.CFHIRE_DATE                                                                 entryDate,        pd.CFPERSON_STATUS                                                             labor,        pd.CFSORT_GROUPID                                                              gid,        (select g.FNAME_L2 from CT_MP_PDGROUPCONFIG g where g.FID = pd.CFSORT_GROUPID) gname,        pd.CFSHRID                                                                     shrId from CT_MP_pdSpFlowPd fpd          join CT_MP_pdPerson pd on fpd.CFPDID = pd.FID          left join T_BD_Person p on pd.CFPERSONID = p.FID where fpd.CFSPFLOWID = '" + flowId + "' ";
        List<PdFlowDTO> flowPdList = this.selectList(selectFlowPdSql, PdFlowDTO.class);
        PdSpFlowFullDTO dto = new PdSpFlowFullDTO();
        dto.setFlow(flow);
        dto.setNotes(notes);
        dto.setFlowPds(flowPdList);
        dto.setFirstNote(notes.stream().filter(n -> "1".equals(n.getIsFirst())).findFirst().orElse(null));
        dto.setSecondNote(notes.stream().filter(n -> !"1".equals(n.getIsFirst())).findFirst().orElse(null));
        dto.setCurrNote(notes.stream().filter(n -> "1".equals(n.getIsCurr())).findFirst().orElse(null));
        dto.setCurrNextNote(notes.stream().filter(n -> PdNoteStatusEnum.UNSUBMIT.getValue().equals(n.getStatus()) && !"1".equals(n.getIsCurr())).findFirst().orElse(null));
        Set<String> noteIds = notes.stream().map(PdSpFlowNoteDTO::getId).collect(Collectors.toSet());
        String handlerSql = "select n.CFSPFLOWID flowId,        n.FID        noteId,        p.FID        handlerId,        p.FNAME_L2   handlerName,        p.FNUMBER    handlerNumber from CT_MP_pdSpFlowNote n          left join CT_MP_pdSpFlowNoteHandler h on n.FID = h.CFSPFLOWNOTEID          left join T_BD_Person p on h.CFPERSONID = p.FID where n.FID in (" + PdUtil.in(noteIds) + ") ";
        List<PdSpFlowNoteHandlerDTO> handlers = this.selectList(handlerSql, PdSpFlowNoteHandlerDTO.class);
        dto.setHandlerMap(handlers.stream().collect(Collectors.groupingBy(PdSpFlowNoteHandlerDTO::getNoteId, Collectors.mapping(PdSpFlowNoteHandlerDTO::getHandlerId, Collectors.toList()))));
        dto.setHandlerNumberMap(handlers.stream().collect(Collectors.groupingBy(PdSpFlowNoteHandlerDTO::getNoteId, Collectors.mapping(PdSpFlowNoteHandlerDTO::getHandlerNumber, Collectors.toSet()))));
        return dto;
    }

    public List<PdFlowNoticeDTO> listForNotice(Set<String> flowIds) {
        String sql = "select flow.FID                                                                             flowId,        flow.CFSTATUS                                                                        flowStatus,        flow.CFGNAME                                                                         flowGname,        (select p.FNUMBER from T_BD_PERSON p where p.FID = flow.CFPERSONID)                  flowCreatorNumber,        (select p.FNAME_L2 from T_BD_PERSON p where p.FID = flow.CFPERSONID)                 flowCreatorName,        handler.FNUMBER                                                                      handlerNumber,        handler.FNAME_L2                                                                     handlerName from CT_MP_pdSpFlow flow          join CT_MP_pdSpFlowNote note on flow.FID = note.CFSPFLOWID and note.CFISCURR = 1          join CT_MP_pdSpFlowNoteHandler h on note.FID = h.CFSPFLOWNOTEID          join T_BD_PERSON handler on h.CFPERSONID = handler.FID where flow.FID in (" + PdUtil.in(flowIds) + ") ";
        return this.selectList(sql, PdFlowNoticeDTO.class);
    }
}

