/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.shr.pd.web.enums.PdPersonStatusEnum;
import com.kingdee.shr.zc.web.zenum.ZcActionEnum;
import com.kingdee.shr.zc.web.zenum.ZcShztEnum;
import com.kingdee.shr.zc.web.zenum.ZcSpSubjectStatusEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PdUtil {
    public static final String YES = "1";
    public static final String NO = "0";

    public static String currYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return sdf.format(new Date());
    }

    public static String currDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public static String currTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public static Set<String> split(String idStr) {
        if (StringUtils.isBlank((CharSequence)idStr)) {
            return new HashSet<String>();
        }
        String[] arr = idStr.split(",");
        return new HashSet<String>(Arrays.asList(arr));
    }

    public static String in(Set<String> idSet) {
        return "'" + Joiner.on((String)"','").join(idSet) + "'";
    }

    public static String checkStatus(Set<String> newIdSet, Set<String> oldIdSet, ZcShztEnum expect, ZcActionEnum action) {
        if (newIdSet.size() != oldIdSet.size()) {
            return "\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709" + expect.getName() + "\u72b6\u6001\uff0c\u624d\u80fd\u8fdb\u884c" + action.getText() + "\u64cd\u4f5c!";
        }
        return "";
    }

    public static String preCheck(Set<String> idSet, Map<String, Map<String, String>> zcListMap, PdPersonStatusEnum pivot, ZcActionEnum action) {
        String msg = "";
        if (CollectionUtils.isEmpty(idSet)) {
            msg = "\u8bf7\u5148\u9009\u4e2d\u8868\u683c\u4e2d\u7684\u6570\u636e!";
        }
        for (String zcId : idSet) {
            Map<String, String> zc = zcListMap.get(zcId);
            if (zc == null) {
                msg = "\u5ba1\u6838ID[" + zcId + "]\u4e0d\u5b58\u5728\uff01";
                break;
            }
            if (pivot.getCode().equals(zc.get("status"))) continue;
            msg = "\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709" + pivot.getName() + "\u72b6\u6001\uff0c\u624d\u80fd\u8fdb\u884c" + action.getText() + "\u64cd\u4f5c!";
            break;
        }
        return msg;
    }

    public static Set<String> filterNumber(Map<String, Map<String, String>> zcListMap) {
        HashSet set = Sets.newHashSet();
        if (MapUtils.isNotEmpty(zcListMap)) {
            for (Map<String, String> zcMap : zcListMap.values()) {
                String number = zcMap.get("number");
                if (StringUtils.isBlank((CharSequence)number)) continue;
                set.add(number);
            }
        }
        return set;
    }

    public static String toDateStr(Object dateObj, Object timeObj) {
        String timeStr;
        if (dateObj == null || timeObj == null) {
            return null;
        }
        String dateStr = PdUtil.toStr(dateObj);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dateStr, timeStr = PdUtil.toStr(timeObj)})) {
            return null;
        }
        String s = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            s = sdf.format(sdf.parse(dateStr + " " + timeStr));
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        return s;
    }

    public static String toDateStr(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        String s = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            s = sdf.format(sdf.parse(dateStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return s;
    }

    public static List<Map<String, String>> toList(Object obj) {
        List list = Lists.newArrayList();
        try {
            list = (List)obj;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = Lists.newArrayList();
        }
        return list;
    }

    public static String toStr(Object obj) {
        String str = (String)obj;
        return StringUtils.trimToEmpty((String)str);
    }

    public static Map<String, String> subjectStatusMap() {
        HashMap evalStatusMap = Maps.newHashMap();
        for (ZcSpSubjectStatusEnum e : ZcSpSubjectStatusEnum.values()) {
            evalStatusMap.put(e.getCode(), e.getName());
        }
        return evalStatusMap;
    }

    public static String joinCommaEnd(Map<String, String> dict, Set<String> ids) {
        String string = PdUtil.join(dict, ids);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            return string + "\uff0c";
        }
        return "";
    }

    public static String join(Map<String, String> dict, Set<String> ids) {
        if (dict == null) {
            dict = new HashMap<String, String>();
        }
        StringBuilder str = new StringBuilder();
        String splitStr = "\u3001";
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String key : ids) {
                if (StringUtils.isBlank((CharSequence)key)) continue;
                str.append(dict.getOrDefault(key, key)).append(splitStr);
            }
            if (StringUtils.isNotBlank((CharSequence)str.toString())) {
                return str.substring(0, str.lastIndexOf(splitStr));
            }
        }
        return "";
    }

    public static <K, T> Map<K, T> listToMap(Collection<T> list, Function<T, K> keyMapper) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(keyMapper, Function.identity(), (key1, key2) -> key2));
    }

    public static Set<String> toSet(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Sets.newHashSet();
        }
        return new HashSet<String>(list);
    }
}

