/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.handler.cp;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.zc.web.dto.ZcDTO;
import com.kingdee.shr.zc.web.server.ZcComponent;
import com.kingdee.shr.zc.web.util.ZcUtil;
import com.kingdee.shr.zc.web.zenum.ZcCpztEnum;
import com.kingdee.shr.zc.web.zenum.ZcShztEnum;
import com.kingdee.shr.zc.web.zenum.ZcSpztEnum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class ZcCpZcFzrListHandler
extends ListHandler {
    private static final String LOG_HEAD = "ygzc_" + ZcCpZcFzrListHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final ZcComponent component = new ZcComponent(this.ctx);

    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        FilterInfo enterpriseNatureFilter = new FilterInfo();
        enterpriseNatureFilter.getFilterItems().add(new FilterItemInfo("auditStatus = '" + ZcShztEnum.SIGN_UP_PASS.getCode() + "'"));
        return enterpriseNatureFilter;
    }

    public void transferCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "transferCheckAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> idSet = ZcUtil.split(request.getParameter("ids"));
        String errMsg = this.checkTransfer(idSet);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private String checkTransfer(Set<String> zcIdSet) {
        if (CollectionUtils.isEmpty(zcIdSet)) {
            return "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a";
        }
        Map<String, ZcDTO> zcMap = this.component.mapZc(zcIdSet);
        Set<String> smallStepSet = this.component.allSmallStep();
        for (String zcId : zcIdSet) {
            String pre = "[" + zcId + "]";
            ZcDTO zc = zcMap.get(zcId);
            if (zc == null) {
                return pre + "\u4e13\u6d4b\u4e0d\u5b58\u5728";
            }
            if (!ZcShztEnum.SIGN_UP_PASS.getCode().equals(zc.getAuditStatus())) {
                return pre + "\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c" + ZcShztEnum.SIGN_UP_PASS.getName() + "\u72b6\u6001\u624d\u80fd\u5c0f\u6b65\u5b89\u6392\u6d4b\u8bc4";
            }
            if (!ZcCpztEnum.ASSESS_DOING.getCode().equals(zc.getCpzt())) {
                return pre + "\u6d4b\u8bc4\u72b6\u6001\u5f02\u5e38\uff0c" + ZcCpztEnum.ASSESS_DOING.getName() + "\u72b6\u6001\u624d\u80fd\u5c0f\u6b65\u5b89\u6392\u6d4b\u8bc4";
            }
            if (smallStepSet.contains(zc.getSqdj())) continue;
            return pre + "\u4e0d\u662f\u5c0f\u6b65\u5feb\u8dd1";
        }
        return null;
    }

    public void transferAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "transferAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> zcIdSet = ZcUtil.split(request.getParameter("ids"));
        String errMsg = this.checkTransfer(zcIdSet);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        ArrayList stmtSqls = Lists.newArrayList();
        this.updateCpzt(zcIdSet, stmtSqls);
        this.delCpg(zcIdSet, stmtSqls);
        this.component.tx(stmtSqls, null);
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private void updateCpzt(Set<String> idSet, List<String> stmtSqls) throws ShrWebBizException {
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String userId = this.component.getUserId(personInfo.getId().toString());
        String sql = "/*dialect */ update CT_MP_YGZC set CFCPZT = '" + ZcCpztEnum.ARRANGE_NO.getCode() + "', CFCPSJ = null, CFCPDD = '', FLASTUPDATETIME = sysdate, FLASTUPDATEUSERID = '" + userId + "' " + "where FID in (" + ZcUtil.in(idSet) + ") ";
        stmtSqls.add(sql);
    }

    private void delCpg(Set<String> idSet, List<String> stmtSqls) {
        String sql = "/*dialect*/ delete from CT_MP_Cpg where CFZCID in (" + ZcUtil.in(idSet) + ") ";
        stmtSqls.add(sql);
    }

    public void checkChangeCpztAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "checkChangeCpztAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> zcIdSet = ZcUtil.split(request.getParameter("ids"));
        String errMsg = this.check(zcIdSet);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    public String check(Set<String> zcIdSet) {
        if (CollectionUtils.isEmpty(zcIdSet)) {
            return "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a";
        }
        Map<String, ZcDTO> zcMap = this.component.mapZc(zcIdSet);
        for (String zcId : zcIdSet) {
            String pre = "[" + zcId + "]";
            ZcDTO zc = zcMap.get(zcId);
            if (zc == null) {
                return pre + "\u4e13\u6d4b\u4e0d\u5b58\u5728";
            }
            if (!ZcShztEnum.SIGN_UP_PASS.getCode().equals(zc.getAuditStatus())) {
                return pre + "\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c" + ZcShztEnum.SIGN_UP_PASS.getName() + "\u72b6\u6001\u624d\u80fd\u4fee\u6539\u6d4b\u8bc4\u72b6\u6001";
            }
            if (!Lists.newArrayList((Object[])new String[]{ZcCpztEnum.EVAL_PASS_NO.getCode(), ZcCpztEnum.EVAL_PASS_YES.getCode()}).contains(zc.getCpzt())) {
                return pre + "\u6d4b\u8bc4\u72b6\u6001\u5f02\u5e38\uff0c" + ZcCpztEnum.EVAL_PASS_NO.getName() + "\u6216" + ZcCpztEnum.EVAL_PASS_YES.getName() + "\u72b6\u6001\u624d\u80fd\u4fee\u6539\u6d4b\u8bc4\u72b6\u6001";
            }
            if (!Lists.newArrayList((Object[])new String[]{ZcSpztEnum.APPROVAL_FINISH.getCode(), ZcSpztEnum.NOTIFIED.getCode()}).contains(zc.getSpzt())) continue;
            return pre + "\u5ba1\u6279\u72b6\u6001\u5f02\u5e38\uff0c" + ZcSpztEnum.APPROVAL_FINISH.getName() + "\u6216" + ZcSpztEnum.NOTIFIED.getName() + "\u72b6\u6001\u4e0d\u80fd\u4fee\u6539\u6d4b\u8bc4\u72b6\u6001";
        }
        return null;
    }

    public void changeCpztAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "changeCpztAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> zcIdSet = ZcUtil.split(request.getParameter("ids"));
        String errMsg = this.check(zcIdSet);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        this.doChangeCpzt(zcIdSet);
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private void doChangeCpzt(Set<String> zcIdSet) throws ShrWebBizException, BOSException {
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String userId = this.component.getUserId(personInfo.getId().toString());
        String sql = "/*dialect */ update CT_MP_YGZC set CFCPZT = '" + ZcCpztEnum.ASSESS_DONE.getCode() + "', CFZZDJ = null, FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = sysdate " + "where FID in (" + ZcUtil.in(zcIdSet) + ") ";
        DbUtil.execute((Context)this.ctx, (String)sql);
    }
}

