/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.handler.sp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.zc.web.dto.SubjectPersonDTO;
import com.kingdee.shr.zc.web.dto.ZcSpSubjectDTO;
import com.kingdee.shr.zc.web.dto.ZcSpSubjectRequestDTO;
import com.kingdee.shr.zc.web.server.ZcComponent;
import com.kingdee.shr.zc.web.util.ZcUtil;
import com.kingdee.shr.zc.web.zenum.ZcSpSubjectStatusEnum;
import com.kingdee.shr.zc.web.zenum.ZcSpztEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class ZcSpSubjectEditHandler
extends EditHandler {
    private static final String LOG_HEAD = "ygzc_" + ZcSpSubjectEditHandler.class.getSimpleName() + "_";
    private static final String AC_SAVE = "1";
    private static final String AC_SUBMIT = "2";
    private static final List<String> ACTION_CODE = Lists.newArrayList((Object[])new String[]{"1", "2"});
    private final Context ctx = SHRContext.getInstance().getContext();
    private final ZcComponent component = new ZcComponent(this.ctx);

    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        System.out.println(LOG_HEAD + "setInitData() \u8fdb\u5165 \u3002\u3002\u3002");
        String subjectId = request.getParameter("billId");
        String zcIds = request.getParameter("ids");
        ZcSpSubjectDTO subject = new ZcSpSubjectDTO();
        if (StringUtils.isNotBlank((CharSequence)subjectId)) {
            initData.put("subject", this.getSubject(subjectId));
        } else if (StringUtils.isNotBlank((CharSequence)zcIds)) {
            subject.setZcList(this.component.listZc(ZcUtil.split(zcIds)));
            initData.put("subject", subject);
        }
        initData.put("subjectStatusMap", ZcUtil.subjectStatusMap());
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        initData.put("currPersonId", personInfo.getId().toString());
        initData.put("currZcCycle", this.component.getCurrCycle());
        super.setInitData(request, response, modelMap, initData);
    }

    private String decode(String zcId) {
        String str = "";
        if (StringUtils.isNotBlank((CharSequence)zcId)) {
            try {
                str = URLDecoder.decode(zcId, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    private ZcSpSubjectDTO getSubject(String subjectId) {
        ZcSpSubjectDTO subjectDTO = this.component.getSubject(subjectId);
        if (subjectDTO != null) {
            subjectDTO.setSprList(this.component.listSpSubjectSpr(subjectId));
            Set<String> zcIdSet = this.component.listSpSubjectZcIds(subjectId);
            subjectDTO.setZcList(this.component.listZc(zcIdSet));
        }
        return subjectDTO;
    }

    public void listZcAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "listZcAction() \u8fdb\u5165 \u3002\u3002\u3002");
        String ids = request.getParameter("ids");
        try {
            ids = URLDecoder.decode(ids, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ids = "";
            System.out.println(LOG_HEAD + "listZcAction() ids\u89e3\u6790\u5f02\u5e38 ids = " + ids);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("result", "200");
        result2.put("zcList", this.component.listZc(ZcUtil.split(ids)));
        this.writeSuccessData(result2);
    }

    public void checkAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        String arData = request.getParameter("arData");
        ZcSpSubjectRequestDTO dto = (ZcSpSubjectRequestDTO)JSON.parseObject((String)arData, (TypeReference)new TypeReference<ZcSpSubjectRequestDTO>(){}, (Feature[])new Feature[0]);
        String errMsg = this.check(dto);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private String check(ZcSpSubjectRequestDTO dto) {
        if (dto == null) {
            return "\u8bf7\u6c42\u53c2\u6570dto\u4e3anull";
        }
        if (!ACTION_CODE.contains(dto.getActionCode())) {
            return "\u8bf7\u6c42\u64cd\u4f5c\u53ea\u80fd\u4e3a\u4fdd\u5b58\u6216\u63d0\u4ea4";
        }
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            return "\u8bf7\u586b\u5199\u4e3b\u9898";
        }
        if (StringUtils.isBlank((CharSequence)dto.getDesc())) {
            return "\u8bf7\u586b\u5199\u8bf4\u660e";
        }
        if (CollectionUtils.isEmpty(dto.getSprIdList())) {
            return "\u8bf7\u9009\u62e9\u5ba1\u6279\u4eba";
        }
        if (CollectionUtils.isEmpty(dto.getZcIdList())) {
            return "\u8bf7\u9009\u62e9\u5ba1\u6279\u5458\u5de5";
        }
        String subjectId = dto.getId();
        if (StringUtils.isNotBlank((CharSequence)subjectId)) {
            ZcSpSubjectDTO subject = this.component.getSubject(subjectId);
            if (subject == null) {
                return "\u8bf7\u6c42\u4e3b\u9898ID\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a";
            }
            if (!Lists.newArrayList((Object[])new String[]{ZcSpSubjectStatusEnum.NOT_SUBMITTED.getCode(), ZcSpSubjectStatusEnum.APPROVAL_DOING.getCode()}).contains(subject.getStatus())) {
                return "\u5ba1\u6279\u4e3b\u9898\u72b6\u6001\u4e3a" + ZcSpSubjectStatusEnum.NOT_SUBMITTED.getName() + "\u6216" + ZcSpSubjectStatusEnum.APPROVAL_DOING.getName() + "\u624d\u53ef\u4ee5\u8fdb\u884c\u4fdd\u5b58\u6216\u63d0\u4ea4";
            }
            if (ZcSpSubjectStatusEnum.APPROVAL_DOING.getCode().equals(subject.getStatus()) && AC_SAVE.equals(dto.getActionCode())) {
                return "\u5ba1\u6279\u4e3b\u9898\u72b6\u6001\u4e3a" + ZcSpSubjectStatusEnum.APPROVAL_DOING.getName() + "\u53ea\u5141\u8bb8\u8fdb\u884c\u63d0\u4ea4";
            }
        }
        if (this.isThemeRepeat(dto.getId(), dto.getName())) {
            return "\u4e3b\u9898\u540d\u79f0\u91cd\u590d";
        }
        return "";
    }

    private boolean isThemeRepeat(String subjectId, String name) {
        ZcSpSubjectDTO dto = this.component.getSubjectByName(name);
        if (StringUtils.isNotBlank((CharSequence)subjectId)) {
            return dto != null && !subjectId.equals(dto.getId());
        }
        return dto != null;
    }

    public void arrangeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "arrangeAction() \u8fdb\u5165\u3002\u3002\u3002 ");
        String arData = request.getParameter("arData");
        ZcSpSubjectRequestDTO requestDTO = (ZcSpSubjectRequestDTO)JSON.parseObject((String)arData, (TypeReference)new TypeReference<ZcSpSubjectRequestDTO>(){}, (Feature[])new Feature[0]);
        System.out.println(LOG_HEAD + "arrangeAction() \u8f6c\u6362 dto = " + JSON.toJSONString((Object)requestDTO));
        String errMsg = this.check(requestDTO);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        if (!this.checkSpr(requestDTO)) {
            JSONUtils.ERROR((String)"\u5ba1\u6279\u4eba\u4e0d\u5b58\u5728\u6216\u5df2\u79bb\u804c");
            return;
        }
        if (!this.checkZc(requestDTO)) {
            JSONUtils.ERROR((String)"\u4e13\u6d4b\u5458\u5de5\u4e0d\u5b58\u5728");
            return;
        }
        System.out.println(LOG_HEAD + "arrangeAction() \u6821\u9a8cOK  dto = " + JSON.toJSONString((Object)requestDTO));
        String subjectId = requestDTO.getId();
        if (StringUtils.isBlank((CharSequence)subjectId)) {
            subjectId = this.addNew(requestDTO);
        } else {
            this.edit(requestDTO);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        result2.put("subjectId", subjectId);
        this.writeSuccessData(result2);
    }

    private String addNew(ZcSpSubjectRequestDTO requestDTO) throws ShrWebBizException, BOSException, SQLException {
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String personId = personInfo.getId().toString();
        String userId = this.component.getUserId(personId);
        List<String> stmtSqlList = this.buildUpdateZcSql(requestDTO, userId);
        String subjectId = BOSUuid.create((String)"AB0F2516").toString();
        String subjectStatus = this.calSubjectStatus(requestDTO.getActionCode());
        String zcCycle = this.component.getCurrCycle();
        String insertSubjectSql = "/*dialect*/ insert into CT_MP_ZcSpSubject (FID, FNAME_L2, FDESCRIPTION_L2, CFCPNF, CFSTATUS, CFPERSONID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME) values ('" + subjectId + "', '" + requestDTO.getName() + "', '" + requestDTO.getDesc() + "', '" + zcCycle + "', '" + subjectStatus + "', '" + personId + "', '" + userId + "', sysdate, '" + userId + "', sysdate)";
        stmtSqlList.add(insertSubjectSql);
        Map<String, List<Object[]>> psMap = this.buildBatchInsertMap(requestDTO, subjectId, userId);
        this.component.tx(stmtSqlList, psMap);
        return subjectId;
    }

    private List<String> buildUpdateZcSql(ZcSpSubjectRequestDTO requestDTO, String userId) {
        Set<String> oldZcIdSet;
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)requestDTO.getId()) && CollectionUtils.isNotEmpty(oldZcIdSet = this.component.listSpSubjectZcIds(requestDTO.getId()))) {
            String updateZcSpztToNullSql = "/*dialect*/ update CT_MP_YGZC set CFJGTZZT = null, FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = sysdate where FID in (" + ZcUtil.in(oldZcIdSet) + ")";
            list.add(updateZcSpztToNullSql);
        }
        String updateZcSpztToNotSubmitSql = "/*dialect*/ update CT_MP_YGZC set CFJGTZZT = '" + this.calSpztStatus(requestDTO.getActionCode()) + "', FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = sysdate where FID in (" + ZcUtil.in(requestDTO.getZcIdSet()) + ")";
        list.add(updateZcSpztToNotSubmitSql);
        return list;
    }

    private Map<String, List<Object[]>> buildBatchInsertMap(ZcSpSubjectRequestDTO requestDTO, String subjectId, String userId) {
        HashMap psMap = Maps.newHashMap();
        List<Object[]> insertThemePersonParamList = this.subjectSprParamList(requestDTO);
        String insertSprSql = "/*dialect*/ insert into CT_MP_ZcSpSubjectPerson(FID, CFSUBJECTID, CFPERSONID,CFSTATUS, CFSPTIME, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME) values (NEWBOSID('4471040B'),'" + subjectId + "', ?, ?, to_date(?, 'yyyy-mm-dd hh24:mi:ss'), '" + userId + "', sysdate, '" + userId + "', sysdate)";
        psMap.put(insertSprSql, insertThemePersonParamList);
        List<Object[]> insertThemeZcParamList = this.buildInsertThemeZcParamList(requestDTO.getZcIdSet());
        String insertZcRelationSql = "/*dialect*/ insert into CT_MP_ZcSpSubjectRelation(FID, CFSUBJECTID, CFZCID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME) values (NEWBOSID('B0CA0D32'),'" + subjectId + "', ?, '" + userId + "', sysdate, '" + userId + "', sysdate)";
        psMap.put(insertZcRelationSql, insertThemeZcParamList);
        return psMap;
    }

    private void edit(ZcSpSubjectRequestDTO requestDTO) throws ShrWebBizException, BOSException, SQLException {
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String personId = personInfo.getId().toString();
        String userId = this.component.getUserId(personId);
        String subjectId = requestDTO.getId();
        List<String> stmtSqlList = this.buildUpdateZcSql(requestDTO, userId);
        this.updateSubject(subjectId, userId, requestDTO, stmtSqlList);
        this.deleteSubjectSpr(subjectId, stmtSqlList);
        this.deleteSubjectZc(subjectId, stmtSqlList);
        Map<String, List<Object[]>> psMap = this.buildBatchInsertMap(requestDTO, requestDTO.getId(), userId);
        this.component.tx(stmtSqlList, psMap);
    }

    private void updateSubject(String subjectId, String userId, ZcSpSubjectRequestDTO requestDTO, List<String> stmtSqlList) {
        String subjectStatus = this.calSubjectStatus(requestDTO.getActionCode());
        String updateSubjectSql = "/*dialect*/ update CT_MP_ZcSpSubject set FNAME_L2 = '" + requestDTO.getName() + "', FDESCRIPTION_L2 = '" + requestDTO.getDesc() + "', CFSTATUS = '" + subjectStatus + "', FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = sysdate " + "where FID = '" + subjectId + "'";
        stmtSqlList.add(updateSubjectSql);
    }

    private void deleteSubjectSpr(String subjectId, List<String> stmtSqlList) {
        String delSprSql = "/*dialect*/ delete from CT_MP_ZcSpSubjectPerson where CFSUBJECTID = '" + subjectId + "'";
        stmtSqlList.add(delSprSql);
    }

    private void deleteSubjectZc(String subjectId, List<String> stmtSqlList) {
        String delZcRelationSql = "/*dialect*/ delete from CT_MP_ZcSpSubjectRelation where CFSUBJECTID = '" + subjectId + "'";
        stmtSqlList.add(delZcRelationSql);
    }

    private List<Object[]> subjectSprParamList(ZcSpSubjectRequestDTO requestDTO) {
        System.out.println(LOG_HEAD + "subjectSprParamList() requestDTO = " + JSON.toJSONString((Object)requestDTO));
        ArrayList list = Lists.newArrayList();
        boolean isAddNew = StringUtils.isBlank((CharSequence)requestDTO.getId());
        this.component.getSubject(requestDTO.getId());
        if (isAddNew || this.isContentChange(requestDTO)) {
            for (String sprId : requestDTO.getSprIdSet()) {
                list.add(new Object[]{sprId, null, null});
            }
            return list;
        }
        Map<String, SubjectPersonDTO> sprMap = this.component.mapSpSubjectSpr(requestDTO.getId());
        for (String sprId : requestDTO.getSprIdSet()) {
            SubjectPersonDTO spr = sprMap.get(sprId);
            String status = null;
            String spTime = null;
            if (spr != null) {
                status = spr.getStatus();
                spTime = spr.getSpTime();
            }
            list.add(new Object[]{sprId, status, spTime});
        }
        return list;
    }

    private boolean isContentChange(ZcSpSubjectRequestDTO requestDTO) {
        ZcSpSubjectDTO oldSubject = this.component.getSubject(requestDTO.getId());
        boolean equalName = requestDTO.getName().equals(oldSubject.getName());
        boolean equalDesc = requestDTO.getDesc().equals(oldSubject.getDesc());
        Set<String> oldSubjectZcIds = this.component.listSpSubjectZcIds(requestDTO.getId());
        boolean equalZcIdList = SetUtils.isEqualSet(requestDTO.getZcIdSet(), oldSubjectZcIds);
        return !equalName || !equalDesc || !equalZcIdList;
    }

    private boolean checkSpr(ZcSpSubjectRequestDTO requestDTO) {
        if (requestDTO == null || CollectionUtils.isEmpty(requestDTO.getSprIdList())) {
            return false;
        }
        String inStr = "'" + Joiner.on((String)"','").join(requestDTO.getSprIdList()) + "'";
        String sql = "/*dialect*/ select p.FID FID from T_BD_Person p          left join T_Hr_EmpLaborRelation e on e.FPERSONID = p.FID          left join T_Hr_BDEmployeeType t on e.FLABORRELATIONSTATEID = t.FID where t.FNAME_L2 not like '%\u79bb\u804c%' and p.FID in (" + inStr + ") ";
        try {
            ArrayList idList = Lists.newArrayList();
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                idList.add(rs.getString("FID"));
            }
            for (String inputSprId : requestDTO.getSprIdList()) {
                if (idList.contains(inputSprId)) continue;
                return false;
            }
            requestDTO.setSprIdSet(Sets.newHashSet((Iterable)idList));
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean checkZc(ZcSpSubjectRequestDTO requestDTO) {
        if (requestDTO == null || CollectionUtils.isEmpty(requestDTO.getZcIdList())) {
            return false;
        }
        String inStr = "'" + Joiner.on((String)"','").join(requestDTO.getZcIdList()) + "'";
        String sql = "/*dialect*/ select FID, FNUMBER, CFAUDITSTATUS, CFCPZT from CT_MP_YGZC where FID in (" + inStr + ")";
        try {
            ArrayList zcIdList = Lists.newArrayList();
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                zcIdList.add(rs.getString("FID"));
            }
            for (String inputZcId : requestDTO.getZcIdList()) {
                if (zcIdList.contains(inputZcId)) continue;
                return false;
            }
            requestDTO.setZcIdSet(Sets.newHashSet((Iterable)zcIdList));
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private List<Object[]> buildInsertThemeZcParamList(Set<String> zcIdSet) {
        ArrayList list = Lists.newArrayList();
        for (String zcId : zcIdSet) {
            list.add(new Object[]{zcId});
        }
        return list;
    }

    private String calSubjectStatus(String actionCode) {
        if (AC_SAVE.equals(actionCode)) {
            return ZcSpSubjectStatusEnum.NOT_SUBMITTED.getCode();
        }
        return ZcSpSubjectStatusEnum.APPROVAL_DOING.getCode();
    }

    private String calSpztStatus(String actionCode) {
        if (AC_SAVE.equals(actionCode)) {
            return ZcSpztEnum.NOT_SUBMIT.getCode();
        }
        return ZcSpztEnum.APPROVAL_DOING.getCode();
    }
}

