/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.handler.sp;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.zc.web.dto.ZcSpSubjectDTO;
import com.kingdee.shr.zc.web.server.ZcComponent;
import com.kingdee.shr.zc.web.util.ZcUtil;
import com.kingdee.shr.zc.web.zenum.ZcSpSubjectStatusEnum;
import java.security.Principal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class ZcSpSubjectListHandler
extends ListHandler {
    private static final String LOG_HEAD = "ygzc_" + ZcSpSubjectListHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final ZcComponent component = new ZcComponent(this.ctx);

    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        Principal principal = request.getUserPrincipal();
        String number = principal.getName();
        FilterInfo enterpriseNatureFilter = new FilterInfo();
        enterpriseNatureFilter.getFilterItems().add(new FilterItemInfo("person.number = '" + number + "'"));
        return enterpriseNatureFilter;
    }

    public void getStatusAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        System.out.println(LOG_HEAD + "getStatusAction() \u8fdb\u5165\u3002\u3002\u3002");
        String billId = request.getParameter("billId");
        if (StringUtils.isBlank((CharSequence)billId)) {
            JSONUtils.ERROR((String)"billId\u4e3a\u7a7a");
            return;
        }
        String status = "";
        String sql = "select CFSTATUS from CT_MP_ZCSPSUBJECT where FID = '" + billId + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            if (rs.next()) {
                status = rs.getString(1);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        result2.put("status", status);
        this.writeSuccessData(result2);
    }

    public void checkDelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        System.out.println(LOG_HEAD + "checkDelAction() \u8fdb\u5165\u3002\u3002\u3002");
        Set<String> idSet = ZcUtil.split(request.getParameter("ids"));
        if (CollectionUtils.isEmpty(idSet)) {
            JSONUtils.ERROR((String)"\u8bf7\u5148\u9009\u4e2d\u8868\u683c\u4e2d\u7684\u6570\u636e");
            return;
        }
        String errMsg = this.check(idSet);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private String check(Set<String> idSet) {
        Map<String, ZcSpSubjectDTO> map = this.component.mapSpSubject(idSet);
        for (String id : idSet) {
            ZcSpSubjectDTO subject = map.get(id);
            if (subject == null) {
                return "\u5ba1\u6279\u4e3b\u9898\u4e0d\u5b58\u5728";
            }
            if (ZcSpSubjectStatusEnum.NOT_SUBMITTED.getCode().equals(subject.getStatus())) continue;
            return "\u53ea\u6709" + ZcSpSubjectStatusEnum.NOT_SUBMITTED.getName() + "\u72b6\u6001\u624d\u53ef\u4ee5\u5220\u9664";
        }
        return null;
    }

    public void delAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "delAction() \u8fdb\u5165\u3002\u3002\u3002");
        Set<String> idSet = ZcUtil.split(request.getParameter("ids"));
        if (CollectionUtils.isEmpty(idSet)) {
            JSONUtils.ERROR((String)"\u8bf7\u5148\u9009\u4e2d\u8868\u683c\u4e2d\u7684\u6570\u636e");
            return;
        }
        String errMsg = this.check(idSet);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        this.doDelete(idSet);
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private void doDelete(Set<String> idSet) throws ShrWebBizException, BOSException, SQLException {
        String delSpSubjectSql = "/*dialect*/ delete from CT_MP_ZcSpSubject where FID in (" + ZcUtil.in(idSet) + ")";
        String delSpSubjectSprSql = "/*dialect*/ delete from CT_MP_ZcSpSubjectPerson where CFSUBJECTID in (" + ZcUtil.in(idSet) + ")";
        String delSpSubjectZcSql = "/*dialect*/ delete from CT_MP_ZcSpSubjectRelation where CFSUBJECTID in (" + ZcUtil.in(idSet) + ")";
        ArrayList stmtSqls = Lists.newArrayList((Object[])new String[]{delSpSubjectSql, delSpSubjectSprSql, delSpSubjectZcSql});
        Set<String> zcIdSet = this.component.listSpSubjectZcIds(idSet);
        if (CollectionUtils.isNotEmpty(zcIdSet)) {
            PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
            String personId = personInfo.getId().toString();
            String userId = this.component.getUserId(personId);
            String updateZcSql = "/*dialect*/ update CT_MP_YGZC set CFJGTZZT = null, FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = sysdate where FID in (" + ZcUtil.in(zcIdSet) + ")";
            stmtSqls.add(updateZcSql);
        }
        this.component.tx(stmtSqls, null);
    }
}

