/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.server;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.zc.web.dto.CpgDTO;
import com.kingdee.shr.zc.web.dto.PersonDTO;
import com.kingdee.shr.zc.web.dto.SubjectPersonDTO;
import com.kingdee.shr.zc.web.dto.ZcDTO;
import com.kingdee.shr.zc.web.dto.ZcSpSubjectDTO;
import com.kingdee.shr.zc.web.util.ZcUtil;
import com.kingdee.shr.zc.web.util.ZcWeChatUtil;
import com.kingdee.shr.zc.web.zenum.ZcMsgTemplateEnum;
import com.kingdee.shr.zc.web.zenum.ZcStepGradeEnum;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ZcComponent {
    private static final boolean PROD = true;
    private static final String TO_USER = "140850|26969";
    private static final String LOG_HEAD = "ygzc_ZcComponent ";
    Context ctx;

    public ZcComponent(Context ctx) {
        this.ctx = ctx;
    }

    public Map<String, String> zc(String zcId) {
        HashMap resultMap = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)zcId)) {
            return resultMap;
        }
        String sql = "/*dialect*/ select FID                                   id,        FNUMBER                               pnumber,        FNAME_L2                              pname,        CFAUDITSTATUS                         auditStatus,        CFCPZT                                cpzt,        CFMQDJ                                mqdj,        CFSQDJ                                sqdj,        CFZZDJ                                zzdj,        CFCPDD                                cpdd,        to_char(CFCPSJ, 'yyyy-MM-dd HH24:mi') cpsj,        CFCPTSNR                              cptsnr,        CFZYPJF                               zypjf,        CFXMPJF                               xmpjf from CT_MP_YGZC where FID = '" + zcId + "'";
        System.out.println("ygzc sql = " + sql);
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            if (rs.next()) {
                resultMap.put("id", rs.getString("id"));
                resultMap.put("number", rs.getString("pnumber"));
                resultMap.put("name", rs.getString("pname"));
                resultMap.put("auditStatus", rs.getString("auditStatus"));
                resultMap.put("cpzt", rs.getString("cpzt"));
                resultMap.put("mqdj", rs.getString("mqdj"));
                resultMap.put("sqdj", rs.getString("sqdj"));
                resultMap.put("zzdj", rs.getString("zzdj"));
                resultMap.put("cpdd", rs.getString("cpdd"));
                resultMap.put("cpsj", rs.getString("cpsj"));
                resultMap.put("cptsnr", rs.getString("cptsnr"));
                resultMap.put("zypjf", rs.getString("zypjf"));
                resultMap.put("xmpjf", rs.getString("xmpjf"));
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return resultMap;
    }

    public Map<String, Map<String, String>> get(Set<String> idSet) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        if (CollectionUtils.isEmpty(idSet)) {
            return resultMap;
        }
        String sql = "/*dialect*/ select zc.FID                           zcId,        zc.FNUMBER                       zcPnumber,        zc.FNAME_L2                      zcPname,        zc.CFAUDITSTATUS                 auditStatus,        zc.CFMQDJ                        mqdj,        zc.CFSQDJ                        sqdj,        hrbp.FID                         hrbpId,        hrbp.FNUMBER                     hrbpNumber,        hrbp.FNAME_L2                    hrbpName,        fzr.FID                          fzrId,        fzr.FNUMBER                      fzrNumber,        fzr.FNAME_L2                     fzrName,        zc.CFORGNAME                     orgName,        zc.CFPOSITIONNAME                positionName,        zc.CFCPZT                        cpzt,        zc.CFCPDD                        cpdd,        to_char(zc.CFCPSJ, 'yyyy-MM-dd') cprq,        to_char(zc.CFCPSJ, 'HH24:mi')    cpsj from CT_MP_YGZC zc          left join T_BD_PERSON hrbp on zc.CFHRBPID = hrbp.FID          left join T_BD_PERSON fzr on zc.CFFZRID = fzr.FID where zc.FID in (" + ZcUtil.in(idSet) + ") ";
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            while (rs.next()) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                String id = rs.getString("zcId");
                tempMap.put("id", id);
                tempMap.put("number", rs.getString("zcPnumber"));
                tempMap.put("name", rs.getString("zcPname"));
                tempMap.put("auditStatus", rs.getString("auditStatus"));
                tempMap.put("mqdj", rs.getString("mqdj"));
                tempMap.put("sqdj", rs.getString("sqdj"));
                tempMap.put("hrbpId", rs.getString("hrbpId"));
                tempMap.put("hrbpNumber", rs.getString("hrbpNumber"));
                tempMap.put("hrbpName", rs.getString("hrbpName"));
                tempMap.put("fzrId", rs.getString("fzrId"));
                tempMap.put("fzrNumber", rs.getString("fzrNumber"));
                tempMap.put("fzrName", rs.getString("fzrName"));
                tempMap.put("orgName", rs.getString("orgName"));
                tempMap.put("positionName", rs.getString("positionName"));
                tempMap.put("cpzt", rs.getString("cpzt"));
                tempMap.put("cpdd", rs.getString("cpdd"));
                tempMap.put("cprq", rs.getString("cprq"));
                tempMap.put("cpsj", rs.getString("cpsj"));
                resultMap.put(id, tempMap);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CpgDTO> listCpg(Set<String> zcIdSet) {
        if (!CollectionUtils.isNotEmpty(zcIdSet)) return Lists.newArrayList();
        String sql = "/*dialect*/ select    cpg.CFZCID          zcId,    p.FID               cpgId,    p.FNUMBER           cpgNumber,    p.FNAME_L2          cpgName,    cpg.CFZYF           zyf,    cpg.CFXMF           xmf,    cpg.CFPASS          pass,    cpg.CFCPGTYPE       cpgType,    cpg.CFSCORESTATUS   scoreStatus,    cpg.CFEVALUATION    valuation from CT_MP_Cpg cpg left join T_BD_PERSON p on cpg.CFPERSONID = p.FID where cpg.CFZCID in (" + ZcUtil.in(zcIdSet) + ") " + "   order by cpg.CFZCID, cpg.CFCPGTYPE, cpg.FCREATETIME desc";
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            ArrayList cpgList = Lists.newArrayList();
            while (rs.next()) {
                CpgDTO cpg = new CpgDTO();
                cpg.setZcId(rs.getString("zcId"));
                cpg.setCpgId(rs.getString("cpgId"));
                cpg.setCpgNumber(rs.getString("cpgNumber"));
                cpg.setCpgName(rs.getString("cpgName"));
                cpg.setZyf(rs.getString("zyf"));
                cpg.setXmf(rs.getString("xmf"));
                cpg.setPass(rs.getString("pass"));
                cpg.setCpgType(rs.getString("cpgType"));
                cpg.setScoreStatus(rs.getString("scoreStatus"));
                cpg.setEvaluation(rs.getString("valuation"));
                cpgList.add(cpg);
            }
            ArrayList arrayList = cpgList;
            return arrayList;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Lists.newArrayList();
    }

    public Map<String, List<CpgDTO>> listCpgMap(Set<String> zcIdSet) {
        Map<Object, Object> cpgMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(zcIdSet)) {
            return cpgMap;
        }
        String sql = "/*dialect*/ select p.FID         cpgId,        p.FNUMBER     cpgNumber,        p.FNAME_L2    cpgName,        cpg.CFZCID    zcId,        cpg.CFZYF     zyf,        cpg.CFXMF     xmf,        cpg.CFPASS    pass,        cpg.CFCPGTYPE cpgType from CT_MP_Cpg cpg          left join T_BD_PERSON p on cpg.CFPERSONID = p.FID where cpg.CFZCID in (" + ZcUtil.in(zcIdSet) + ")";
        ArrayList cpgList = Lists.newArrayList();
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            while (rs.next()) {
                CpgDTO cpg = new CpgDTO();
                cpg.setCpgId(rs.getString("cpgId"));
                cpg.setCpgNumber(rs.getString("cpgNumber"));
                cpg.setCpgName(rs.getString("cpgName"));
                cpg.setZcId(rs.getString("zcId"));
                cpg.setZyf(rs.getString("zyf"));
                cpg.setXmf(rs.getString("xmf"));
                cpg.setPass(rs.getString("pass"));
                cpg.setCpgType(rs.getString("cpgType"));
                cpgList.add(cpg);
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_ZcComponent listCpgMap() \u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (CollectionUtils.isNotEmpty((Collection)cpgList)) {
            cpgMap = cpgList.stream().sorted(Comparator.comparing(CpgDTO::getCpgType)).collect(Collectors.groupingBy(CpgDTO::getZcId));
        }
        return cpgMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CpgDTO> listCpg(String zcId) {
        if (!StringUtils.isNotBlank((CharSequence)zcId)) return Lists.newArrayList();
        String sql = "/*dialect*/ select p.FID             cpgId,        p.FNUMBER         cpgNumber,        p.FNAME_L2        cpgName,        cpg.CFCPGTYPE     cpgType,        cpg.CFZCID        zcId,        cpg.CFZYF         zyf,        cpg.CFXMF         xmf,        cpg.CFPASS        pass,        cpg.CFEVALUATION  evaluation,        cpg.CFSCORESTATUS scoreStatus from CT_MP_Cpg cpg          left join T_BD_PERSON p on cpg.CFPERSONID = p.FID where cpg.CFZCID = '" + zcId + "' ";
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            ArrayList cpgList = Lists.newArrayList();
            while (rs.next()) {
                CpgDTO cpg = new CpgDTO();
                cpg.setCpgId(rs.getString("cpgId"));
                cpg.setCpgNumber(rs.getString("cpgNumber"));
                cpg.setCpgName(rs.getString("cpgName"));
                cpg.setCpgType(rs.getString("cpgType"));
                cpg.setZcId(rs.getString("zcId"));
                cpg.setZyf(rs.getString("zyf"));
                cpg.setXmf(rs.getString("xmf"));
                cpg.setPass(rs.getString("pass"));
                cpg.setEvaluation(rs.getString("evaluation"));
                cpg.setScoreStatus(rs.getString("scoreStatus"));
                cpgList.add(cpg);
            }
            ArrayList arrayList = cpgList;
            return arrayList;
        }
        catch (Exception e) {
            System.out.println("ygzc_ZcComponent listCpgMap() \u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return Lists.newArrayList();
    }

    private Set<String> getIdSet(Set<String> idSet, String auditStatus) {
        HashSet<String> set = new HashSet<String>();
        String sql = "/*dialect*/  select FID from CT_MP_YGZC where FID in (" + ZcUtil.in(idSet) + ") and CFAUDITSTATUS = '" + auditStatus + "'";
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            while (rs.next()) {
                set.add(rs.getString(1));
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return set;
    }

    public String getWwMsg(ZcMsgTemplateEnum wwEnum) {
        return this.getWwMsg(wwEnum.getCode(), wwEnum.getDefaulValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getWwMsg(String code, String defaultValue) {
        String sql = "/*dialect*/ select FDESCRIPTION_L2 from CT_SYS_EKVARIABLE where FNUMBER = '" + code + "'";
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            String content;
            do {
                if (!rs.next()) return defaultValue;
            } while (!StringUtils.isNotBlank((CharSequence)(content = rs.getString(1))));
            String string = content;
            return string;
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return defaultValue;
    }

    public void sendMsg(Set<String> numberSet, ZcMsgTemplateEnum templateEnum) {
        System.out.println("ygzc ZcComponent sendMsg() \u8fdb\u5165\u3002\u3002\u3002numberSet = " + JSON.toJSONString(numberSet) + ", templateEnum = " + templateEnum.getCode());
        try {
            if (CollectionUtils.isEmpty(numberSet)) {
                return;
            }
            String toUser = TO_USER;
            toUser = Joiner.on((String)"|").join(numberSet);
            String content = this.getWwMsg(templateEnum.getCode(), templateEnum.getDefaulValue());
            System.out.println("ygzc ZcComponent sendMsg() toUser = " + toUser + ", contentValue = " + content);
            ZcWeChatUtil.send(toUser, content);
        }
        catch (Exception e) {
            System.out.println("ygzc ZcComponent sendMsg() \u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void sendMsg(Map<String, String> wwMap) {
        System.out.println("ygzc_ZcComponent sendMsg() wwMap = " + JSON.toJSONString(wwMap));
        if (MapUtils.isEmpty(wwMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : wwMap.entrySet()) {
            String toUser = entry.getKey();
            String msg = entry.getValue();
            try {
                ZcWeChatUtil.send(toUser, msg);
            }
            catch (Exception ignored) {
                System.out.println("ygzc_ZcComponent sendMsg() \u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u5931\u8d25 toUser = " + toUser + ", msg = " + msg);
            }
        }
    }

    public String getUserId(String personId) {
        String userId = "";
        String sql = "select FID from T_PM_USER  where FPERSONID = '" + personId + "'";
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            if (rs.next()) {
                userId = rs.getString(1);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return userId;
    }

    public Map<String, ZcDTO> mapZc(Set<String> zcIdSet) {
        List<ZcDTO> list = this.listZc(zcIdSet);
        return list.stream().collect(Collectors.toMap(ZcDTO::getId, k -> k, (v1, v2) -> v1));
    }

    public List<ZcDTO> listZc(Set<String> zcIdSet) {
        ArrayList zcList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(zcIdSet)) {
            return zcList;
        }
        String sql = "/*dialect*/ select zc.FID                                        id,        zc.FPERSONID                                  personId,        zc.FNUMBER                                    fnumber,        zc.FNAME_L2                                   name,        zc.CFPOSITIONID                               positionId,        zc.CFPOSITIONNAME                             positionName,        zc.CFORGID                                    orgId,        zc.CFORGNAME                                  orgName,        deptFzr.FID                                   deptFzrId,        deptFzr.FNUMBER                               deptFzrNumber,        deptFzr.FNAME_L2                              deptFzrName,        hrbp.FID                                      hrbpId,        hrbp.FNUMBER                                  hrbpNumber,        hrbp.FNAME_L2                                 hrbpName,        zc.CFMQDJ                                     mqdj,        zc.CFSQDJ                                     sqdj,        zc.CFZZDJ                                     zzdj,        zc.CFSQDJOPTION                               ccdj,        to_char(zc.CFBMSJ, 'yyyy-mm-dd hh24:mi:ss')   bmsj,        to_char(zc.CFSHSJ, 'yyyy-mm-dd hh24:mi:ss')   shsj,        zc.CFBMSHR                                    bmshr,        zc.CFAUDITSTATUS                              auditStatus,        zc.CFCPDD                                     cpdd,        to_char(zc.CFCPSJ, 'yyyy-MM-dd HH24:mi')      cpsj,        zc.CFCPZT                                     cpzt,        zc.CFCPTSNR                                   cptsnr,        zc.CFCPNOTE                                   cpNote,        to_char(zc.CFXMCKF)                           xmckf,        to_char(zc.CFXMPJF)                           xmpjf,        to_char(zc.CFZYCKF)                           zyckf,        to_char(zc.CFZYPJF)                           zypjf,        zc.CFJGTZZT                                   spzt,        to_char(zc.CFJGTZSJ, 'yyyy-mm-dd hh24:mi:ss') jgtzsj,        zc.CFCPNF                                     cycle from CT_MP_YGZC zc          left join T_Org_Admin org on zc.CFORGID = org.FID          left join T_Org_Position pos on zc.CFPOSITIONID = pos.FID          left join T_Bd_Person deptFzr on zc.CFFZRID = deptFzr.FID          left join T_Bd_Person hrbp on zc.CFHRBPID = hrbp.FID where zc.FID in (" + ZcUtil.in(zcIdSet) + ") " + "order by org.FSORTCODE, org.FLONGNUMBER, pos.FINDEX, zc.CFSQDJ ";
        System.out.println("ygzc_ZcComponent listZc() sql = " + sql);
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            while (rs.next()) {
                ZcDTO zc = new ZcDTO();
                String id = rs.getString("id");
                zc.setId(id);
                zc.setPersonId(rs.getString("personId"));
                zc.setNumber(rs.getString("fnumber"));
                zc.setName(rs.getString("name"));
                zc.setPersonId(rs.getString("positionId"));
                zc.setPositionName(rs.getString("positionName"));
                zc.setOrgId(rs.getString("orgId"));
                zc.setOrgName(rs.getString("orgName"));
                zc.setDeptFzrId(rs.getString("deptFzrId"));
                zc.setDeptFzrNumber(rs.getString("deptFzrNumber"));
                zc.setDeptFzrName(rs.getString("deptFzrName"));
                zc.setHrbpId(rs.getString("hrbpId"));
                zc.setHrbpNumber(rs.getString("hrbpNumber"));
                zc.setHrbpName(rs.getString("hrbpName"));
                zc.setMqdj(StringUtils.trimToEmpty((String)rs.getString("mqdj")));
                zc.setSqdj(StringUtils.trimToEmpty((String)rs.getString("sqdj")));
                zc.setZzdj(StringUtils.trimToEmpty((String)rs.getString("zzdj")));
                zc.setCcdj(StringUtils.trimToEmpty((String)rs.getString("ccdj")));
                zc.setBmsj(StringUtils.trimToEmpty((String)rs.getString("bmsj")));
                zc.setShsj(StringUtils.trimToEmpty((String)rs.getString("shsj")));
                zc.setBmshr(StringUtils.trimToEmpty((String)rs.getString("bmshr")));
                zc.setAuditStatus(StringUtils.trimToEmpty((String)rs.getString("auditStatus")));
                zc.setCpdd(StringUtils.trimToEmpty((String)rs.getString("cpdd")));
                zc.setCpsj(StringUtils.trimToEmpty((String)rs.getString("cpsj")));
                zc.setCpzt(StringUtils.trimToEmpty((String)rs.getString("cpzt")));
                zc.setCptsnr(StringUtils.trimToEmpty((String)rs.getString("cptsnr")));
                zc.setCpNote(StringUtils.trimToEmpty((String)rs.getString("cpNote")));
                zc.setZyckf(StringUtils.trimToEmpty((String)rs.getString("zyckf")));
                zc.setZypjf(StringUtils.trimToEmpty((String)rs.getString("zypjf")));
                zc.setXmckf(StringUtils.trimToEmpty((String)rs.getString("xmckf")));
                zc.setXmpjf(StringUtils.trimToEmpty((String)rs.getString("xmpjf")));
                zc.setSpzt(StringUtils.trimToEmpty((String)rs.getString("spzt")));
                zc.setJgtzsj(StringUtils.trimToEmpty((String)rs.getString("jgtzsj")));
                zc.setCycle(StringUtils.trimToEmpty((String)rs.getString("cycle")));
                zcList.add(zc);
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_ZcComponent listZc() e = " + ExceptionUtils.getStackTrace((Throwable)e) + ", sql = " + sql);
        }
        return zcList;
    }

    public ZcDTO getZc(String zcId) {
        if (StringUtils.isBlank((CharSequence)zcId)) {
            return null;
        }
        String sql = "/*dialect*/ select zc.FID                                        id,        zc.FPERSONID                                  personId,        zc.FNUMBER                                    fnumber,        zc.FNAME_L2                                   name,        zc.CFPOSITIONID                               positionId,        zc.CFPOSITIONNAME                             positionName,        zc.CFORGID                                    orgId,        zc.CFORGNAME                                  orgName,        deptFzr.FID                                   deptFzrId,        deptFzr.FNUMBER                               deptFzrNumber,        deptFzr.FNAME_L2                              deptFzrName,        hrbp.FID                                      hrbpId,        hrbp.FNUMBER                                  hrbpNumber,        hrbp.FNAME_L2                                 hrbpName,        zc.CFMQDJ                                     mqdj,        zc.CFSQDJ                                     sqdj,        zc.CFZZDJ                                     zzdj,        zc.CFSQDJOPTION                               ccdj,        to_char(zc.CFBMSJ, 'yyyy-mm-dd hh24:mi:ss')   bmsj,        to_char(zc.CFSHSJ, 'yyyy-mm-dd hh24:mi:ss')   shsj,        zc.CFBMSHR                                    bmshr,        zc.CFAUDITSTATUS                              auditStatus,        zc.CFCPDD                                     cpdd,        to_char(zc.CFCPSJ, 'yyyy-MM-dd HH24:mi')      cpsj,        zc.CFCPZT                                     cpzt,        zc.CFCPTSNR                                   cptsnr,        zc.CFCPNOTE                                   cpNote,        to_char(zc.CFXMCKF)                           xmckf,        to_char(zc.CFXMPJF)                           xmpjf,        to_char(zc.CFZYCKF)                           zyckf,        to_char(zc.CFZYPJF)                           zypjf,        zc.CFJGTZZT                                   spzt,        to_char(zc.CFJGTZSJ, 'yyyy-mm-dd hh24:mi:ss') jgtzsj from CT_MP_YGZC zc          left join T_Bd_Person deptFzr on zc.CFFZRID = deptFzr.FID          left join T_Bd_Person hrbp on zc.CFHRBPID = hrbp.FID where zc.FID = '" + zcId + "' ";
        ZcDTO zc = null;
        try (IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);){
            if (rs.next()) {
                zc = new ZcDTO();
                zc.setId(rs.getString("id"));
                zc.setPersonId(rs.getString("personId"));
                zc.setNumber(rs.getString("fnumber"));
                zc.setName(rs.getString("name"));
                zc.setPersonId(rs.getString("positionId"));
                zc.setPositionName(rs.getString("positionName"));
                zc.setOrgId(rs.getString("orgId"));
                zc.setOrgName(rs.getString("orgName"));
                zc.setDeptFzrId(rs.getString("deptFzrId"));
                zc.setDeptFzrNumber(rs.getString("deptFzrNumber"));
                zc.setDeptFzrName(rs.getString("deptFzrName"));
                zc.setHrbpId(rs.getString("hrbpId"));
                zc.setHrbpNumber(rs.getString("hrbpNumber"));
                zc.setHrbpName(rs.getString("hrbpName"));
                zc.setMqdj(StringUtils.trimToEmpty((String)rs.getString("mqdj")));
                zc.setSqdj(StringUtils.trimToEmpty((String)rs.getString("sqdj")));
                zc.setZzdj(StringUtils.trimToEmpty((String)rs.getString("zzdj")));
                zc.setCcdj(StringUtils.trimToEmpty((String)rs.getString("ccdj")));
                zc.setBmsj(StringUtils.trimToEmpty((String)rs.getString("bmsj")));
                zc.setShsj(StringUtils.trimToEmpty((String)rs.getString("shsj")));
                zc.setBmshr(StringUtils.trimToEmpty((String)rs.getString("bmshr")));
                zc.setAuditStatus(StringUtils.trimToEmpty((String)rs.getString("auditStatus")));
                zc.setCpdd(StringUtils.trimToEmpty((String)rs.getString("cpdd")));
                zc.setCpsj(StringUtils.trimToEmpty((String)rs.getString("cpsj")));
                zc.setCpzt(StringUtils.trimToEmpty((String)rs.getString("cpzt")));
                zc.setCptsnr(StringUtils.trimToEmpty((String)rs.getString("cptsnr")));
                zc.setCpNote(StringUtils.trimToEmpty((String)rs.getString("cpNote")));
                zc.setZyckf(StringUtils.trimToEmpty((String)rs.getString("zyckf")));
                zc.setZypjf(StringUtils.trimToEmpty((String)rs.getString("zypjf")));
                zc.setXmckf(StringUtils.trimToEmpty((String)rs.getString("xmckf")));
                zc.setXmpjf(StringUtils.trimToEmpty((String)rs.getString("xmpjf")));
                zc.setSpzt(StringUtils.trimToEmpty((String)rs.getString("spzt")));
                zc.setJgtzsj(StringUtils.trimToEmpty((String)rs.getString("jgtzsj")));
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_ZcComponent getZc() e = " + ExceptionUtils.getStackTrace((Throwable)e) + ", sql = " + sql);
        }
        if (zc != null) {
            zc.setCpgList(this.listCpg(zcId));
        }
        return zc;
    }

    public boolean tx(List<String> stmtSqls, Map<String, List<Object[]>> psSqlMap) throws BOSException, SQLException {
        if (CollectionUtils.isEmpty((Collection)stmtSqls)) {
            stmtSqls = Lists.newArrayList();
        }
        if (MapUtils.isEmpty((Map)psSqlMap)) {
            psSqlMap = Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty((Collection)stmtSqls) && MapUtils.isEmpty((Map)psSqlMap)) {
            return false;
        }
        Connection conn = null;
        ArrayList stmtList = Lists.newArrayList();
        ArrayList psList = Lists.newArrayList();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            System.out.println("ygzc_ZcComponent doArrange() \u83b7\u53d6DB\u8fde\u63a5\u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        try {
            for (String string : stmtSqls) {
                Statement stmt = conn.createStatement();
                stmt.execute(string);
                stmtList.add(stmt);
            }
            for (Map.Entry entry : psSqlMap.entrySet()) {
                String sql = (String)entry.getKey();
                List paramList = (List)entry.getValue();
                PreparedStatement ps = this.prepare(conn, sql, paramList);
                ps.executeBatch();
                psList.add(ps);
            }
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            System.out.println("ygzc_ZcComponent tx() \u6279\u91cf\u6267\u884cSQL\u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
            throw new BOSException("sql execute tx exception : ", (Throwable)e);
        }
        finally {
            for (Statement stmt : stmtList) {
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            }
            for (Statement ps : psList) {
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
            }
        }
        return true;
    }

    private PreparedStatement prepare(Connection conn, String sql, List<Object[]> paramList) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        for (Object[] objArr : paramList) {
            for (int i = 0; i < objArr.length; ++i) {
                if (objArr[i] != null) {
                    ps.setObject(i + 1, objArr[i]);
                    continue;
                }
                ps.setNull(i + 1, 12);
            }
            ps.addBatch();
        }
        return ps;
    }

    public ZcSpSubjectDTO getSubjectByName(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            String sql = "select FID, FNAME_L2 from CT_MP_ZCSPSUBJECT where FNAME_L2 = '" + name + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                if (rs.next()) {
                    ZcSpSubjectDTO dto = new ZcSpSubjectDTO();
                    dto.setId(rs.getString("FID"));
                    dto.setName(rs.getString("FNAME_L2"));
                    return dto;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ZcSpSubjectDTO getSubject(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String sql = "select FID, FNAME_L2, FDESCRIPTION_L2, CFSTATUS, CFLOG from CT_MP_ZcSpSubject where FID = '" + id + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                if (rs.next()) {
                    ZcSpSubjectDTO subject = new ZcSpSubjectDTO();
                    subject.setId(rs.getString("FID"));
                    subject.setName(rs.getString("FNAME_L2"));
                    subject.setDesc(rs.getString("FDESCRIPTION_L2"));
                    subject.setStatus(rs.getString("CFSTATUS"));
                    subject.setLog(rs.getString("CFLOG"));
                    return subject;
                }
            }
            catch (Exception e) {
                System.out.println("ygzc_ZcComponent _e getSubject() e = " + ExceptionUtils.getStackTrace((Throwable)e) + ", sql = " + sql);
            }
        }
        return null;
    }

    public Map<String, SubjectPersonDTO> mapSpSubjectSpr(String subjectId) {
        List<SubjectPersonDTO> list = this.listSpSubjectSpr(subjectId);
        return list.stream().collect(Collectors.toMap(SubjectPersonDTO::getPersonId, k -> k, (v1, v2) -> v1));
    }

    public List<SubjectPersonDTO> listSpSubjectSpr(String subjectId) {
        if (StringUtils.isNotBlank((CharSequence)subjectId)) {
            String sql = "select sp.FID id, p.FID personId, p.FNUMBER personNumber, p.FNAME_L2 personName, sp.CFSTATUS status, to_char(sp.CFSPTIME, 'yyyy-mm-dd hh24:mi:ss') spTime from CT_MP_ZcSpSubjectPerson sp, T_BD_Person p where sp.CFPERSONID = p.FID and CFSUBJECTID = '" + subjectId + "'";
            try {
                ArrayList list = Lists.newArrayList();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                while (rs.next()) {
                    SubjectPersonDTO dto = new SubjectPersonDTO();
                    dto.setId(rs.getString("id"));
                    dto.setPersonId(rs.getString("personId"));
                    dto.setPersonNumber(rs.getString("personNumber"));
                    dto.setPersonName(rs.getString("personName"));
                    dto.setStatus(rs.getString("status"));
                    dto.setSpTime(rs.getString("spTime"));
                    list.add(dto);
                }
                return list;
            }
            catch (Exception e) {
                System.out.println("ygzc_ZcComponent _e getSubjectById() e = " + ExceptionUtils.getStackTrace((Throwable)e) + ", sql = " + sql);
            }
        }
        return Lists.newArrayList();
    }

    public Set<String> listSpSubjectZcIds(String subjectId) {
        if (StringUtils.isNotBlank((CharSequence)subjectId)) {
            String sql = "select CFZCID from CT_MP_ZcSpSubjectRelation where CFSUBJECTID = '" + subjectId + "'";
            try {
                HashSet zcIdSet = Sets.newHashSet();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                while (rs.next()) {
                    zcIdSet.add(rs.getString(1));
                }
                return zcIdSet;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Sets.newHashSet();
    }

    public Set<String> listSpSubjectZcIds(Set<String> subjectIdSet) {
        if (CollectionUtils.isNotEmpty(subjectIdSet)) {
            String sql = "select CFZCID from CT_MP_ZcSpSubjectRelation where CFSUBJECTID in (" + ZcUtil.in(subjectIdSet) + ")";
            try {
                HashSet zcIdSet = Sets.newHashSet();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                while (rs.next()) {
                    zcIdSet.add(rs.getString(1));
                }
                return zcIdSet;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Sets.newHashSet();
    }

    public List<PersonDTO> listPersonsByIdSet(HashSet<String> id) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(id)) {
            return list;
        }
        String sql = "/*dialect*/ select p.FID, p.FNUMBER, p.FNAME_L2 from T_BD_Person p          left join T_Hr_EmpLaborRelation e on e.FPERSONID = p.FID          left join T_Hr_BDEmployeeType t on e.FLABORRELATIONSTATEID = t.FID where t.FNAME_L2 not like '%\u79bb\u804c%' and p.FID in (" + ZcUtil.in(id) + ") ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                PersonDTO dto = new PersonDTO();
                dto.setId(rs.getString(1));
                dto.setNumber(rs.getString(2));
                dto.setName(rs.getString(3));
                list.add(dto);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return list;
    }

    public String getCurrCycle() {
        return "2021";
    }

    public Map<String, ZcSpSubjectDTO> mapSpSubject(Set<String> idSet) {
        List<ZcSpSubjectDTO> spSubjectList = this.listSpSubject(idSet);
        return spSubjectList.stream().collect(Collectors.toMap(ZcSpSubjectDTO::getId, k -> k, (v1, v2) -> v1));
    }

    public List<ZcSpSubjectDTO> listSpSubject(Set<String> idSet) {
        if (CollectionUtils.isNotEmpty(idSet)) {
            String sql = "select FID, FNAME_L2, FDESCRIPTION_L2, CFSTATUS, CFLOG from CT_MP_ZcSpSubject where FID in (" + ZcUtil.in(idSet) + ")";
            try {
                ArrayList list = Lists.newArrayList();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                while (rs.next()) {
                    ZcSpSubjectDTO subject = new ZcSpSubjectDTO();
                    subject.setId(rs.getString("FID"));
                    subject.setName(rs.getString("FNAME_L2"));
                    subject.setDesc(rs.getString("FDESCRIPTION_L2"));
                    subject.setStatus(rs.getString("CFSTATUS"));
                    subject.setLog(rs.getString("CFLOG"));
                    list.add(subject);
                }
                return list;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Lists.newArrayList();
    }

    public Set<String> allSmallStep() {
        String sql = "select FNAME_L2 from CT_MP_ZCDJGZ where CFTYPE = '" + ZcStepGradeEnum.SMALL_STEP.getCode() + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            HashSet set = Sets.newHashSet();
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            return set;
        }
        catch (Exception exception) {
            return Sets.newHashSet();
        }
    }
}

