/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.zimport;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseColumnInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseImportService;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseRowInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.zc.web.zenum.ZcShztEnum;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class YgzcImportService
extends BaseImportService {
    private static final String LOG_HEAD = "ygzc_import ";

    protected void verifyRowBiz2(BaseRowInfo row) throws ImportException {
        Context ctx = this.getContext();
        BaseColumnInfo columnInfo = null;
        Iterator it = this.getColumnIterator();
        HashMap<String, String> validMap = new HashMap<String, String>();
        while (it.hasNext()) {
            columnInfo = (BaseColumnInfo)it.next();
            if (columnInfo == null) continue;
            System.out.println("ygzc_import columnInfo = " + JSON.toJSONString((Object)columnInfo));
            if (!"number".equals(columnInfo.getPropName())) continue;
            validMap.put(columnInfo.getPropName(), row.getValueOfStringByIndex(columnInfo.getColumnIndex()));
        }
        System.out.println("ygzc_import validMap = " + JSON.toJSONString(validMap));
        if ("140850".equals(validMap.get("number"))) {
            throw new ImportException("140850\u62a5\u9519");
        }
        System.out.println("ygzc_import verifyRowBiz row = " + JSON.toJSONString((Object)row));
        super.verifyRowBiz(row);
    }

    protected void importOverride(BaseRowInfo row) throws ImportException {
        System.out.println("ygzc_import importOverride() \u8fdb\u5165\u3002\u3002\u3002");
        CoreBaseInfo coreBaseInfo = this.transRowToObejct(row);
        String number = (String)coreBaseInfo.get("number");
        PersonInfo deptFzr = (PersonInfo)coreBaseInfo.get("fzr");
        String deptFzrNumber = deptFzr.getNumber();
        PersonInfo hrbp = (PersonInfo)coreBaseInfo.get("hrbp");
        coreBaseInfo.put("spHrbp", (Object)hrbp);
        Context ctx = this.getContext();
        Map<String, Map<String, String>> personMap = this.getPersonMap(ctx, number, deptFzrNumber, hrbp.getNumber());
        Map<String, String> staffMap = personMap.get(number);
        String personId = staffMap.get("personId");
        coreBaseInfo.put("name", StringUtils.isNotBlank((CharSequence)staffMap.get("personName")) ? staffMap.get("personName") : coreBaseInfo.get("name"));
        try {
            PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where number = '" + number + "'");
            if (personColl != null && personColl.size() > 0) {
                PersonInfo personInfo = personColl.get(0);
                coreBaseInfo.put("person", (Object)personInfo);
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_import importOverride() \u83b7\u53d6\u5458\u5de5ID\u5f02\u5e38");
        }
        coreBaseInfo.put("positionId", (Object)staffMap.get("positionId"));
        coreBaseInfo.put("positionName", (Object)staffMap.get("positionName"));
        Map<String, String> jobGradeMap = this.getJobGrade(ctx, personId);
        coreBaseInfo.put("currJobGrade", (Object)jobGradeMap.get("id"));
        coreBaseInfo.put("xueli", (Object)staffMap.get("xueli"));
        coreBaseInfo.put("pdqy", (Object)staffMap.get("pdqy"));
        coreBaseInfo.put("rzjl", (Object)staffMap.get("rzjl"));
        coreBaseInfo.put("cpnf", (Object)"2021");
        coreBaseInfo.put("orgId", (Object)staffMap.get("orgId"));
        coreBaseInfo.put("orgName", (Object)staffMap.get("orgName"));
        coreBaseInfo.put("auditStatus", (Object)ZcShztEnum.QULIFY_NOT_AUDIT.getCode());
        this.saveData(coreBaseInfo);
    }

    private Map<String, Map<String, String>> getPersonMap(Context ctx, String number, String fzrNumber, String hrbpNumber) {
        String sql = "/*dialect */ select p.FNUMBER                                                                             person_number,\n       p.FID                                                                                 person_id,\n       p.FNAME_L2                                                                            person_name,\n       pos.FID                                                                               position_id,\n       pos.FNAME_L2                                                                          position_name,\n       (select d.FNAME_L2\n        from T_HR_PERSONDEGREE pd\n                 join T_BD_HRDIPLOMA d on pd.FDIPLOMA = d.FID\n        where pd.FISHIGHEST = 1\n          and pd.FPERSONID = p.FID)                                                          person_diploma,\n       (select pd.cfpdqy from CT_MP_Rcpdb pd where pd.cfsfzjyc = 1 and pd.fpersonid = p.FID) person_pdqy,\n       CFRZJL                                                                                person_rzjl,\n       o.FID                                                                                 person_org_id,\n       o.FNAME_L2                                                                            person_org_name\nfrom T_BD_PERSON p,\n     T_Org_PositionMember posm,\n     T_ORG_POSITION pos,\n     T_Org_Admin o,\n     T_Hr_EmpLaborRelation empl,\n     T_Hr_BDEmployeeType empt\nwhere p.FID = posm.FPERSONID\n  and posm.FPOSITIONID = pos.FID\n  and posm.FISPRIMARY = 1\n  and o.FID = pos.FADMINORGUNITID\n  and empl.FPERSONID = p.FID\n  and empl.FLABORRELATIONSTATEID = empt.FID\n  and empt.FNAME_L2 not like '%\u79bb\u804c%'\n  and p.FNUMBER in ('" + number + "', '" + fzrNumber + "', '" + hrbpNumber + "')";
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);){
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personId", rs.getString("person_id"));
                map.put("personNumber", rs.getString("person_number"));
                map.put("personName", rs.getString("person_name"));
                map.put("positionId", rs.getString("position_id"));
                map.put("positionName", rs.getString("position_name"));
                map.put("xueli", rs.getString("person_diploma"));
                map.put("pdqy", rs.getString("person_pdqy"));
                map.put("rzjl", rs.getString("person_rzjl"));
                map.put("orgId", rs.getString("person_org_id"));
                map.put("orgName", rs.getString("person_org_name"));
                resultMap.put(rs.getString("person_number"), map);
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_import \u804c\u7ea7\u67e5\u8be2\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (resultMap.get(number) == null) {
            throw new ImportException("\u5458\u5de5\u7f16\u7801\u9519\u8bef\uff0c\u5458\u5de5\u4e0d\u5b58\u5728\u6216\u5df2\u79bb\u804c");
        }
        if (resultMap.get(fzrNumber) == null) {
            throw new ImportException("\u90e8\u95e8\u8d1f\u8d23\u4eba\u7f16\u7801\u9519\u8bef\uff0c\u90e8\u95e8\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\u6216\u5df2\u79bb\u804c");
        }
        if (resultMap.get(hrbpNumber) == null) {
            throw new ImportException("HRBP\u7f16\u7801\u9519\u8bef\uff0cHRBP\u4e0d\u5b58\u5728\u6216\u5df2\u79bb\u804c");
        }
        System.out.println("ygzc_import getPersonMap() resultMap = " + JSON.toJSONString(resultMap));
        return resultMap;
    }

    private Map<String, Object> getBigStepInfo(Context ctx, String personId) {
        System.out.println("ygzc_import getBigStepInfo() \u8fdb\u5165 personId = " + personId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date bigStepDate = null;
        String sql = "/*dialect*/ select CFDRBZYRQ from CT_MP_Zyjsry where CFSFZJYC = '1' and FPERSONID = '" + personId + "' order by CFDRBZYRQ desc";
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);){
            if (rs.next()) {
                bigStepDate = rs.getDate("CFDRBZYRQ");
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_import \u67e5\u8be2\u62c5\u4efb\u5927\u6b65\u65e5\u671f\u4fe1\u606f\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (bigStepDate != null) {
            try {
                Instant instant = Instant.ofEpochMilli(bigStepDate.getTime());
                long days = Duration.between(instant, Instant.now()).toDays();
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(days)).divide(new BigDecimal("365"), 1, 4);
                resultMap.put("bigStepDate", bigStepDate);
                resultMap.put("bigStepTime", bigDecimal.toString());
            }
            catch (Exception e) {
                System.out.println("ygzc_import \u89e3\u6790\u62c5\u4efb\u5927\u6b65\u65e5\u671f\u4fe1\u606f\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        System.out.println("ygzc_import getBigStepInfo() resultMap = " + JSON.toJSONString(resultMap));
        return resultMap;
    }

    private String getContractFirstParty(Context ctx, String personId) {
        String contractFirstParty = "";
        String sql = "/*dialect*/  select cfp.FNUMBER fnumber  from t_hr_employeeContract c,      t_hr_labContractFirstParty cfp  where c.FCONTFIRSTPARTYID = cfp.FID   and c.FEMPLOYEEID = '" + personId + "'";
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);){
            while (rs.next() && !StringUtils.isNotBlank((CharSequence)(contractFirstParty = rs.getString("fnumber")))) {
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_import getContractFirstParty() \u67e5\u8be2\u5408\u540c\u4e3b\u4f53\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (StringUtils.isBlank((CharSequence)contractFirstParty)) {
            System.out.println("ygzc_import getContractFirstParty() \u67e5\u8be2\u5408\u540c\u4e3b\u4f53\u4e3a\u7a7a sql = " + sql);
        }
        System.out.println("ygzc_import getContractFirstParty() contractFirstParty = " + contractFirstParty);
        return contractFirstParty;
    }

    private Map<String, String> getCurrJobGrade(Context ctx, String personId, String positionName) {
        String contractFirstParty = this.getContractFirstParty(ctx, personId);
        if (StringUtils.isBlank((CharSequence)contractFirstParty)) {
            return new HashMap<String, String>();
        }
        Map<String, String> jobGradeMap = this.getJobGrade(ctx, personId);
        if (MapUtils.isEmpty(jobGradeMap) || StringUtils.isBlank((CharSequence)jobGradeMap.get("id"))) {
            return new HashMap<String, String>();
        }
        String gradeType = "";
        String name = "074".equals(contractFirstParty) ? this.getLingzhiGradeName(ctx, jobGradeMap.get("name"), personId) : this.getTianhongGradeName(jobGradeMap.get("name"), gradeType);
        HashMap<String, String> currJobGradeMap = new HashMap<String, String>();
        currJobGradeMap.put("id", jobGradeMap.get("id"));
        currJobGradeMap.put("name", name);
        return currJobGradeMap;
    }

    private String getLingzhiGradeName(Context ctx, String jobGrade, String personId) {
        String gradeName = "";
        String sql = "/*dialect*/  select jg.FNAME_L2 job_grade, tr.FNAME_L2 grade_name  from CT_GRA_JobGradeChange jgc,      T_HR_JobGrade jg,      CT_MP_TechnicalRank tr  where jgc.CFJOBGRADEID = jg.FID   and jgc.FISNEW = '1'   and jgc.CFPERSONID = '" + personId + "' " + "  and jgc.CFJSDJID = tr.FID " + " order by jgc.CFSTARTDATE desc";
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);){
            while (rs.next() && !StringUtils.isNotBlank((CharSequence)(gradeName = rs.getString("grade_name")))) {
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_import getLingzhiGradeName() \u67e5\u8be2\u7075\u667a\u804c\u7ea7\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (StringUtils.isBlank((CharSequence)gradeName)) {
            System.out.println("ygzc_import getLingzhiGradeName() \u67e5\u8be2\u7075\u667a\u804c\u7ea7\u4e3a\u7a7a sql = " + sql);
            return jobGrade;
        }
        System.out.println("ygzc_import getLingzhiGrade() jobGrade = " + gradeName);
        return gradeName;
    }

    private Map<String, String> getJobGrade(Context ctx, String personId) {
        HashMap<String, String> jobGradeMap = new HashMap<String, String>();
        String sql = "/*dialect*/ select jg.FID FID, jg.FNAME_L2 FNAME from CT_GRA_JobGradeChange jgc, T_HR_JobGrade jg where jgc.CFJOBGRADEID = jg.FID and jgc.FISNEW = '1' and jgc.CFPERSONID = '" + personId + "' " + "order by jgc.CFSTARTDATE desc";
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);){
            while (rs.next()) {
                String id = rs.getString("FID");
                jobGradeMap.put("id", id);
                jobGradeMap.put("name", rs.getString("FNAME"));
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                break;
            }
        }
        catch (Exception e) {
            System.out.println("ygzc_import getJobGrade() \u67e5\u8be2\u804c\u7ea7\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)jobGradeMap.get("id")))) {
            System.out.println("ygzc_import getJobGrade() \u67e5\u8be2\u804c\u7ea7\u4e3a\u7a7a sql = " + sql);
        }
        System.out.println("ygzc_import getJobGrade() jobGradeMap = " + JSON.toJSONString(jobGradeMap));
        return jobGradeMap;
    }

    private String getTianhongGradeName(String jobGrade, String positionName) {
        HashMap<String, String> gradeMap = new HashMap<String, String>();
        gradeMap.put("4", "\u521d\u7ea7");
        gradeMap.put("5-1", "\u4e2d\u7ea71");
        gradeMap.put("5-2", "\u4e2d\u7ea72");
        gradeMap.put("6-1", "\u4e2d\u7ea71");
        gradeMap.put("6-2", "\u4e2d\u7ea72");
        if (positionName.contains("\u8425\u9500") || positionName.contains("\u7b56\u5212") || positionName.contains("\u8bbe\u8ba1")) {
            gradeMap.put("6-1", "\u9ad8\u7ea71");
            gradeMap.put("6-2", "\u9ad8\u7ea72");
        }
        gradeMap.put("7-1", "\u9ad8\u7ea71");
        gradeMap.put("7-2", "\u9ad8\u7ea72");
        gradeMap.put("8-1", "\u8d44\u6df11");
        gradeMap.put("8-2", "\u8d44\u6df12");
        gradeMap.put("9-1", "\u8d44\u6df13");
        gradeMap.put("9-2", "\u8d44\u6df14");
        gradeMap.put("10", "\u8d44\u6df15");
        gradeMap.put("11", "\u4e13\u5bb6");
        gradeMap.put("12", "\u9ad8\u7ea7\u4e13\u5bb6");
        String name = StringUtils.isNotBlank((CharSequence)((CharSequence)gradeMap.get(jobGrade))) ? (String)gradeMap.get(jobGrade) : jobGrade;
        System.out.println("ygzc_import getTianhongGradeName() tianhongGradeName = " + name);
        return name;
    }
}

