/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.secret.SecretUtil;
import com.kingdee.shr.compensation.util.BaseUtils;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UserPayTotalServiceEx
implements IHRMsfService {
    private final BaseUtils util = new BaseUtils();

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        PersonInfo person;
        SimpleDateFormat sdf;
        Calendar cal;
        ArrayList periodResult;
        block38: {
            String periodParam = (String)param.get("periodParam");
            periodResult = new ArrayList();
            cal = Calendar.getInstance();
            sdf = new SimpleDateFormat("yyyyMM");
            if (periodParam == null || "".equals(periodParam)) {
                cal.setTime(new Date());
                cal.add(2, 1);
            } else {
                cal.setTime(sdf.parse(periodParam));
            }
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo == null) {
                String userId = (String)ctx.get((Object)"userID");
                userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
            }
            if ((person = userInfo.getPerson()) != null) break block38;
            return null;
        }
        try {
            int i;
            IRowSet list;
            String sql;
            String personid = person.getId().toString();
            int minYear = 0;
            int minMonth = 0;
            int year = 0;
            int month = 0;
            if (BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_minYear")) == null) {
                sql = "select min(FPeriodYear) from T_HR_SCmpCalTable where FPersonID = ? and FCalState >= 2";
                list = SqlUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{person.getId().toString()});
                if (list.next()) {
                    minYear = list.getInt(1);
                    BaseUtils.setCacheMap((String)(String.valueOf(personid) + "_minYear"), (Object)minYear);
                }
            } else {
                minYear = this.util.toInt(BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_minYear")));
            }
            if (BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_minMonth")) == null) {
                sql = "select min(FPeriodMonth) from T_HR_SCmpCalTable where FPersonID = ? and FPeriodYear = ? and FCalState >= 2";
                list = SqlUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{person.getId().toString(), minYear});
                if (list.next()) {
                    minMonth = list.getInt(1);
                    BaseUtils.setCacheMap((String)(String.valueOf(personid) + "_minMonth"), (Object)minMonth);
                }
            } else {
                minMonth = this.util.toInt(BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_minMonth")));
            }
            Map<String, String> calNameMap = new HashMap();
            if (BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_calNameMap")) == null) {
                CalSchemeCollection calSchemes = CalSchemeFactory.getLocalInstance((Context)ctx).getCalSchemeCollection();
                int i2 = 0;
                while (i2 < calSchemes.size()) {
                    calNameMap.put(calSchemes.get(i2).getId().toString(), calSchemes.get(i2).getName());
                    ++i2;
                }
                BaseUtils.setCacheMap((String)(String.valueOf(personid) + "_calNameMap"), calNameMap);
            } else {
                calNameMap = (Map)BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_calNameMap"));
            }
            Map<String, CmpItemInfo> cmpItemMap = new HashMap();
            if (BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_cmpItemMap")) == null) {
                CmpItemCollection cmpItems = CmpItemFactory.getLocalInstance((Context)ctx).getCmpItemCollection("select *,cmpItemCatalog.name");
                i = 0;
                while (i < cmpItems.size()) {
                    cmpItemMap.put("S" + cmpItems.get(i).getFieldSn(), cmpItems.get(i));
                    ++i;
                }
                BaseUtils.setCacheMap((String)(String.valueOf(personid) + "_cmpItemMap"), cmpItemMap);
            } else {
                cmpItemMap = (Map)BaseUtils.getCacheMap((String)(String.valueOf(personid) + "_cmpItemMap"));
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select * from T_HR_SCmpCalTable t");
            sb.append(" left join T_HR_SCalScheme cal on t.FCalSchemeID = cal.FID");
            sb.append(" left join t_org_admin admin on cal.FAdminOrgUnitID = admin.FID");
            sb.append(" left join t_org_admin org on cal.fadminorgunitid = org.fid");
            sb.append(" where t.FPersonID = ? and t.FPeriodYear = ? and t.FPeriodMonth = ?");
            sb.append(" and t.FCalState >= 2 order by org.fsortcode,cal.fnumber");
            i = 0;
            while (i < 3) {
                cal.add(2, -1);
                year = cal.get(1);
                month = cal.get(2) + 1;
                IRowSet list2 = SqlUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{person.getId().toString(), year, month});
                LinkedHashMap calSchemeMap = new LinkedHashMap();
                while (list2.next()) {
                    Map timeMap;
                    String calSchemeId = list2.getString("FCalSchemeID");
                    Integer time = list2.getInt("FCalTime");
                    if (calSchemeId == null || "".equals(calSchemeId.trim())) {
                        calSchemeId = "";
                    }
                    if (!calSchemeMap.containsKey(calSchemeId)) {
                        String oql = "select id where isPayTotal = 1 and calScheme.id = '" + calSchemeId + "'";
                        CalSchemeItemCollection calSchemeItemCollection = CalSchemeItemFactory.getLocalInstance((Context)ctx).getCalSchemeItemCollection(oql);
                        if (calSchemeItemCollection == null || calSchemeItemCollection.size() > 0) {
                            // empty if block
                        }
                        calSchemeMap.put(calSchemeId, new LinkedHashMap());
                    }
                    if ((timeMap = (Map)calSchemeMap.get(calSchemeId)).containsKey(time)) continue;
                    Map<String, Object> datas = this.rowDatas(list2);
                    timeMap.put(time, datas);
                }
                ArrayList result2 = new ArrayList();
                for (String calSchemeId : calSchemeMap.keySet()) {
                    HashMap<String, Object> schemeObj = new HashMap<String, Object>();
                    if ("".equals(calSchemeId)) {
                        schemeObj.put("name", "\u540c\u6b65\u65b9\u6848");
                    } else {
                        schemeObj.put("name", calNameMap.get(calSchemeId));
                    }
                    Map timeMap = (Map)calSchemeMap.get(calSchemeId);
                    ArrayList timeArr = new ArrayList();
                    Map<String, Object> snCmpItems = this.snCmpItems(ctx, calSchemeId, (Map)calSchemeMap.get(calSchemeId), cmpItemMap);
                    List items = (List)snCmpItems.get("items");
                    Map isPayMap = (Map)snCmpItems.get("isPayMap");
                    LinkedHashMap itemMap = new LinkedHashMap();
                    for (CmpItemInfo item : items) {
                        int fieldSn = item.getFieldSn();
                        String catalog = item.getCmpItemCatalog().getName();
                        if (fieldSn <= 3) {
                            catalog = "_TOTAL";
                        }
                        if (fieldSn == 11) {
                            catalog = "_REMARK";
                        }
                        if (!itemMap.containsKey(catalog)) {
                            itemMap.put(catalog, new ArrayList());
                        }
                        ((List)itemMap.get(catalog)).add(new Object[]{item.getName(), fieldSn, item.getDataType(), item.getDataDot()});
                    }
                    for (Integer time : timeMap.keySet()) {
                        Map values = (Map)timeMap.get(time);
                        ArrayList catArr = new ArrayList();
                        for (String catalog : itemMap.keySet()) {
                            ArrayList payArr = new ArrayList();
                            List calItems = (List)itemMap.get(catalog);
                            for (Object[] item : calItems) {
                                HashMap<String, Object> payObj = new HashMap<String, Object>();
                                payObj.put("name", item[0]);
                                Object value = values.get("S" + item[1]);
                                if (item[2] == CmpItemDataType.NUMBER && value instanceof BigDecimal) {
                                    double doubleV = (value = SecretUtil.decode((Context)ctx, (BigDecimal)((BigDecimal)value), (String)person.getId().toString())) == null ? 0.0 : ((BigDecimal)value).doubleValue();
                                    value = FunctionTools.getRound((int)((CmpItemDataDot)item[3]).getValue(), (double)doubleV);
                                    if (doubleV == 0.0 && isPayMap.containsKey(item[1]) && 1 == (Integer)isPayMap.get(item[1])) continue;
                                }
                                if (this.util.isNullOrEmpty(new Object[]{value}) && isPayMap.containsKey(item[1]) && 1 == (Integer)isPayMap.get(item[1])) continue;
                                if (value == null) {
                                    payObj.put("pay", "");
                                } else {
                                    payObj.put("pay", value);
                                }
                                payArr.add(payObj);
                            }
                            HashMap<String, Object> catObj = new HashMap<String, Object>();
                            if (payArr.size() <= 0) continue;
                            catObj.put("catalog", catalog);
                            catObj.put("items", payArr);
                            catArr.add(catObj);
                        }
                        if (catArr.size() <= 0) continue;
                        HashMap<String, Serializable> timeObj = new HashMap<String, Serializable>();
                        timeObj.put("time", time);
                        timeObj.put("cats", catArr);
                        timeArr.add(timeObj);
                    }
                    if (timeArr.size() <= 0) continue;
                    schemeObj.put("times", timeArr);
                    result2.add(schemeObj);
                }
                HashMap<String, Object> obj = new HashMap<String, Object>();
                obj.put("year", year);
                obj.put("month", month);
                obj.put("period", sdf.format(cal.getTime()));
                obj.put("data", result2);
                periodResult.add(obj);
                ++i;
            }
            HashMap<String, Object> result3 = new HashMap<String, Object>();
            result3.put("datas", periodResult);
            if (minYear == 0 || year * 10000 + month <= minYear * 10000 + minMonth) {
                result3.put("hasMore", "N");
            } else {
                result3.put("hasMore", "Y");
            }
            return result3;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    private Map<String, Object> rowDatas(IRowSet list) throws SQLException {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        ResultSetMetaData meta = list.getMetaData();
        int cols = meta.getColumnCount();
        int i = 1;
        while (i <= cols) {
            datas.put(meta.getColumnName(i), list.getObject(i));
            ++i;
        }
        return datas;
    }

    private Map<String, Object> snCmpItems(Context ctx, String calSchemeId, Map<Integer, Map<String, Object>> timeMap, Map<String, CmpItemInfo> itemMap) throws BOSException {
        ArrayList<CmpItemInfo> items = new ArrayList<CmpItemInfo>();
        HashMap<Integer, Integer> isPayMap = new HashMap<Integer, Integer>();
        CalSchemeItemInfo calSchemeItemInfo = null;
        if (!"".equals(calSchemeId)) {
            String oql = "select cmpItem.*, cmpItem.cmpItemCatalog.name, isPayNull where calScheme.id = '" + calSchemeId + "' and isPayTotal = 1" + " order by cmpItem.cmpItemCatalog.number,sortSn,cmpItem.number";
            CalSchemeItemCollection col = CalSchemeItemFactory.getLocalInstance((Context)ctx).getCalSchemeItemCollection(oql);
            int i = 0;
            while (i < col.size()) {
                calSchemeItemInfo = col.get(i);
                if (calSchemeItemInfo.getCmpItem() != null) {
                    items.add(calSchemeItemInfo.getCmpItem());
                    isPayMap.put(calSchemeItemInfo.getCmpItem().getFieldSn(), calSchemeItemInfo.getIsPayNull() == null ? 0 : calSchemeItemInfo.getIsPayNull().getValue());
                }
                ++i;
            }
        } else {
            HashSet<String> itemCol = new HashSet<String>();
            for (int time : timeMap.keySet()) {
                Map<String, Object> datas = timeMap.get(time);
                for (String col : datas.keySet()) {
                    if (!col.startsWith("S")) continue;
                    Object data = datas.get(col);
                    if (data instanceof String && data != null && !"".equals(data)) {
                        itemCol.add(col);
                    }
                    if (!(data instanceof Number) || data == null || ((Number)data).doubleValue() == 0.0) continue;
                    itemCol.add(col);
                }
            }
            for (String itemSn : itemCol) {
                if (!itemMap.containsKey(itemSn)) continue;
                items.add(itemMap.get(itemSn));
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("items", items);
        map.put("isPayMap", isPayMap);
        return map;
    }
}

