/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.emp.web.handler;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.compensation.util.CmpUtils;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.emp.web.handler.EnterDateDTO;
import com.kingdee.shr.emp.web.handler.JobGradeDTO;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class EmpCompileHandle
extends ListHandler {
    private final Context ctx = SHRContext.getInstance().getContext();
    private ThreadLocal<AtomicInteger> threadLocal = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    private final List<String> orgLongNumber = new ArrayList<String>();
    private final Map<String, String> orgNames = new HashMap<String, String>();
    private final String jobIDs = "";
    private final String qtIDs = "";

    protected GridDataEntity getGridRequestData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        long start = System.currentTimeMillis();
        CmpUtils util = new CmpUtils();
        String filterItems = request.getParameter("filterItems");
        System.out.println("bianzhi18001 \u8fdb\u5165getGridRequestData(), filterItems = " + filterItems);
        String originLongNumber = "";
        Map<String, String> paramMap = this.putParamToMap(request);
        if (MapUtils.isNotEmpty(paramMap)) {
            originLongNumber = paramMap.get("adminOrgUnit");
        }
        if (StringUtils.isBlank((CharSequence)originLongNumber)) {
            String str = "SELECT * FROM T_Org_LayerType WHERE 1 = 0";
            return util.getSearchList(str, 1, 10, null, null, null);
        }
        boolean isSessionExsit = false;
        Object session = request.getSession().getAttribute("tempTable");
        if (UIRuleUtil.isNull((Object)session)) {
            request.getSession().setAttribute("tempTable", (Object)UUID.randomUUID().toString());
        } else {
            isSessionExsit = true;
        }
        int pageSize = util.toInt(util.getParameterByRequest((ServletRequest)request, "rows"));
        int page = util.toInt(util.getParameterByRequest((ServletRequest)request, "page"));
        ArrayList<Map<String, String>> planList = new ArrayList<Map<String, String>>();
        String actTableName = "";
        try {
            actTableName = this.tempTableIsExsit(this.ctx, request, isSessionExsit);
            if (UIRuleUtil.isNull((String)actTableName)) {
                actTableName = this.getTempTable(this.ctx);
                String tempTableName = this.getTempTable(this.ctx);
                this.selectPersonResultPutToList(this.ctx, originLongNumber, planList);
                this.insertDataToTable(planList, tempTableName, this.ctx);
                this.putTotalInfo(this.ctx, tempTableName, originLongNumber);
                this.insertDataToActTable(actTableName, tempTableName, originLongNumber);
                this.insertRecordToTable(this.ctx, actTableName, filterItems);
            }
        }
        catch (Exception var16) {
            var16.printStackTrace();
        }
        String viewSql = "select    fseq,    forgLongNumber, forgName, fpositionId, fpositionName, fbzs, fzbs,    fpersonName, fpersonNumber, fpersonLabor, fpersonGradeLevel, fpersonEnterDate,    fpersonGradeDate, fpersonPositionDate, fpersonGender, fpersonAge, fpersonDiploma, fpersonDm,    fpersonGlpxs, fpersonWed, fpersonJob, fpersonPdqy, fpersonAddress, fpersonRzjl,    fisAdmin, fisTatol from " + actTableName;
        GridDataEntity gridDataEntity = util.getSearchList(viewSql, page, pageSize, "seq", "asc", null);
        System.out.println("bianzhi\u8017\u65f6-\u5217\u8868\u67e5\u8be2- " + new DecimalFormat("#,###").format(System.currentTimeMillis() - start));
        return gridDataEntity;
    }

    private void insertDataToActTable(String actTableName, String tempTableName, String originLongNumber) throws BOSException, SQLException {
        String sql = "select admin.FID org_id, admin.FLONGNUMBER org_long_number from T_Org_Admin admin where admin.FISSEALUP = '0'   and admin.FLONGNUMBER like '" + originLongNumber + "%' " + "order by admin.FSORTCODE,admin.FLONGNUMBER ";
        IRowSet rs1 = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        int sum = 2;
        while (rs1.next()) {
            String orgLongNumber = rs1.getString("org_long_number");
            Map<String, String> enterDateMap = this.getEnterDateMap(rs1.getString("org_id"));
            Map<String, JobGradeDTO> jobGradeMap = this.getJobGradeMap(rs1.getString("org_id"));
            this.getAdminTotal(orgLongNumber, actTableName, tempTableName, sum);
            String groupBySQL = "select temp.forgLongNumber     org_long_number,        temp.forgName           org_name,        temp.fpositionId        position_id,        temp.fpositionName      position_name,        temp.fisTatol           is_tatol,        temp.fbzs               bzs,        temp.fzbs               zbs from " + tempTableName + " temp left join T_Org_Position pos on temp.fpositionId = pos.FID " + "where temp.forgLongNumber = '" + orgLongNumber + "' " + "order by pos.FINDEX ";
            IRowSet rs2 = DbUtil.executeQuery((Context)this.ctx, (String)groupBySQL);
            String orgName = "";
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            while (true) {
                if (!rs2.next()) break;
                orgName = rs2.getString("org_name");
                String positionName = rs2.getString("position_name");
                HashMap<String, String> actMap = new HashMap<String, String>();
                actMap.put("bzs", rs2.getString("bzs"));
                actMap.put("zbs", rs2.getString("zbs"));
                if ("1".equals(rs2.getString("is_tatol"))) {
                    actMap.put("orgName", "\u5408\u8ba1");
                    actMap.put("positionName", "");
                    actMap.put("isTatol", "1");
                    actMap.put("isAdmin", "");
                    actMap.put("seq", "0");
                    list.add(actMap);
                    continue;
                }
                actMap.put("orgLongNumber", rs2.getString("org_long_number"));
                actMap.put("orgName", orgName);
                actMap.put("positionId", rs2.getString("position_id"));
                actMap.put("positionName", positionName);
                actMap.put("isAdmin", "");
                actMap.put("isTatol", String.valueOf(sum));
                List<Map<String, String>> allList = this.getPersonList(actMap, enterDateMap, jobGradeMap);
                list.addAll(allList);
            }
            this.insertDataToTable(list, actTableName, this.ctx);
            ++sum;
        }
    }

    private List<Map<String, String>> getPersonList(Map<String, String> actMap, Map<String, String> enterDateMap, Map<String, JobGradeDTO> jobGradeMap) throws BOSException, SQLException {
        ArrayList<Map<String, String>> result2 = new ArrayList<Map<String, String>>();
        String orgLongNumber = actMap.get("orgLongNumber");
        String positionId = actMap.get("positionId");
        String personQuerySql = "/*dialect*/  select Person.FID                                                                                 person_id,        Person.FNAME_L2                                                                            person_name,        Person.FNUMBER                                                                             person_number,        type.FNAME_L2                                                                              person_labor,        Person.FGENDER                                                                             person_gender,        (to_char(sysdate, 'yyyy') - to_char(Person.FBIRTHDAY, 'yyyy'))                             person_age,        (select diploma.FNAME_L2         from T_HR_PERSONDEGREE persondegree                  join T_BD_HRDIPLOMA diploma on persondegree.FDIPLOMA = diploma.FID         where persondegree.FISHIGHEST = 1           and persondegree.FPERSONID = Person.FID)                                                person_diploma,        (select dm.FNAME_L2         from T_HR_Persondegree dg                  join T_BD_HrDiplomaModality dm on dg.FDIPLOMAMODALITY = dm.FID         where dg.FPERSONID = Person.FID           and dg.FISHIGHEST = 1)                                                                  person_dm,       (select glpxs.FNAME_L2 from CT_MP_GLPXS glpxs where glpxs.fid = Person.CFGLPXSID)          person_glpxs,        (select wed.FNAME_L2 from T_BD_HRWED wed where wed.FID = Person.FWEDID)                    person_wed,        (select to_char(max(r.FEFFDT), 'yyyy-MM-dd')         from T_HR_EmpOrgRelation r         where r.FPERSONID = Person.FID)                                                           person_position_date,        (select job.FNAME_L2 from T_Org_Job job where job.FID = Position.FJOBID)                   person_job,        (select pd.cfpdqy from CT_MP_Rcpdb pd where pd.cfsfzjyc = 1 and pd.fpersonid = Person.FID) person_pdqy,        Person.CFADDRESS                                                                           person_address,        Person.CFRZJL                                                                              person_rzjl  from T_BD_Person Person          inner join T_Org_PositionMember Member on Person.FID = Member.FPERSONID          inner join T_Org_Position Position on Member.FPOSITIONID = Position.FID          inner join T_Org_Admin Org on Org.FID = Position.FADMINORGUNITID          left join T_Hr_EmpLaborRelation empRelation on empRelation.FPERSONID = Person.FID          left join T_Hr_BDEmployeeType type on empRelation.FLABORRELATIONSTATEID = type.FID  where Member.FISPRIMARY = 1   and Position.FID = '" + positionId + "' " + "  and type.FNAME_L2 not like '%\u79bb\u804c%' " + "  and Org.FLONGNUMBER = '" + orgLongNumber + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)personQuerySql);
        if (rs.size() == 0) {
            actMap.put("seq", String.valueOf(this.threadLocal.get().incrementAndGet()));
            result2.add(actMap);
        } else {
            int i = 0;
            while (rs.next()) {
                HashMap<String, String> personMap = new HashMap<String, String>(actMap);
                String personId = rs.getString("person_id");
                personMap.put("personName", rs.getString("person_name"));
                personMap.put("personNumber", rs.getString("person_number"));
                personMap.put("personLabor", rs.getString("person_labor"));
                personMap.put("personGender", rs.getString("person_gender"));
                String ageStr = rs.getString("person_age");
                try {
                    ageStr = String.valueOf(Integer.parseInt(ageStr) - 1);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                personMap.put("personAge", ageStr);
                personMap.put("personDiploma", rs.getString("person_diploma"));
                personMap.put("personDm", rs.getString("person_dm"));
                personMap.put("personGlpxs", rs.getString("person_glpxs"));
                personMap.put("personPositionDate", rs.getString("person_position_date"));
                personMap.put("personJob", rs.getString("person_job"));
                personMap.put("personPdqy", rs.getString("person_pdqy"));
                personMap.put("personWed", rs.getString("person_wed"));
                personMap.put("personAddress", rs.getString("person_address"));
                personMap.put("personRzjl", rs.getString("person_rzjl"));
                personMap.put("personGradeLevel", Objects.nonNull(jobGradeMap.get(personId)) ? jobGradeMap.get(personId).getJobGrade() : "");
                personMap.put("personEnterDate", Objects.nonNull(enterDateMap.get(personId)) ? enterDateMap.get(personId) : "");
                personMap.put("personGradeDate", Objects.nonNull(jobGradeMap.get(personId)) ? jobGradeMap.get(personId).getJobGradeDate() : "");
                personMap.put("seq", String.valueOf(this.threadLocal.get().incrementAndGet()));
                if (i++ != 0) {
                    personMap.put("bzs", "");
                    personMap.put("zbs", "");
                }
                result2.add(personMap);
            }
        }
        return result2;
    }

    private void getAdminTotal(String orgLongNumber, String actTableName, String tempTableName, int sum) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String sql = "select admin.FNAME_L2 orgName from T_Org_Admin admin where admin.FLONGNUMBER = '" + orgLongNumber + "'";
        IRowSet rs1 = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        while (rs1.next()) {
            map.put("orgName", rs1.getString("orgName") + "\u5408\u8ba1");
        }
        String groupBySQL = "select '" + orgLongNumber + "', sum(temp.fbzs) bzs, sum(temp.fzbs) zbs " + "from " + tempTableName + " temp " + "         left join T_Org_Admin Admin on Admin.FLONGNUMBER = temp.forgLongNumber " + "where temp.forgLongNumber like '" + orgLongNumber + "%' " + "  and temp.forgName != '\u5408\u8ba1' " + "order by temp.forgLongNumber";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)groupBySQL);
        while (rs.next()) {
            map.put("bzs", rs.getString("bzs"));
            map.put("zbs", rs.getString("zbs"));
            map.put("positionName", "");
            map.put("isTatol", String.valueOf(sum));
            map.put("isAdmin", "1");
            map.put("seq", String.valueOf(this.threadLocal.get().incrementAndGet()));
            list.add(map);
        }
        this.insertDataToTable(list, actTableName, this.ctx);
    }

    public void insertRecordToTable(Context ctx, String tableName, String filter) throws BOSException {
        String insertSQL = "INSERT INTO T_Emp_CompileHandler(FfilterItems,FTableName) VALUES(?,?)";
        DbUtil.execute((Context)ctx, (String)insertSQL, (Object[])new Object[]{filter, tableName});
    }

    public void putTotalInfo(Context ctx, String tableName, String originLongNumber) throws BOSException, SQLException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isTatol", "1");
        map.put("positionName", "\u6c47\u603b\u6570\u636e");
        map.put("orgName", "\u5408\u8ba1");
        map.put("orgLongNumber", originLongNumber);
        String sql = "select sum(fbzs) bzs, sum(fzbs) zbs from " + tableName;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            if (UIRuleUtil.isNull((String)rs.getString("zbs"))) {
                return;
            }
            map.put("bzs", rs.getString("bzs"));
            map.put("zbs", rs.getString("zbs"));
        }
        list.add(map);
        this.insertDataToTable(list, tableName, ctx);
    }

    private int selectActPersonCount(String orgLongNumber, String positionId) throws SQLException, BOSException {
        String sql = "select count(1) actPerson from T_BD_Person Person          inner join T_Org_PositionMember Member on Person.FID = Member.FPERSONID          inner join T_Org_Position Position on Member.FPOSITIONID = Position.FID          inner join T_Org_Admin Org on Org.FID = Position.FADMINORGUNITID          left join T_Hr_EmpLaborRelation empRelation on empRelation.FPERSONID = Person.FID          left join T_Hr_BDEmployeeType type on empRelation.FLABORRELATIONSTATEID = type.FID where Member.FISPRIMARY = 1   and Position.FID = '" + positionId + "' " + "  and type.FNAME_L2 not like '%\u79bb\u804c%' " + "  and Org.FLONGNUMBER = '" + orgLongNumber + "'";
        IRowSet actRs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        return actRs.next() ? actRs.getInt("actPerson") : 0;
    }

    public void selectPersonResultPutToList(Context ctx, String originLongNumber, List<Map<String, String>> planList) throws BOSException, SQLException {
        Calendar cd = Calendar.getInstance();
        int monthOfYear = cd.get(2) + 1;
        String sql = "/*dialect*/ select Org.FLONGNUMBER                 org_long_number,        Org.FNAME_L2                    org_name,        Position.FNAME_L2               position_name,        Position.FID                    position_id,        nvl(sum(Staff.FALLSTAFFING), 0) bzs from T_Org_Admin Org          left join T_Org_position Position on Position.FADMINORGUNITID = Org.FID          left join T_Hr_StaffingPost Staff                    on Staff.FPOSITION = Position.FID and Staff.FADMINORGUNIT = Org.FID and Staff.FSTATE = 1 and Staff.FMONTH = '" + monthOfYear + "'" + "         left join T_Org_Job job on Position.FJOBID = job.FID " + "         left join T_Org_LayerType Lt on Lt.FID = Org.FLAYERTYPEID " + "where (FDELETEDSTATUS != 2) " + "  and (Org.FDESCRIPTION_L2 is null or Org.FDESCRIPTION_L2 != '\u5c01\u5b58') " + "  and Org.FISSEALUP = 0 " + "  and Org.FLONGNUMBER like '" + originLongNumber + "%' " + "group by Org.FLONGNUMBER, Org.FNAME_L2, Position.FNAME_L2, Position.FID";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String positionId = rs.getString("position_id");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("orgName", rs.getString("org_name"));
            map.put("orgLongNumber", rs.getString("org_long_number"));
            map.put("positionName", rs.getString("position_name"));
            map.put("positionId", positionId);
            map.put("bzs", rs.getString("bzs"));
            int zbs = this.selectActPersonCount(rs.getString("org_long_number"), positionId);
            map.put("zbs", Integer.toString(zbs));
            planList.add(map);
        }
    }

    public void insertDataToTable(List<Map<String, String>> planList, String tableName, Context ctx) throws BOSException {
        if (CollectionUtils.isNotEmpty(planList)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" INSERT INTO " + tableName);
            sb.append("(");
            sb.append("forgLongNumber, forgName, fpositionId, fpositionName, fbzs, fzbs, ");
            sb.append("fpersonName, fpersonNumber, fpersonLabor, fpersonGradeLevel, fpersonEnterDate, ");
            sb.append("fpersonGradeDate, fpersonPositionDate, fpersonGender, fpersonAge, fpersonDiploma, fpersonDm, ");
            sb.append("fpersonGlpxs, fpersonWed, fpersonJob, fpersonPdqy, fpersonAddress, fpersonRzjl, ");
            sb.append("fisAdmin, fisTatol, fseq");
            sb.append(")");
            sb.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (Map<String, String> map : planList) {
                Object[] obj = new Object[]{map.get("orgLongNumber"), map.get("orgName"), map.get("positionId"), map.get("positionName"), map.get("bzs"), map.get("zbs"), map.get("personName"), map.get("personNumber"), map.get("personLabor"), map.get("personGradeLevel"), map.get("personEnterDate"), map.get("personGradeDate"), map.get("personPositionDate"), map.get("personGender"), map.get("personAge"), map.get("personDiploma"), map.get("personDm"), map.get("personGlpxs"), map.get("personWed"), map.get("personJob"), map.get("personPdqy"), map.get("personAddress"), map.get("personRzjl"), map.get("isAdmin"), map.get("isTatol"), map.get("seq")};
                list.add(obj);
            }
            DbUtil.executeBatch((Context)ctx, (String)sb.toString(), list);
        }
    }

    public Map<String, String> putParamToMap(HttpServletRequest request) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String filterString = request.getParameter("filterItems");
        if (UIRuleUtil.isNotNull((String)filterString)) {
            String[] param = filterString.split(";");
            for (int i = 0; i < param.length; ++i) {
                String[] split = param[i].split(":");
                if (split.length == 1) {
                    paramMap.put(split[0], "");
                    continue;
                }
                paramMap.put(split[0], split[1]);
            }
        }
        return paramMap;
    }

    public String tempTableIsExsit(Context ctx, HttpServletRequest request, boolean sessionIsExsit) {
        try {
            Map<String, String> paramMap = this.putParamToMap(request);
            String orgUnitlongNumber = paramMap.get("adminOrgUnit");
            String filterItems = request.getParameter("filterItems");
            String exsitSql = "SELECT FTableName FROM T_Emp_CompileHandler WHERE FfilterItems='" + filterItems + "'";
            IRowSet recordRs = DbUtil.executeQuery((Context)ctx, (String)exsitSql);
            while (recordRs.next()) {
                String tableExsit = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME='" + recordRs.getString("FTableName") + "'";
                IRowSet tableExsitRs = DbUtil.executeQuery((Context)ctx, (String)tableExsit);
                if (tableExsitRs.next() && sessionIsExsit) {
                    return tableExsitRs.getString("KSQL_TABNAME");
                }
                String deleteSql = "/*dialect*/DELETE T_Emp_CompileHandler WHERE instr(FfilterItems,'" + orgUnitlongNumber + "') > 0 ";
                DbUtil.execute((Context)ctx, (String)deleteSql);
                if (tableExsitRs.size() <= 0) continue;
                String deletetTable = "drop table " + recordRs.getString("FTableName");
                DbUtil.execute((Context)ctx, (String)deletetTable);
            }
        }
        catch (BOSException var13) {
            var13.printStackTrace();
        }
        catch (SQLException var14) {
            var14.printStackTrace();
        }
        return null;
    }

    public String getTempTable(Context ctx) {
        String tempTable = null;
        try {
            tempTable = "abc";
            String sql = "create table " + tempTable + " (" + "forgLongNumber NVARCHAR(255), " + "forgName NVARCHAR(255), " + "fpositionId NVARCHAR(50), " + "fpositionName NVARCHAR(50), " + "fbzs NVARCHAR(30), " + "fzbs NVARCHAR(30), " + "fpersonName NVARCHAR(50), " + "fpersonNumber NVARCHAR(50), " + "fpersonLabor NVARCHAR(50), " + "fpersonGradeLevel NVARCHAR(50), " + "fpersonEnterDate NVARCHAR(50), " + "fpersonGradeDate NVARCHAR(50), " + "fpersonPositionDate NVARCHAR(50), " + "fpersonGender int, " + "fpersonAge NVARCHAR(30), " + "fpersonDiploma NVARCHAR(50), " + "fpersonDm NVARCHAR(50), " + "fpersonGlpxs NVARCHAR(50), " + "fpersonWed NVARCHAR(50), " + "fpersonJob NVARCHAR(50), " + "fpersonPdqy NVARCHAR(50), " + "fpersonAddress NVARCHAR(255), " + "fpersonRzjl CLOB, " + "fisAdmin NVARCHAR(30)," + "fisTatol NVARCHAR(30)," + "fseq int" + ")";
            TempTablePool tablePool = TempTablePool.getInstance((Context)ctx);
            tempTable = tablePool.createTempTable(sql);
            System.out.println("bianzhi15 getTempTable sql =  " + sql);
        }
        catch (Exception var5) {
            System.out.println("bianzhi15 getTempTable2 \u751f\u6210\u4e34\u65f6\u8868\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)var5));
            var5.printStackTrace();
        }
        return tempTable;
    }

    private String getStaffTempTable(int month) {
        String tempTable = "abc";
        HashSet<String> set = new HashSet<String>();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        String sql = "select * from T_Hr_StaffingPost where fstate = 1 and (FMONTH='" + month + "' or FMONTH='0')  order by FCREATETIME asc";
        try {
            String createTableSQL = "create table " + tempTable + "" + "(" + "FPosition NVARCHAR(80), " + "FADMINORGUNIT NVARCHAR(80), " + "FYear NUMERIC(10,0)" + ", " + "FMONTH NUMERIC(10,0), " + "FAllStaffing NUMERIC(20,0)," + "FSTATE NUMERIC(5,0)" + ")";
            tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSQL);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                if (!set.add(rs.getString("FPosition") + "," + rs.getString("FADMINORGUNIT") + "," + rs.getString("FYear") + "," + rs.getString("FMONTH"))) continue;
                Object[] obj = new Object[]{rs.getString("FPosition"), rs.getString("FADMINORGUNIT"), rs.getString("FYear"), rs.getString("FMONTH"), rs.getString("FAllStaffing"), rs.getString("FSTATE")};
                dataList.add(obj);
            }
            StringBuffer insertSQL = new StringBuffer();
            insertSQL.append(" INSERT INTO " + tempTable);
            insertSQL.append("(FPosition,FADMINORGUNIT,FYear,FMONTH,FAllStaffing,FSTATE) ");
            insertSQL.append(" VALUES(?,?,?,?,?,?)");
            DbUtil.executeBatch((Context)this.ctx, (String)insertSQL.toString(), dataList);
        }
        catch (Exception var9) {
            var9.printStackTrace();
        }
        return tempTable;
    }

    private Map<String, String> getEnterDateMap(String orgId) {
        Map<String, String> result2 = new HashMap<String, String>();
        Context ctx = SHRContext.getInstance().getContext();
        String sql = "/*dialect*/ select p.FID PERSON_ID, to_char(h.FENTERDATE, 'yyyy-MM-dd') ENTER_DATE from T_BD_Person p          inner join T_ORG_PositionMember posm on p.FID = posm.FPERSONID and posm.FISPRIMARY = 1          inner join T_ORG_POSITION pos on pos.FID = posm.FPOSITIONID          inner join T_HR_EmpLaborRelationHis h on p.FID = h.FPERSONID where pos.FADMINORGUNITID = '" + orgId + "'";
        ArrayList<EnterDateDTO> list = new ArrayList<EnterDateDTO>();
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);){
            while (rs.next()) {
                String personId = rs.getString("PERSON_ID");
                String enterDate = rs.getString("ENTER_DATE");
                if (StringUtils.isBlank((CharSequence)enterDate) || StringUtils.isBlank((CharSequence)personId)) {
                    System.out.println("bianzhi18003 \u5165\u804c\u65e5\u671f \u4e0d\u6ee1\u8db3 personId = " + personId + ", enterDate = " + enterDate);
                    continue;
                }
                list.add(new EnterDateDTO(personId, enterDate));
            }
        }
        catch (Exception e) {
            System.out.println("bianzhi \u67e5\u8be2\u7ec4\u7ec7[" + orgId + "]\u4e0b\u6240\u6709\u5458\u5de5\u5165\u804c\u65e5\u671f \u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            try {
                result2 = list.stream().collect(Collectors.toMap(EnterDateDTO::getPersonId, EnterDateDTO::getEnterDate, (c1, c2) -> c1.compareTo((String)c2) > 0 ? c1 : c2));
            }
            catch (Exception e) {
                System.out.println("bianzhi getEnterDateMap \u67e5\u8be2\u7ec4\u7ec7[" + orgId + "]\u4e0b\u6240\u6709\u5458\u5de5\u5165\u804c\u65e5\u671f \u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result2;
    }

    private Map<String, JobGradeDTO> getJobGradeMap(String orgId) {
        Map<String, JobGradeDTO> result2 = new HashMap<String, JobGradeDTO>();
        long start = System.currentTimeMillis();
        Context ctx = SHRContext.getInstance().getContext();
        String sql = "/*dialect*/ select p.FID   PERSON_ID,        to_char(jgc.CFSTARTDATE, 'yyyy-MM-dd')  JOB_GRADE_DATE,        (select g.FNAME_L2 from T_HR_JobGrade g where g.fid = jgc.CFJOBGRADEID) JOB_GRADE from T_BD_Person p          inner join T_ORG_PositionMember posm on p.FID = posm.FPERSONID and posm.FISPRIMARY = 1          inner join T_ORG_POSITION pos on pos.FID = posm.FPOSITIONID          inner join CT_GRA_JobGradeChange jgc on p.FID = jgc.CFPERSONID where pos.FADMINORGUNITID = '" + orgId + "'";
        ArrayList<JobGradeDTO> dtoList = new ArrayList<JobGradeDTO>();
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);){
            while (rs.next()) {
                String personId = rs.getString("PERSON_ID");
                String jobGradeDate = rs.getString("JOB_GRADE_DATE");
                if (StringUtils.isBlank((CharSequence)jobGradeDate) || StringUtils.isBlank((CharSequence)personId)) {
                    System.out.println("bianzhi18003 \u804c\u7ea7 \u4e0d\u6ee1\u8db3 personId = " + personId + ", jobGradeDate = " + jobGradeDate);
                    continue;
                }
                JobGradeDTO dto = new JobGradeDTO();
                dto.setPersonId(personId);
                dto.setJobGradeDate(jobGradeDate);
                dto.setJobGrade(rs.getString("JOB_GRADE"));
                dtoList.add(dto);
            }
            result2 = dtoList.stream().collect(Collectors.toMap(JobGradeDTO::getPersonId, Function.identity(), (c1, c2) -> c1.getJobGradeDate().compareTo(c2.getJobGradeDate()) > 0 ? c1 : c2));
        }
        catch (Exception e) {
            System.out.println("bianzhi \u804c\u7ea7\u67e5\u8be2\u5f02\u5e38 " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result2;
    }

    public String exportToExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        System.out.println("bianzhi16 \u8fdb\u5165exportToExcelAction ");
        try {
            System.out.println("bianzhi16 request = " + JSON.toJSONString((Object)request.getParameterMap()));
        }
        catch (Exception e) {
            System.out.println("bianzhi16 request\u4ecb\u4f11\u5931\u8d25 ");
        }
        return super.exportToExcelAction(request, response, modelMap);
    }
}

