/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.group;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.pd.web.dto.PdSortGroupDTO;
import com.kingdee.shr.pd.web.enums.PdSortGroupStatusEnum;
import com.kingdee.shr.pd.web.server.PdSpComponent;
import com.kingdee.shr.pd.web.util.PdUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class PdGroupEditHandler
extends EditHandler {
    private static final String LOG_HEAD = "wdpd_" + PdGroupEditHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final PdSpComponent component = new PdSpComponent(this.ctx);

    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        String gcId = request.getParameter("billId");
        String sql = "select g.FID                                                                  id,        g.FNAME_L2                                                             name,        g.CFSORTCODE                                                           sortCode,        g.CFISHR                                                               isHr,        g.CFISSHR                                                              isShr,        g.CFISSPECIFYSHR                                                       isSpecifyShr,        g.CFSPECIFYSHRID                                                       specifyShrId,        (select p.FNAME_L2 from T_BD_PERSON p where p.FID = g.CFSPECIFYSHRID)  specifyShrName,        g.CFSTATUS                                                             status,        g.CFREMARK                                                             remark,        (select u.FNAME_L2 from T_PM_USER u where u.FID = g.FCREATORID)        createUser,        to_char(g.FCREATETIME, 'yyyy-mm-dd')                                   createDate,        (select u.FNAME_L2 from T_PM_USER u where u.FID = g.FLASTUPDATEUSERID) updateUser,        to_char(g.FLASTUPDATETIME, 'yyyy-mm-dd')                               updateDate from CT_MP_pdGroupConfig g where g.FID = '" + gcId + "'";
        PdSortGroupDTO dto = this.component.selectOne(sql, PdSortGroupDTO.class);
        initData.put("SortGroup", dto);
        initData.put("currUser", ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getName());
        initData.put("currDate", PdUtil.currDate());
        initData.put("statusMap", PdSortGroupStatusEnum.map());
        super.setInitData(request, response, modelMap, initData);
    }

    public void isDuplicateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        HashMap result2 = Maps.newHashMap();
        result2.put("result", "200");
        result2.put("isDuplicate", this.isDuplicate(id, name) ? "1" : "0");
        this.writeSuccessData(result2);
    }

    private Set<String> queryIdsByName(String name) {
        HashSet set = Sets.newHashSet();
        String sql = "select FID from CT_MP_PdGroupConfig where FNAME_L2 = '" + name + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                set.add(rs.getString(1));
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return set;
    }

    public void gcSaveAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        String reqData = request.getParameter("reqData");
        PdSortGroupDTO reqDTO = this.component.parseJson(reqData, PdSortGroupDTO.class);
        this.check(reqDTO);
        String billId = this.saveOrUpdate(reqDTO);
        HashMap result2 = Maps.newHashMap();
        result2.put("result", "200");
        result2.put("billId", billId);
        this.writeSuccessData(result2);
    }

    private String saveOrUpdate(PdSortGroupDTO reqDTO) throws BOSException, SQLException {
        if (StringUtils.isBlank((CharSequence)reqDTO.getId())) {
            return this.doSave(reqDTO);
        }
        return this.doUpdate(reqDTO);
    }

    private void check(PdSortGroupDTO dto) throws ShrWebBizException {
        if (dto == null) {
            throw new ShrWebBizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            throw new ShrWebBizException("\u7fa4\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (dto.getName().length() > 255) {
            throw new ShrWebBizException("\u7fa4\u4f53\u540d\u79f0\u6587\u672c\u957f\u5ea6\u8d85\u9650\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSortCode())) {
            if (dto.getSortCode().length() > 9) {
                throw new ShrWebBizException("\u6392\u5e8f\u6587\u672c\u957f\u5ea6\u8d85\u9650\uff01");
            }
            if (!NumberUtils.isNumber((String)dto.getSortCode())) {
                throw new ShrWebBizException("\u6392\u5e8f\u53ea\u5141\u8bb8\u8f93\u5165\u6570\u5b57\uff01");
            }
        }
        if (!("1".equals(dto.getIsHr()) || "1".equals(dto.getIsShr()) || "1".equals(dto.getIsSpecifyShr()))) {
            throw new ShrWebBizException("\u81f3\u5c11\u9009\u4e2d\u4e00\u4e2a\u5ba1\u6279\u6d41\u7a0b\u8282\u70b9\uff01");
        }
        if ("1".equals(dto.getIsSpecifyShr()) && StringUtils.isBlank((CharSequence)dto.getSpecifyShrId())) {
            throw new ShrWebBizException("\u6307\u5b9a\u5ba1\u6279\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark()) && dto.getRemark().length() > 500) {
            throw new ShrWebBizException("\u8bf4\u660e\u6587\u672c\u8d85\u9650\uff01");
        }
        if (this.isDuplicate(dto.getId(), dto.getName())) {
            throw new ShrWebBizException("\u7fa4\u4f53\u540d\u79f0\u91cd\u590d\uff01");
        }
        if (StringUtils.isBlank((CharSequence)dto.getStatus())) {
            throw new ShrWebBizException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private boolean isDuplicate(String id, String name) {
        Set<String> idSet = this.queryIdsByName(name);
        if (CollectionUtils.isNotEmpty(idSet)) {
            if (idSet.size() > 1) {
                return true;
            }
            if (StringUtils.isBlank((CharSequence)id)) {
                return true;
            }
            return !idSet.contains(id);
        }
        return false;
    }

    private String doSave(PdSortGroupDTO dto) throws BOSException, SQLException {
        String userId = this.ctx.getCaller().toString();
        String billId = BOSUuid.create((String)"A260423D").toString();
        String sql = "/*dialect*/ insert into CT_MP_pdGroupConfig (   FID, FNAME_L2, CFSORTCODE, CFISHR, CFISSHR,    CFISSPECIFYSHR, CFSPECIFYSHRID, CFSTATUS, CFREMARK, FCREATORID,    FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME) values ('" + billId + "', ?, ?, ?, ?, ?, ?, ?, ?, '" + userId + "', sysdate, '" + userId + "', sysdate)";
        List<Object[]> paramList = this.listParam(dto);
        HashMap psSqlMap = Maps.newHashMap();
        psSqlMap.put(sql, paramList);
        this.component.tx(null, psSqlMap);
        return billId;
    }

    private String doUpdate(PdSortGroupDTO dto) throws BOSException, SQLException {
        String sql = "/*dialect*/ update CT_MP_pdGroupConfig set FNAME_L2 = ? ,CFSORTCODE = ?, CFISHR = ?, CFISSHR = ?, CFISSPECIFYSHR = ?, CFSPECIFYSHRID = ?, CFSTATUS = ?, CFREMARK = ?, FLASTUPDATEUSERID = '" + this.ctx.getCaller().toString() + "', FLASTUPDATETIME   = sysdate " + "where FID = '" + dto.getId() + "' ";
        List<Object[]> paramList = this.listParam(dto);
        HashMap psSqlMap = Maps.newHashMap();
        psSqlMap.put(sql, paramList);
        this.component.tx(null, psSqlMap);
        return dto.getId();
    }

    private List<Object[]> listParam(PdSortGroupDTO dto) {
        ArrayList paramList = Lists.newArrayList();
        paramList.add(new Object[]{StringUtils.trimToEmpty((String)dto.getName()), dto.getSortCode(), "1".equals(dto.getIsHr()) ? "1" : "0", "1".equals(dto.getIsShr()) ? "1" : "0", "1".equals(dto.getIsSpecifyShr()) ? "1" : "0", StringUtils.trimToEmpty((String)dto.getSpecifyShrId()), PdSortGroupStatusEnum.ENALBE.getValue().equals(dto.getStatus()) ? PdSortGroupStatusEnum.ENALBE.getValue() : PdSortGroupStatusEnum.DISABLE.getValue(), StringUtils.trimToEmpty((String)dto.getRemark())});
        return paramList;
    }
}

