/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.rule;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdResultEnum;
import com.kingdee.shr.pd.web.rule.PdRuleResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class PdRule {
    private static final String LOG_HEAD = "wdpd_rule_";
    private static final String MORE_OF_A = "A\u6bd4\u4f8b\u5927\u4e8e20%";
    private static final String LEAST_OF_C = "C\u6bd4\u4f8b\u5c0f\u4e8e10%";

    public static PdRuleResult execute(String gid, String gname, List<String> list) {
        System.out.println(LOG_HEAD + gname + " \u5165\u53c2 list = " + JSON.toJSONString(PdSpFlowPdResultEnum.aliasOf(list)));
        ArrayList joinFlags = Lists.newArrayList((Object[])new String[]{PdSpFlowPdResultEnum.A.getValue(), PdSpFlowPdResultEnum.B.getValue(), PdSpFlowPdResultEnum.C.getValue()});
        long joinTotal = list.stream().filter(joinFlags::contains).count();
        long joinCountOfA = list.stream().filter(r -> PdSpFlowPdResultEnum.A.getValue().equals(r)).count();
        long joinCountOfB = list.stream().filter(r -> PdSpFlowPdResultEnum.B.getValue().equals(r)).count();
        long joinCountOfC = list.stream().filter(r -> PdSpFlowPdResultEnum.C.getValue().equals(r)).count();
        long notJoinTotal = list.stream().filter(r -> PdSpFlowPdResultEnum.NOT_JOIN.getValue().equals(r)).count();
        ArrayList err = Lists.newArrayList();
        if (joinTotal <= 4L) {
            if (joinCountOfA > 1L) {
                err.add(MORE_OF_A);
            }
        } else {
            int mostLimit = new BigDecimal(String.valueOf(joinTotal)).multiply(new BigDecimal("0.2")).setScale(0, 4).intValue();
            int leastLimt = new BigDecimal(String.valueOf(joinTotal)).multiply(new BigDecimal("0.1")).setScale(0, 4).intValue();
            if (joinCountOfA > (long)mostLimit) {
                err.add(MORE_OF_A);
            }
            if (joinCountOfC < (long)leastLimt) {
                err.add(LEAST_OF_C);
            }
        }
        StringBuilder summary = new StringBuilder();
        summary.append(gname).append("\u5171 ").append(list.size()).append("\u4eba").append("\n");
        summary.append("A ").append(joinCountOfA).append("\u4eba\uff0c\u6bd4\u4f8b ").append(PdRule.calPercent(joinCountOfA, joinTotal)).append("%\n");
        summary.append("B ").append(joinCountOfB).append("\u4eba\uff0c\u6bd4\u4f8b ").append(PdRule.calPercent(joinCountOfB, joinTotal)).append("%\n");
        summary.append("C ").append(joinCountOfC).append("\u4eba\uff0c\u6bd4\u4f8b ").append(PdRule.calPercent(joinCountOfC, joinTotal)).append("%\n");
        summary.append("\u4e0d\u53c2\u8bc4 ").append(notJoinTotal).append("\u4eba");
        String message = "";
        boolean success = true;
        if (CollectionUtils.isNotEmpty((Collection)err)) {
            message = String.join((CharSequence)"\uff0c", err);
            success = false;
        }
        PdRuleResult result2 = new PdRuleResult();
        result2.setGid(gid);
        result2.setGname(gname);
        result2.setPass(success);
        result2.setMessage(message);
        result2.setSummary(summary.toString());
        System.out.println(LOG_HEAD + gname + " \u51fa\u53c2 result = " + JSON.toJSONString((Object)result2));
        return result2;
    }

    private static String calPercent(long part, long whole) {
        if (part == 0L || whole == 0L) {
            return "0";
        }
        return new BigDecimal(String.valueOf(part)).multiply(new BigDecimal("100")).divide(new BigDecimal(String.valueOf(whole)), 0, 4).toString();
    }
}

