/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.handler.cp;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.zc.web.dto.CpgDTO;
import com.kingdee.shr.zc.web.dto.ZcDTO;
import com.kingdee.shr.zc.web.server.ZcComponent;
import com.kingdee.shr.zc.web.util.ZcUtil;
import com.kingdee.shr.zc.web.zenum.ZcCpgTypeEnum;
import com.kingdee.shr.zc.web.zenum.ZcCpztEnum;
import com.kingdee.shr.zc.web.zenum.ZcMsgTemplateEnum;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class ZcCpHrbpArrangeEditHandler
extends EditHandler {
    private static final String LOG_HEAD = "ygzc_" + ZcCpHrbpArrangeEditHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final ZcComponent component = new ZcComponent(this.ctx);

    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        System.out.println(LOG_HEAD + "setInitData() \u8fdb\u5165 \u3002\u3002\u3002");
        String ids = request.getParameter("ids");
        try {
            ids = URLDecoder.decode(ids, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ids = "";
            System.out.println(LOG_HEAD + "setInitData() ids\u89e3\u6790\u5f02\u5e38 ids = " + ids);
        }
        Set<String> zcIdSet = ZcUtil.split(ids);
        if (CollectionUtils.isNotEmpty(zcIdSet)) {
            System.out.println(LOG_HEAD + "setInitData() zcIdSet = " + zcIdSet);
            List<ZcDTO> zcList = this.component.listZc(zcIdSet);
            System.out.println(LOG_HEAD + "setInitData() zcList = " + JSON.toJSONString(zcList));
            Map<String, List<CpgDTO>> cpgMap = this.component.listCpgMap(zcIdSet);
            System.out.println(LOG_HEAD + "setInitData() cpgMap = " + JSON.toJSONString(cpgMap));
            if (CollectionUtils.isNotEmpty(zcList)) {
                for (ZcDTO zc : zcList) {
                    ArrayList cpgList = cpgMap.get(zc.getId());
                    if (cpgList == null) {
                        cpgList = Lists.newArrayList();
                    }
                    this.addHrbpAndFzr(zc, cpgList);
                    zc.setCpgList(cpgList);
                }
            }
            System.out.println(LOG_HEAD + "setInitData() zcList = " + JSON.toJSONString(zcList));
            initData.put("zcList", zcList);
            initData.put("ww", this.component.getWwMsg(ZcMsgTemplateEnum.ZC_EVAL_ARRANGE));
        }
        super.setInitData(request, response, modelMap, initData);
    }

    private void addHrbpAndFzr(ZcDTO zc, List<CpgDTO> cpgList) {
        if (ZcCpztEnum.ARRANGE_NO.getCode().equals(zc.getCpzt())) {
            String deptFzrId = zc.getDeptFzrId();
            if (cpgList.stream().map(CpgDTO::getCpgId).noneMatch(cpgId -> cpgId.equals(deptFzrId))) {
                CpgDTO cpg = new CpgDTO();
                cpg.setCpgId(zc.getDeptFzrId());
                cpg.setCpgNumber(zc.getDeptFzrNumber());
                cpg.setCpgName(zc.getDeptFzrName());
                cpg.setCpgType(ZcCpgTypeEnum.DEPT_FZR.getCode());
                cpgList.add(0, cpg);
            }
            String hrbpId = zc.getHrbpId();
            if (cpgList.stream().map(CpgDTO::getCpgId).noneMatch(cpgId -> cpgId.equals(hrbpId))) {
                CpgDTO cpg = new CpgDTO();
                cpg.setCpgId(zc.getHrbpId());
                cpg.setCpgNumber(zc.getHrbpNumber());
                cpg.setCpgName(zc.getHrbpName());
                cpg.setCpgType(ZcCpgTypeEnum.HRBP.getCode());
                cpgList.add(0, cpg);
            }
        }
    }

    public void arrangeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "zcEvalArrangeAction() \u8fdb\u5165 \u3002\u3002\u3002");
        String reqeustData = request.getParameter("arData");
        String wwTemplate = request.getParameter("ww");
        System.out.println(LOG_HEAD + "zcEvalArrangeAction() reqeustData = " + reqeustData);
        System.out.println(LOG_HEAD + "zcEvalArrangeAction() wwTemplate = " + wwTemplate);
        List zcList = JSON.parseArray((String)reqeustData, ZcDTO.class);
        if (CollectionUtils.isEmpty((Collection)zcList)) {
            zcList = Lists.newArrayList();
        }
        System.out.println(LOG_HEAD + "zcEvalArrangeAction() zcList = " + JSON.toJSONString((Object)zcList));
        Set<String> zcIdSet = zcList.stream().map(ZcDTO::getId).collect(Collectors.toSet());
        Map<String, Map<String, String>> zcListMap = this.component.get(zcIdSet);
        String errMsg = this.checkZc(zcList, zcListMap);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        HashMap wwMap = Maps.newHashMap();
        HashSet cpgDeleteParamSet = Sets.newHashSet();
        ArrayList cpgInsertParamList = Lists.newArrayList();
        ArrayList zcUpdateParamList = Lists.newArrayList();
        for (ZcDTO zc : zcList) {
            String zcId = zc.getId();
            Map<String, String> zcMap = zcListMap.get(zcId);
            String cpsj = zc.getCpsj();
            String cpdd = zc.getCpdd();
            String wwMsg = this.getWwMsg(wwTemplate, cpsj, cpdd);
            if (this.needNotice(zcMap, cpsj, cpdd)) {
                wwMap.put(zcMap.get("number"), wwMsg);
            }
            zcUpdateParamList.add(this.buildZcUpdateParamObj(cpsj, cpdd, wwMsg, zcId));
            cpgInsertParamList.addAll(this.buildCpgInsertParamList(zc.getCpgList(), zcMap));
            cpgDeleteParamSet.add(zcId);
        }
        if (this.doArrange(cpgDeleteParamSet, cpgInsertParamList, zcUpdateParamList)) {
            this.component.sendMsg(wwMap);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private boolean doArrange(Set<String> cpgDeleteParamSet, List<Object[]> cpgInsertParamList, List<Object[]> zcUpdateParamList) throws BOSException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            System.out.println(LOG_HEAD + "doArrange() \u83b7\u53d6DB\u8fde\u63a5\u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        try {
            String delCpgSql = String.format("/*dialect*/ delete from CT_MP_Cpg where CFZCID in (%s)", ZcUtil.in(cpgDeleteParamSet));
            stmt = conn.createStatement();
            stmt.execute(delCpgSql);
            String updateZcSql = String.format("/*dialect*/ update CT_MP_YGZC set CFCPSJ = to_date(?, 'yyyy-mm-dd hh24:mi'),  CFCPDD = ?, CFCPZT = ?, CFCPTSNR = ? where FID = ?", new Object[0]);
            ps1 = this.prepare(conn, updateZcSql, zcUpdateParamList);
            ps1.executeBatch();
            PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
            String currPersonId = personInfo.getId().toString();
            String insertCpgSql = String.format("/*dialect*/ insert into CT_MP_CPG(FID, CFPERSONID, CFCPGTYPE, CFZCID, FCREATETIME, FCREATORID) values (NEWBOSID('7ABB5BCA'), ?, ?, ?, sysdate, '%s')", currPersonId);
            ps2 = this.prepare(conn, insertCpgSql, cpgInsertParamList);
            ps2.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
                System.out.println(LOG_HEAD + "doArrange() e = " + ExceptionUtils.getStackTrace((Throwable)e));
                throw new BOSException("sql execute tx exception : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                SQLUtils.cleanup(ps1, (Connection)conn);
                SQLUtils.cleanup(ps2, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        SQLUtils.cleanup((Statement)ps2, (Connection)conn);
        return true;
    }

    private PreparedStatement prepare(Connection conn, String sql, List<Object[]> paramList) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        for (Object[] objArr : paramList) {
            for (int i = 0; i < objArr.length; ++i) {
                if (objArr[i] != null) {
                    ps.setObject(i + 1, objArr[i]);
                    continue;
                }
                ps.setNull(i + 1, 12);
            }
            ps.addBatch();
        }
        return ps;
    }

    private String checkZc(List<ZcDTO> zcList, Map<String, Map<String, String>> zcListMap) {
        if (CollectionUtils.isEmpty(zcList)) {
            return "\u65e0\u53c2\u6d4b\u5458\u5de5\uff0c\u4e0d\u53ef\u63d0\u4ea4\uff01";
        }
        for (ZcDTO zc : zcList) {
            Map<String, String> zcMap = zcListMap.get(zc.getId());
            if (MapUtils.isEmpty(zcMap)) {
                return "\u4e13\u6d4b[" + zc.getId() + "]\u4e0d\u5b58\u5728";
            }
            if (!ZcCpztEnum.arrangeStatuses().contains(zcMap.get("cpzt"))) {
                return "\u53ea\u6709\u6d4b\u8bc4\u72b6\u6001\u4e3a\u672a\u5b89\u6392\u3001\u5df2\u5b89\u6392\u6216\u6d4b\u8bc4\u4e2d\u624d\u53ef\u4ee5\u5b89\u6392";
            }
            if (StringUtils.isBlank((CharSequence)ZcUtil.toDateStr(zc.getCpsj()))) {
                return "\u6d4b\u8bc4\u5b89\u6392\u65f6\u95f4\u89e3\u6790\u5f02\u5e38";
            }
            if (zc.getCpsj().split(" ")[0].compareTo(ZcUtil.currDate()) < 0) {
                return "\u6d4b\u8bc4\u5b89\u6392\u65f6\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u4eca\u5929";
            }
            if (StringUtils.isBlank((CharSequence)zc.getCpdd())) {
                return "\u6d4b\u8bc4\u5b89\u6392\u5730\u70b9\u90fd\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!CollectionUtils.isEmpty(zc.getCpgList())) continue;
            return "\u6d4b\u8bc4\u5b89\u6392\u6d4b\u8bc4\u5b98\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return "";
    }

    private Object[] buildZcUpdateParamObj(String cpsj, String cpdd, String wwMsg, String zcId) {
        String cpzt = this.calEvalStatus(cpsj);
        return new Object[]{cpsj, cpdd, cpzt, wwMsg, zcId};
    }

    private List<Object[]> buildCpgInsertParamList(List<CpgDTO> cpgList, Map<String, String> zcMap) {
        ArrayList list = Lists.newArrayList();
        String zcId = zcMap.get("id");
        HashSet cpgIdSet = Sets.newHashSet();
        for (CpgDTO cpg : cpgList) {
            String cpgId = cpg.getCpgId();
            String cpgType = this.calCpgType(zcMap, cpgId);
            if (!cpgIdSet.add(cpgId)) continue;
            list.add(new Object[]{cpgId, cpgType, zcId});
        }
        return list;
    }

    private String calCpgType(Map<String, String> zcMap, String cpgId) {
        if (StringUtils.isNotBlank((CharSequence)cpgId)) {
            String hrbpId = zcMap.get("hrbpId");
            String fzrId = zcMap.get("fzrId");
            if (cpgId.equals(hrbpId)) {
                return ZcCpgTypeEnum.HRBP.getCode();
            }
            if (cpgId.equals(fzrId)) {
                return ZcCpgTypeEnum.DEPT_FZR.getCode();
            }
        }
        return ZcCpgTypeEnum.CPG.getCode();
    }

    private boolean needNotice(Map<String, String> zcMap, String cpsjNew, String cpddNew) {
        String oldLocation;
        String oldTime;
        String oldDate = zcMap.get("cprq");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{oldDate, oldTime = zcMap.get("cpsj"), oldLocation = zcMap.get("cpdd")})) {
            return true;
        }
        return !(oldDate + " " + oldTime).equals(cpsjNew) || !oldLocation.equals(cpddNew);
    }

    private String calEvalStatus(String cpsj) {
        if (StringUtils.isNotBlank((CharSequence)cpsj) && ZcUtil.currDate().equals(cpsj.split(" ")[0])) {
            return ZcCpztEnum.EVALUATE_DOING.getCode();
        }
        return ZcCpztEnum.ARRANGE_YES.getCode();
    }

    private String getWwMsg(String msgTemplate, String cpsj, String arLocation) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{cpsj, arLocation})) {
            return "";
        }
        msgTemplate = StringUtils.isNotBlank((CharSequence)msgTemplate) ? msgTemplate : ZcMsgTemplateEnum.ZC_EVAL_ARRANGE.getDefaulValue();
        return msgTemplate.replaceAll("\\$\\{date}", cpsj.split(" ")[0]).replaceAll("\\$\\{time}", cpsj.split(" ")[1]).replaceAll("\\$\\{place}", arLocation);
    }
}

