/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.handler.cp;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.zc.web.dto.CpgDTO;
import com.kingdee.shr.zc.web.dto.cp.ZcCpHrbpEnterResultDTO;
import com.kingdee.shr.zc.web.server.ZcComponent;
import com.kingdee.shr.zc.web.zenum.ZcCpgPassEnum;
import com.kingdee.shr.zc.web.zenum.ZcCpztEnum;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class ZcCpHrbpInputResultListHandler
extends ListHandler {
    private static final String LOG_HEAD = "ygzc_" + ZcCpHrbpInputResultListHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final ZcComponent component = new ZcComponent(this.ctx);

    protected void afterGetListData(HttpServletRequest request, HttpServletResponse response, GridDataEntity gridDataEntity) throws SHRWebException {
        this.setData(gridDataEntity);
        super.afterGetListData(request, response, gridDataEntity);
    }

    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        Principal principal = request.getUserPrincipal();
        String number = principal.getName();
        FilterInfo enterpriseNatureFilter = new FilterInfo();
        enterpriseNatureFilter.getFilterItems().add(new FilterItemInfo("hrbp.number = '" + number + "'"));
        enterpriseNatureFilter.getFilterItems().add(new FilterItemInfo("cpzt = '" + ZcCpztEnum.ASSESS_DONE.getCode() + "'"));
        return enterpriseNatureFilter;
    }

    private void setData(GridDataEntity gridDataEntity) {
        if (null != gridDataEntity) {
            List rowsData = gridDataEntity.getRows();
            if (rowsData == null) {
                gridDataEntity.setRows(new ArrayList());
            } else {
                Set<String> smallStepSet = this.component.allSmallStep();
                int index = 0;
                for (Map row : rowsData) {
                    String zcId = row.get("id").toString();
                    String sqdj = (String)row.get("sqdj");
                    String sqdjOption = (String)row.get("sqdjOption");
                    row.put("sqdjOption", this.reOrder(sqdj, sqdjOption));
                    boolean isSmallStep = smallStepSet.contains(sqdj);
                    row.put("isSmallStep", isSmallStep ? "1" : "0");
                    if (isSmallStep) {
                        List<CpgDTO> cpgList = this.component.listCpg(zcId);
                        row.put("allCpgPass", this.allCpgPass(cpgList));
                        row.put("allCpgNotPass", this.allCpgNotPass(cpgList));
                    }
                    ++index;
                }
            }
        }
    }

    private String allCpgPass(List<CpgDTO> cpgList) {
        if (CollectionUtils.isEmpty(cpgList)) {
            return "0";
        }
        return cpgList.stream().allMatch(c -> ZcCpgPassEnum.YES.getCode().equals(c.getPass())) ? "1" : "0";
    }

    private String allCpgNotPass(List<CpgDTO> cpgList) {
        if (CollectionUtils.isEmpty(cpgList)) {
            return "0";
        }
        return cpgList.stream().allMatch(c -> ZcCpgPassEnum.NO.getCode().equals(c.getPass())) ? "1" : "0";
    }

    private String reOrder(String sqdj, String sqdjOption) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sqdj, sqdjOption})) {
            return sqdjOption;
        }
        Object[] sqdjArr = sqdjOption.split(",");
        if (ArrayUtils.isEmpty((Object[])sqdjArr)) {
            return sqdjOption;
        }
        ArrayList list = Lists.newArrayList();
        list.add(sqdj);
        for (Object s : sqdjArr) {
            if (list.contains(s)) continue;
            list.add(s);
        }
        return Joiner.on((String)",").join((Iterable)list);
    }

    public void saveZcGridAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "saveZcGridAction() \u8fdb\u5165 \u3002\u3002\u3002");
        String reqeustData = request.getParameter("models");
        List dataList = JSON.parseArray((String)reqeustData, ZcCpHrbpEnterResultDTO.class);
        String errMsg = this.check(dataList);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        ArrayList zcUpdateParamList = Lists.newArrayList();
        for (ZcCpHrbpEnterResultDTO dto : dataList) {
            String cpzt = "1".equals(dto.getIsPass()) ? ZcCpztEnum.EVAL_PASS_YES.getCode() : ZcCpztEnum.EVAL_PASS_NO.getCode();
            zcUpdateParamList.add(new Object[]{dto.getZzdj(), dto.getCpNote(), cpzt, dto.getZcId()});
        }
        this.updateZc(zcUpdateParamList);
        HashMap result2 = Maps.newHashMap();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private void updateZc(List<Object> zcUpdateParamList) {
        System.out.println(LOG_HEAD + "updateZc() ZcUpdateParamList = " + JSON.toJSONString(zcUpdateParamList));
        if (CollectionUtils.isEmpty(zcUpdateParamList)) {
            return;
        }
        try {
            PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
            String userId = this.component.getUserId(personInfo.getId().toString());
            String sql = "/*dialect*/ update CT_MP_YGZC set CFZZDJ = ?, CFCPNOTE = ?, CFCPZT = ?, FLASTUPDATEUSERID='" + userId + "', FLASTUPDATETIME = sysdate where FID = ? ";
            DbUtil.executeBatch((Context)this.ctx, (String)sql, zcUpdateParamList);
        }
        catch (Exception e) {
            System.out.println(LOG_HEAD + "updateZc() \u5f02\u5e38 e = " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private String check(List<ZcCpHrbpEnterResultDTO> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return "\u8bf7\u5148\u9009\u4e2d\u8868\u683c\u4e2d\u7684\u6570\u636e";
        }
        String errMsg = "";
        for (ZcCpHrbpEnterResultDTO dto : dataList) {
            String name = dto.getName();
            if (StringUtils.isBlank((CharSequence)dto.getIsPass())) {
                errMsg = "\u8bf7\u9009\u62e9\u662f\u5426\u901a\u8fc7";
                if (!StringUtils.isNotBlank((CharSequence)name)) break;
                errMsg = "\u8bf7\u9009\u62e9[" + StringUtils.isNotBlank((CharSequence)name) + "]\u662f\u5426\u901a\u8fc7";
                break;
            }
            if (!"1".equals(dto.getIsPass()) || !StringUtils.isBlank((CharSequence)dto.getZzdj())) continue;
            errMsg = "\u8bf7\u9009\u62e9\u6700\u7ec8\u7b49\u7ea7";
            if (!StringUtils.isNotBlank((CharSequence)name)) break;
            errMsg = "\u8bf7\u9009\u62e9[" + StringUtils.isNotBlank((CharSequence)name) + "]\u6700\u7ec8\u7b49\u7ea7";
            break;
        }
        return errMsg;
    }
}

