/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.handler.cp;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.zc.web.dto.CpgDTO;
import com.kingdee.shr.zc.web.dto.ZcDTO;
import com.kingdee.shr.zc.web.server.ZcComponent;
import com.kingdee.shr.zc.web.util.ZcResult;
import com.kingdee.shr.zc.web.util.ZcUtil;
import com.kingdee.shr.zc.web.zenum.ZcActionEnum;
import com.kingdee.shr.zc.web.zenum.ZcCpgScoreEnum;
import com.kingdee.shr.zc.web.zenum.ZcCpztEnum;
import com.kingdee.shr.zc.web.zenum.ZcMsgTemplateEnum;
import com.kingdee.shr.zc.web.zenum.ZcShztEnum;
import com.kingdee.shr.zc.web.zenum.ZcSpztEnum;
import java.security.Principal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public class ZcCpHrbpListHandler
extends ListHandler {
    private static final String LOG_HEAD = "ygzc_" + ZcCpHrbpListHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final ZcComponent component = new ZcComponent(this.ctx);

    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        Principal principal = request.getUserPrincipal();
        String number = principal.getName();
        FilterInfo enterpriseNatureFilter = new FilterInfo();
        enterpriseNatureFilter.getFilterItems().add(new FilterItemInfo("hrbp.number = '" + number + "'"));
        enterpriseNatureFilter.getFilterItems().add(new FilterItemInfo("auditStatus = '" + ZcShztEnum.SIGN_UP_PASS.getCode() + "'"));
        return enterpriseNatureFilter;
    }

    public void hrbpAuditPreCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        Map<String, Map<String, String>> zcListMap;
        Set<String> idSet = ZcUtil.split(request.getParameter("ids"));
        String errMsg = ZcUtil.preCheck(idSet, zcListMap = this.component.get(idSet), ZcShztEnum.QULIFY_NOT_AUDIT, ZcActionEnum.QUALIFY_AUDIT);
        if (StringUtils.isNotBlank((String)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        HashMap result2 = Maps.newHashMap();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    public void hrbpAuditAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "hrbpAuditAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> idSet = ZcUtil.split(request.getParameter("ids"));
        Map<String, Map<String, String>> zcListMap = this.component.get(idSet);
        String errMsg = ZcUtil.preCheck(idSet, zcListMap, ZcShztEnum.QULIFY_NOT_AUDIT, ZcActionEnum.QUALIFY_AUDIT);
        if (StringUtils.isNotBlank((String)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        String sql = "/*dialect*/ update CT_MP_YGZC set CFAUDITSTATUS = '" + ZcShztEnum.QULIFY_AUDIT_PASSED.getCode() + "' where FID in (" + ZcUtil.in(idSet) + ")";
        DbUtil.execute((Context)this.ctx, (String)sql);
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    public void toArrangeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "toArrangeAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> idSet = ZcUtil.split(request.getParameter("ids"));
        Map<String, Map<String, String>> zcListMap = this.component.get(idSet);
        System.out.println(LOG_HEAD + "toArrangeAction() zcListMap = " + JSON.toJSONString(zcListMap));
        HashMap ignoreMap = Maps.newHashMap();
        HashSet zcIdSet = Sets.newHashSet();
        for (String zcId : idSet) {
            Map<String, String> zcMap = zcListMap.get(zcId);
            if (MapUtils.isEmpty(zcMap)) {
                ignoreMap.put(zcId, "\u6570\u636e\u5e93\u6ca1\u67e5\u5230");
                continue;
            }
            if (!ZcCpztEnum.arrangeStatuses().contains(zcMap.get("cpzt"))) {
                ignoreMap.put(zcId, "\u6d4b\u8bc4\u72b6\u6001\u4e0d\u5bf9\uff0c\u5f53\u524d\u662f\uff1a" + zcMap.get("cpzt") + "\uff0c\u671f\u671b\u662f\uff1a" + ZcCpztEnum.arrangeStatuses());
                continue;
            }
            zcIdSet.add(zcId);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("zcIds", Joiner.on((String)",").join((Iterable)zcIdSet));
        result2.put("ignoreMap", ignoreMap);
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    public void checkNoticeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "noticeCheckAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> zcIdSet = ZcUtil.split(request.getParameter("ids"));
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String personId = personInfo.getId().toString();
        ZcResult<ZcDTO> zcResult = this.check(zcIdSet, personId);
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("result", "200");
        result2.put("zcResult", zcResult);
        this.writeSuccessData(result2);
    }

    public void noticeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "noticeAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> zcIdSet = ZcUtil.split(request.getParameter("ids"));
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String personId = personInfo.getId().toString();
        String userId = this.component.getUserId(personId);
        ZcResult<ZcDTO> zcResult = this.check(zcIdSet, personId);
        List<ZcDTO> zcList = zcResult.getDataList();
        if (CollectionUtils.isNotEmpty(zcList)) {
            Set<String> idSet = zcList.stream().map(ZcDTO::getId).collect(Collectors.toSet());
            Set<String> numberSet = zcList.stream().map(ZcDTO::getNumber).collect(Collectors.toSet());
            String updateSql = "/*dialect*/ update CT_MP_YGZC set CFJGTZZT = '" + ZcSpztEnum.NOTIFIED.getCode() + "', CFJGTZSJ = sysdate, FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = sysdate where FID in (" + ZcUtil.in(idSet) + ")";
            DbUtil.execute((Context)this.ctx, (String)updateSql);
            this.component.sendMsg(numberSet, ZcMsgTemplateEnum.ZC_EVAL_FINISH);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("result", "200");
        result2.put("zcResult", zcResult);
        this.writeSuccessData(result2);
    }

    private ZcResult<ZcDTO> check(Set<String> zcIdSet, String personId) throws BOSException, SQLException {
        String zcCycle = this.component.getCurrCycle();
        HashMap errMap = Maps.newHashMap();
        ArrayList dataList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(zcIdSet)) {
            Map<String, ZcDTO> zcMap = this.component.mapZc(zcIdSet);
            for (String zcId : zcIdSet) {
                ZcDTO zc = zcMap.get(zcId);
                if (zc == null) {
                    errMap.put(zcId, "\u4e0d\u5b58\u5728");
                    continue;
                }
                if (!personId.equals(zc.getHrbpId())) {
                    errMap.put(zcId, "hrbp ID \u975e\u767b\u5f55\u5458\u5de5ID");
                    continue;
                }
                if (!ZcShztEnum.SIGN_UP_PASS.getCode().equals(zc.getAuditStatus())) {
                    errMap.put(zcId, "\u5ba1\u6838\u72b6\u6001\u975e" + ZcShztEnum.SIGN_UP_PASS.getName());
                    continue;
                }
                if (!Lists.newArrayList((Object[])new String[]{ZcCpztEnum.EVAL_PASS_NO.getCode(), ZcCpztEnum.EVAL_PASS_YES.getCode()}).contains(zc.getCpzt())) {
                    errMap.put(zcId, "\u6d4b\u8bc4\u72b6\u6001\u975e" + ZcCpztEnum.EVAL_PASS_NO.getName() + "\u6216" + ZcCpztEnum.EVAL_PASS_YES.getName());
                    continue;
                }
                if (!Lists.newArrayList((Object[])new String[]{ZcSpztEnum.APPROVAL_FINISH.getCode(), ZcSpztEnum.NOTIFIED.getCode()}).contains(zc.getSpzt())) {
                    errMap.put(zcId, "\u5ba1\u6279\u72b6\u6001\u975e" + ZcSpztEnum.APPROVAL_FINISH.getName() + "\u6216" + ZcSpztEnum.NOTIFIED.getName());
                    continue;
                }
                if (!zcCycle.equals(zc.getCycle())) {
                    errMap.put(zcId, "\u975e\u5f53\u524d\u4e13\u6d4b\u5468\u671f");
                    continue;
                }
                ZcDTO dto = new ZcDTO();
                dto.setId(zc.getId());
                dto.setNumber(zc.getNumber());
                dataList.add(dto);
            }
        } else {
            String sql = "select FID zcId, FNUMBER pnumber from CT_MP_YGZC where CFHRBPID = '" + personId + "' " + "  and CFAUDITSTATUS = '" + ZcShztEnum.SIGN_UP_PASS.getCode() + "' " + "  and CFCPZT in ('" + ZcCpztEnum.EVAL_PASS_NO.getCode() + "', '" + ZcCpztEnum.EVAL_PASS_YES.getCode() + "') " + "  and CFJGTZZT = '" + ZcSpztEnum.APPROVAL_FINISH.getCode() + "' " + "  and CFCpnf = '" + zcCycle + "' ";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                ZcDTO dto = new ZcDTO();
                dto.setId(rs.getString("zcId"));
                dto.setNumber(rs.getString("pnumber"));
                dataList.add(dto);
            }
        }
        return new ZcResult<ZcDTO>(CollectionUtils.isNotEmpty((Collection)dataList) ? "1" : "0", dataList, errMap);
    }

    public void urgeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException, SQLException {
        System.out.println(LOG_HEAD + "noticeAction() \u8fdb\u5165 \u3002\u3002\u3002");
        Set<String> zcIdSet = ZcUtil.split(request.getParameter("ids"));
        if (CollectionUtils.isEmpty(zcIdSet)) {
            JSONUtils.ERROR((String)"\u8bf7\u5148\u9009\u4e2d\u8868\u683c\u4e2d\u7684\u6570\u636e");
            return;
        }
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String personId = personInfo.getId().toString();
        HashMap errMap = Maps.newHashMap();
        Map<String, ZcDTO> zcMap = this.component.mapZc(zcIdSet);
        HashSet zcIdSetValid = Sets.newHashSet();
        for (String zcId : zcIdSet) {
            ZcDTO zc = zcMap.get(zcId);
            if (zc == null) {
                errMap.put(zcId, "\u4e0d\u5b58\u5728");
                continue;
            }
            if (!personId.equals(zc.getHrbpId())) {
                errMap.put(zcId, "\u4e13\u6d4b-\u767b\u5f55\u7528\u6237\u5f02\u5e38\uff0cHRPB ID\u975e\u5f53\u524d\u767b\u5f55\u5458\u5de5ID");
                continue;
            }
            if (!ZcShztEnum.SIGN_UP_PASS.getCode().equals(zc.getAuditStatus())) {
                errMap.put(zcId, "\u4e13\u6d4b-\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c[" + ZcShztEnum.SIGN_UP_PASS.getName() + "]\u72b6\u6001\u624d\u53ef\u50ac\u529e");
                continue;
            }
            if (!Lists.newArrayList((Object[])new String[]{ZcCpztEnum.EVALUATE_DOING.getCode(), ZcCpztEnum.ASSESS_DOING.getCode()}).contains(zc.getCpzt())) {
                errMap.put(zcId, "\u4e13\u6d4b-\u6d4b\u8bc4\u72b6\u6001\u5f02\u5e38\uff0c[" + ZcCpztEnum.EVALUATE_DOING.getName() + "]\u6216[" + ZcCpztEnum.ASSESS_DOING.getName() + "]\u72b6\u6001\u624d\u53ef\u50ac\u529e");
                continue;
            }
            zcIdSetValid.add(zcId);
        }
        Set<String> cpgNumber = this.countCpg(zcIdSetValid, errMap);
        if (CollectionUtils.isNotEmpty(cpgNumber)) {
            this.component.sendMsg(cpgNumber, ZcMsgTemplateEnum.ZC_CP_URGE);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("result", "200");
        result2.put("zcResult", new ZcResult<String>(errMap, cpgNumber));
        this.writeSuccessData(result2);
    }

    private Set<String> countCpg(Set<String> zcIdSetValid, Map<String, String> errMap) {
        List<CpgDTO> cpgList;
        if (CollectionUtils.isNotEmpty(zcIdSetValid) && CollectionUtils.isNotEmpty(cpgList = this.component.listCpg(zcIdSetValid))) {
            HashSet cpgNumber = Sets.newHashSet();
            for (CpgDTO cpg : cpgList) {
                String cpgId = cpg.getCpgId();
                if (ZcCpgScoreEnum.SUBMIT.getCode().equals(cpg.getScoreStatus())) {
                    errMap.put(cpgId, "\u6d4b\u8bc4\u5b98-\u8bc4\u5206\u72b6\u6001\u5df2[\u63d0\u4ea4]");
                    continue;
                }
                cpgNumber.add(cpg.getCpgNumber());
            }
            return cpgNumber;
        }
        return Sets.newHashSet();
    }
}

