/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.zc.web.handler.sp;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.zc.web.dto.PersonDTO;
import com.kingdee.shr.zc.web.dto.ZcDTO;
import com.kingdee.shr.zc.web.server.ZcComponent;
import com.kingdee.shr.zc.web.util.ZcUtil;
import com.kingdee.shr.zc.web.zenum.ZcCpztEnum;
import com.kingdee.shr.zc.web.zenum.ZcShztEnum;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class ZcSpListHandler
extends ListHandler {
    private static final String LOG_HEAD = "ygzc_" + ZcSpListHandler.class.getSimpleName() + "_";
    private final Context ctx = SHRContext.getInstance().getContext();
    private final ZcComponent component = new ZcComponent(this.ctx);

    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        Principal principal = request.getUserPrincipal();
        String number = principal.getName();
        FilterInfo enterpriseNatureFilter = new FilterInfo();
        enterpriseNatureFilter.getFilterItems().add(new FilterItemInfo("spHrbp.number = '" + number + "'"));
        return enterpriseNatureFilter;
    }

    public void checkAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "checkAction() \u8fdb\u5165\u3002\u3002\u3002");
        String hrbpId = request.getParameter("hrbpId");
        String zcListStr = request.getParameter("zcList");
        List zcList = JSON.parseArray((String)zcListStr, ZcDTO.class);
        String errMsg = this.check(hrbpId, zcList);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private String check(String hrbpId, List<ZcDTO> zcListInput) {
        if (StringUtils.isBlank((CharSequence)hrbpId)) {
            return "\u8bf7\u9009\u62e9HRBP";
        }
        List<PersonDTO> personList = this.component.listPersonsByIdSet(Sets.newHashSet((Object[])new String[]{hrbpId}));
        if (CollectionUtils.isEmpty(personList) || !hrbpId.equals(personList.get(0).getId())) {
            return "HRBP\u4e0d\u5b58\u5728\u6216\u5df2\u79bb\u804c";
        }
        if (CollectionUtils.isEmpty(zcListInput)) {
            return "\u8bf7\u9009\u4e2d\u8868\u683c\u4e2d\u7684\u6570\u636e";
        }
        Map<String, ZcDTO> zcMap = this.component.mapZc(zcListInput.stream().map(ZcDTO::getId).collect(Collectors.toSet()));
        for (ZcDTO zcInput : zcListInput) {
            String zcIdInput = zcInput.getId();
            String name = zcInput.getName() + "[" + zcInput.getNumber() + "]";
            if (StringUtils.isBlank((CharSequence)zcIdInput)) {
                return name + "\u4e13\u6d4bID\u4e3a\u7a7a";
            }
            ZcDTO zcDb = zcMap.get(zcIdInput);
            if (zcDb == null) {
                return name + "\u4e13\u6d4b\u4e0d\u5b58\u5728";
            }
            if (!ZcShztEnum.SIGN_UP_PASS.getCode().equals(zcDb.getAuditStatus())) {
                return name + "\u5ba1\u6838\u72b6\u6001\u4e0d\u662f" + ZcShztEnum.SIGN_UP_PASS.getName();
            }
            if (!StringUtils.isNotBlank((CharSequence)zcDb.getSpzt())) continue;
            return name + "\u5ba1\u6279\u72b6\u6001\u4e0d\u4e3a\u7a7a";
        }
        return "";
    }

    public void authAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "checkAction() \u8fdb\u5165\u3002\u3002\u3002");
        String hrbpId = request.getParameter("hrbpId");
        String zcListStr = request.getParameter("zcList");
        List zcList = JSON.parseArray((String)zcListStr, ZcDTO.class);
        String errMsg = this.check(hrbpId, zcList);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            JSONUtils.ERROR((String)errMsg);
            return;
        }
        this.doAuth(hrbpId, zcList);
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    private void doAuth(String hrbpId, List<ZcDTO> zcList) throws ShrWebBizException, BOSException {
        Set<String> zcIdSet = zcList.stream().map(ZcDTO::getId).collect(Collectors.toSet());
        PersonInfo personInfo = SHRBillUtil.getCurrPersonInfo();
        String personId = personInfo.getId().toString();
        String userId = this.component.getUserId(personId);
        String sql = "/*dialect*/ update CT_MP_YGZC set CFSPHRBPID = '" + hrbpId + "', FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = sysdate where FID in (" + ZcUtil.in(zcIdSet) + ")";
        DbUtil.execute((Context)this.ctx, (String)sql);
        System.out.println(LOG_HEAD + "doAuth() sql = " + sql);
    }

    public void toArrangeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        System.out.println(LOG_HEAD + "checkAction() \u8fdb\u5165\u3002\u3002\u3002");
        String idStr = request.getParameter("ids");
        Set<String> zcIdSet = ZcUtil.split(idStr);
        if (CollectionUtils.isEmpty(zcIdSet)) {
            JSONUtils.ERROR((String)"\u8bf7\u5148\u9009\u4e2d\u8868\u683c\u4e2d\u7684\u6570\u636e");
            return;
        }
        HashMap errMap = Maps.newHashMap();
        HashSet set = Sets.newHashSet();
        Map<String, ZcDTO> zcMap = this.component.mapZc(zcIdSet);
        for (String zcId : zcIdSet) {
            ZcDTO zc = zcMap.get(zcId);
            if (zc == null) {
                errMap.put(zcId, "\u4e13\u6d4b\u4e0d\u5b58\u5728");
                continue;
            }
            if (!ZcShztEnum.SIGN_UP_PASS.getCode().equals(zc.getAuditStatus())) {
                errMap.put(zcId, "\u5ba1\u6838\u72b6\u6001\u4e0d\u662f" + ZcShztEnum.SIGN_UP_PASS.getName());
                continue;
            }
            if (!Lists.newArrayList((Object[])new String[]{ZcCpztEnum.EVAL_PASS_NO.getCode(), ZcCpztEnum.EVAL_PASS_YES.getCode()}).contains(zc.getCpzt())) {
                errMap.put(zcId, "\u6d4b\u8bc4\u72b6\u6001\u4e0d\u662f" + ZcCpztEnum.EVAL_PASS_NO.getName() + "\u6216" + ZcCpztEnum.EVAL_PASS_YES.getName());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)zc.getSpzt())) {
                errMap.put(zcId, "\u5ba1\u6279\u72b6\u6001\u4e0d\u4e3a\u7a7a");
                continue;
            }
            set.add(zcId);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("result", "200");
        result2.put("zcIds", Joiner.on((String)",").join((Iterable)set));
        result2.put("errMap", errMap);
        this.writeSuccessData(result2);
    }
}

