package qitu.dm.ds.plugin.form;

import com.kingdee.util.StringUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.*;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import qitu.dm.ds.common.QituApplybillConstant;

import java.math.BigDecimal;
import java.util.*;

public class ApplyBillFormPlugin extends AbstractBillPlugIn {
    private final static String APPLYBILL = "qitu_applybill"; // 办公用品领用申请单
    private final static String INVENTORY = "qitu_inventory";//库存单
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject user = (DynamicObject) this.getModel().getValue(QituApplybillConstant.QITU_USERFIELD);
        //通过用户id查询其所属组织
        long deptId = UserServiceHelper.getUserMainOrgId(user.getLong("id"));
        this.getModel().setValue(QituApplybillConstant.QITU_ORGFIELD,deptId);
        List ids = new ArrayList();
        ids.add(user.getLong("id"));
        Map<String, Object> companyMap = OrgUnitServiceHelper.getCompanyByAdminOrg(deptId,false);
        this.getModel().setValue(QituApplybillConstant.QITU_COMPANY,companyMap.get("id"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ( StringUtils.equals(QituApplybillConstant.KEY_VIEW_INVENTORY, formOperate.getOperateKey())){
            // 获取单据体
            EntryGrid entryentity = this.getControl(QituApplybillConstant.ENTRYENTITY);
            // 获取选中的行
            int[] selectRows = entryentity.getSelectRows();
            Object good = this.getModel().getValue(QituApplybillConstant.QITU_GOOD,selectRows[0]);
            if(null == good){
                this.getView().showTipNotification(ResManager.loadKDString("请先选择物品!", "ApplyBillFormPlugin_0", "qitu-dm-ds"));
                args.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ( StringUtils.equals(QituApplybillConstant.KEY_VIEW_INVENTORY, args.getOperateKey())){
            // 获取单据体
            EntryGrid entryentity = this.getControl(QituApplybillConstant.ENTRYENTITY);
            // 获取选中的行
            int[] selectRows = entryentity.getSelectRows();
            Object good = this.getModel().getValue(QituApplybillConstant.QITU_GOOD,selectRows[0]);
            if(null != good){
                //根据物品查询库存单
                DynamicObject goodInfo = (DynamicObject) good;
                //根据物品查询库存
                DynamicObject inventory = BusinessDataServiceHelper.loadSingle(INVENTORY,
                        "id",
                        new QFilter[]{new QFilter("qitu_good.id", QCP.equals, goodInfo.getPkValue())});
                if(null!=inventory){
                    BillShowParameter billShowParameter = new BillShowParameter();
                    billShowParameter.setFormId(INVENTORY);
                    billShowParameter.setCaption(new LocaleString(ResManager.loadKDString("办公用品库存单", "ApplyBillFormPlugin_1", "qitu-dm-ds")).toString());
                    billShowParameter.setPkId(inventory.getPkValue());
                    billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(billShowParameter);
                }else{
                    this.getView().showTipNotification(ResManager.loadKDString("所选物品没有对应库存!", "ApplyBillFormPlugin_2", "qitu-dm-ds"));
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String stopChange = this.getPageCache().get("stopChange");
        if (!"true".equals(stopChange)) {
            String fieldKey = e.getProperty().getName();
            ChangeData[] changeSet = e.getChangeSet();
            for(int i = 0; i < changeSet.length; ++i) {
                ChangeData changeData = changeSet[i];
                Object newValue = changeData.getNewValue();
                Object oldValue = changeData.getOldValue();
                int rowIndex = changeData.getRowIndex();
                if (newValue == null && oldValue == null) {
                    return;
                }

                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }

                if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                    return;
                }

                if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                    return;
                }
                switch (fieldKey) {
                    case "qitu_qtyfield":
                        this.changeGoodQty(oldValue, newValue, rowIndex);
                        break;
                }
            }
        }
    }
    private void changeGoodQty(Object oldValue, Object newValue, int rowIndex) {
        BigDecimal appQty = (BigDecimal) newValue;
        IDataModel model = this.getModel();
        Object good = this.getModel().getValue(QituApplybillConstant.QITU_GOOD,rowIndex);
        if(null != good){
            //根据物品查询库存单
            DynamicObject goodInfo = (DynamicObject) good;
            //根据物品查询库存
            DynamicObject inventory = BusinessDataServiceHelper.loadSingle(INVENTORY,
                    "id,qitu_qtyfield",
                    new QFilter[]{new QFilter("qitu_good.id", QCP.equals, goodInfo.getPkValue())});
            BigDecimal qty = BigDecimal.ZERO;
            if(null!=inventory){
                qty=inventory.getBigDecimal("qitu_qtyfield");
            }
            //查询流程中对应物品的数量
            Set<String> strArray = new HashSet<>();
            strArray.add("B");
            strArray.add("C");
            DynamicObject[] applybills = BusinessDataServiceHelper.load(APPLYBILL,
                    "id,entryentity.qitu_qtyfield",
                    new QFilter[]{new QFilter("entryentity.qitu_good", QCP.equals, goodInfo.getPkValue())
                            ,new QFilter("billstatus", QCP.in, strArray)});
            BigDecimal appHisQty = BigDecimal.ZERO;
            for (int i = 0; i < applybills.length; i++) {
                DynamicObject applybill = applybills[i];
                DynamicObjectCollection enCol = applybill.getDynamicObjectCollection(QituApplybillConstant.ENTRYENTITY);
                for (int j = 0; j < enCol.size(); j++) {
                    DynamicObject enInfo = enCol.get(j);
                    appHisQty.add(enInfo.getBigDecimal("qitu_qtyfield"));
                }
            }
            if(appQty.compareTo(qty.subtract(appHisQty))>0){
                this.getPageCache().put("resQty",qty.subtract(appHisQty).toString());
                //作废操作前让用户选择是否继续作废操作，在用户点击确认框上的按钮后，系统会调用confirmCallBack方法
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("feiqiction", this);
                //设置页面确认框，参数为：标题，选项框类型，回调监听
                this.getView().showConfirm(ResManager.loadKDString("库存不足,是否只领用剩余数量？", "ApplyBillFormPlugin_3", "qitu-dm-ds"), MessageBoxOptions.YesNo, confirmCallBackListener);
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        //判断回调参数id
        if("feiqiction".equals(messageBoxClosedEvent.getCallBackId())){
            if (MessageBoxResult.Yes.equals(messageBoxClosedEvent.getResult())) {
                IDataModel model = this.getModel();
                // 获取单据体
                EntryGrid entryEntity = this.getControl(QituApplybillConstant.ENTRYENTITY);
                // 获取选中的行
                int[] selectRows = entryEntity.getSelectRows();
                if(null!=this.getPageCache().get("resQty")){
                    model.beginInit();
                    model.setValue("qitu_qtyfield", new BigDecimal(this.getPageCache().get("resQty")), selectRows[0]);
                    model.setValue("qitu_qtyfield1",new BigDecimal(this.getPageCache().get("resQty")), selectRows[0]);
                    model.endInit();
                    IFormView view = this.getView();
                    view.updateView("qitu_qtyfield", selectRows[0]);
                    view.updateView("qitu_qtyfield1", selectRows[0]);
                }
            }else if(MessageBoxResult.No.equals(messageBoxClosedEvent.getResult())){
                IDataModel model = this.getModel();
                // 获取单据体
                EntryGrid entryEntity = this.getControl(QituApplybillConstant.ENTRYENTITY);
                // 获取选中的行
                int[] selectRows = entryEntity.getSelectRows();
                model.beginInit();
                model.setValue("qitu_qtyfield",null, selectRows[0]);
                model.setValue("qitu_qtyfield1",null, selectRows[0]);
                model.endInit();
                IFormView view = this.getView();
                view.updateView("qitu_qtyfield", selectRows[0]);
                view.updateView("qitu_qtyfield1", selectRows[0]);
            }
        }
    }
}
