package qitu.dm.ds.plugin.form;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.*;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.service.handler.EmailHandler;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.constant.entity.UserConst;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import qitu.dm.ds.common.QituGoodapplyConstant;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChartDemoDynamicFormPlugin extends AbstractFormPlugin {
    @Override
    public void initialize() {
        super.initialize();
        Chart barchart =this.getControl("qitu_barchartap");
        if(barchart instanceof Chart) {
            Map<String, Object> titlePropValue = new HashMap<>();

            // 主标题内容：text
            titlePropValue.put("text", "条形图");
            // 设置触发提示框的类型为axis：坐标轴触发
            barchart.addTooltip("trigger", "axis");
            // 字符串模板格式
            List<Object> toolTipFuncPath = new ArrayList<>();
            String formatter = "{b0}: {c0}";
            barchart.addTooltip("formatter", formatter);
            toolTipFuncPath.add("tooltip");
            toolTipFuncPath.add("formatter");
            barchart.addFuncPath(toolTipFuncPath);
            barchart.setShowTooltip(true);
            // 设置图例位置为中上
            barchart.setLegendAlign(XAlign.center, YAlign.top);
            //AxisType可以调整纵轴或横轴显示数据
            Axis x = barchart.createXAxis("来源", AxisType.category);
            Axis y = barchart.createYAxis("数量", AxisType.value);
            // 设置X轴类目数据（如果没有设置，则需要再series中设置）
            String[] data2 = {"视频广告", "联盟广告", "邮件营销", "直接访问", "搜索引擎"};
            x.setPropValue("data", data2);
            // 创建系列为“辅助”的系列
            BarSeries barseries = barchart.createBarSeries("辅助");
            // 设置系列名称，用于tooltip的显示，legend 的图例筛选.
            barseries.setName("来源");
            // 设置数据堆叠，同个类目轴上系列配置相同的stack值可以堆叠放置
            barseries.setStack("数量");
            // 设置系列中数据的内容
            Number[] number = {234, 354, 137, 1000, 400};
            barseries.setData(number);
            // 设置柱条颜色（直接设置颜色值和渐变设置）
//            barseries.setColor("");
            barchart.refresh();
        }
    }
}
