package qitu.dm.ds.plugin.form;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

/**
 * @author:赵晨光
 * @date:2024/4/29
 * @time:  14:04
 * Description:(常量类生成工具)
 */
public class GenMetaConstantDynamicFormPlugin extends AbstractFormPlugin {
    /**
     * 生成按钮标识
     */
    protected final String CREATEJAVA = "createjava";
    /**
     * 元数据对象字段标识
     */
    protected final String ENTITYOBJECT = "entityobject";
    /**
     * 换行标识符
     */
    protected final String LINEFEED = "\r\n";
    /**
     * 包路径字段标识
     */
    protected final String PACKAGENAME = "packagename";

    private static final String CODE = "code";
    protected Map<String, String> codeLineMap = new HashMap<String, String>();
    protected SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    public void registerListener(EventObject evt) {
        this.addClickListeners(CREATEJAVA);
    }

    public void click(EventObject evt) {
        Control control = (Control) evt.getSource();
        String key = control.getKey();
        if (CREATEJAVA.equals(key)) {
            this.afterDoCreateJava();
        }
    }

    protected void afterDoCreateJava() {
        // 获取数据实体对象
        DynamicObject dataEntity = this.getModel().getDataEntity();

        // 检查是否选择了主实体对象
        DynamicObject entityObject = dataEntity.getDynamicObject(ENTITYOBJECT);
        if (entityObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString("请选择【主实体对象】", "GenMetaConstantDynamicFormPlugin_0", "qitu-dm-ds"));
            return;
        }

        // 获取实体编号和名称
        String entityNumber = entityObject.getString("number");
        String entityName = entityObject.getString("name");

        // 生成常量类名
        String javaName = entityNumber + "Constant";
        javaName = this.rename(javaName);

        // 创建字符串构建器
        StringBuilder content = new StringBuilder();

        // 获取主实体类型及其属性集合
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType(entityNumber);
        DataEntityPropertyCollection mainEntityProperties = mainEntityType.getProperties();

        // 创建前缀代码
        this.createPrefixCode(content, javaName, entityName);

        //生成单据实体属性
        String annotation = "    /**" + entityName + "**/" + LINEFEED;
        String code = "    public static final String ENTITYKEY = \"" + entityNumber + "\";" + LINEFEED;
        content.append(annotation).append(code);
        // 遍历主实体属性，处理所有类型的属性
        for (IDataEntityProperty property : mainEntityProperties) {
            this.createProperteyCode(content, property);

            // 如果当前属性是 EntryProp 类型，进一步处理其子属性
            if (property instanceof EntryProp) {
                handleEntryProp((EntryProp) property, content);
            }
        }

        // 创建后缀代码并输出生成的 Java 代码
        this.createSuffixCode(content);
        this.outPutJava(content);
        this.getView().showSuccessNotification(ResManager.loadKDString("生成成功。", "GenMetaConstantDynamicFormPlugin_1", "qitu-dm-ds"));
    }

    // 提取处理 EntryProp 子属性的逻辑
    private void handleEntryProp(EntryProp entryProp, StringBuilder content) {
        DynamicObjectType entryPropType = entryProp.getDynamicCollectionItemPropertyType();

        // 遍历 EntryProp 的属性
        for (IDataEntityProperty entryPropProperty : entryPropType.getProperties()) {
            this.createProperteyCode(content, entryPropProperty);

            // 如果当前属性是 SubEntryProp 类型，进一步处理其子属性
            if (entryPropProperty instanceof SubEntryProp) {
                handleSubEntryProp((SubEntryProp) entryPropProperty, content);
            }
        }
    }

    // 提取处理 SubEntryProp 子属性的逻辑
    private void handleSubEntryProp(SubEntryProp subEntryProp, StringBuilder content) {
        DynamicObjectType subEntryPropType = subEntryProp.getDynamicCollectionItemPropertyType();

        // 遍历 SubEntryProp 的属性，并生成对应的代码
        for (IDataEntityProperty subEntryPropProperty : subEntryPropType.getProperties()) {
            this.createProperteyCode(content, subEntryPropProperty);
        }
    }


    protected String rename(String javaName) {
        String splitStr = "_";
        StringBuilder result = new StringBuilder();
        if (javaName.contains(splitStr)) {
            String[] splitArray = javaName.split(splitStr);

            for (String s : splitArray) {
                result.append(this.toUpperFirstChar(s));
            }
        } else {
            result = new StringBuilder(this.toUpperFirstChar(javaName));
        }

        return result.toString();
    }

    protected String toUpperFirstChar(String string) {
        char[] chars = string.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char) (chars[0] - 32);
            return String.valueOf(chars);
        } else {
            return string;
        }
    }

    protected void createSuffixCode(StringBuilder content) {
        content.append("}" + LINEFEED);
    }

    protected void createPrefixCode(StringBuilder content, String javaName, String entityName) {
        String packageName = "kd.constant";
        Object packageNameValue = this.getModel().getValue(PACKAGENAME);
        if (packageNameValue != null && !packageNameValue.toString().isEmpty()) {
            packageName = packageNameValue.toString();
        }

        String rdNumber = RequestContext.get().getUserName();

        String dateStr = this.formatter.format(new Date());
        String prefixCode = "package " + packageName + ";" + LINEFEED + LINEFEED + "/**" + LINEFEED + " * "
                + entityName + ResManager.loadKDString("常量类", "GenMetaConstantDynamicFormPlugin_2", "qitu-dm-ds") + LINEFEED + " *" + LINEFEED + " * @author " + rdNumber + LINEFEED + " * @version 1.0"
                + LINEFEED + " * @date " + dateStr + LINEFEED + " */" + LINEFEED + "public class " + javaName + " {" + LINEFEED;
        content.append(prefixCode);
    }

    protected void createProperteyCode(StringBuilder content, IDataEntityProperty iDataEntityProperty) {
        String propertyName = iDataEntityProperty.getName();
        if (this.codeLineMap.get(propertyName) == null) {
            LocaleString displayNameObj = iDataEntityProperty.getDisplayName();

            if (displayNameObj == null && !"id".equals(propertyName)) {
                return;
            }

            String disPlayName = ResManager.loadKDString("缺省id字段", "GenMetaConstantDynamicFormPlugin_3", "qitu-dm-ds");

            if (displayNameObj != null) {
                disPlayName = displayNameObj.getLocaleValue_zh_CN();
            }


            this.codeLineMap.put(propertyName, disPlayName);
            String uppercasePropertyName = propertyName.toUpperCase();
            String annotation = "    /**" + disPlayName + "**/" + LINEFEED;
            String code = "    public static final String " + uppercasePropertyName + " = \"" + propertyName + "\";" + LINEFEED;
            content.append(annotation).append(code);
        }
    }

    protected void outPutJava(StringBuilder content) {
        CodeEdit codeshow = this.getView().getControl(CODE);
        codeshow.setText(content.toString());
    }
}
