package qitu.dm.ds.plugin.form;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.service.handler.EmailHandler;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.constant.entity.UserConst;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import qitu.dm.ds.common.QituGoodapplyConstant;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GoodApplyDynamicFormPlugin extends AbstractFormPlugin {

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ( QituGoodapplyConstant.KEY_SENDEMAIL.equals(args.getOperateKey())) {
            DynamicObjectCollection userCol = QueryServiceHelper.query("bos_user","id,name,email",new QFilter[]{new QFilter("id", QCP.is_notnull,null)});
            if(null!=userCol&&userCol.size()>0){
                for (DynamicObject dynamicObject : userCol) {
                    String jobStr = UserServiceHelper.getUserMainJob((Long) dynamicObject.get("id"));
                    String email = (String) dynamicObject.get(UserConst.PROP_EMAIL);
                    if (ResManager.loadKDString("库存管理员", "GoodApplyDynamicFormPlugin_0", "qitu-dm-ds").equals(jobStr) && !StringUtils.isEmpty(email)) {
                        DynamicObject entity = this.getModel().getDataEntity();
                        String good = entity.getString(QituGoodapplyConstant.QITU_GOOD);
                        DynamicObject applyer = entity.getDynamicObject(QituGoodapplyConstant.QITU_APPLYER);
                        String remark = entity.getString(QituGoodapplyConstant.QITU_REMARK);
                        //附件面板获取附件信息
                        AttachmentPanel panel = this.getView().getControl(QituGoodapplyConstant.ATTACHMENT_PANEL);
                        List<Map<String, Object>> attachs = panel.getAttachmentData();
                        EmailInfo emailInfo = new EmailInfo();
                        emailInfo.setTitle(applyer.get("name") + ResManager.loadKDString(":物品新增申请", "GoodApplyDynamicFormPlugin_1", "qitu-dm-ds"));
                        emailInfo.setContent(ResManager.loadKDString("正文:物品：", "GoodApplyDynamicFormPlugin_3", "qitu-dm-ds") + good + ResManager.loadKDString("，申请人：", "GoodApplyDynamicFormPlugin_3", "qitu-dm-ds") + applyer.get("name") + ResManager.loadKDString("，说明：", "GoodApplyDynamicFormPlugin_3", "qitu-dm-ds") + remark);
                        List<String> receiver = new ArrayList<>();
                        receiver.add(email);
                        emailInfo.setReceiver(receiver);
//                        MessageAttachment attachment = new MessageAttachment();
                        if (null != attachs && attachs.size() > 0) {
                            List<byte[]> datas = new ArrayList<>();
                            List<String> attachmentNames = new ArrayList<>();
                            for (Map<String, Object> attInfo : attachs) {
                                datas.add(this.getBytesByFile((String) attInfo.get("url")));
                                attachmentNames.add((String) attInfo.get("name"));
                            }
                            emailInfo.setAttachments(datas);
                            emailInfo.setAttachmentNames(attachmentNames);
//                            attachment.setAttachments(datas);
                        }
                        EmailHandler.sendEmail(emailInfo);
                    }
                }
            }
        }
    }
    public byte[] getBytesByFile(String pathStr) {
//        File file = new File(pathStr);
        byte[] fileBytes = null;
        try {
            //获取临时文件的输入流
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream fis = cache.getInputStream(pathStr);

//            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            int n;
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            fileBytes = bos.toByteArray();
//            List<byte[]> datas = new ArrayList<>();
//            datas.add(data);
            bos.close();;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return fileBytes;
    }
}
