package qitu.dm.ds.plugin.form;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import qitu.dm.ds.common.QituInventoryConstant;
import qitu.dm.ds.common.QituRegisterConstant;

import java.util.EventObject;

public class InventoryFormPlugin extends AbstractBillPlugIn implements HyperLinkClickListener {
    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String key = hyperLinkClickEvent.getFieldName();
        if(QituInventoryConstant.QITU_TEXTFIELD.equals(key)){
            int index = hyperLinkClickEvent.getRowIndex();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(QituRegisterConstant.QITU_REGISTER);
            billShowParameter.setCaption(new LocaleString(ResManager.loadKDString("办公用品登记单", "InventoryFormPlugin_0", "qitu-dm-ds")).toString());
            String billNo = (String) this.getModel().getValue(QituInventoryConstant.QITU_TEXTFIELD,index);
            String comboField = (String) this.getModel().getValue(QituInventoryConstant.QITU_COMBOFIELD,index);
            //根据编码查询登记单
            if(!"B".equals(comboField)){
                DynamicObject register = BusinessDataServiceHelper.loadSingle(QituRegisterConstant.QITU_REGISTER,
                        "id",
                        new QFilter[]{new QFilter("billno", QCP.equals, billNo)});
                billShowParameter.setPkId(register.getPkValue());
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(billShowParameter);
            }

        }
    }
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = this.getView().getControl(QituInventoryConstant.QITU_INVENTORYENTRY);
        entry.addHyperClickListener(this);
    }
}
