package qitu.dm.ds.plugin.form;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ClientProperties;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import qitu.dm.ds.common.QituGoodConstant;
import qitu.dm.ds.common.QituRegisterConstant;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class RegisterFormPlugin extends AbstractBillPlugIn implements BeforeF7SelectListener, ItemClickListener, AfterF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit operator =this.getView().getControl(QituRegisterConstant.QITU_GOOD);
        if (operator != null) {
            operator.addBeforeF7SelectListener(this);
        }
        BasedataEdit reuser = this.getView().getControl(QituRegisterConstant.QITU_REUSER);
        if (reuser != null) {
            reuser.addAfterF7SelectListener(this);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        //标准界面控件与数据绑定之后，初始化个性化控件绑定数据显示
        IFormView view = this.getView();//界面
        IDataModel model = this.getModel();//数据
        //标准界面控件与数据绑定之后，初始化个性化控件绑定数据显示
        //根据数据初始化界面控件颜色
        String billStatus = (String) model.getValue(QituRegisterConstant.BILLSTATUS);
        switch (billStatus) {
            case "B":  //已提交（红色）
                HashMap<String,Object> fieldMap1 = new HashMap<>();
                fieldMap1.put(ClientProperties.ForeColor,"#FF0000");
                view.updateControlMetadata(QituRegisterConstant.BILLSTATUS,fieldMap1);
                break;

            case "C": //已审核(绿色)
                HashMap<String,Object> fieldMap2 = new HashMap<>();
                fieldMap2.put(ClientProperties.ForeColor,"#00B050");
                view.updateControlMetadata(QituRegisterConstant.BILLSTATUS,fieldMap2);
                break;
            case "D":  //已入库（蓝色）
                HashMap<String,Object> fieldMap3 = new HashMap<>();
                fieldMap3.put(ClientProperties.ForeColor,"#FF5C5C");
                view.updateControlMetadata(QituRegisterConstant.BILLSTATUS,fieldMap3);
                break;
            default:
                break;
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (fieldKey.equals(QituRegisterConstant.QITU_GOOD)) {
            int row = e.getRow();
            DynamicObject goodType = (DynamicObject) this.getModel().getValue(QituRegisterConstant.QITU_GOODTYPE, row);
            if (goodType != null && goodType.getPkValue() != null) {
                QFilter qFilter = new QFilter(QituGoodConstant.GROUP, "=", goodType.getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            } else {
//                    this.getView().showTipNotification(ResManager.loadKDString("请先选择物料信息。", "PurApplyBillPlugin_21", "scmc-pm-formplugin", new Object[0]));
//                    e.setCancel(true);
            }
        }
    }
    @Override
    public void afterF7Select(AfterF7SelectEvent e) {
        this.getModel().beginInit();
        //获取选中行
        ListSelectedRow selectRowList = e.getListSelectedRow();
//        if(null!=selectRowList){
//            // 获取选中行主键
//            Long pk = (Long) selectRowList.getPrimaryKeyValue();
//            // 获取选中分录行主键
////            Long entryPk = (Long) selectRowList.getEntryPrimaryKeyValue();
//            DynamicObject user = BusinessDataServiceHelper.loadSingle(pk,"bos_user");
//            if(null!=user){
//                //通过用户id查询其所属组织
//                long deptId = UserServiceHelper.getUserMainOrgId(user.getLong("id"));
//                this.getModel().setValue("qitu_orgfield1",deptId);
//                List ids = new ArrayList();
//                ids.add(user.getLong("id"));
////                Map<String, Object> companyMap = OrgUnitServiceHelper.getCompanyByOrg(deptId);
//                Map<String, Object> companyMap =OrgUnitServiceHelper.getCompanyByAdminOrg(deptId,false);
//                this.getModel().setValue("qitu_company",companyMap.get("id"));
//            }else{
//                this.getModel().setValue("qitu_orgfield1",null);
//                this.getModel().setValue("qitu_company",null);
//            }
//        }
//        this.getModel().endInit();
//        IFormView view = this.getView();
//        view.updateView("qitu_orgfield1");
//        view.updateView("qitu_orgfield2");
    }
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String stopChange = this.getPageCache().get("stopChange");
        if (!"true".equals(stopChange)) {
            String fieldKey = e.getProperty().getName();
            ChangeData[] changeSet = e.getChangeSet();
            for(int i = 0; i < changeSet.length; ++i) {
                ChangeData changeData = changeSet[i];
                Object newValue = changeData.getNewValue();
                Object oldValue = changeData.getOldValue();
                int rowIndex = changeData.getRowIndex();
                if (newValue == null && oldValue == null) {
                    return;
                }

                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }

                if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                    return;
                }

                if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                    return;
                }
                switch (fieldKey) {
                    case QituRegisterConstant.QITU_GOODTYPE:
                        this.changeGoodType(oldValue, newValue, rowIndex);
                        break;
                    case QituRegisterConstant.QITU_REUSER:
                        this.getModel().beginInit();
                        if(null!=newValue){
                            DynamicObject user = (DynamicObject) newValue;
                            long deptId = UserServiceHelper.getUserMainOrgId(user.getLong("id"));
                            this.getModel().setValue(QituRegisterConstant.QITU_ORGFIELD1,deptId);
                            Map<String, Object> companyMap =OrgUnitServiceHelper.getCompanyByAdminOrg(deptId,false);
                            this.getModel().setValue(QituRegisterConstant.QITU_COMPANY,companyMap.get("id"));
                        }else{
                            this.getModel().setValue(QituRegisterConstant.QITU_ORGFIELD1,null);
                            this.getModel().setValue(QituRegisterConstant.QITU_COMPANY,null);
                        }
                        this.getModel().endInit();
                        IFormView view = this.getView();
                        view.updateView(QituRegisterConstant.QITU_ORGFIELD1);
                        view.updateView(QituRegisterConstant.QITU_COMPANY);
                        break;
                }
            }
        }

    }

    private void changeGoodType(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(QituRegisterConstant.QITU_ORGFIELD1, null, rowIndex);
        model.endInit();
        IFormView view = this.getView();
        view.updateView(QituRegisterConstant.QITU_GOOD, rowIndex);
    }

}
