package qitu.dm.ds.plugin.operate;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import qitu.dm.ds.common.QituApplybillConstant;
import qitu.dm.ds.common.QituInventoryConstant;
import qitu.dm.ds.plugin.other.ApplyBillAuditValidator;

import java.math.BigDecimal;
import java.util.Date;

public class ApplyBillAuditOpServicePlugin extends AbstractOperationServicePlugIn {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new ApplyBillAuditValidator());
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        //扣减物品库存数量
        for (DynamicObject dataEntity: e.getDataEntities()) {
            DynamicObjectCollection enCol = dataEntity.getDynamicObjectCollection(QituApplybillConstant.ENTRYENTITY);
            if(null!=enCol&&enCol.size()>0){
                for (DynamicObject enInfo : enCol) {
                    DynamicObject good = enInfo.getDynamicObject(QituApplybillConstant.QITU_GOOD);
                    BigDecimal qty = enInfo.getBigDecimal(QituApplybillConstant.QITU_QTYFIELD1);
                    //根据物品查询库存单
                    DynamicObject inventory = BusinessDataServiceHelper.loadSingle(QituInventoryConstant.QITU_INVENTORY,
                            "id,billno,qitu_good.id,qitu_good.billno,qitu_good.name,qitu_qtyfield,qitu_inventoryentry," +
                                    "billstatus,qitu_inventoryentry.qitu_textfield,qitu_inventoryentry.qitu_datetimefield," +
                                    "qitu_inventoryentry.qitu_combofield,qitu_inventoryentry.qitu_attachmentfield",
                            new QFilter[]{new QFilter(QituInventoryConstant.QITU_GOOD, QCP.equals, good.getPkValue())});
                    if (null != inventory) {
                        BigDecimal qtyfield = inventory.getBigDecimal(QituInventoryConstant.QITU_QTYFIELD);//库存数量
                        qtyfield = qtyfield.subtract(qty);
                        inventory.set(QituInventoryConstant.QITU_QTYFIELD,qtyfield);
                        ////记录本次申请单号到库存单分录，操作类型为出库
                        DynamicObjectCollection dyCol = inventory.getDynamicObjectCollection(QituInventoryConstant.QITU_INVENTORYENTRY);
                        DynamicObject newEnInfo = dyCol.addNew();
                        newEnInfo.set(QituInventoryConstant.QITU_TEXTFIELD,dataEntity.get("billno"));
                        newEnInfo.set(QituInventoryConstant.QITU_DATETIMEFIELD,new Date());
                        newEnInfo.set(QituInventoryConstant.QITU_COMBOFIELD,'B');
                        OperationResult result = SaveServiceHelper
                                .saveOperate(QituInventoryConstant.QITU_INVENTORY,new DynamicObject[]{inventory}, OperateOption.create());
                        if(!result.isSuccess()){
                            throw new KDException(ResManager.loadKDString("库存单保存失败，请检查!", "ApplyBillAuditOpServicePlugin_0", "qitu-dm-ds"));
                        }
                    }
                }
            }
        }
    }
}
