package qitu.dm.ds.plugin.operate;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.service.business.datamodel.DynamicFormModelProxy;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import qitu.dm.ds.common.QituInventoryConstant;
import qitu.dm.ds.common.QituRegisterConstant;

import java.math.BigDecimal;
import java.util.*;

public class RegisterInStorageOpServicePlugin extends EntityOperateService {
    @Override
    protected boolean validate() {
        ExtendedDataEntitySet extendedDataEntitySet = this.getExtendDataEntitySet();
        Map<String, List<ExtendedDataEntity>> maps = extendedDataEntitySet.getExtDataEntityMap();
        List<ExtendedDataEntity> lisds=maps.get(QituRegisterConstant.QITU_REGISTER);
        if(lisds.size()>1){
            this.getOperationResult().addErrorInfo(new ValidationErrorInfo("","",
                            0,0,"err","billtitle",ResManager.loadKDString("每次只能入库一条数据！", "RegisterInStorageOpServicePlugin_0", "qitu-dm-ds"), ErrorLevel.Error));
            return false;
        }
        return super.validate();
    }
    @Override
    protected void executeOperate(DynamicObject[] dynamicObjects) {
        if(dynamicObjects.length>0){
            DynamicObject register = dynamicObjects[0];
            register=BusinessDataServiceHelper.loadSingle(register.getPkValue(),QituRegisterConstant.QITU_REGISTER);
            DynamicObjectCollection enCol = register.getDynamicObjectCollection(QituRegisterConstant.ENTRYENTITY);
            if(null!=enCol&&enCol.size()>0){
                for (DynamicObject enInfo : enCol) {
                    DynamicObject good = enInfo.getDynamicObject(QituRegisterConstant.QITU_GOOD);
                    BigDecimal qty = enInfo.getBigDecimal(QituRegisterConstant.QITU_QTYFIELD);
                    DynamicObjectCollection attCol= enInfo.getDynamicObjectCollection(QituRegisterConstant.QITU_ATTACHMENTFIELD);
                    //根据物品查询库存单
                    DynamicObject inventory = BusinessDataServiceHelper.loadSingle(QituInventoryConstant.QITU_INVENTORY,
                            "id,billno,qitu_good.id,qitu_good.billno,qitu_good.name,qitu_qtyfield,qitu_inventoryentry," +
                                    "billstatus,qitu_inventoryentry.qitu_textfield,qitu_inventoryentry.qitu_datetimefield," +
                                    "qitu_inventoryentry.qitu_combofield,qitu_inventoryentry.qitu_attachmentfield,qitu_unitfield",
                            new QFilter[]{new QFilter(QituInventoryConstant.QITU_GOOD, QCP.equals, good.getPkValue())});
                    if (null == inventory) {
                        DynamicFormModelProxy modelProxy = new DynamicFormModelProxy(QituInventoryConstant.QITU_INVENTORY, UUID.randomUUID().toString(), new HashMap<>());
                        inventory = (DynamicObject) modelProxy.createNewData();
                        inventory.set(QituInventoryConstant.QITU_GOOD,good.getPkValue());
                        if(null!=enInfo.getDynamicObject(QituRegisterConstant.QITU_UNITFIELD)){
                            inventory.set(QituInventoryConstant.QITU_UNITFIELD,enInfo.getDynamicObject(QituRegisterConstant.QITU_UNITFIELD).getPkValue());
                        }
                        inventory.set(QituInventoryConstant.QITU_QTYFIELD,BigDecimal.ZERO);
                    }
                    BigDecimal qtyfield = inventory.getBigDecimal(QituInventoryConstant.QITU_QTYFIELD);//库存数量
                    qtyfield = qtyfield.add(qty);
                    inventory.set(QituInventoryConstant.QITU_QTYFIELD,qtyfield);
                    inventory.set(QituInventoryConstant.BILLSTATUS,"C");
                    //需要记录本次入库对应各个物品的[登记单号][操作时间]到其库存单的[出入记录]分录，操作类型为入库。
                    DynamicObjectCollection dyCol = inventory.getDynamicObjectCollection(QituInventoryConstant.QITU_INVENTORYENTRY);
                    DynamicObject newEnInfo = dyCol.addNew();
                    newEnInfo.set(QituInventoryConstant.QITU_TEXTFIELD,register.get(QituRegisterConstant.BILLNO));
                    newEnInfo.set(QituInventoryConstant.QITU_DATETIMEFIELD,new Date());
                    newEnInfo.set(QituInventoryConstant.QITU_COMBOFIELD,'A');
                    DynamicObjectCollection attNewCol= newEnInfo.getDynamicObjectCollection(QituInventoryConstant.QITU_ATTACHMENTFIELD);

                    for (DynamicObject att:attCol) {
                        DynamicObject dynamicObject = attNewCol.addNew();
                        dynamicObject.set("fbasedataid", att.get("fbasedataid"));
                        dynamicObject.set("fbasedataid_id", att.get("fbasedataid_id"));
                    }
                    OperationResult result = SaveServiceHelper.saveOperate(QituInventoryConstant.QITU_INVENTORY
                            ,new DynamicObject[]{inventory}, OperateOption.create());
                    if(result.isSuccess()){
                        enInfo.set(QituRegisterConstant.QITU_BILLSTATUSFIELD,"1");
                        //入库成功后改变登记单的单据状态以及分录【入库状态】为“已入库”。
                        SaveServiceHelper.update(enInfo);
                    }
                }
            }
            register.set(QituRegisterConstant.BILLSTATUS,"D");
            SaveServiceHelper.update(register);
        }
    }
}
