package qitu.dm.ds.plugin.other;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import qitu.dm.ds.common.QituApplybillConstant;
import qitu.dm.ds.common.QituInventoryConstant;

import java.math.BigDecimal;

public class ApplyBillAuditValidator extends AbstractValidator {
    @Override
    public void validate() {
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection enCol = dataEntity.getDynamicObjectCollection(QituApplybillConstant.ENTRYENTITY);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < enCol.size(); i++) {
                DynamicObject enInfo = enCol.get(i);
                BigDecimal acQty = enInfo.getBigDecimal(QituApplybillConstant.QITU_QTYFIELD1);
                DynamicObject goodInfo = enInfo.getDynamicObject(QituApplybillConstant.QITU_GOOD);
                //根据物品查询库存
                DynamicObject inventory = BusinessDataServiceHelper.loadSingle(QituInventoryConstant.QITU_INVENTORY,
                        "id,qitu_qtyfield",
                        new QFilter[]{new QFilter(QituApplybillConstant.QITU_GOOD, QCP.equals, goodInfo.getPkValue())});
                BigDecimal qty = BigDecimal.ZERO;
                if(null!=inventory){
                    qty=inventory.getBigDecimal(QituInventoryConstant.QITU_QTYFIELD);
                }
                if(acQty.compareTo(qty)>0){
                    sb.append(i+1);
                    sb.append("、");
                }
            }
            if(sb.length()>0){
                sb.deleteCharAt(sb.length()-1);
                this.addErrorMessage(entity,String.format(ResManager.loadKDString("第%s行,实际领取数量不得大于对应物品的库存量", "ApplyBillAuditValidator_0", "qitu-dm-ds"),sb));
            }
        }
    }
}
