package qitu.dm.ds.plugin.other;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.operate.OperateOptionConst;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import qitu.dm.ds.common.QituApplybillConstant;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class SendMessageTask extends AbstractTask {
    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, -5); // 减去5天
            Date fiveDaysAgo = calendar.getTime();
            String formattedDate = sdf.format(fiveDaysAgo);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper
                    .load(QituApplybillConstant.QITU_APPLYBILL,"id,qitu_userfield,billno",
                            new QFilter[]{new QFilter(QituApplybillConstant.AUDITDATE, QCP.large_equals,sdf.parse(formattedDate)),
                                    new QFilter(QituApplybillConstant.BILLSTATUS, QCP.equals,'C')});

            for (DynamicObject dynamicObject:dynamicObjects) {
                //发送站内消息
                MessageInfo messageInfo = new MessageInfo();
                LocaleString title = new LocaleString();
                title.setLocaleValue_zh_CN(ResManager.loadKDString("gj测试消息标题", "SendMessageTask_0", "qitu-dm-ds"));
                title.setLocaleValue_en("gj test send message title");
                title.setLocaleValue_zh_TW(ResManager.loadKDString("gj測試消息標題", "SendMessageTask_1", "qitu-dm-ds"));
                messageInfo.setMessageTitle(title);
                LocaleString content = new LocaleString();
                //这样是生效的
                content.setLocaleValue_zh_CN(ResManager.loadKDString("亲爱的员工", "SendMessageTask_2", "qitu-dm-ds")+dynamicObject.getDynamicObject(QituApplybillConstant.QITU_USERFIELD).getString("name")
                        +ResManager.loadKDString("，你所提交的办公用品领用申请单", "SendMessageTask_3", "qitu-dm-ds")+dynamicObject.getString(QituApplybillConstant.BILLNO)+ResManager.loadKDString("因超过领用期限已自动废弃，如还需领用，请重新发起申请！", "SendMessageTask_4", "qitu-dm-ds"));
//                content.setLocaleValue_en("test send message content,<b>test send message content</b><br><i>test test test test</i>");
//                content.setLocaleValue_zh_TW("測試消息內容，<b>測試消息內容</b><br><i>測試測試測試測試</i>");
                messageInfo.setMessageContent(content);
                //获取当前的业务单元
//                long orgId = requestContext.getOrgId();
                //获取业务单元中所有的用户
//                List<Long> allUsersOfOrg = UserServiceHelper.getAllUsersOfOrg(orgId);
                ArrayList<Long> ids = new ArrayList<Long>();
                //获取当前登录用户id
                ids.add((Long) dynamicObject.getDynamicObject(QituApplybillConstant.QITU_USERFIELD).get("id"));
                messageInfo.setUserIds(ids);
                messageInfo.setType(MessageInfo.TYPE_MESSAGE);
                messageInfo.setTag(ResManager.loadKDString("gj测试", "SendMessageTask_5", "qitu-dm-ds"));
                //发送消息
                MessageCenterServiceHelper.sendMessage(messageInfo);


                //调用废弃操作
                OperateOption option = OperateOption.create();
                // 不执行警告级别校验器
                //option.setVariableValue(OperateOptionConst.MUTEX_IGNORE_VALIDATION, String.valueOf(true));
                // 不显示交互提示，自动执行到底
                //option.setVariableValue(OperateOptionConst.IGNOREINTERACTION, String.valueOf(true));
                // 跳过用户操作权限项
                option.setVariableValue(OperateOptionConst.ISHASRIGHT, String.valueOf(true));
                //有用户打开了当前页面也可以直接执行操作的参数，不受网络互斥限制
                option.setVariableValue("ignoreValidation",String.valueOf(true));
                //取消标准的弹窗提示，比如保存成功
                //option.setVariableValue(OperateOptionConst.ISSHOWMESSAGE, "false");

                OperationResult opResult = OperationServiceHelper.executeOperate("abandon",dynamicObject.getDataEntityType().getName(),new DynamicObject[] {dynamicObject},option);

            }
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}
