package qitu.dm.ds.plugin.report;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.algo.*;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

import java.util.*;

public class RecsituationReportListDataPlugin extends AbstractReportListDataPlugin {
    /**

     * 报表所有字段集合

     */

    private  String[] FIELDS=new String[]
            {"qitu_00","qitu_01","qitu_02","qitu_03","qitu_04","qitu_05","qitu_06","qitu_07","qitu_08","qitu_09","qitu_10","qitu_11","qitu_12","qitu_year"};

    /**

     *报表所有字段的数据类型集合

     */

    public DataType[] DATATYPES=new DataType[]{DataType.StringType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,

            DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType,DataType.IntegerType};

    private String[] Hiden=new String[]{"qitu_01","qitu_02","qitu_03","qitu_04","qitu_05","qitu_06","qitu_07","qitu_08","qitu_09","qitu_10","qitu_11","qitu_12"};

    @Override
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        //获取创建时间月份
        String timeMonth="Month(createtime) as qitu_12";
        //把查询字段的创建时间改为月份
        String fields="billno,entryentity.qitu_good.name qitu_00,entryentity.qitu_qtyfield1 qitu_qty,"+timeMonth;
        //查询领用单据-登录人本人数据
        DataSet dataSet=  QueryServiceHelper.queryDataSet(this.getClass().getName(), "qitu_applybill",fields,
                new QFilter[]{new QFilter("qitu_userfield", QCP.equals, UserServiceHelper.getCurrentUserId())}, null);
        //分组查询  group 物品 月份  数量     result：物品 月份
        DataSet group=dataSet.executeSql("select  qitu_00,qitu_qty,qitu_12 "+" group by qitu_00,qitu_12,qitu_qty");
        DataSet result=group.executeSql("select  qitu_00, qitu_12,sum(qitu_qty) as qitu_qty"+" group by qitu_00,qitu_12");
        //行转列    根据创建时间的不同月份创建不同列 把实际领取数量复制给月份列
        DataSet copy=result.copy();//复制一份数据
        Map<String,Object[]> values=new HashMap<>();//定义一个map集合
        Object[] tempData=null; //object数组
        for (Row row:copy){//遍历数据
            String name=row.getString("qitu_00");
            tempData=values.getOrDefault(name,new Object[FIELDS.length]);
            tempData[0]=row.getString("qitu_00");
            Integer i=row.getInteger("qitu_12");//获取 月份
            //把Hiden数组ArrayList化  便于移除String元素
            List<String> list = new ArrayList<>(Arrays.asList(Hiden));
            if (i<10) {
                list.remove("qitu_0"+i);//移除 hidden中的月份列
            }else {
                list.remove("qitu_"+i);
            }
            Hiden = list.toArray(new String[0]);
            tempData[i]=row.getInteger("qitu_qty");
            tempData[13]=row.getInteger("qitu_qty");
            values.put(name,tempData);

        }

        Collection<Object[]> coll=values.values();
        RowMeta rowMeta= RowMetaFactory.createRowMeta(FIELDS,DATATYPES);
        CollectionInput input=new CollectionInput(rowMeta,coll);
        DataSet resultDataSet= Algo.create(this.getClass().getName()).createDataSet(input);
        //合计
        DataSet dataSet2 =resultDataSet.groupBy().sum("qitu_01").sum("qitu_02").sum("qitu_03").sum("qitu_04").sum("qitu_05").sum("qitu_06").sum("qitu_07").sum("qitu_08").sum("qitu_09").sum("qitu_10").sum("qitu_11").sum("qitu_12").sum("qitu_year").finish();
        DataSet  ds=dataSet2.addField(ResManager.loadKDString("'合计'", "RecsituationReportListDataPlugin_0", "qitu-dm-ds"),"qitu_00");
        //重新查询  使ds字段与resultDataSet字段顺序一致
        ds=ds.select("qitu_00,qitu_01,qitu_02,qitu_03,qitu_04,qitu_05,qitu_06,qitu_07,qitu_08,qitu_09,qitu_10,qitu_11,qitu_12,qitu_year");
        return resultDataSet.union(ds);
    }

    @Override
    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
//        columns.add(createReportColumn("qitu_00","text","物品名称"));
//        columns.add(createReportColumn("qitu_01","text","一月"));
//        columns.add(createReportColumn("qitu_02","text","二月"));
//        columns.add(createReportColumn("qitu_03","text","三月"));
//        columns.add(createReportColumn("qitu_04","text","四月"));
//        columns.add(createReportColumn("qitu_05","text","五月"));
//        columns.add(createReportColumn("qitu_06","text","六月"));
//        columns.add(createReportColumn("qitu_07","text","七月"));
//        columns.add(createReportColumn("qitu_08","text","八月"));
//        columns.add(createReportColumn("qitu_09","text","九月"));
//        columns.add(createReportColumn("qitu_10","text","十月"));
//        columns.add(createReportColumn("qitu_11","text","十一月"));
//        columns.add(createReportColumn("qitu_12","text","十二月"));
//        columns.add(createReportColumn("qitu_year","text","年"));
        //隐藏列
        for(int i = 0; i < columns.size(); i ++) {
            ReportColumn rColumn = (ReportColumn) columns.get(i);
            String key = rColumn.getFieldKey();
            for (int j=0;j< Hiden.length;j++){
                if(key.equals(Hiden[j])) {
//                    rColumn.setHide(true);
                    columns.set(i, rColumn);
                }
            }
        }
        return columns;

    }
    public ReportColumn createReportColumn(String fieldKey, String fieldType, String caption){
        ReportColumn column = new ReportColumn();
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        column.setCaption(new LocaleString(caption));
        return column;
    }

}
