/*
 * Decompiled with CFR 0.152.
 */
package qitu.dm.ds.plugin.form;

import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ApplyBillFormPlugin
extends AbstractBillPlugIn {
    private static final String APPLYBILL = "qitu_applybill";
    private static final String INVENTORY = "qitu_inventory";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject user = (DynamicObject)this.getModel().getValue("qitu_userfield");
        long deptId = UserServiceHelper.getUserMainOrgId((long)user.getLong("id"));
        this.getModel().setValue("qitu_orgfield", (Object)deptId);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(user.getLong("id"));
        Map companyMap = OrgUnitServiceHelper.getCompanyByAdminOrg((Long)deptId, (Boolean)false);
        this.getModel().setValue("qitu_company", companyMap.get("id"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((String)"viewinventory", (String)formOperate.getOperateKey())) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            Object good = this.getModel().getValue("qitu_good", selectRows[0]);
            if (null == good) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u54c1!", (String)"ApplyBillFormPlugin_0", (String)"qitu-dm-ds", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((String)"viewinventory", (String)args.getOperateKey())) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            Object good = this.getModel().getValue("qitu_good", selectRows[0]);
            if (null != good) {
                DynamicObject goodInfo = (DynamicObject)good;
                DynamicObject inventory = BusinessDataServiceHelper.loadSingle((String)INVENTORY, (String)"id", (QFilter[])new QFilter[]{new QFilter("qitu_good.id", "=", goodInfo.getPkValue())});
                if (null != inventory) {
                    BillShowParameter billShowParameter = new BillShowParameter();
                    billShowParameter.setFormId(INVENTORY);
                    billShowParameter.setCaption(new LocaleString(ResManager.loadKDString((String)"\u529e\u516c\u7528\u54c1\u5e93\u5b58\u5355", (String)"ApplyBillFormPlugin_1", (String)"qitu-dm-ds", (Object[])new Object[0])).toString());
                    billShowParameter.setPkId(inventory.getPkValue());
                    billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)billShowParameter);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7269\u54c1\u6ca1\u6709\u5bf9\u5e94\u5e93\u5b58!", (String)"ApplyBillFormPlugin_2", (String)"qitu-dm-ds", (Object[])new Object[0]));
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String stopChange = this.getPageCache().get("stopChange");
        if (!"true".equals(stopChange)) {
            String fieldKey = e.getProperty().getName();
            ChangeData[] changeSet = e.getChangeSet();
            for (int i = 0; i < changeSet.length; ++i) {
                ChangeData changeData = changeSet[i];
                Object newValue = changeData.getNewValue();
                Object oldValue = changeData.getOldValue();
                int rowIndex = changeData.getRowIndex();
                if (newValue == null && oldValue == null) {
                    return;
                }
                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }
                if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                    return;
                }
                if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                    return;
                }
                switch (fieldKey) {
                    case "qitu_qtyfield": {
                        this.changeGoodQty(oldValue, newValue, rowIndex);
                    }
                }
            }
        }
    }

    private void changeGoodQty(Object oldValue, Object newValue, int rowIndex) {
        BigDecimal appQty = (BigDecimal)newValue;
        IDataModel model = this.getModel();
        Object good = this.getModel().getValue("qitu_good", rowIndex);
        if (null != good) {
            DynamicObject goodInfo = (DynamicObject)good;
            DynamicObject inventory = BusinessDataServiceHelper.loadSingle((String)INVENTORY, (String)"id,qitu_qtyfield", (QFilter[])new QFilter[]{new QFilter("qitu_good.id", "=", goodInfo.getPkValue())});
            BigDecimal qty = BigDecimal.ZERO;
            if (null != inventory) {
                qty = inventory.getBigDecimal("qitu_qtyfield");
            }
            HashSet<String> strArray = new HashSet<String>();
            strArray.add("B");
            strArray.add("C");
            DynamicObject[] applybills = BusinessDataServiceHelper.load((String)APPLYBILL, (String)"id,entryentity.qitu_qtyfield", (QFilter[])new QFilter[]{new QFilter("entryentity.qitu_good", "=", goodInfo.getPkValue()), new QFilter("billstatus", "in", strArray)});
            BigDecimal appHisQty = BigDecimal.ZERO;
            for (int i = 0; i < applybills.length; ++i) {
                DynamicObject applybill = applybills[i];
                DynamicObjectCollection enCol = applybill.getDynamicObjectCollection("entryentity");
                for (int j = 0; j < enCol.size(); ++j) {
                    DynamicObject enInfo = (DynamicObject)enCol.get(j);
                    appHisQty.add(enInfo.getBigDecimal("qitu_qtyfield"));
                }
            }
            if (appQty.compareTo(qty.subtract(appHisQty)) > 0) {
                this.getPageCache().put("resQty", qty.subtract(appHisQty).toString());
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("feiqiction", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3,\u662f\u5426\u53ea\u9886\u7528\u5269\u4f59\u6570\u91cf\uff1f", (String)"ApplyBillFormPlugin_3", (String)"qitu-dm-ds", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("feiqiction".equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                IDataModel model = this.getModel();
                EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryEntity.getSelectRows();
                if (null != this.getPageCache().get("resQty")) {
                    model.beginInit();
                    model.setValue("qitu_qtyfield", (Object)new BigDecimal(this.getPageCache().get("resQty")), selectRows[0]);
                    model.setValue("qitu_qtyfield1", (Object)new BigDecimal(this.getPageCache().get("resQty")), selectRows[0]);
                    model.endInit();
                    IFormView view = this.getView();
                    view.updateView("qitu_qtyfield", selectRows[0]);
                    view.updateView("qitu_qtyfield1", selectRows[0]);
                }
            } else if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
                IDataModel model = this.getModel();
                EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryEntity.getSelectRows();
                model.beginInit();
                model.setValue("qitu_qtyfield", null, selectRows[0]);
                model.setValue("qitu_qtyfield1", null, selectRows[0]);
                model.endInit();
                IFormView view = this.getView();
                view.updateView("qitu_qtyfield", selectRows[0]);
                view.updateView("qitu_qtyfield1", selectRows[0]);
            }
        }
    }
}

