/*
 * Decompiled with CFR 0.152.
 */
package qitu.dm.ds.plugin.form;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class GenMetaConstantDynamicFormPlugin
extends AbstractFormPlugin {
    protected final String CREATEJAVA = "createjava";
    protected final String ENTITYOBJECT = "entityobject";
    protected final String LINEFEED = "\r\n";
    protected final String PACKAGENAME = "packagename";
    private static final String CODE = "code";
    protected Map<String, String> codeLineMap = new HashMap<String, String>();
    protected SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"createjava"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("createjava".equals(key)) {
            this.afterDoCreateJava();
        }
    }

    protected void afterDoCreateJava() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject entityObject = dataEntity.getDynamicObject("entityobject");
        if (entityObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010\u4e3b\u5b9e\u4f53\u5bf9\u8c61\u3011", (String)"GenMetaConstantDynamicFormPlugin_0", (String)"qitu-dm-ds", (Object[])new Object[0]));
            return;
        }
        String entityNumber = entityObject.getString("number");
        String entityName = entityObject.getString("name");
        String javaName = entityNumber + "Constant";
        javaName = this.rename(javaName);
        StringBuilder content = new StringBuilder();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection mainEntityProperties = mainEntityType.getProperties();
        this.createPrefixCode(content, javaName, entityName);
        String annotation = "    /**" + entityName + "**/" + "\r\n";
        String code = "    public static final String ENTITYKEY = \"" + entityNumber + "\";" + "\r\n";
        content.append(annotation).append(code);
        for (IDataEntityProperty property : mainEntityProperties) {
            this.createProperteyCode(content, property);
            if (!(property instanceof EntryProp)) continue;
            this.handleEntryProp((EntryProp)property, content);
        }
        this.createSuffixCode(content);
        this.outPutJava(content);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"GenMetaConstantDynamicFormPlugin_1", (String)"qitu-dm-ds", (Object[])new Object[0]));
    }

    private void handleEntryProp(EntryProp entryProp, StringBuilder content) {
        DynamicObjectType entryPropType = entryProp.getDynamicCollectionItemPropertyType();
        for (IDataEntityProperty entryPropProperty : entryPropType.getProperties()) {
            this.createProperteyCode(content, entryPropProperty);
            if (!(entryPropProperty instanceof SubEntryProp)) continue;
            this.handleSubEntryProp((SubEntryProp)entryPropProperty, content);
        }
    }

    private void handleSubEntryProp(SubEntryProp subEntryProp, StringBuilder content) {
        DynamicObjectType subEntryPropType = subEntryProp.getDynamicCollectionItemPropertyType();
        for (IDataEntityProperty subEntryPropProperty : subEntryPropType.getProperties()) {
            this.createProperteyCode(content, subEntryPropProperty);
        }
    }

    protected String rename(String javaName) {
        String splitStr = "_";
        StringBuilder result = new StringBuilder();
        if (javaName.contains(splitStr)) {
            String[] splitArray;
            for (String s : splitArray = javaName.split(splitStr)) {
                result.append(this.toUpperFirstChar(s));
            }
        } else {
            result = new StringBuilder(this.toUpperFirstChar(javaName));
        }
        return result.toString();
    }

    protected String toUpperFirstChar(String string) {
        char[] chars = string.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
            return String.valueOf(chars);
        }
        return string;
    }

    protected void createSuffixCode(StringBuilder content) {
        content.append("}\r\n");
    }

    protected void createPrefixCode(StringBuilder content, String javaName, String entityName) {
        String packageName = "kd.constant";
        Object packageNameValue = this.getModel().getValue("packagename");
        if (packageNameValue != null && !packageNameValue.toString().isEmpty()) {
            packageName = packageNameValue.toString();
        }
        String rdNumber = RequestContext.get().getUserName();
        String dateStr = this.formatter.format(new Date());
        String prefixCode = "package " + packageName + ";" + "\r\n" + "\r\n" + "/**" + "\r\n" + " * " + entityName + ResManager.loadKDString((String)"\u5e38\u91cf\u7c7b", (String)"GenMetaConstantDynamicFormPlugin_2", (String)"qitu-dm-ds", (Object[])new Object[0]) + "\r\n" + " *" + "\r\n" + " * @author " + rdNumber + "\r\n" + " * @version 1.0" + "\r\n" + " * @date " + dateStr + "\r\n" + " */" + "\r\n" + "public class " + javaName + " {" + "\r\n";
        content.append(prefixCode);
    }

    protected void createProperteyCode(StringBuilder content, IDataEntityProperty iDataEntityProperty) {
        String propertyName = iDataEntityProperty.getName();
        if (this.codeLineMap.get(propertyName) == null) {
            LocaleString displayNameObj = iDataEntityProperty.getDisplayName();
            if (displayNameObj == null && !"id".equals(propertyName)) {
                return;
            }
            String disPlayName = ResManager.loadKDString((String)"\u7f3a\u7701id\u5b57\u6bb5", (String)"GenMetaConstantDynamicFormPlugin_3", (String)"qitu-dm-ds", (Object[])new Object[0]);
            if (displayNameObj != null) {
                disPlayName = displayNameObj.getLocaleValue_zh_CN();
            }
            this.codeLineMap.put(propertyName, disPlayName);
            String uppercasePropertyName = propertyName.toUpperCase();
            String annotation = "    /**" + disPlayName + "**/" + "\r\n";
            String code = "    public static final String " + uppercasePropertyName + " = \"" + propertyName + "\";" + "\r\n";
            content.append(annotation).append(code);
        }
    }

    protected void outPutJava(StringBuilder content) {
        CodeEdit codeshow = (CodeEdit)this.getView().getControl(CODE);
        codeshow.setText(content.toString());
    }
}

