/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.recuritment.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.beisen.entity.PhaseStatusInfo;
import com.kingdee.eas.custom.beisen.utils.BeisenApiClient;
import com.kingdee.eas.custom.beisen.utils.BeisenParamByProperties;
import com.kingdee.eas.custom.recuritment.task.AbstractBeisenTransferPhaseFacadeControllerBean;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.recuritment.IOffer;
import com.kingdee.shr.recuritment.IRecApproval;
import com.kingdee.shr.recuritment.OfferCollection;
import com.kingdee.shr.recuritment.OfferFactory;
import com.kingdee.shr.recuritment.OfferInfo;
import com.kingdee.shr.recuritment.RecApprovalCollection;
import com.kingdee.shr.recuritment.RecApprovalFactory;
import com.kingdee.shr.recuritment.RecApprovalInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeStateInfo;
import com.kingdee.shr.recuritment.app.OfferConfirmStateEnum;
import com.kingdee.util.DateTimeUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BeisenTransferPhaseFacadeControllerBean
extends AbstractBeisenTransferPhaseFacadeControllerBean {
    private static Logger logger = Logger.getLogger(BeisenTransferPhaseFacadeControllerBean.class);
    private Map<String, PhaseStatusInfo> phaseStatus = Maps.newHashMap();
    private static Set hireApprovalBillStatusSet = new HashSet();
    private static Set hireApprovalResumeStateSet = new HashSet();
    private static Set hireTerminationResumeStateSet = new HashSet();
    private static Set hireOfferStateSet = new HashSet();
    private static Map<String, String> beisenTransferPhaseErrorMap = new HashMap<String, String>();
    private final String RECAPPROVAL1 = "recApproval1";
    private final String RECAPPROVAL2 = "recApproval2";
    private final String OFFER1 = "offer1";
    private final String OFFER2 = "offer2";
    private final String OFFER3 = "offer3";
    private final String OFFER4 = "offer4";
    private final String OFFER5 = "offer5";
    private final String ENROLL1 = "enroll1";
    private final String ENROLL2 = "enroll2";
    private final String ENROLL3 = "enroll3";

    static {
        hireApprovalBillStatusSet.add(HRBillStateEnum.SAVED);
        hireApprovalBillStatusSet.add(HRBillStateEnum.SUBMITED);
        hireApprovalBillStatusSet.add(HRBillStateEnum.AUDITING);
        hireApprovalResumeStateSet.add("0009");
        hireApprovalResumeStateSet.add("0010");
        hireTerminationResumeStateSet.add("0012");
        hireTerminationResumeStateSet.add("0011");
        hireOfferStateSet.add("0013");
        hireOfferStateSet.add("0015");
        beisenTransferPhaseErrorMap.put("applyDeleteApplyIds", "\u56e0\u5728\u5f53\u524d\u804c\u4f4d\u4e0b\u88ab\u5220\u9664\u800c\u8f6c\u79fb\u5931\u8d25");
        beisenTransferPhaseErrorMap.put("applicantDeleteApplyIds", "\u56e0\u5e94\u8058\u8005\u88ab\u5220\u9664\u800c\u8f6c\u79fb\u5931\u8d25");
        beisenTransferPhaseErrorMap.put("applicantBlackApplyIds", "\u56e0\u5e94\u8058\u8005\u88ab\u62c9\u9ed1\u800c\u8f6c\u79fb\u5931\u8d25");
        beisenTransferPhaseErrorMap.put("applicantLockedApplyIds", "\u56e0\u5e94\u8058\u8005\u88ab\u9501\u5b9a\u800c\u8f6c\u79fb\u5931\u8d25");
        beisenTransferPhaseErrorMap.put("applyStatusChangedApplyIds", "\u56e0\u5e94\u8058\u8005\u9636\u6bb5\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u5316\u800c\u8f6c\u79fb\u5931\u8d25");
        beisenTransferPhaseErrorMap.put("applyOtherReasonRejectedApplyIds", "\u56e0\u5b9a\u5236\u529f\u80fd\u6821\u9a8c\u5931\u8d25\u800c\u8f6c\u79fb\u5931\u8d25");
        beisenTransferPhaseErrorMap.put("applyByHunterOrRPOUnAcceptedIds", "\u56e0\u5e94\u8058\u8005\u5b58\u5728\u730e\u5934/RPO\u7b80\u5386\u4e14\u672a\u88ab\u63a5\u53d7\u800c\u8f6c\u79fb\u5931\u8d25");
        beisenTransferPhaseErrorMap.put("applyTransferRuleFailedApplyIds", "\u56e0\u5e94\u8058\u8005\u5b58\u5728\u4e0d\u7b26\u5408\u51c6\u5165\u89c4\u5219\u800c\u8f6c\u79fb\u5931\u8d25");
    }

    public BeisenTransferPhaseFacadeControllerBean() throws IOException, BOSException {
        BeisenParamByProperties properties = null;
        try {
            properties = new BeisenParamByProperties();
        }
        catch (IOException e) {
            logger.error((Object)("\u5317\u68ee\u72b6\u6001\u8f6c\u79fbFacade\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u62a5\u9519: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        Map<String, String> config = properties.getConfig();
        String phase1 = config.get("phase1");
        String status1A = config.get("status1A");
        String status1B = config.get("status1B");
        String phase2 = config.get("phase2");
        String status2A = config.get("status2A");
        String status2B = config.get("status2B");
        String status2C = config.get("status2C");
        String status2D = config.get("status2D");
        String status2E = config.get("status2E");
        String phase3 = config.get("phase3");
        String status3A = config.get("status3A");
        String status3B = config.get("status3B");
        String status3C = config.get("status3C");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{phase1, phase2, phase3, status1A, status1B, status2A, status2B, status2C, status2D, status2E, phase3, status3A, status3B, status3C})) {
            throw new BOSException("\u5317\u68ee\u9636\u6bb5\u72b6\u6001\u4e3a\u7a7a!");
        }
        this.phaseStatus.put("recApproval1", new PhaseStatusInfo(phase1, status1A));
        this.phaseStatus.put("recApproval2", new PhaseStatusInfo(phase1, status1B));
        this.phaseStatus.put("offer1", new PhaseStatusInfo(phase2, status2A));
        this.phaseStatus.put("offer2", new PhaseStatusInfo(phase2, status2B));
        this.phaseStatus.put("offer3", new PhaseStatusInfo(phase2, status2C));
        this.phaseStatus.put("offer4", new PhaseStatusInfo(phase2, status2D));
        this.phaseStatus.put("offer5", new PhaseStatusInfo(phase2, status2E));
        this.phaseStatus.put("enroll1", new PhaseStatusInfo(phase3, status3A));
        this.phaseStatus.put("enroll2", new PhaseStatusInfo(phase3, status3B));
        this.phaseStatus.put("enroll3", new PhaseStatusInfo(phase3, status3C));
    }

    @Override
    protected void _syncRecApprovalToBeisen(Context ctx, String billIds, int preponeHours) throws BOSException, EASBizException {
        try {
            super._syncRecApprovalToBeisen(ctx, billIds, preponeHours);
            IRecApproval iRecApproval = RecApprovalFactory.getLocalInstance((Context)ctx);
            RecApprovalCollection recApprovalCollection = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("resumeBaseRec.*");
            sic.add("resumeBaseRec.resumeState.*");
            if (StringUtils.isNotBlank((CharSequence)billIds)) {
                if (billIds.contains("'")) {
                    billIds = billIds.replace("'", "");
                }
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("id", (Object)billIds, CompareType.INCLUDE));
                EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
                recApprovalCollection = iRecApproval.getRecApprovalCollection(viewInfo);
                if (recApprovalCollection.isEmpty()) {
                    logger.error((Object)("\u672a\u5339\u914d\u5230\u5f55\u7528\u62a5\u6279\u5355\u636e\uff0c\u5355\u636eid\uff1a " + billIds));
                    throw new BOSException("\u672a\u5339\u914d\u5230\u5f55\u7528\u62a5\u6279\u5355\u636e");
                }
            } else {
                if (preponeHours <= 0) {
                    preponeHours = 2;
                }
                Date now = new Date();
                Date before = DateTimeUtils.addMinute((Date)now, (long)(-preponeHours));
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("lastUpdateTime", (Object)before, CompareType.GREATER_EQUALS));
                filterItems.add(new FilterItemInfo("lastUpdateTime", (Object)now, CompareType.LESS_EQUALS));
                EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
                recApprovalCollection = iRecApproval.getRecApprovalCollection(viewInfo);
            }
            if (recApprovalCollection == null || recApprovalCollection.isEmpty()) {
                logger.error((Object)"\u5f55\u7528\u62a5\u6279\u4e3a\u7a7a!");
                return;
            }
            HashMap<String, String> applyIdRecApprovalMap = new HashMap<String, String>();
            HashMap<String, JSONArray> recApprovalMap = new HashMap<String, JSONArray>();
            IOffer iOffer = OfferFactory.getLocalInstance((Context)ctx);
            int i = 0;
            while (i < recApprovalCollection.size()) {
                RecApprovalInfo recApprovalInfo = recApprovalCollection.get(i);
                String fid = recApprovalInfo.getId().toString();
                ResumeBaseRecInfo resumeBaseRec = recApprovalInfo.getResumeBaseRec();
                String applyId = resumeBaseRec.getString("applyId");
                if (StringUtils.isEmpty((CharSequence)applyId)) {
                    String errorMsg = "\u5317\u68ee\u7533\u8bf7id\u4e3a\u7a7a!";
                    logger.error((Object)errorMsg);
                    HashSet<String> set = new HashSet<String>();
                    set.add(fid);
                    this.updateTable(ctx, "T_REC_RecApproval", errorMsg, "2", set);
                } else {
                    applyIdRecApprovalMap.put(applyId, fid);
                    ResumeStateInfo resumeState = resumeBaseRec.getResumeState();
                    String resumeStateNumber = resumeState.getNumber();
                    String beisenStatus = null;
                    HRBillStateEnum billState = recApprovalInfo.getBillState();
                    if (hireApprovalResumeStateSet.contains(resumeStateNumber)) {
                        beisenStatus = "recApproval1";
                    } else if (hireTerminationResumeStateSet.contains(resumeStateNumber)) {
                        beisenStatus = "recApproval2";
                    } else if (HRBillStateEnum.AUDITED.equals((Object)billState) && "0013".equals(resumeStateNumber)) {
                        try {
                            OfferCollection offerCollection = iOffer.getOfferCollection("where resumeBaseRec ='" + resumeBaseRec.getId() + "'");
                            String sendState = null;
                            if (!offerCollection.isEmpty()) {
                                OfferInfo offerInfo = offerCollection.get(0);
                                sendState = offerInfo.getSendState();
                            }
                            if (StringUtils.isBlank(sendState) || "\u5f85\u53d1\u9001".equals(sendState)) {
                                beisenStatus = "offer1";
                            }
                        }
                        catch (BOSException e) {
                            throw new BOSException("\u83b7\u53d6offer\u72b6\u6001\u62a5\u9519: " + e.getMessage());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)beisenStatus)) {
                        if (recApprovalMap.containsKey(beisenStatus)) {
                            ((JSONArray)recApprovalMap.get(beisenStatus)).add((Object)applyId);
                        } else {
                            JSONArray applyIds = new JSONArray();
                            applyIds.add((Object)applyId);
                            recApprovalMap.put(beisenStatus, applyIds);
                        }
                    }
                }
                ++i;
            }
            this.handleBeisenTransferPhaseQuery(ctx, recApprovalMap, applyIdRecApprovalMap, "T_REC_RecApproval");
        }
        catch (Exception e) {
            logger.error((Object)("\u5f55\u7528\u62a5\u6279\u540c\u6b65\u5317\u68ee\u72b6\u6001\u8f6c\u79fb\u62a5\u9519: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected void _syncOfferToBeisen(Context ctx, String billIds, int preponeHours) throws BOSException, EASBizException {
        try {
            super._syncOfferToBeisen(ctx, billIds, preponeHours);
            IOffer iOffer = OfferFactory.getLocalInstance((Context)ctx);
            OfferCollection offerCollection = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("resumeBaseRec.*");
            sic.add("resumeBaseRec.resumeState.*");
            sic.add("person.employeeType.isInCount");
            if (StringUtils.isNotBlank((CharSequence)billIds)) {
                if (billIds.contains("'")) {
                    billIds = billIds.replace("'", "");
                }
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("id", (Object)billIds));
                EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
                offerCollection = iOffer.getOfferCollection(viewInfo);
                if (offerCollection.isEmpty()) {
                    logger.error((Object)("\u672a\u5339\u914d\u5230offer\u5355\u636e\uff0c\u5355\u636eid\uff1a " + billIds));
                    throw new BOSException("\u672a\u5339\u914d\u5230offer\u5355\u636e");
                }
            } else {
                if (preponeHours <= 0) {
                    preponeHours = 2;
                }
                Date now = new Date();
                Date before = DateTimeUtils.addMinute((Date)now, (long)(-preponeHours));
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("lastUpdateTime", (Object)before, CompareType.GREATER_EQUALS));
                filterItems.add(new FilterItemInfo("lastUpdateTime", (Object)now, CompareType.LESS_EQUALS));
                EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
                offerCollection = iOffer.getOfferCollection(viewInfo);
            }
            if (offerCollection == null || offerCollection.isEmpty()) {
                logger.error((Object)"offer\u4e3a\u7a7a!");
                return;
            }
            HashMap<String, String> applyIdOfferMap = new HashMap<String, String>();
            HashMap<String, JSONArray> offerMap = new HashMap<String, JSONArray>();
            HashMap recApprovalMap = new HashMap();
            int i = 0;
            while (i < offerCollection.size()) {
                OfferInfo offerInfo = offerCollection.get(i);
                String fid = offerInfo.getId().toString();
                ResumeBaseRecInfo resumeBaseRec = offerInfo.getResumeBaseRec();
                String applyId = resumeBaseRec.getString("applyId");
                if (StringUtils.isEmpty((CharSequence)applyId)) {
                    String errorMsg = "\u5317\u68ee\u7533\u8bf7id\u4e3a\u7a7a!";
                    logger.error((Object)errorMsg);
                    HashSet<String> set = new HashSet<String>();
                    set.add(fid);
                    this.updateTable(ctx, "T_REC_Offer", errorMsg, "2", set);
                } else {
                    applyIdOfferMap.put(applyId, fid);
                    ResumeStateInfo resumeState = resumeBaseRec.getResumeState();
                    String resumeStateNumber = resumeState.getNumber();
                    String sendState = offerInfo.getSendState();
                    OfferConfirmStateEnum confirmState = offerInfo.getConfirmState();
                    String beisenStatus = null;
                    if ("0013".equals(resumeStateNumber) && (StringUtils.isBlank((CharSequence)sendState) || "\u5f85\u53d1\u9001".equals(sendState))) {
                        beisenStatus = "offer1";
                    } else if ("0013".equals(resumeStateNumber) && "\u5df2\u53d1\u9001".equals(sendState) && OfferConfirmStateEnum.TOBECONFIRM.equals((Object)confirmState)) {
                        beisenStatus = "offer2";
                    } else if ("0013".equals(resumeStateNumber) && "\u5df2\u53d1\u9001".equals(sendState) && OfferConfirmStateEnum.ACCEPTED.equals((Object)confirmState)) {
                        beisenStatus = "offer4";
                    } else if ("0013".equals(resumeStateNumber) && "\u5df2\u53d1\u9001".equals(sendState) && OfferConfirmStateEnum.REJECTED.equals((Object)confirmState)) {
                        beisenStatus = "offer3";
                    } else if ("0015".equals(resumeStateNumber)) {
                        beisenStatus = "offer5";
                    } else if ("0017".equals(resumeStateNumber)) {
                        EmployeeTypeInfo employeeType;
                        PersonInfo person = offerInfo.getPerson();
                        if (person != null && (employeeType = person.getEmployeeType()) != null && !employeeType.isIsInCount()) {
                            return;
                        }
                        beisenStatus = "enroll1";
                    } else if ("0016".equals(resumeStateNumber) || "0014".equals(resumeStateNumber)) {
                        beisenStatus = "enroll2";
                    }
                    if (StringUtils.isNotBlank((CharSequence)beisenStatus)) {
                        if (recApprovalMap.containsKey(beisenStatus)) {
                            ((JSONArray)offerMap.get(beisenStatus)).add((Object)applyId);
                        } else {
                            JSONArray applyIds = new JSONArray();
                            applyIds.add((Object)applyId);
                            offerMap.put(beisenStatus, applyIds);
                        }
                    }
                }
                ++i;
            }
            this.handleBeisenTransferPhaseQuery(ctx, offerMap, applyIdOfferMap, "T_REC_Offer");
        }
        catch (Exception e) {
            logger.error((Object)("offer\u540c\u6b65\u5317\u68ee\u72b6\u6001\u8f6c\u79fb\u62a5\u9519: " + e.getMessage()), (Throwable)e);
        }
    }

    private void handleBeisenTransferPhaseQuery(Context ctx, Map<String, JSONArray> recApprovalMap, Map<String, String> applyIdStatusMap, String tableName) throws BOSException, IOException, EASBizException {
        BeisenApiClient beisenApiClient = BeisenApiClient.getInstance();
        IOffer iOffer = OfferFactory.getLocalInstance((Context)ctx);
        for (String statusName : recApprovalMap.keySet()) {
            try {
                JSONArray applyIds = recApprovalMap.get(statusName);
                PhaseStatusInfo phaseStatusInfo = this.phaseStatus.get(statusName);
                JSONObject params = new JSONObject();
                params.put("applyIds", (Object)applyIds);
                params.put("phaseId", (Object)phaseStatusInfo.getPhaseId());
                params.put("statusId", (Object)phaseStatusInfo.getStatusId());
                logger.error((Object)("\u540c\u6b65\u5317\u68ee\u72b6\u6001statusName: " + statusName));
                logger.error((Object)"\u540c\u6b65\u5317\u68ee\u72b6\u6001url: https://openapi.italent.cn/RecruitV6/api/v1/Apply/TransferPhase");
                logger.error((Object)("\u540c\u6b65\u5317\u68ee\u72b6\u6001\u53c2\u6570: " + params.toJSONString()));
                JSONObject response = beisenApiClient.callApi("https://openapi.italent.cn/RecruitV6/api/v1/Apply/TransferPhase", params);
                logger.error((Object)("\u540c\u6b65\u5317\u68ee\u72b6\u6001\u54cd\u5e94: " + response.toJSONString()));
                int code = response.getIntValue("code");
                String message = response.getString("message");
                if (200 == code) {
                    JSONObject data = response.getJSONObject("data");
                    Integer noTransferCount = data.getInteger("noTransferCount");
                    if (noTransferCount > 0) {
                        for (String key : beisenTransferPhaseErrorMap.keySet()) {
                            JSONArray failApplyIds = data.getJSONArray(key);
                            if (failApplyIds.isEmpty()) continue;
                            String errorMsg = beisenTransferPhaseErrorMap.get(key);
                            HashSet fids = new HashSet();
                            failApplyIds.forEach(applyid -> {
                                fids.add(applyIdStatusMap.get(applyid));
                                applyIds.remove(applyid);
                            });
                            this.updateTable(ctx, tableName, errorMsg, "2", fids);
                        }
                    }
                    if (!applyIds.isEmpty()) {
                        HashSet<String> fids = new HashSet<String>();
                        int i = 0;
                        while (i < applyIds.size()) {
                            String applyId = applyIds.get(i).toString();
                            fids.add(applyIdStatusMap.get(applyId));
                            ++i;
                        }
                        this.updateTable(ctx, tableName, "\u6210\u529f", "1", fids);
                    }
                } else {
                    HashSet fids = new HashSet();
                    applyIdStatusMap.values().forEach(id -> fids.add(id));
                    this.updateTable(ctx, tableName, message, "2", fids);
                }
                if (!"enroll1".equals(statusName) || applyIds.isEmpty()) continue;
                JSONObject entryhandleParams = new JSONObject();
                int i = 0;
                while (i < applyIds.size()) {
                    String applyId = applyIds.get(i).toString();
                    entryhandleParams.put("applyId", (Object)applyIds);
                    String offerId = applyIdStatusMap.get(applyId);
                    OfferInfo offerInfo = iOffer.getOfferInfo((IObjectPK)new ObjectUuidPK(offerId));
                    Date entryDate = offerInfo.getEntryDate();
                    if (entryDate != null) {
                        String entryDateStr = DateTimeUtils.format((Date)entryDate, (String)"yyyy-MM-dd'T'HH:mm:ss");
                        entryhandleParams.put("entryDate", (Object)entryDateStr);
                    }
                    logger.error((Object)"\u5317\u68ee\u62db\u8058\u5230\u5c97urlhttps://openapi.italent.cn/RecruitV6/api/v1/Requirement/EntryHandle");
                    logger.error((Object)("\u5317\u68ee\u62db\u8058\u5230\u5c97\u53c2\u6570" + params.toJSONString()));
                    JSONObject result = beisenApiClient.callApi("https://openapi.italent.cn/RecruitV6/api/v1/Requirement/EntryHandle", entryhandleParams);
                    logger.error((Object)("\u5317\u68ee\u62db\u8058\u5230\u5c97\u54cd\u5e94" + result.toJSONString()));
                    if (result.getInteger("code") != 200) {
                        logger.error((Object)("\u5317\u68ee\u62db\u8058\u5230\u5c97\u54cd\u5e94\u62a5\u9519: " + result.getString("message")));
                        this.updateTable(ctx, tableName, result.getString("message"), "2", AtsUtil.toSet((String)offerId));
                    } else {
                        this.updateTable(ctx, tableName, "\u6210\u529f", "1", AtsUtil.toSet((String)offerId));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u540c\u6b65\u5317\u68ee\u72b6\u6001\u8f6c\u79fb\u62a5\u9519: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
    }

    private void updateTable(Context ctx, String tableName, String message, String status, Set fids) throws BOSException {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tableName).append(" set CFsyncBeisenResult ='");
        updateSql.append(message).append("' ,CFsyncStatus = '").append(status).append("'");
        updateSql.append(" where fid in (").append(AtsUtil.convertSetToString((Set)fids)).append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }
}

