/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.recuritment.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.beisen.utils.BeisenApiClient;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.recuritment.DemandCompTypeCollection;
import com.kingdee.shr.recuritment.DemandCompTypeInfo;
import com.kingdee.shr.recuritment.FlowStateEnum;
import com.kingdee.shr.recuritment.IRecType4BaseItem;
import com.kingdee.shr.recuritment.IRecuritmentDemand;
import com.kingdee.shr.recuritment.JobNatureEnum;
import com.kingdee.shr.recuritment.RecPersonType;
import com.kingdee.shr.recuritment.RecType4BaseItemFactory;
import com.kingdee.shr.recuritment.RecType4BaseItemInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.SalaryEnum;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecruitmentDemandService {
    private static final Logger logger = Logger.getLogger(RecruitmentDemandService.class);
    private static boolean isProductionEnv = true;
    private static final int REQUIREMENT_STATUS_IN_PROGRESS = 40;
    private static final int SHARE_TYPE_SUBORDINATE = 2;
    private static final int REQUIREMENT_TYPE_NEW = 1;
    private static final int REQUIREMENT_TYPE_SUPPLY = 4;
    private static final Map<String, Integer> REQUIREMENT_TYPE_MAP = RecruitmentDemandService.createRequirementTypeMap();
    private static final Map<String, Integer> CATEGORY_MAP = RecruitmentDemandService.createCategoryMap();
    private static final Map<String, Integer> KIND_MAP = RecruitmentDemandService.createKindMap();
    private static final Map<String, String> HEADCOUNT_TYPE_MAP = RecruitmentDemandService.createHeadcountTypeMap();
    private static final Map<String, String> YES_NO_MAP = RecruitmentDemandService.createYesNoMap();
    private static final Map<String, String> TRAIN_PERIOD_MAP = RecruitmentDemandService.createTrainPeriodMap();
    private static final Map<String, String> FORMAL_CUSTOM_FIELDS = RecruitmentDemandService.createFormalCustomFields();
    private static final Map<String, String> TEST_CUSTOM_FIELDS = RecruitmentDemandService.createTestCustomFields();
    private static final Map<String, Integer> RECRUITMENTTYPE_MAP = RecruitmentDemandService.createRecruitmentType();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final Map<String, Integer> jobNumberToUserIdCache = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> STATUS_MAPPING = new HashMap<String, Integer>();

    static {
        STATUS_MAPPING.put(RecruitmentDemandService.key(3, 0), 40);
        STATUS_MAPPING.put(RecruitmentDemandService.key(3, 1), 60);
        STATUS_MAPPING.put(RecruitmentDemandService.key(3, 2), 50);
        STATUS_MAPPING.put(RecruitmentDemandService.key(0, 3), 10);
        STATUS_MAPPING.put(RecruitmentDemandService.key(1, 0), 20);
        STATUS_MAPPING.put(RecruitmentDemandService.key(2, 0), 20);
    }

    private static String key(int state1, int state2) {
        return String.valueOf(state1) + "|" + state2;
    }

    public static Integer mapShrToStatus(int billState, int flowState) {
        return STATUS_MAPPING.get(RecruitmentDemandService.key(billState, flowState));
    }

    public RecruitmentDemandService(boolean isProductionEnv) {
        RecruitmentDemandService.isProductionEnv = isProductionEnv;
    }

    private static Map<String, Integer> createRequirementTypeMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("002", 4);
        map.put("001", 1);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, Integer> createCategoryMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("001", 1);
        map.put("002", 2);
        map.put("006", 3);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, Integer> createKindMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("0", 4);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> createHeadcountTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", "0");
        map.put("1", "1");
        map.put("2", "2");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> createYesNoMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u662f", "\u662f");
        map.put("\u5426", "\u5426");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> createTrainPeriodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("three", "3\u6708");
        map.put("six", "6\u6708");
        map.put("twelve", "12\u6708");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, Integer> createRecruitmentType() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("001", 1);
        map.put("002", 2);
        map.put("006", 3);
        map.put("003", 4);
        map.put("004", 5);
        map.put("005", 6);
        map.put("007", 7);
        map.put("008", 8);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> createFormalCustomFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u62db\u8058\u804c\u4f4d", "extzhaopinzhiwei_614492_675953134");
        map.put("\u62db\u8058\u4e1a\u52a1\u7ec4\u7ec7", "extzhaopinyewuzuzhi_614492_625299195");
        map.put("\u62db\u8058\u7533\u8bf7\u7c7b\u578b", "extzhaopinshenqingleixing_614492_1996095690");
        map.put("\u7ec4\u7ec7\u5c42\u7ea7", "extzhaopinbumencengji_614492_28373535");
        map.put("\u662f\u5426\u8425\u9500\u7c7b", "extshifouyingxiaolei_614492_686667835");
        map.put("\u5de5\u8d44\u5f85\u9047", "extgongzidaiyu_614492_1581268897");
        map.put("\u798f\u5229\u5f85\u9047", "extfulidaiyu_614492_1723263995");
        map.put("\u5907\u6ce8", "extbeizhu_614492_449117520");
        map.put("\u57f9\u517b\u5468\u671f", "extpeiyangzhouqi_614492_13124793");
        map.put("\u662f\u5426\u9700\u8f6e\u5c97", "extshifouxulungang_614492_1020570825");
        map.put("\u8f6e\u5c97\u5c97\u4f4d", "extlunganggangwei_614492_1371281235");
        map.put("\u5b9a\u5c97\u5c97\u4f4d", "extdingganggangwei_614492_1002839243");
        map.put("\u8f6c\u6b63\u8003\u6838\u6807\u51c6", "extzhuanzhengkaohebiaozhun_614492_1527148155");
        map.put("\u529e\u516c\u5730\u70b9", "extbangongdidian_614492_920550595");
        map.put("\u62db\u8058\u7c7b\u578b", "extzhaopinqudao_614492_409009478");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> createTestCustomFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u62db\u8058\u804c\u4f4d", "extzhaopinzhiwei_433899_675953134");
        map.put("\u62db\u8058\u4e1a\u52a1\u7ec4\u7ec7", "extzhaopinyewuzuzhi_433899_625299195");
        map.put("\u62db\u8058\u7533\u8bf7\u7c7b\u578b", "extzhaopinshenqingleixing_433899_1996095690");
        map.put("\u7ec4\u7ec7\u5c42\u7ea7", "extzhaopinbumencengji_433899_28373535");
        map.put("\u662f\u5426\u8425\u9500\u7c7b", "extshifouyingxiaolei_433899_686667835");
        map.put("\u5de5\u8d44\u5f85\u9047", "extgongzidaiyu_433899_1581268897");
        map.put("\u798f\u5229\u5f85\u9047", "extfulidaiyu_433899_1723263995");
        map.put("\u5907\u6ce8", "extbeizhu_433899_449117520");
        map.put("\u57f9\u517b\u5468\u671f", "extpeiyangzhouqi_433899_13124793");
        map.put("\u662f\u5426\u9700\u8f6e\u5c97", "extshifouxulungang_433899_1020570825");
        map.put("\u8f6e\u5c97\u5c97\u4f4d", "extlunganggangwei_433899_1371281235");
        map.put("\u5b9a\u5c97\u5c97\u4f4d", "extdingganggangwei_433899_1002839243");
        map.put("\u8f6c\u6b63\u8003\u6838\u6807\u51c6", "extzhuanzhengkaohebiaozhun_433899_1527148155");
        map.put("\u529e\u516c\u5730\u70b9", "extbangongdidian_433899_920550595");
        map.put("\u62db\u8058\u7c7b\u578b", "extzhaopinqudao_433899_409009478");
        return Collections.unmodifiableMap(map);
    }

    private JSONObject buildRequirementData(Context ctx, RecuritmentDemandInfo demandInfo) throws BOSException, EASBizException {
        IPerson pIns;
        Integer beisenUserId;
        Date arrivalDate;
        Timestamp applyDate;
        JSONObject params = new JSONObject();
        RecPersonType recPersonType = demandInfo.getRecPersonType();
        if (recPersonType != null && StringUtils.isNotBlank((CharSequence)recPersonType.getValue())) {
            Integer mappedType = REQUIREMENT_TYPE_MAP.get(recPersonType.getValue());
            params.put("requirementType", (Object)(mappedType != null ? mappedType : 1));
        }
        params.put("name", (Object)demandInfo.getPositionName());
        params.put("requirementCount", (Object)demandInfo.getRecuritNumber());
        params.put("jobDescription", (Object)demandInfo.getResponsibilities());
        params.put("qualification", (Object)demandInfo.getQualification());
        AdminOrgUnitInfo department = demandInfo.getDepartment();
        if (department != null) {
            IAdminOrgUnit orgIns = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            department = orgIns.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(department.getId().toString()));
            params.put("orgCode", (Object)department.getNumber());
            params.put("orgName", (Object)department.getName());
        }
        if ((applyDate = demandInfo.getApplyDate()) != null) {
            params.put("createDate", (Object)DATE_FORMAT.format(applyDate));
        }
        if ((arrivalDate = demandInfo.getArrivalDate()) != null) {
            params.put("arivalTime", (Object)DATE_FORMAT.format(arrivalDate));
        }
        this.mapValueIfPresent(CATEGORY_MAP, demandInfo.getRecuritmentType(), "category", params);
        this.mapEnumValue(KIND_MAP, demandInfo.getJobNature(), "kind", params);
        PersonInfo proposer = demandInfo.getProposer();
        if (proposer != null && (beisenUserId = this.convertToBeisenUserId((proposer = (pIns = PersonFactory.getLocalInstance((Context)ctx)).getPersonInfo((IObjectPK)new ObjectUuidPK(proposer.getId().toString()))).getNumber())) != null) {
            params.put("createBy", (Object)beisenUserId);
            params.put("dutyUser", (Object)beisenUserId);
        }
        HRBillStateEnum billState = demandInfo.getBillState();
        FlowStateEnum flowState = demandInfo.getFlowState();
        Integer rStatus = RecruitmentDemandService.mapShrToStatus(billState.getValue(), flowState.getValue());
        params.put("requirementStatus", (Object)rStatus);
        this.addCustomFields(ctx, params, demandInfo);
        return params;
    }

    private void addCustomFields(Context ctx, JSONObject params, RecuritmentDemandInfo demandInfo) throws BOSException, EASBizException {
        DemandCompTypeInfo demandCompTypeInfo;
        RecType4BaseItemInfo recType;
        this.addCustomField(params, "\u62db\u8058\u804c\u4f4d", demandInfo.getRecuritPosition().getName());
        this.addCustomField(params, "\u62db\u8058\u4e1a\u52a1\u7ec4\u7ec7", demandInfo.getHrOrgUnit().getName());
        String headcountType = Optional.ofNullable(demandInfo.get("headcountType")).map(Object::toString).orElse("");
        this.addCustomField(params, "\u62db\u8058\u7533\u8bf7\u7c7b\u578b", this.mapHeadcountType(headcountType));
        this.addCustomField(params, "\u7ec4\u7ec7\u5c42\u7ea7", String.valueOf(demandInfo.getDepartment().getLevel()));
        this.addCustomField(params, "\u662f\u5426\u8425\u9500\u7c7b", this.mapYesNo(this.getPropertyValue(demandInfo, "isMarketing")));
        SalaryEnum salary = demandInfo.getSalary();
        if (salary != null) {
            String alias = salary.getAlias();
            this.addCustomField(params, "\u5de5\u8d44\u5f85\u9047", alias);
        }
        this.addCustomField(params, "\u798f\u5229\u5f85\u9047", this.getBenefits(demandInfo));
        this.addCustomField(params, "\u5907\u6ce8", demandInfo.getRecRema());
        String trainPeriod = Optional.ofNullable(this.getPropertyValue(demandInfo, "trainPeriod")).map(Object::toString).map(key -> TRAIN_PERIOD_MAP.getOrDefault(key, "")).orElse("");
        this.addCustomField(params, "\u57f9\u517b\u5468\u671f", trainPeriod);
        this.addCustomField(params, "\u662f\u5426\u9700\u8f6e\u5c97", this.mapYesNo(this.getPropertyValue(demandInfo, "needJobRotation")));
        this.addCustomField(params, "\u8f6e\u5c97\u5c97\u4f4d", this.getPropertyAsString(demandInfo, "rotationPosition"));
        this.addCustomField(params, "\u5b9a\u5c97\u5c97\u4f4d", this.getPropertyAsString(demandInfo, "fixedPosition"));
        this.addCustomField(params, "\u8f6c\u6b63\u8003\u6838\u6807\u51c6", this.getPropertyAsString(demandInfo, "regularizationStandard"));
        this.addCustomField(params, "\u529e\u516c\u5730\u70b9", this.getPropertyAsString(demandInfo, "workPlace"));
        DemandCompTypeCollection demandCompType = demandInfo.getDemandCompType();
        if (demandCompType != null && demandCompType.size() > 0 && (recType = (demandCompTypeInfo = demandCompType.get(0)).getRecType()) != null) {
            IRecType4BaseItem retTypeIns = RecType4BaseItemFactory.getLocalInstance((Context)ctx);
            recType = retTypeIns.getRecType4BaseItemInfo((IObjectPK)new ObjectUuidPK(recType.getId().toString()));
            String number = recType.getNumber();
            Integer val = RECRUITMENTTYPE_MAP.get(number);
            this.addCustomField(params, "\u62db\u8058\u7c7b\u578b", val);
        }
    }

    public String createRequirement(Context ctx, RecuritmentDemandInfo demandInfo, JSONObject requirementData) throws IOException, EASBizException, BOSException {
        JSONObject response = new JSONObject();
        try {
            response = BeisenApiClient.getInstance().callApi("https://openapi.italent.cn/RecruitV6/api/v1/Requirement/CreateRequirement", requirementData);
            this.handleApiResponse(ctx, response, demandInfo, "");
        }
        catch (Exception e) {
            this.handleApiResponse(ctx, response, demandInfo, "");
            logger.error((Object)"\u521b\u5efa\u62db\u8058\u9700\u6c42\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return response.getString("data");
    }

    public String createRecruitmentDemand(Context ctx, RecuritmentDemandInfo demandInfo) throws Exception {
        JSONObject params = this.buildRequirementData(ctx, demandInfo);
        params.put("shareType", (Object)2);
        return this.createRequirement(ctx, demandInfo, params);
    }

    public void updateRequirement(Context ctx, String requirementId, RecuritmentDemandInfo demandInfo) throws BOSException, EASBizException {
        JSONObject params = this.buildRequirementData(ctx, demandInfo);
        params.put("requirementId", (Object)requirementId);
        JSONObject response = new JSONObject();
        try {
            BeisenApiClient apiClient = BeisenApiClient.getInstance();
            response = apiClient.callPutApi("https://openapi.italent.cn/RecruitV6/api/v1/Requirement/UpdateRequirement", params);
            this.handleApiResponse(ctx, response, demandInfo, requirementId);
        }
        catch (Exception e) {
            this.handleApiResponse(ctx, response, demandInfo, requirementId);
            logger.error((Object)"\u66f4\u65b0\u62db\u8058\u9700\u6c42\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleApiResponse(Context ctx, JSONObject response, RecuritmentDemandInfo demandInfo, String requirementId) throws BOSException, EASBizException {
        int code = 500;
        if (response.containsKey((Object)"code")) {
            code = response.getIntValue("code");
        }
        String message = "\u53d1\u751f\u8c03\u7528\u9519\u8bef,\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7!";
        if (response.containsKey((Object)"message")) {
            message = response.getString("message");
        }
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("requirementId"));
        selectorCol.add(new SelectorItemInfo("syncBeisenResult"));
        selectorCol.add(new SelectorItemInfo("syncStatus"));
        if (code == 200) {
            if (!StringUtils.isEmpty((CharSequence)requirementId)) {
                demandInfo.put("requirementId", (Object)requirementId);
            } else {
                demandInfo.put("requirementId", (Object)response.getString("data"));
            }
            demandInfo.put("syncStatus", (Object)"1");
            demandInfo.put("syncBeisenResult", (Object)("\u6210\u529f: " + message));
            logger.info((Object)("\u6210\u529f: " + message));
        } else {
            logger.error((Object)("\u5931\u8d25: " + message + " (code: " + code + ")"));
            demandInfo.put("syncStatus", (Object)"2");
            demandInfo.put("syncBeisenResult", (Object)("\u5931\u8d25: " + message + " (code: " + code + ")"));
        }
        IRecuritmentDemand demandIns = RecuritmentDemandFactory.getLocalInstance((Context)ctx);
        demandIns.updatePartial(demandInfo, selectorCol);
    }

    private Object getPropertyValue(RecuritmentDemandInfo demandInfo, String property) {
        return demandInfo.get(property);
    }

    private String getPropertyAsString(RecuritmentDemandInfo demandInfo, String property) {
        return Optional.ofNullable(this.getPropertyValue(demandInfo, property)).map(Object::toString).orElse("");
    }

    private void mapValueIfPresent(Map<String, Integer> valueMap, String sourceValue, String targetKey, JSONObject params) {
        Integer mappedValue;
        if (StringUtils.isNotBlank((CharSequence)sourceValue) && (mappedValue = valueMap.get(sourceValue)) != null) {
            params.put(targetKey, (Object)mappedValue);
        }
    }

    private void mapEnumValue(Map<String, Integer> valueMap, JobNatureEnum sourceEnum, String targetKey, JSONObject params) {
        Integer mappedValue;
        if (sourceEnum != null && (mappedValue = valueMap.get(sourceEnum.getValue())) != null) {
            params.put(targetKey, (Object)mappedValue);
        }
    }

    public String getBenefits(RecuritmentDemandInfo demandInfo) {
        String sql = "SELECT BENEFITS.FName FROM T_REC_Benefits BENEFITS JOIN T_REC_RecDemandLinkBenefits LINK01 ON (BENEFITS.FID = LINK01.FBenefitsID) WHERE BENEFITS.FState = 1 AND LINK01.FDemandID = ?";
        StringBuilder value = new StringBuilder();
        try {
            List datas = RecDBUtils.getQueryData((Context)SHRContext.getInstance().getContext(), (String)sql, (Object[])new Object[]{demandInfo.getId().toString()});
            if (CollectionUtils.isNotEmpty((Collection)datas)) {
                for (Object[] objects : datas) {
                    if (objects.length <= 0) continue;
                    value.append(String.valueOf(objects[0]));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u798f\u5229\u5f85\u9047\u5f02\u5e38", (Throwable)e);
        }
        return value.toString();
    }

    private void addCustomField(JSONObject params, String fieldName, String value) {
        String fieldCode;
        if (StringUtils.isNotBlank((CharSequence)value) && (fieldCode = this.getCustomFieldCode(fieldName)) != null) {
            params.put(fieldCode, (Object)value);
        }
    }

    private void addCustomField(JSONObject params, String fieldName, Integer value) {
        String fieldCode;
        if (value != null && (fieldCode = this.getCustomFieldCode(fieldName)) != null) {
            params.put(fieldCode, (Object)value);
        }
    }

    private String getCustomFieldCode(String fieldName) {
        Map<String, String> fieldMap = isProductionEnv ? FORMAL_CUSTOM_FIELDS : TEST_CUSTOM_FIELDS;
        return fieldMap.get(fieldName);
    }

    private String mapHeadcountType(String headcountType) {
        return StringUtils.isNotBlank((CharSequence)headcountType) ? HEADCOUNT_TYPE_MAP.getOrDefault(headcountType, headcountType) : null;
    }

    private String mapYesNo(Object value) {
        if (ObjectUtils.isNotEmpty((Object)value)) {
            String strValue = value.toString();
            return YES_NO_MAP.getOrDefault(strValue, strValue);
        }
        return YES_NO_MAP.get("\u5426");
    }

    public Map<String, Integer> getUserIdsByJobNumbers(Set<String> jobNumbers) throws IOException {
        if (jobNumbers == null || jobNumbers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ArrayList<String> needQuery = new ArrayList<String>();
        for (String jobNumber : jobNumbers) {
            if (jobNumberToUserIdCache.containsKey(jobNumber)) {
                result.put(jobNumber, jobNumberToUserIdCache.get(jobNumber));
                continue;
            }
            needQuery.add(jobNumber);
        }
        int batchSize = 30;
        int i = 0;
        while (i < needQuery.size()) {
            int end = Math.min(i + batchSize, needQuery.size());
            List batch = needQuery.subList(i, end);
            JSONObject requestData = new JSONObject();
            requestData.put("jobNumbers", batch);
            JSONObject response = BeisenApiClient.getInstance().callApi("https://openapi.italent.cn/TenantBaseExternal/api/v5/Employee/GetUserIDsByJobNumbers", requestData);
            if ("200".equals(response.getString("code"))) {
                JSONArray data = response.getJSONArray("data");
                if (data != null) {
                    int j = 0;
                    while (j < data.size()) {
                        JSONObject item = data.getJSONObject(j);
                        String jobNum = item.getString("jobNumber");
                        Integer userId = item.getInteger("userId");
                        if (jobNum != null && userId != null && userId > 0) {
                            jobNumberToUserIdCache.put(jobNum, userId);
                            result.put(jobNum, userId);
                        }
                        ++j;
                    }
                }
            } else {
                logger.error((Object)("\u6279\u91cf\u83b7\u53d6\u7528\u6237ID\u5931\u8d25: " + response.getString("message")));
            }
            i += batchSize;
        }
        return result;
    }

    private Integer convertToBeisenUserId(String jobNumber) {
        if (StringUtils.isBlank((CharSequence)jobNumber)) {
            return null;
        }
        if (jobNumberToUserIdCache.containsKey(jobNumber)) {
            return jobNumberToUserIdCache.get(jobNumber);
        }
        try {
            Set<String> jobNumbers = Collections.singleton(jobNumber);
            Map<String, Integer> mapping = this.getUserIdsByJobNumbers(jobNumbers);
            return mapping.get(jobNumber);
        }
        catch (IOException e) {
            logger.error((Object)("\u8f6c\u6362\u5de5\u53f7\u5230\u5317\u68ee\u7528\u6237ID\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u5de5\u53f7: " + jobNumber), (Throwable)e);
            return null;
        }
    }
}

