/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.beisen.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.custom.beisen.utils.BeisenTokenManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class BeisenApiClient {
    private static final Logger logger = Logger.getLogger(BeisenApiClient.class);
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final int MAX_RETRIES = 3;
    private static volatile BeisenApiClient instance;
    private final OkHttpClient httpClient = this.buildHttpClient();
    private final BeisenTokenManager tokenManager = BeisenTokenManager.getInstance();

    private BeisenApiClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BeisenApiClient getInstance() {
        if (instance != null) return instance;
        Class<BeisenApiClient> clazz = BeisenApiClient.class;
        synchronized (BeisenApiClient.class) {
            if (instance != null) return instance;
            instance = new BeisenApiClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public JSONObject callApi(String apiUrl, JSONObject requestData) throws IOException {
        return this.callApi(apiUrl, requestData, "POST");
    }

    public JSONObject callApi(String apiUrl, JSONArray dataArray) throws IOException {
        return this.callApi(apiUrl, dataArray, "POST");
    }

    public JSONObject callPutApi(String apiUrl, JSONObject requestData) throws IOException {
        return this.callApi(apiUrl, requestData, "PUT");
    }

    public JSONObject callGetApi(String apiUrl, JSONObject requestData) throws IOException {
        return this.callApi(apiUrl, requestData, "GET");
    }

    public JSONObject callGetApi(String apiUrl, JSONArray dataArray) throws IOException {
        return this.callApi(apiUrl, dataArray, "GET");
    }

    public JSONObject callApi(String apiUrl, JSONObject requestData, String method) throws IOException {
        return this.callApiInternal(apiUrl, requestData, true, method);
    }

    public JSONObject callApi(String apiUrl, JSONArray dataArray, String method) throws IOException {
        return this.callApiInternal(apiUrl, dataArray, true, method);
    }

    private JSONObject callApiInternal(String apiUrl, Object requestBody, boolean retryOnTokenExpired, String method) throws IOException {
        int retryCount = 0;
        JSONObject handleResponse = new JSONObject();
        while (retryCount <= 3) {
            try {
                String accessToken = this.tokenManager.getAccessToken();
                Request request = this.buildRequest(apiUrl, requestBody, accessToken, method);
                Throwable throwable = null;
                Object var10_12 = null;
                try (Response response = this.httpClient.newCall(request).execute();){
                    handleResponse = this.handleResponse(response, apiUrl, method);
                    return handleResponse;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (this.shouldRetry(retryOnTokenExpired, retryCount, e)) {
                    this.handleTokenRefresh(++retryCount);
                    continue;
                }
                ++retryCount;
                break;
            }
        }
        return handleResponse;
    }

    private JSONObject handleResponse(Response response, String apiUrl, String method) throws IOException {
        String responseBody;
        String string = responseBody = response.body() != null ? response.body().string() : "null";
        if (!response.isSuccessful()) {
            this.handleHttpError(responseBody, apiUrl, method);
        }
        JSONObject jsonResponse = this.parseResponse(responseBody, apiUrl);
        this.validateBusinessStatus(jsonResponse, apiUrl);
        return jsonResponse;
    }

    private void handleHttpError(String errorBody, String apiUrl, String method) throws IOException {
        logger.error((Object)("API request failed , URL: " + apiUrl + ", Method: " + method + ", Body: " + errorBody));
        System.out.print("\u8c03\u7528\u9519\u8bef" + errorBody);
    }

    private JSONObject parseResponse(String responseBody, String apiUrl) throws IOException {
        try {
            return JSON.parseObject((String)responseBody);
        }
        catch (Exception e) {
            logger.error((Object)("Invalid JSON response from API. URL: " + apiUrl + ", Response: " + responseBody));
            throw new IOException("Failed to parse API response", e);
        }
    }

    private void validateBusinessStatus(JSONObject jsonResponse, String apiUrl) throws IOException {
        int apiCode = jsonResponse.getIntValue("code");
        if (apiCode != 200) {
            String apiMessage = jsonResponse.getString("message");
            logger.error((Object)("API business error. Code: " + apiCode + ", Message: " + apiMessage + ", URL: " + apiUrl));
        }
    }

    private boolean shouldRetry(boolean retryOnTokenExpired, int retryCount, Exception e) {
        return retryOnTokenExpired && this.isTokenExpiredError(e) && retryCount < 3;
    }

    private void handleTokenRefresh(int retryCount) {
        logger.warn((Object)("Token may have expired, refreshing and retrying... (" + retryCount + "/" + 3 + ")"));
        try {
            this.tokenManager.refreshToken();
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to refresh token during retry", (Throwable)ex);
        }
    }

    private Request buildRequest(String apiUrl, Object requestBody, String accessToken, String method) {
        String jsonString = this.convertToJsonString(requestBody);
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jsonString);
        if (requestBody instanceof JSONObject && ((JSONObject)requestBody).size() == 0) {
            body = null;
        }
        return new Request.Builder().url(apiUrl).addHeader("Authorization", "Bearer " + accessToken).addHeader("Content-Type", "application/json").method(method, body).build();
    }

    private String convertToJsonString(Object data) {
        if (data instanceof JSONObject) {
            return ((JSONObject)data).toJSONString();
        }
        if (data instanceof JSONArray) {
            return ((JSONArray)data).toJSONString();
        }
        throw new IllegalArgumentException("Unsupported request data type: " + data.getClass());
    }

    private boolean isTokenExpiredError(Exception e) {
        String msg = e.getMessage();
        return msg != null && (msg.contains("401") || msg.contains("Unauthorized") || msg.contains("token"));
    }

    private OkHttpClient buildHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(45L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(50, 5L, TimeUnit.MINUTES)).retryOnConnectionFailure(true).build();
    }
}

