/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.beisen.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.custom.beisen.utils.BeisenParamByProperties;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class BeisenTokenManager {
    private static final Logger logger = Logger.getLogger(BeisenTokenManager.class);
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final long EXPIRY_BUFFER = 300000L;
    private final OkHttpClient httpClient;
    private final Lock lock = new ReentrantLock();
    private volatile TokenState tokenState;
    private final String appKey;
    private final String appSecret;
    private final String tokenUrl;
    private static volatile BeisenTokenManager instance;

    private BeisenTokenManager() {
        this(Config.APP_KEY, Config.APP_SECRET, Config.TOKEN_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BeisenTokenManager getInstance() {
        if (instance != null) return instance;
        Class<BeisenTokenManager> clazz = BeisenTokenManager.class;
        synchronized (BeisenTokenManager.class) {
            if (instance != null) return instance;
            instance = new BeisenTokenManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public BeisenTokenManager(String appKey, String appSecret, String tokenUrl) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.tokenUrl = tokenUrl;
        this.httpClient = this.buildHttpClient();
        this.tokenState = this.loadInitialToken();
    }

    public String getAccessToken() throws IOException {
        TokenState currentState = this.tokenState;
        if (currentState != null && !this.isTokenExpired(currentState)) {
            return currentState.getAccessToken();
        }
        if (currentState == null || this.isTokenExpired(currentState)) {
            this.lock.lock();
            try {
                currentState = this.tokenState;
                if (currentState == null || this.isTokenExpired(currentState)) {
                    this.tokenState = currentState = this.fetchNewToken();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return currentState.getAccessToken();
    }

    public void refreshToken() throws IOException {
        TokenState currentState = this.tokenState;
        if (currentState == null || currentState.getRefreshToken() == null) {
            this.tokenState = this.fetchNewToken();
            return;
        }
        if (this.isTokenExpired(currentState)) {
            this.lock.lock();
            try {
                currentState = this.tokenState;
                if (this.isTokenExpired(currentState)) {
                    this.tokenState = this.refreshToken(currentState.getRefreshToken());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean isTokenExpired(TokenState state) {
        return System.currentTimeMillis() > state.getExpireTime() - 300000L;
    }

    private TokenState loadInitialToken() {
        try {
            return this.fetchNewToken();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to initialize token", (Throwable)e);
            throw new RuntimeException("Token initialization failed", e);
        }
    }

    private TokenState fetchNewToken() throws IOException {
        JSONObject requestBody = new JSONObject();
        requestBody.put("grant_type", (Object)"client_credentials");
        requestBody.put("app_key", (Object)this.appKey);
        requestBody.put("app_secret", (Object)this.appSecret);
        return this.executeTokenRequest(requestBody);
    }

    private TokenState refreshToken(String refreshToken) throws IOException {
        JSONObject requestBody = new JSONObject();
        requestBody.put("grant_type", (Object)"refresh_token");
        requestBody.put("refresh_token", (Object)refreshToken);
        return this.executeTokenRequest(requestBody);
    }

    private TokenState executeTokenRequest(JSONObject requestBody) throws IOException {
        Request request = new Request.Builder().url(this.tokenUrl).post(RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)requestBody.toJSONString())).build();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String errorBody = response.body() != null ? response.body().string() : "null";
                logger.error((Object)("Token request failed. Code: " + response.code() + ", Body: " + errorBody));
                throw new IOException("Token request failed with code: " + response.code());
            }
            String responseBody = response.body().string();
            JSONObject jsonResponse = JSON.parseObject((String)responseBody);
            String accessToken = jsonResponse.getString("access_token");
            String refreshToken = jsonResponse.getString("refresh_token");
            Long expiresIn = jsonResponse.getLong("expires_in");
            if (accessToken == null || expiresIn == null || expiresIn <= 0L) {
                throw new IOException("Invalid token response: " + responseBody);
            }
            return new TokenState(accessToken, System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expiresIn), refreshToken);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private OkHttpClient buildHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public static class Config {
        public static String APP_KEY = "6200E9EEE80C440B8342B1F8E8F0DFFE";
        public static String APP_SECRET = "BCDF24366FBA4851AEAE2638085548B1D780130E808842049FA7FDDD6D63B18D";
        public static String TOKEN_URL = "https://openapi.italent.cn/token";

        static {
            try {
                BeisenParamByProperties beisenParamByProperties = new BeisenParamByProperties();
                Map<String, String> config = beisenParamByProperties.getConfig();
                if (config != null) {
                    if (config.containsKey("appKey")) {
                        APP_KEY = config.get("appKey");
                    }
                    if (config.containsKey("appSecret")) {
                        APP_SECRET = config.get("appSecret");
                    }
                    if (config.containsKey("tokenUrl")) {
                        TOKEN_URL = config.get("tokenUrl");
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TokenState {
        private final String accessToken;
        private final long expireTime;
        private final String refreshToken;

        public TokenState(String accessToken, long expireTime, String refreshToken) {
            this.accessToken = accessToken;
            this.expireTime = expireTime;
            this.refreshToken = refreshToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }
    }
}

