/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy.encrypt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.bos.privacy.encrypt.AES_CBC_128;
import com.kingdee.bos.privacy.encrypt.AES_CBC_256;
import com.kingdee.bos.privacy.encrypt.AES_GCM_256;
import com.kingdee.bos.privacy.encrypt.AbstractEncryptor;
import com.kingdee.bos.privacy.encrypt.EncryptUtils;
import com.kingdee.bos.privacy.encrypt.EncryptorType;
import com.kingdee.bos.privacy.encrypt.ICustomEncryptor;
import com.kingdee.bos.privacy.encrypt.IEncryptor;
import com.kingdee.bos.privacy.encrypt.SM4_CBC_128;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.crypto.codec.Hex;

public class ComposeEncryptor
extends AbstractEncryptor
implements IEncryptor {
    private List<IEncryptor> encryptors;
    private static Map<String, ComposeEncryptor> instances = new ConcurrentHashMap<String, ComposeEncryptor>();
    private static final IEncryptor keyEncryptor;
    private static final IEncryptor keyEncryptor2;
    private static final String SIGN = "$";
    private static Class customEncryptorClazz;

    private ComposeEncryptor(List<IEncryptor> encryptors) {
        this.encryptors = encryptors;
    }

    @Override
    public byte[] encrypt(byte[] src) throws BOSException {
        IEncryptor encryptor;
        if (this.encryptors != null && this.encryptors.size() > 0 && (encryptor = this.encryptors.get(0)) != null) {
            src = encryptor.encrypt(src);
        }
        return src;
    }

    @Override
    public byte[] decrypt(byte[] src) throws BOSException {
        if (this.encryptors != null) {
            for (int i = 0; i < this.encryptors.size(); ++i) {
                IEncryptor encryptor = this.encryptors.get(i);
                try {
                    if (encryptor == null) continue;
                    src = encryptor.decrypt(src);
                    continue;
                }
                catch (BOSException e) {
                    if (i != this.encryptors.size()) continue;
                    throw e;
                }
            }
        }
        return src;
    }

    @Override
    public byte[] generateKey() {
        return null;
    }

    public static void reset(String ais, String[] solutionIds) {
        if (solutionIds == null) {
            instances.clear();
        } else {
            for (String solutionId : solutionIds) {
                String key = PrivacyPropertyManager.aisKey(ais, solutionId);
                instances.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ComposeEncryptor getInstance(Context ctx, String solutionId) throws BOSException {
        if (StringUtils.isEmpty((String)solutionId)) {
            return null;
        }
        String key = PrivacyPropertyManager.aisKey(ctx.getAIS(), solutionId);
        ComposeEncryptor instance = instances.get(key);
        if (instance != null) return instance;
        Class<ComposeEncryptor> clazz = ComposeEncryptor.class;
        synchronized (ComposeEncryptor.class) {
            if (instance != null) return instance;
            try {
                String sql = " select FEncryptType,FEncryptKey from T_Privacy_EncryptKeyHis where fsolutionId=? order by FCreateTime desc ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{solutionId});
                ArrayList<ICustomEncryptor> encryptors = new ArrayList<ICustomEncryptor>();
                while (rs.next()) {
                    EncryptorType encryptType = EncryptorType.getEncryptorType(rs.getInt(1));
                    String encryptKey = rs.getString(2);
                    IEncryptor encryptor = null;
                    if (encryptType == EncryptorType.CUSTOM) {
                        ICustomEncryptor customEncryptor = ComposeEncryptor.getCustomEncryptor(ctx);
                        customEncryptor.loadKey(ctx, solutionId);
                        encryptor = customEncryptor;
                    } else if (encryptKey != null) {
                        byte[] array = ComposeEncryptor.unWarp(encryptKey);
                        if (encryptType == EncryptorType.AES_CBC_256) {
                            encryptor = new AES_CBC_256(ctx, array);
                        } else if (encryptType == EncryptorType.AES_CBC_128) {
                            encryptor = new AES_CBC_128(ctx, array);
                        } else if (encryptType == EncryptorType.AES_GCM_256) {
                            encryptor = new AES_GCM_256(ctx, array);
                        } else if (encryptType == EncryptorType.SM4_CBC_128) {
                            encryptor = new SM4_CBC_128(ctx, array);
                        }
                    }
                    encryptors.add((ICustomEncryptor)encryptor);
                }
                if (encryptors.size() <= 0) return instance;
                EncryptorType encryptorType = EncryptUtils.getRecentEncryptorType(ctx);
                ArrayList<IEncryptor> sortedEncryptors = new ArrayList<IEncryptor>();
                ArrayList<IEncryptor> other = new ArrayList<IEncryptor>();
                for (int i = 0; i < encryptors.size(); ++i) {
                    IEncryptor encryptor = (IEncryptor)encryptors.get(i);
                    if (encryptorType == encryptor.getType()) {
                        sortedEncryptors.add(encryptor);
                        continue;
                    }
                    other.add(encryptor);
                }
                sortedEncryptors.addAll(other);
                instance = new ComposeEncryptor(sortedEncryptors);
                key = PrivacyPropertyManager.aisKey(ctx.getAIS(), solutionId);
                instances.put(key, instance);
            }
            catch (SQLException e) {
                throw new BOSException("Get ComposeEncryptor error", (Throwable)e);
            }
            return instance;
        }
    }

    static String generateKey(Context ctx, EncryptorType encryptType) throws BOSException {
        byte[] encryptKey = null;
        if (encryptType == EncryptorType.AES_CBC_256) {
            encryptKey = new AES_CBC_256().generateKey();
        } else if (encryptType == EncryptorType.AES_CBC_128) {
            encryptKey = new AES_CBC_128().generateKey();
        } else if (encryptType == EncryptorType.AES_GCM_256) {
            encryptKey = new AES_GCM_256().generateKey();
        } else if (encryptType == EncryptorType.SM4_CBC_128) {
            encryptKey = new SM4_CBC_128().generateKey();
        } else if (encryptType == EncryptorType.CUSTOM) {
            encryptKey = ComposeEncryptor.getCustomEncryptor(ctx).generateKey();
            return new String(Hex.encode((byte[])encryptKey));
        }
        if (encryptKey != null) {
            return ComposeEncryptor.warp(encryptKey);
        }
        return null;
    }

    private static String warp(byte[] encryptKey) throws BOSException {
        encryptKey = keyEncryptor.encrypt(encryptKey);
        return SIGN + new String(Hex.encode((byte[])encryptKey));
    }

    private static byte[] unWarp(String encryptKey) throws BOSException {
        byte[] array;
        if (encryptKey.startsWith(SIGN)) {
            encryptKey = encryptKey.substring(SIGN.length());
            array = Hex.decode((CharSequence)encryptKey);
            try {
                array = keyEncryptor.decrypt(array);
            }
            catch (Exception e) {
                array = keyEncryptor2.decrypt(array);
            }
        } else {
            array = Hex.decode((CharSequence)encryptKey);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ICustomEncryptor getCustomEncryptor(Context ctx) throws BOSException {
        if (customEncryptorClazz == null) {
            Class<ComposeEncryptor> clazz = ComposeEncryptor.class;
            // MONITORENTER : com.kingdee.bos.privacy.encrypt.ComposeEncryptor.class
            String implClazz = null;
            String sql = " select top 1 FImplClazz from T_Privacy_Encryptor where FType=? order by FCreateTime desc ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{EncryptorType.CUSTOM.getType()});
            try {
                if (rs.next()) {
                    implClazz = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            customEncryptorClazz = ComposeEncryptor.checkCustomEncryptorImpl(implClazz);
            // MONITOREXIT : clazz
        }
        Constructor simpleConstructor = null;
        try {
            simpleConstructor = customEncryptorClazz.getConstructor(new Class[0]);
        }
        catch (Exception implClazz) {
            // empty catch block
        }
        try {
            return (ICustomEncryptor)simpleConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Class checkCustomEncryptorImpl(String implClazz) throws BOSException {
        if (StringUtils.isEmpty((String)implClazz)) {
            throw new BOSException("\u81ea\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Class<?> customEncryptor = null;
        try {
            customEncryptor = Class.forName(implClazz);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!IEncryptor.class.isAssignableFrom(customEncryptor)) {
            throw new BOSException(implClazz + "\u5fc5\u987b\u5b9e\u73b0" + ICustomEncryptor.class.getName() + "\u63a5\u53e3");
        }
        try {
            customEncryptor.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new BOSException(implClazz + "\u5fc5\u987b\u6709\u65e0\u53c2\u7684\u6784\u9020\u65b9\u6cd5 ", (Throwable)e);
        }
        return customEncryptor;
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.kingdee.bos.openapi.app.PrivacySolutionControllerBean");
            Field tempField = clazz.getDeclaredField("temp");
            tempField.setAccessible(true);
            String temp = (String)tempField.get(null);
            keyEncryptor = new AES_GCM_256(null, Hex.decode((CharSequence)temp));
            tempField = clazz.getDeclaredField("temp2");
            tempField.setAccessible(true);
            temp = (String)tempField.get(null);
            keyEncryptor2 = new AES_CBC_128(null, Hex.decode((CharSequence)temp));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

