/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.util.LoggerItem;
import com.kingdee.util.ThreadScopeRecord;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;

class LoggerWriter {
    private LinkedList tasks = new LinkedList();
    private Thread thread;

    LoggerWriter() {
    }

    public static String printTime(long t) {
        return new Timestamp(t).toString();
    }

    public static String printTime2(long t) {
        String str = new Timestamp(t).toString();
        str = StringUtil.replace(str, ":", ".");
        return str;
    }

    String printTime(long start, long end) {
        return "" + (end - start) + "ms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ThreadScopeRecord tsr) {
        LinkedList linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.addLast(tsr);
        }
        if (this.thread == null) {
            this.thread = this.createThread();
            this.thread.start();
        }
    }

    private Thread createThread() {
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    ThreadScopeRecord tsr;
                    if (LoggerWriter.this.tasks.isEmpty()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    LinkedList linkedList = LoggerWriter.this.tasks;
                    synchronized (linkedList) {
                        tsr = (ThreadScopeRecord)LoggerWriter.this.tasks.removeFirst();
                    }
                    LoggerWriter.this.innerWrite(tsr);
                }
            }
        }, "KSQLThreadScopeLogger");
    }

    private String getLogDirectory() {
        String config = System.getProperty("ormrpc.config");
        String dir = null;
        int p = config.lastIndexOf(47);
        if (p > 0) {
            dir = config.substring(0, p);
            p = dir.lastIndexOf(47);
            dir = dir.substring(0, p + 1);
        } else {
            p = config.lastIndexOf(File.separator);
            if (p > 0) {
                dir = config.substring(0, p);
                p = dir.lastIndexOf(47);
                dir = dir.substring(0, p + 1);
            }
        }
        if (dir == null) {
            dir = "w:/eas/server/profiles/server1/";
        }
        dir = dir + "logs/";
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void innerWrite(ThreadScopeRecord tsr) {
        String dir = this.getLogDirectory();
        String fileName = dir + tsr.desc + "(" + LoggerWriter.printTime2(tsr.startTime) + "--" + LoggerWriter.printTime2(tsr.endTime) + ").log";
        PrintWriter pw = null;
        try {
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            int executeCount = 0;
            int executeTime = 0;
            int addBatchCount = 0;
            int addBatchTime = 0;
            int resultNextCount = 0;
            int resultNextTime = 0;
            int ormappingCount = 0;
            int ormappingTime = 0;
            int getValueCount = 0;
            int getValueTime = 0;
            int getCollectionCount = 0;
            int getCollectionTime = 0;
            int executeBatchCount = 0;
            int executeBatchTime = 0;
            int existsCount = 0;
            int existsTime = 0;
            int deleteCount = 0;
            int deleteTime = 0;
            int addnewCount = 0;
            int addnewTime = 0;
            int updateCount = 0;
            int updateTime = 0;
            int getCountCount = 0;
            int getCountTime = 0;
            int getPKListCount = 0;
            int getPKListTime = 0;
            int ormappingExecuteCount = 0;
            int ormappingExecuteTime = 0;
            int ormappingAddBatchCount = 0;
            int ormappingAddBatchTime = 0;
            int ormappingResultNextCount = 0;
            int ormappingResultNextTime = 0;
            int ormItemDBCount = 0;
            int ormItemDBTime = 0;
            Iterator iter = tsr.iterator();
            while (iter.hasNext()) {
                LoggerItem item;
                Object o = iter.next();
                if (o instanceof LoggerItem.ExecuteItem) {
                    item = (LoggerItem.ExecuteItem)o;
                    executeTime = (int)((long)executeTime + (item.endTime - item.startTime));
                    ++executeCount;
                    if (item.parent != null) {
                        ormappingExecuteTime = (int)((long)ormappingExecuteTime + (item.endTime - item.startTime));
                        ++ormappingExecuteCount;
                        ormItemDBTime = (int)((long)ormItemDBTime + (item.endTime - item.startTime));
                        ++ormItemDBCount;
                    }
                    this.write(pw, (LoggerItem.ExecuteItem)item);
                    continue;
                }
                if (o instanceof LoggerItem.AddBatchItem) {
                    item = (LoggerItem.AddBatchItem)o;
                    addBatchTime = (int)((long)addBatchTime + (((LoggerItem.AddBatchItem)item).endTime - ((LoggerItem.AddBatchItem)item).startTime));
                    ++addBatchCount;
                    if (((LoggerItem.AddBatchItem)item).parent != null) {
                        ormappingAddBatchTime = (int)((long)ormappingAddBatchTime + (((LoggerItem.AddBatchItem)item).endTime - ((LoggerItem.AddBatchItem)item).startTime));
                        ++ormappingAddBatchCount;
                    }
                    this.write(pw, (LoggerItem.AddBatchItem)item);
                    continue;
                }
                if (o instanceof LoggerItem.ResultNextItem) {
                    item = (LoggerItem.ResultNextItem)o;
                    resultNextTime = (int)((long)resultNextTime + (((LoggerItem.ResultNextItem)item).endTime - ((LoggerItem.ResultNextItem)item).startTime));
                    ++resultNextCount;
                    if (((LoggerItem.ResultNextItem)item).parent == null) continue;
                    ormappingResultNextTime = (int)((long)ormappingResultNextTime + (((LoggerItem.ResultNextItem)item).endTime - ((LoggerItem.ResultNextItem)item).startTime));
                    ++ormappingResultNextCount;
                    continue;
                }
                if (o instanceof LoggerItem.OrmappingItem) {
                    item = (LoggerItem.OrmappingItem)o;
                    ormappingTime = (int)((long)ormappingTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                    ++ormappingCount;
                    if ("getValue".equals(((LoggerItem.OrmappingItem)item).type)) {
                        getValueTime = (int)((long)getValueTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++getValueCount;
                    } else if ("getCollection".equals(((LoggerItem.OrmappingItem)item).type)) {
                        getCollectionTime = (int)((long)getCollectionTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++getCollectionCount;
                    } else if ("executeBatch".equals(((LoggerItem.OrmappingItem)item).type)) {
                        executeBatchTime = (int)((long)executeBatchTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++executeBatchCount;
                    } else if ("exists".equals(((LoggerItem.OrmappingItem)item).type)) {
                        existsTime = (int)((long)existsTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++existsCount;
                    } else if ("delete".equals(((LoggerItem.OrmappingItem)item).type)) {
                        deleteTime = (int)((long)deleteTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++deleteCount;
                    } else if ("addnew".equals(((LoggerItem.OrmappingItem)item).type)) {
                        addnewTime = (int)((long)addnewTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++addnewCount;
                    } else if ("update".equals(((LoggerItem.OrmappingItem)item).type)) {
                        updateTime = (int)((long)updateTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++updateCount;
                    } else if ("getCount".equals(((LoggerItem.OrmappingItem)item).type)) {
                        getCountTime = (int)((long)getCountTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++getCountCount;
                    } else if ("getPKList".equals(((LoggerItem.OrmappingItem)item).type)) {
                        getPKListTime = (int)((long)getPKListTime + (((LoggerItem.OrmappingItem)item).endTime - ((LoggerItem.OrmappingItem)item).startTime));
                        ++getPKListCount;
                    }
                    pw.println("Index:\t" + ((LoggerItem.OrmappingItem)item).index);
                    pw.println("Method:\t" + ((LoggerItem.OrmappingItem)item).method);
                    pw.println("Type:\t" + ((LoggerItem.OrmappingItem)item).type);
                    pw.println("Start Time:\t" + LoggerWriter.printTime(((LoggerItem.OrmappingItem)item).startTime));
                    pw.println("End Time:\t" + LoggerWriter.printTime(((LoggerItem.OrmappingItem)item).endTime));
                    pw.println("Cost Time:\t" + this.printTime(((LoggerItem.OrmappingItem)item).startTime, ((LoggerItem.OrmappingItem)item).endTime));
                    if (ormItemDBCount > 0) {
                        pw.println("\u5176\u4e2d\uff0c\u6267\u884cSQL\u6b21\u6570\uff1a" + ormItemDBCount + ",\u6267\u884cSQL\u65f6\u95f4:" + ormItemDBTime);
                    }
                    pw.println("------------------------");
                    ormItemDBTime = 0;
                    ormItemDBCount = 0;
                    continue;
                }
                if (!(o instanceof LoggerItem.CommentItem)) continue;
                item = (LoggerItem.CommentItem)o;
                this.write(pw, (LoggerItem.CommentItem)item);
            }
            pw.flush();
            String content = sw.toString();
            int dbTotalTime = executeTime + addBatchTime + resultNextTime;
            int dbTotalCount = executeCount + addBatchCount + resultNextCount;
            pw = new PrintWriter(new FileWriter(fileName));
            pw.println("Desc:" + tsr.desc);
            pw.println("Method Start Time:" + LoggerWriter.printTime(tsr.startTime));
            pw.println("Method End Time:" + LoggerWriter.printTime(tsr.endTime));
            pw.println("Method Response Time(\u65b9\u6cd5\u603b\u54cd\u5e94\u65f6\u95f4):" + this.printTime(tsr.startTime, tsr.endTime) + ".");
            pw.println("---DB\u60c5\u51b5----");
            pw.println("DB Total Count(\u6570\u636e\u5e93\u4ea4\u4e92\u603b\u6b21\u6570):" + dbTotalCount);
            pw.println("DB Total Time(\u6570\u636e\u5e93\u4ea4\u4e92\u603b\u65f6\u95f4):" + dbTotalTime + ",\u5360" + LoggerWriter.getPercent(dbTotalTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("SQL Execute Count(\u6267\u884cSQL\u6b21\u6570):" + executeCount);
            pw.println("SQL Execute Time(\u6267\u884cSQL\u603b\u65f6\u95f4):" + executeTime + ",\u5360" + LoggerWriter.getPercent(executeTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("AddBatch Count(AddBatch\u6b21\u6570):" + addBatchCount);
            pw.println("AddBatch Time(AddBatch\u603b\u65f6\u95f4):" + addBatchTime + ",\u5360" + LoggerWriter.getPercent(addBatchTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("ResultNext Count(ResultNext\u6b21\u6570):" + resultNextCount);
            pw.println("Resultnext Time(ResultNext\u603b\u65f6\u95f4):" + resultNextTime + ",\u5360" + LoggerWriter.getPercent(resultNextTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("---Ormapping\u60c5\u51b5----");
            int ormappingDbTotalTime = ormappingExecuteTime + ormappingAddBatchTime + ormappingResultNextTime;
            int ormappingDbTotalCount = ormappingExecuteCount + ormappingAddBatchCount + ormappingResultNextCount;
            pw.println("Ormapping Count(Ormapping\u603b\u6b21\u6570):" + ormappingCount);
            pw.println("Ormapping Total Time(Ormapping\u603b\u65f6\u95f4):" + ormappingTime + ",\u5360" + LoggerWriter.getPercent(ormappingTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("---\u5176\u4e2dDB\u5360\u7528\u60c5\u51b5\u5982\u4e0b---");
            pw.println("Ormapping DB Count(Ormapping DB\u4ea4\u4e92\u603b\u6b21\u6570):" + ormappingDbTotalCount);
            pw.println("Ormapping DB Total Time(OrmappingDB\u4ea4\u4e92\u603b\u65f6\u95f4):" + ormappingDbTotalTime + ",\u5360\u603bDB\u65f6\u95f4" + LoggerWriter.getPercent(ormappingDbTotalTime, dbTotalTime) + ",\u5360\u603bOrmapping\u65f6\u95f4" + LoggerWriter.getPercent(ormappingDbTotalTime, ormappingTime));
            pw.println("Ormapping SQL Execute Count(Ormapping \u6267\u884cSQL\u6b21\u6570):" + ormappingExecuteCount);
            pw.println("Ormapping SQL Execute Time(Ormapping \u6267\u884cSQL\u603b\u65f6\u95f4):" + ormappingExecuteTime + ",\u5360Ormapping DB\u65f6\u95f4" + LoggerWriter.getPercent(ormappingExecuteTime, ormappingDbTotalTime));
            pw.println("Ormapping AddBatch Count(AddBatch\u6b21\u6570):" + ormappingAddBatchCount);
            pw.println("Ormapping AddBatch Time(AddBatch\u603b\u65f6\u95f4):" + ormappingAddBatchTime + ",\u5360Ormapping DB\u65f6\u95f4" + LoggerWriter.getPercent(ormappingAddBatchTime, ormappingDbTotalTime));
            pw.println("Ormapping ResultNext Count(ResultNext\u6b21\u6570):" + ormappingResultNextCount);
            pw.println("Ormapping Resultnext Time(ResultNext\u603b\u65f6\u95f4):" + ormappingResultNextTime + ",\u5360Ormapping DB\u65f6\u95f4" + LoggerWriter.getPercent(ormappingResultNextTime, ormappingDbTotalTime));
            pw.println("---\u5176\u4e2d\u5404\u65b9\u6cd5\u5360\u7528\u60c5\u51b5\u5982\u4e0b---");
            pw.println("Ormapping.getValue Count(Ormapping.getValue\u603b\u6b21\u6570):" + getValueCount);
            pw.println("Ormapping.getValue Total Time(Ormapping.getValue\u603b\u65f6\u95f4):" + getValueTime + ",\u5360" + LoggerWriter.getPercent(getValueTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.getCollection Count(Ormapping.getCollection\u603b\u6b21\u6570):" + getCollectionCount);
            pw.println("Ormapping.getCollection Total Time(Ormapping.getCollection\u603b\u65f6\u95f4):" + getCollectionTime + ",\u5360" + LoggerWriter.getPercent(getCollectionTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.executeBatch Count(Ormapping.executeBatch\u603b\u6b21\u6570):" + executeBatchCount);
            pw.println("Ormapping.executeBatch Total Time(Ormapping.executeBatch\u603b\u65f6\u95f4):" + executeBatchTime + ",\u5360" + LoggerWriter.getPercent(executeBatchTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.exists Count(Ormapping.exists\u603b\u6b21\u6570):" + existsCount);
            pw.println("Ormapping.exists Total Time(Ormapping.exists\u603b\u65f6\u95f4):" + existsTime + ",\u5360" + LoggerWriter.getPercent(existsTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.addnew Count(Ormapping.addnew\u603b\u6b21\u6570):" + addnewCount);
            pw.println("Ormapping.addnew Total Time(Ormapping.addnew\u603b\u65f6\u95f4):" + addnewTime + ",\u5360" + LoggerWriter.getPercent(addnewTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.update Count(Ormapping.update\u603b\u6b21\u6570):" + updateCount);
            pw.println("Ormapping.update Total Time(Ormapping.update\u603b\u65f6\u95f4):" + updateTime + ",\u5360" + LoggerWriter.getPercent(updateTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.delete Count(Ormapping.delete\u603b\u6b21\u6570):" + deleteCount);
            pw.println("Ormapping.delete Total Time(Ormapping.delete\u603b\u65f6\u95f4):" + deleteTime + ",\u5360" + LoggerWriter.getPercent(deleteTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.getCount Count(Ormapping.getCount\u603b\u6b21\u6570):" + getCountCount);
            pw.println("Ormapping.getCount Total Time(Ormapping.getCount\u603b\u65f6\u95f4):" + getCountTime + ",\u5360" + LoggerWriter.getPercent(getCountTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println("Ormapping.getPKList Count(Ormapping.getPKList\u603b\u6b21\u6570):" + getPKListCount);
            pw.println("Ormapping.getPKList Total Time(Ormapping.getPKList\u603b\u65f6\u95f4):" + getPKListTime + ",\u5360" + LoggerWriter.getPercent(getPKListTime, tsr.endTime - tsr.startTime) + " of Response Time");
            pw.println(content);
        }
        catch (IOException iOException) {
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    private static String getPercent(long a, long b) {
        return "" + (float)((int)(10000L * a / b)) / 100.0f + "%";
    }

    private void write(PrintWriter pw, LoggerItem.ExecuteItem item) {
        pw.println("Index:\t" + item.index);
        pw.println("Method:\t" + item.method);
        pw.println("Start Time:\t" + LoggerWriter.printTime(item.startTime));
        pw.println("End Time:\t" + LoggerWriter.printTime(item.endTime));
        pw.println("Cost Time:\t" + this.printTime(item.startTime, item.endTime));
        if (item.parent == null) {
            pw.println("\u4e0d\u662fOrmapping\u4ea7\u751f\u7684");
        }
        pw.println("KSQL:\n" + item.ksql);
        pw.println("------------------------");
    }

    private void write(PrintWriter pw, LoggerItem.AddBatchItem item) {
        pw.println("Index:\t" + item.index);
        pw.println("Method:\t" + item.method);
        pw.println("Start Time:\t" + LoggerWriter.printTime(item.startTime));
        pw.println("End Time:\t" + LoggerWriter.printTime(item.endTime));
        pw.println("Cost Time:\t" + this.printTime(item.startTime, item.endTime));
        pw.println("KSQL:\n" + item.ksql);
        pw.println("------------------------");
    }

    private void write(PrintWriter pw, LoggerItem.CommentItem item) {
        pw.println("Index:\t" + item.index);
        pw.println("Comment(\u6ce8\u91ca)");
        pw.println("Method:" + item.method);
        pw.println(item.comment);
        pw.println("------------------------");
    }

    private void write(PrintWriter pw, LoggerItem.OrmappingItem item) {
        pw.println("Index:\t" + item.index);
        pw.println("Method:\t" + item.method);
        pw.println("Type:\t" + item.type);
        pw.println("Start Time:\t" + LoggerWriter.printTime(item.startTime));
        pw.println("End Time:\t" + LoggerWriter.printTime(item.endTime));
        pw.println("Cost Time:\t" + this.printTime(item.startTime, item.endTime));
        pw.println("------------------------");
    }

    private void write(PrintWriter pw, LoggerItem.ResultNextItem item) {
        pw.println("Index:\t" + item.index);
        pw.println("Method:\t" + item.method);
        pw.println("Start Time:\t" + LoggerWriter.printTime(item.startTime));
        pw.println("End Time:\t" + LoggerWriter.printTime(item.endTime));
        pw.println("Cost Time:\t" + this.printTime(item.startTime, item.endTime));
        pw.println("------------------------");
    }

    public static void main(String[] args) {
        System.out.println(LoggerWriter.getPercent(94564L, 100000L));
        System.out.println(LoggerWriter.printTime2(System.currentTimeMillis()));
    }
}

