/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.shr.osf.webservice.client.UserInfo;
import com.kingdee.shr.osf.webservice.proxy.client.WSContext;
import com.kingdee.shr.osf.webservice.util.PropertiesUtil;
import com.kingdee.shr.sso.client.util.BASE64Decoder;
import com.kingdee.shr.util.DataHandlerUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.AxisProperties;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSFWSClient {
    private static Integer TIMEOUT_SECOND = 600000;
    private static Logger logger = LoggerFactory.getLogger(OSFWSClient.class);

    public String proceedOSF(String shrAddr, String serviceName, Map<String, Object> params) {
        UserInfo userInfo = null;
        try {
            userInfo = this.getLoginUserInfo();
        }
        catch (Exception e) {
            logger.error("Call OSF error: " + e);
            String errorInfo = e.getCause() == null ? e.getMessage() : e.getCause().toString();
            return "{ \"error\": \"Call OSF error: " + errorInfo + "\"}";
        }
        if (userInfo == null) {
            return "{ \"error\": \"Call OSF error: userInfo is null}";
        }
        return this.proceedOSF(shrAddr, serviceName, params, userInfo);
    }

    public String proceedOSF(String shrAddr, String serviceName, Map<String, Object> params, UserInfo userInfo) {
        String result = null;
        String sessionId = null;
        String easAddrWs = null;
        easAddrWs = this.dealEasAddr(shrAddr);
        String loginURL = easAddrWs + "/ormrpc/services/EASLogin?wsdl";
        Call call = null;
        boolean issuccess = true;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            sessionId = this.doLogin(call, loginURL, userInfo);
            if (sessionId != null && sessionId.trim().length() != 0) {
                result = this.callOSF(call, easAddrWs, sessionId, serviceName, params);
                result = DataHandlerUtil.formatResponseDataHandle(result, false);
                logger.info("webservice invoke success!");
            } else {
                result = "{ \"error\": \"Call OSF error: webservice login fail!\"}";
                logger.error("webservice login fail, username: " + userInfo.getUserName() + ", datacenter: " + userInfo.getDcName() + ", please check username or password!");
                logger.error("loginURL : " + loginURL);
                issuccess = false;
            }
        }
        catch (Exception e) {
            issuccess = false;
            logger.error("Call OSF error: " + e);
            String errorInfo = e.getCause() == null ? e.getMessage() : e.getCause().toString();
            result = "{ \"error\": \"Call OSF error: " + errorInfo + "\"}";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String proceedOSFAndLogout(String shrAddr, String serviceName, Map<String, Object> params, UserInfo userInfo) {
        String result = null;
        String sessionId = null;
        String easAddrWs = null;
        easAddrWs = this.dealEasAddr(shrAddr);
        String loginURL = easAddrWs + "/ormrpc/services/EASLogin?wsdl";
        Call call = null;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            sessionId = this.doLogin(call, loginURL, userInfo);
            if (sessionId != null && sessionId.trim().length() != 0) {
                result = this.callOSF(call, easAddrWs, sessionId, serviceName, params);
                result = DataHandlerUtil.formatResponseDataHandle(result, false);
            } else {
                logger.error("webservice login fail, username: " + userInfo.getUserName() + ", datacenter: " + userInfo.getDcName());
            }
        }
        catch (Exception e) {
            logger.error("Call OSF error: " + e);
            String errorInfo = e.getCause() == null ? e.getMessage() : e.getCause().toString();
            result = "{ \"error\": \"Call OSF error: " + errorInfo + "\"}";
        }
        finally {
            if (!StringUtils.isEmpty((String)sessionId)) {
                try {
                    this.doLogout(call, loginURL, userInfo);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public String proceedOSFByLtpa(String shrAddr, String serviceName, Map<String, Object> params, UserInfo userInfo) {
        String result = null;
        String sessionId = null;
        String easAddrWs = null;
        easAddrWs = this.dealEasAddr(shrAddr);
        String loginURL = easAddrWs + "/ormrpc/services/EASLogin?wsdl";
        Call call = null;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            sessionId = this.doLoginByLtpa(call, loginURL, userInfo);
            if (sessionId != null && sessionId.trim().length() != 0) {
                result = this.callOSF(call, easAddrWs, sessionId, serviceName, params);
                result = DataHandlerUtil.formatResponseDataHandle(result, false);
            } else {
                logger.error("webservice login fail, username: " + userInfo.getUserName() + ", datacenter: " + userInfo.getDcName());
            }
        }
        catch (Exception e) {
            logger.error("Call OSF error: " + e);
            String errorInfo = e.getCause() == null ? e.getMessage() : e.getCause().toString();
            result = "{ \"error\": \"Call OSF error: " + errorInfo + "\"}";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String proceedOSFByLtpaAndLogout(String shrAddr, String serviceName, Map<String, Object> params, UserInfo userInfo) {
        String result = null;
        String sessionId = null;
        String easAddrWs = null;
        easAddrWs = this.dealEasAddr(shrAddr);
        String loginURL = easAddrWs + "/ormrpc/services/EASLogin?wsdl";
        Call call = null;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            sessionId = this.doLoginByLtpa(call, loginURL, userInfo);
            if (sessionId != null && sessionId.trim().length() != 0) {
                result = this.callOSF(call, easAddrWs, sessionId, serviceName, params);
                result = DataHandlerUtil.formatResponseDataHandle(result, false);
            } else {
                logger.error("webservice login fail, username: " + userInfo.getUserName() + ", datacenter: " + userInfo.getDcName());
            }
        }
        catch (Exception e) {
            logger.error("Call OSF error: " + e);
            String errorInfo = e.getCause() == null ? e.getMessage() : e.getCause().toString();
            result = "{ \"error\": \"Call OSF error: " + errorInfo + "\"}";
        }
        finally {
            if (!StringUtils.isEmpty((String)sessionId)) {
                try {
                    this.doLogout(call, loginURL, userInfo);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private String dealEasAddr(String easAddr) {
        if (!StringUtils.isEmpty((String)easAddr) && (easAddr.endsWith("/shr") || easAddr.endsWith("/shr/"))) {
            easAddr = easAddr.substring(0, easAddr.lastIndexOf("/shr"));
        }
        return easAddr;
    }

    private String handleAddr(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            if (str.startsWith("http://")) {
                str = str.substring(7);
            }
            if (str.startsWith("https://")) {
                str = str.substring(8);
            }
        }
        if (!StringUtils.isEmpty((String)str) && str.contains("/shr")) {
            str = str.substring(0, str.indexOf("/shr"));
        }
        return str;
    }

    public String callOSF(Call call, String easAddr, String sessionId, String serviceName, Map<String, Object> params) throws Exception {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
        String paramsStr = gson.toJson(params);
        call.setUseSOAPAction(false);
        call.clearOperation();
        call.setOperationName("proceedOSF");
        call.setTargetEndpointAddress(easAddr + "/ormrpc/services/WSOSFWebserviceFacade?wsdl");
        call.setReturnQName(new QName("", "proceedOSFReturn"));
        call.setTimeout(TIMEOUT_SECOND);
        call.setMaintainSession(true);
        SOAPHeaderElement header = new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId);
        call.addHeader(header);
        return (String)call.invoke(new Object[]{serviceName, paramsStr});
    }

    public String doLogin(Call call, String loginURL, UserInfo userInfo) throws Exception {
        call.setOperationName("login");
        call.setTargetEndpointAddress(loginURL);
        if (!StringUtils.isEmpty((String)loginURL) && loginURL.startsWith("https")) {
            AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
        }
        call.setReturnType(new QName("urn:client", "WSContext"));
        call.setReturnClass(WSContext.class);
        call.setReturnQName(new QName("", "loginReturn"));
        call.setTimeout(Integer.valueOf(TIMEOUT_SECOND));
        call.setMaintainSession(true);
        WSContext context = (WSContext)call.invoke(new Object[]{userInfo.getUserName(), userInfo.getPassword(), userInfo.getSlnName(), userInfo.getDcName(), userInfo.getLanguage(), userInfo.getDbType()});
        return context.getSessionId();
    }

    public String doLoginByLtpa(Call call, String loginURL, UserInfo userInfo) throws Exception {
        call.setOperationName("loginByLtpaToken");
        call.setTargetEndpointAddress(loginURL);
        if (!StringUtils.isEmpty((String)loginURL) && loginURL.startsWith("https")) {
            AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
        }
        call.setReturnType(new QName("urn:client", "WSContext"));
        call.setReturnClass(WSContext.class);
        call.setReturnQName(new QName("", "loginByLtpaTokenReturn"));
        call.setTimeout(Integer.valueOf(TIMEOUT_SECOND));
        call.setMaintainSession(true);
        WSContext context = (WSContext)call.invoke(new Object[]{userInfo.getUserName(), userInfo.getPassword(), userInfo.getSlnName(), userInfo.getDcName(), userInfo.getLanguage(), userInfo.getDbType()});
        return context.getSessionId();
    }

    public void doLogout(Call call, String loginURL, UserInfo userInfo) throws Exception {
        if (call != null) {
            try {
                call.clearOperation();
                call.setOperationName("logout");
                call.setTargetEndpointAddress(loginURL);
                call.setReturnQName(new QName("", "logoutReturn"));
                call.setTimeout(TIMEOUT_SECOND);
                call.setMaintainSession(true);
                Boolean bl = (Boolean)call.invoke(new Object[]{userInfo.getUserName(), userInfo.getSlnName(), userInfo.getDcName(), userInfo.getLanguage()});
            }
            catch (RemoteException e) {
                logger.error("webservice logout fail, username=" + userInfo.getUserName());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public UserInfo getLoginUserInfo() throws IOException {
        UserInfo userInfo = new UserInfo();
        userInfo.setUserName(PropertiesUtil.getProperty("userName"));
        String passwordStr = PropertiesUtil.getProperty("password");
        new BASE64Decoder();
        String decodePasswd = new String(BASE64Decoder.decodeBuffer(StringUtils.isEmpty((String)passwordStr) ? "" : passwordStr));
        userInfo.setPassword(decodePasswd);
        userInfo.setSlnName(PropertiesUtil.getProperty("slnName"));
        userInfo.setDcName(PropertiesUtil.getProperty("dcName"));
        userInfo.setLanguage(PropertiesUtil.getProperty("language"));
        String dbTypeStr = PropertiesUtil.getProperty("dbType");
        userInfo.setDbType(Integer.valueOf(StringUtils.isEmpty((String)dbTypeStr) ? "0" : dbTypeStr));
        return userInfo;
    }
}

