/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.handler;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rabbitmq.guava.Lists;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.PerformProTeamCollection;
import com.kingdee.eas.hr.perf.PerformProTeamFactory;
import com.kingdee.eas.hr.perf.PersonPerformProCollection;
import com.kingdee.eas.hr.perf.PersonPerformProFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.planexecute.handler.EvaresultAuditBillEditHandler;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;

public class EvaresultAuditBillEditHandlerEx
extends EvaresultAuditBillEditHandler {
    private static Logger logger = LoggerFactory.getLogger(EvaresultAuditBillEditHandlerEx.class);

    public void verifyBeforeSubmitAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String entryData = request.getParameter("entryData");
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        boolean isExists = true;
        if (!StringUtils.isEmpty((String)entryData)) {
            String period = request.getParameter("period");
            String planId = request.getParameter("planId");
            String billId = request.getParameter("billId");
            String ids = request.getParameter("ids");
            ArrayList rowList = Lists.newArrayList();
            for (String id : billId.split(",")) {
                rowList.add(id);
            }
            header = this.verifyToDep(request, response, modelMap);
            if (header.getFailureCount() <= 0 && header.getSuccessCount() > 0) {
                header = this.beforeAuditEvaResutProject(ids, period, planId, entryData);
            }
            header.setBillId(billId.toString());
        }
        this.writeSuccessData(header);
    }

    protected static Set<String> getErrorIdsByBatchMessageTip(BatchMessageTipsHeader batchMessageTipsHeader) {
        HashSet<String> errorIds = new HashSet<String>();
        for (BatchMessageTipsBody body : batchMessageTipsHeader.getResult()) {
            if (body.isMuitTipsState()) continue;
            errorIds.add(body.getId());
        }
        return errorIds;
    }

    protected static void addBatchMessageSuccessTips(Set<String> ids, String message, BatchMessageTipsHeader batchMessageTipsHeader) {
        for (String id : ids) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            body.setMuitTipsMessage(StringUtils.isEmpty((String)message) ? SHRPerfWebResourceUtil.getRes((SHRPerfWebResource)SHRPerfWebResource.OPERATESUCCESS, (Context)SHRContext.getInstance().getContext()) : message);
            batchMessageTipsHeader.addResult(body);
        }
    }

    public BatchMessageTipsHeader verifyToDep(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String entryData = request.getParameter("entryData");
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        boolean isExists = true;
        if (!StringUtils.isEmpty((String)entryData)) {
            int success = 0;
            int fail = 0;
            StringBuilder ids = new StringBuilder();
            ArrayList<String> allIdList = new ArrayList<String>();
            try {
                Context ctx = SHRContext.getInstance().getContext();
                JSONArray entryList = JSON.parseArray((String)entryData);
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject object = entryList.getJSONObject(i);
                    BatchMessageTipsBody body = new BatchMessageTipsBody();
                    String id = object.getString("id");
                    boolean isSuccess = false;
                    String msg = "";
                    String pnumber = object.getString("evaResult.pnumber");
                    String pname = object.getString("evaResult.pname");
                    String positionName = object.getString("evaResult.positionName");
                    String evaResult = object.getString("evaResult.id");
                    String auditGradeLevel = object.getString("evaResult.auditGradeLevel");
                    body.setId(id);
                    ids.append(id).append(",");
                    allIdList.add(id);
                    String sql = "select CFDEPGRADELEVEL from T_EVA_EvaResultSummary where fid = ?";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{evaResult});
                    if (rs.next()) {
                        String depgradelevel = rs.getString("CFDEPGRADELEVEL");
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)depgradelevel)) {
                            switch (depgradelevel) {
                                case "S": 
                                case "A": 
                                case "B": {
                                    isSuccess = true;
                                    msg = "\u6821\u9a8c\u901a\u8fc7";
                                    ++success;
                                    break;
                                }
                                case "C": 
                                case "D": {
                                    if ("S".equals(auditGradeLevel) || "A".equals(auditGradeLevel)) {
                                        isSuccess = false;
                                        msg = "\u5f53\u8de8\u90e8\u95e8\u534f\u4f5c\u7ee9\u6548\u7b49\u7ea7\u4e3aC\u3001D\u7b49\u7ea7\u7684\uff0c\u5f53\u671f\u5458\u5de5\u7ee9\u6548\u4e0d\u5f97\u4e3a\u9ad8\u7ee9\u6548\uff08S\u3001A\u7b49\u7ea7\uff09";
                                        ++fail;
                                        break;
                                    }
                                    isSuccess = true;
                                    msg = "\u6821\u9a8c\u901a\u8fc7";
                                    ++success;
                                }
                            }
                        } else {
                            msg = "\u6ca1\u6709\u5f53\u8de8\u90e8\u95e8\u534f\u4f5c\u7ee9\u6548\u7b49\u7ea7\uff0c\u8bf7\u5148\u68c0\u67e5\u8de8\u90e8\u95e8\u534f\u4f5c\u7ee9\u6548\u7b49\u7ea7";
                            isSuccess = true;
                            ++success;
                        }
                    } else {
                        msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5f02\u5e38";
                        isSuccess = false;
                        ++fail;
                    }
                    body.setMuitTipsState(isSuccess);
                    body.setMuitTipsMessage(msg);
                    ArrayList<String> messageListExt = new ArrayList<String>();
                    messageListExt.add(pnumber);
                    messageListExt.add(pname);
                    messageListExt.add(positionName);
                    body.addMessageListExt(messageListExt);
                    header.addResult(body);
                }
            }
            catch (BOSException | SQLException var7) {
                var7.printStackTrace();
            }
            ids.delete(ids.length() - 1, ids.length());
            header.setBillId(ids.toString());
            header.setFailureCount(fail);
            header.setSuccessCount(success);
        }
        return header;
    }

    protected static void addBatchMessageTip(String unvalidEvaObj, String message, BatchMessageTipsHeader batchMessageTipsHeader) {
        BatchMessageTipsBody body = new BatchMessageTipsBody();
        body.setId(unvalidEvaObj);
        body.setMuitTipsState(Boolean.FALSE.booleanValue());
        body.setMuitTipsMessage(message);
        batchMessageTipsHeader.addResult(body);
        batchMessageTipsHeader.setFailureCount(batchMessageTipsHeader.getFailureCount() + 1);
    }

    public Map<String, Map<String, BigDecimal>> getProjectPerformPro(Context ctx, List<String> idList, Map<String, String> batchMessage) throws BOSException, SQLException {
        HashMap orgLevelMap;
        block5: {
            block6: {
                PerformProTeamCollection proCollection;
                block4: {
                    orgLevelMap = Maps.newHashMap();
                    proCollection = PerformProTeamFactory.getLocalInstance((Context)ctx).getPerformProTeamCollection(" where status=1 ");
                    if (proCollection.size() != 1) break block4;
                    StringBuilder orgPerSql = new StringBuilder();
                    orgPerSql.append(" select fp.fid,fpe.CFS,fpe.CFA,fpe.CFB,fpe.CFC,fpe.CFD,fpe.CFORGPERFORMTYPE ");
                    orgPerSql.append(" from CT_PF_PerformProTeam fp ");
                    orgPerSql.append(" left join CT_PF_PerformProTeamEntry fpe on fp.fid=fpe.FPARENTID ");
                    orgPerSql.append(" where fp.CFSTATUS = 1 ");
                    orgPerSql.append(" order by fp.FCREATETIME ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)orgPerSql.toString());
                    while (rs.next()) {
                        HashMap objectMap = Maps.newHashMap();
                        String type = rs.getString("CFORGPERFORMTYPE");
                        objectMap.put("S", rs.getBigDecimal("CFS"));
                        objectMap.put("A", rs.getBigDecimal("CFA"));
                        objectMap.put("B", rs.getBigDecimal("CFB"));
                        objectMap.put("C", rs.getBigDecimal("CFC"));
                        objectMap.put("D", rs.getBigDecimal("CFD"));
                        orgLevelMap.put(type, objectMap);
                    }
                    break block5;
                }
                if (proCollection.size() <= 1) break block6;
                if (null == batchMessage || null == idList) break block5;
                for (String key : idList) {
                    batchMessage.put(key, "\u5b58\u5728\u591a\u4e2a\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                break block5;
            }
            if (null != batchMessage && null != idList) {
                for (String key : idList) {
                    batchMessage.put(key, "\u4e0d\u5b58\u5728\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
        }
        return orgLevelMap;
    }

    public Map<String, Map<String, BigDecimal>> getPersonPerformPro(Context ctx, List<String> idList, Map<String, String> batchMessage) throws BOSException, SQLException {
        HashMap orgLevelMap;
        block5: {
            block6: {
                PersonPerformProCollection proCollection;
                block4: {
                    orgLevelMap = Maps.newHashMap();
                    proCollection = PersonPerformProFactory.getLocalInstance((Context)ctx).getPersonPerformProCollection(" where state=1 ");
                    if (proCollection.size() != 1) break block4;
                    StringBuilder orgPerSql = new StringBuilder();
                    orgPerSql.append(" select fp.fid,fpe.CFS,fpe.CFA,fpe.CFB,fpe.CFC,fpe.CFD,fpe.CFORGPERFORMTYPE ");
                    orgPerSql.append(" from CT_PF_PersonPerformPro fp ");
                    orgPerSql.append(" left join CT_PF_PersonPerformProEntry fpe on fp.fid=fpe.FPARENTID ");
                    orgPerSql.append(" where fp.CFSTATE = 1 ");
                    orgPerSql.append(" order by fp.FCREATETIME ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)orgPerSql.toString());
                    while (rs.next()) {
                        HashMap objectMap = Maps.newHashMap();
                        String type = rs.getString("CFORGPERFORMTYPE");
                        objectMap.put("S", rs.getBigDecimal("CFS"));
                        objectMap.put("A", rs.getBigDecimal("CFA"));
                        objectMap.put("B", rs.getBigDecimal("CFB"));
                        objectMap.put("C", rs.getBigDecimal("CFC"));
                        objectMap.put("D", rs.getBigDecimal("CFD"));
                        orgLevelMap.put(type, objectMap);
                    }
                    break block5;
                }
                if (proCollection.size() <= 1) break block6;
                if (null == batchMessage || null == idList) break block5;
                for (String key : idList) {
                    batchMessage.put(key, "\u5b58\u5728\u591a\u4e2a\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                break block5;
            }
            if (null != batchMessage && null != idList) {
                for (String key : idList) {
                    batchMessage.put(key, "\u4e0d\u5b58\u5728\u6b63\u6001\u5206\u5e03\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
        }
        return orgLevelMap;
    }

    public Map<String, Map<String, Object>> getPersonLevelLensMap(Context ctx, JSONArray entryList) throws BOSException, SQLException {
        String auditGradeLevel;
        String evaResult;
        String id;
        JSONObject object;
        int i;
        HashMap personLevelMap = Maps.newHashMap();
        HashMap revLevelMap = Maps.newHashMap();
        for (i = 0; i < entryList.size(); ++i) {
            object = entryList.getJSONObject(i);
            id = object.getString("id");
            evaResult = object.getString("evaResult.id");
            auditGradeLevel = object.getString("evaResult.auditGradeLevel");
            BigDecimal l = (BigDecimal)revLevelMap.get(auditGradeLevel);
            if (Objects.isNull(l)) {
                l = BigDecimal.ZERO;
            }
            l = l.add(BigDecimal.ONE);
            revLevelMap.put(auditGradeLevel, l);
        }
        for (i = 0; i < entryList.size(); ++i) {
            object = entryList.getJSONObject(i);
            id = object.getString("id");
            evaResult = object.getString("evaResult.id");
            auditGradeLevel = object.getString("evaResult.auditGradeLevel");
            HashMap map = Maps.newHashMap();
            String key = auditGradeLevel;
            map.put("lens", revLevelMap.get(auditGradeLevel));
            map.put("id", id);
            map.put("evaResult", evaResult);
            map.put("revLevel", auditGradeLevel);
            personLevelMap.put(key, map);
        }
        return personLevelMap;
    }

    public BatchMessageTipsHeader beforeAuditEvaResutProject(String ids, String period, String planId, String entryData) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        if (ids == null) {
            throw new ShrWebBizException((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        try {
            boolean fail = false;
            ArrayList idList = Lists.newArrayList();
            for (String id : ids.split(",")) {
                idList.add(id);
            }
            HashSet idSet = Sets.newHashSet();
            idSet.addAll(idList);
            int success = idList.size();
            JSONArray entryList = JSON.parseArray((String)entryData);
            StringBuilder planSql = new StringBuilder();
            planSql.append("select fid,CFPerobjectIdId from T_EVA_PerfPlan where fid=? and CFPerobjectIdId is not null ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)planSql.toString(), (Object[])new Object[]{planId});
            if (rs.next()) {
                String CFPerobjectIdId = rs.getString("CFPerobjectIdId");
                Map<String, String> batchMessage = this.beforeAuditProjectEvaResut(ctx, period, planId, idList, entryList);
                if (null != batchMessage && batchMessage.size() > 0) {
                    for (Map.Entry<String, String> entry : batchMessage.entrySet()) {
                        EvaresultAuditBillEditHandlerEx.addBatchMessageTip(entry.getKey(), entry.getValue(), batchMessageTipsHeader);
                        idSet.remove(entry.getKey());
                    }
                }
            } else {
                Map<String, String> batchMessage = this.beforeAuditEvaResut(ctx, period, planId, idList, entryList);
                if (null != batchMessage && batchMessage.size() > 0) {
                    for (Map.Entry<String, String> entry : batchMessage.entrySet()) {
                        EvaresultAuditBillEditHandlerEx.addBatchMessageTip(entry.getKey(), entry.getValue(), batchMessageTipsHeader);
                        idSet.remove(entry.getKey());
                    }
                }
            }
            EvaresultAuditBillEditHandlerEx.addBatchMessageSuccessTips(idSet, "\u9a8c\u8bc1\u6210\u529f", batchMessageTipsHeader);
            batchMessageTipsHeader.setSuccessCount(idList.size() - batchMessageTipsHeader.getFailureCount());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
        batchMessageTipsHeader.setBillId(ids.toString());
        return batchMessageTipsHeader;
    }

    public BigDecimal getLens(String levelID, Map<String, Map<String, Object>> personLevelMap) {
        Map<String, Object> personMap = personLevelMap.get(levelID);
        BigDecimal lens = BigDecimal.ZERO;
        if (null != personMap) {
            lens = (BigDecimal)personMap.get("lens");
        }
        return lens;
    }

    public Map<String, String> beforeAuditProjectEvaResut(Context ctx, String period, String planId, List<String> idList, JSONArray entryList) throws BOSException, SQLException {
        HashMap batchMessage = Maps.newHashMap();
        StringBuilder selParamId = new StringBuilder("''");
        for (int i = 0; i < idList.size(); ++i) {
            selParamId.append(",?");
        }
        Map<String, Map<String, BigDecimal>> personPerformMap = this.getProjectPerformPro(ctx, idList, batchMessage);
        if (null != personPerformMap && personPerformMap.size() > 0) {
            Map<String, Map<String, Object>> personLevelMap = this.getPersonLevelLensMap(ctx, entryList);
            BigDecimal big100 = new BigDecimal(100);
            for (int i = 0; i < entryList.size(); ++i) {
                String auditGradeLevel;
                JSONObject object = entryList.getJSONObject(i);
                String fid = object.getString("id");
                String evaResult = object.getString("evaResult.id");
                String revLevel = auditGradeLevel = object.getString("evaResult.auditGradeLevel");
                if (StrUtil.isBlank((CharSequence)auditGradeLevel)) {
                    batchMessage.put(fid, "\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4");
                    continue;
                }
                StringBuilder sel = new StringBuilder();
                sel.append(" select s1.fid,ppm.CFPROJECTNAME, pp.CFPerobjectIdId, s1.FPERIODID, s1.FEVAPLANID,");
                sel.append(" isnull(s1.FREVISEGRADELEVEL,s1.FGRADELEVEL) revLevel,s1.CFProjectLevel ");
                sel.append(" from T_EVA_EvaResultSummary s1 ");
                sel.append(" left join T_EVA_PerfPlan pp on pp.fid = s1.FEVAPLANID ");
                sel.append(" left join CT_PRO_ProjectManagement ppm on ppm.fid = pp.CFPerobjectIdId ");
                sel.append(" where s1.fid in ('");
                sel.append(evaResult);
                sel.append("') ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString(), (Object[])idList.toArray());
                if (!rs.next()) {
                    batchMessage.put(fid, "\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4");
                    continue;
                }
                String CFPROJECTNAME = rs.getString("CFPROJECTNAME");
                if (StrUtil.isBlank((CharSequence)revLevel)) {
                    batchMessage.put(fid, "\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4");
                    continue;
                }
                String projectLevel = rs.getString("CFProjectLevel");
                if (StrUtil.isBlank((CharSequence)projectLevel)) {
                    String msg = String.format("%s\u9879\u76ee\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a", CFPROJECTNAME);
                    batchMessage.put(fid, msg);
                    continue;
                }
                Map<String, BigDecimal> personPerform = personPerformMap.get(projectLevel);
                if (null == personPerform) {
                    String msg = String.format("\u6ca1\u6709\u627e\u5230%s\u9879\u76ee\u7ee9\u6548\u7b49\u7ea7%s\u7684\u6b63\u6001\u5206\u5e03\u89c4\u5219", CFPROJECTNAME, projectLevel);
                    batchMessage.put(fid, msg);
                    continue;
                }
                HashMap leveList = Maps.newHashMap();
                String keyRevLevelD = "D";
                BigDecimal dLens = this.getLens(keyRevLevelD, personLevelMap);
                leveList.put("D", dLens);
                String keyRevLevelC = "C";
                BigDecimal cLens = this.getLens(keyRevLevelC, personLevelMap);
                leveList.put("C", cLens);
                String keyRevLevelB = "B";
                BigDecimal bLens = this.getLens(keyRevLevelB, personLevelMap);
                leveList.put("B", bLens);
                String keyRevLevelA = "A";
                BigDecimal aLens = this.getLens(keyRevLevelA, personLevelMap);
                leveList.put("A", aLens);
                String keyRevLevelS = "S";
                BigDecimal sLens = this.getLens(keyRevLevelS, personLevelMap);
                leveList.put("S", sLens);
                BigDecimal alls = new BigDecimal(idList.size());
                BigDecimal scale = personPerform.get(revLevel);
                HashMap bigsList = Maps.newHashMap();
                BigDecimal bigS = personPerform.get("S").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("S", bigS);
                BigDecimal bigA = personPerform.get("A").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("A", bigA);
                BigDecimal bigB = personPerform.get("B").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("B", bigB);
                BigDecimal bigC = personPerform.get("C").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("C", bigC);
                BigDecimal bigD = personPerform.get("D").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("D", bigD);
                BigDecimal lens = BigDecimal.ZERO;
                BigDecimal personSize = BigDecimal.ZERO;
                BigDecimal personMaxSize = BigDecimal.ZERO;
                BigDecimal personMinSize = BigDecimal.ZERO;
                BigDecimal personMaxASize = BigDecimal.ZERO;
                BigDecimal personMaxSSize = BigDecimal.ZERO;
                BigDecimal personMinCSize = BigDecimal.ZERO;
                BigDecimal personMinDSize = BigDecimal.ZERO;
                BigDecimal personMinVSize = BigDecimal.ZERO;
                ArrayList ldrs = Lists.newArrayList();
                HashMap ldrcd = Maps.newHashMap();
                switch (auditGradeLevel) {
                    case "A": {
                        personSize = personSize.add(bigA).subtract(aLens);
                        lens = lens.add(aLens);
                        personMaxSize = "A".equals(auditGradeLevel) ? personMaxSize.add(bigA) : personMaxSize.add(bigA.subtract(aLens));
                        personMaxASize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("A\u6700\u591a" + personMaxASize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "S": {
                        personSize = personSize.add(bigS).subtract(sLens);
                        lens = lens.add(sLens);
                        personMaxSize = "S".equals(auditGradeLevel) ? personMaxSize.add(bigS) : personMaxSize.add(bigS.subtract(sLens));
                        personMaxSSize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("S\u6700\u591a" + personMaxSSize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "B": 
                    case "C": {
                        personMinVSize = personMinVSize.add(bigC).subtract(cLens);
                        personMinSize = "C".equals(revLevel) ? personMinSize.add(bigC) : personMinSize.add(bigC.subtract(cLens));
                        personMinCSize = new BigDecimal(bigC.toPlainString());
                    }
                    case "D": {
                        personMinVSize = personMinVSize.add(bigD).subtract(dLens);
                        personMinSize = "D".equals(revLevel) ? personMinSize.add(bigD) : personMinSize.add(bigD.subtract(dLens));
                        personMinDSize = new BigDecimal(bigD.add(bigC).toPlainString());
                    }
                }
                switch (revLevel) {
                    case "A": 
                    case "S": 
                    case "B": {
                        ldrcd.put("C", "C\u6700\u5c11" + (personMinCSize.compareTo(BigDecimal.ZERO) > 0 ? personMinCSize.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "C": {
                        ldrcd.put("C", "C\u6700\u5c11" + (bigC.compareTo(BigDecimal.ZERO) > 0 ? bigC.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "D": {
                        ldrcd.put("D", "D\u6700\u5c11" + bigD + "\u4eba\uff0c");
                    }
                }
                String ld = "\u5f53\u524d\u5468\u671f\u7ee9\u6548\u7b49\u7ea7\u4e3a%l\u7684\u4eba\u6570\u4e3a%maxs\u4eba,";
                if (personMinVSize.compareTo(BigDecimal.ZERO) <= 0 && personSize.compareTo(BigDecimal.ZERO) >= 0) continue;
                if (ldrs.size() > 0) {
                    String ldrstr = (String)ldrs.get(0);
                    ld = ld + ldrstr;
                    ld = ld.replace("%" + revLevel, (personMaxSize.compareTo(BigDecimal.ZERO) > 0 ? personMaxSize : BigDecimal.ZERO).toPlainString());
                }
                ld = ld.replace("%l", revLevel);
                ld = ld.replace("%maxs", (leveList.get(revLevel) == null ? BigDecimal.ZERO : (BigDecimal)leveList.get(revLevel)).toPlainString());
                for (Map.Entry entry : ldrcd.entrySet()) {
                    String eKey = (String)entry.getKey();
                    String ldr = (String)entry.getValue();
                    ld = ld + ldr;
                }
                ld = ld + "\u8bf7\u4fee\u6b63\u540e\u91cd\u65b0\u5ba1\u6838.";
                batchMessage.put(fid, ld);
            }
        }
        return batchMessage;
    }

    public Map<String, String> beforeAuditEvaResut(Context ctx, String period, String planId, List<String> idList, JSONArray entryList) throws BOSException, SQLException {
        HashMap batchMessage = Maps.newHashMap();
        StringBuilder selParamId = new StringBuilder("''");
        for (int i = 0; i < idList.size(); ++i) {
            selParamId.append(",?");
        }
        Map<String, Map<String, BigDecimal>> personPerformMap = this.getPersonPerformPro(ctx, idList, batchMessage);
        if (null != personPerformMap && personPerformMap.size() > 0) {
            Map<String, Map<String, Object>> personLevelMap = this.getPersonLevelLensMap(ctx, entryList);
            BigDecimal big100 = new BigDecimal(100);
            for (int i = 0; i < entryList.size(); ++i) {
                Map<String, BigDecimal> personPerform;
                JSONObject object = entryList.getJSONObject(i);
                String fid = object.getString("id");
                String evaResult = object.getString("evaResult.id");
                String auditGradeLevel = object.getString("evaResult.auditGradeLevel");
                if (StrUtil.isBlank((CharSequence)auditGradeLevel)) {
                    batchMessage.put(fid, "\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4");
                    continue;
                }
                StringBuilder sel = new StringBuilder();
                sel.append(" select ers.fid,ers.FADMINORGNAME,  ");
                sel.append("  ers.FPERIODID, ers.FEVAPLANID,isnull(ers.FREVISEGRADELEVEL, ers.FGRADELEVEL) revLevel,ers.CFOrgLevel  ");
                sel.append(" from T_EVA_EvaResultSummary ers where ers.fid = '");
                sel.append(evaResult);
                sel.append("' ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString());
                String orgLevel = "";
                String FADMINORGNAME = "";
                if (rs.next()) {
                    orgLevel = rs.getString("CFOrgLevel");
                    FADMINORGNAME = rs.getString("FADMINORGNAME");
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgLevel)) {
                        String msg = String.format("%s\u4e0a\u5b63\u5ea6\u7ec4\u7ec7\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a", FADMINORGNAME);
                        batchMessage.put(fid, msg);
                        continue;
                    }
                }
                if (null == (personPerform = personPerformMap.get(orgLevel))) {
                    String msg = String.format("\u6ca1\u6709\u627e\u5230%s\u4e0a\u5b63\u5ea6\u7ec4\u7ec7\u7ee9\u6548\u7b49\u7ea7%s\u7684\u6b63\u6001\u5206\u5e03\u89c4\u5219", FADMINORGNAME, orgLevel);
                    batchMessage.put(fid, msg);
                    continue;
                }
                HashMap leveList = Maps.newHashMap();
                String keyRevLevelD = "D";
                BigDecimal dLens = this.getLens(keyRevLevelD, personLevelMap);
                leveList.put("D", dLens);
                String keyRevLevelC = "C";
                BigDecimal cLens = this.getLens(keyRevLevelC, personLevelMap);
                leveList.put("C", cLens);
                String keyRevLevelB = "B";
                BigDecimal bLens = this.getLens(keyRevLevelB, personLevelMap);
                leveList.put("B", bLens);
                String keyRevLevelA = "A";
                BigDecimal aLens = this.getLens(keyRevLevelA, personLevelMap);
                leveList.put("A", aLens);
                String keyRevLevelS = "S";
                BigDecimal sLens = this.getLens(keyRevLevelS, personLevelMap);
                leveList.put("S", sLens);
                System.out.println("leveList:" + leveList);
                BigDecimal alls = new BigDecimal(idList.size());
                BigDecimal scale = personPerform.get(auditGradeLevel);
                HashMap bigsList = Maps.newHashMap();
                BigDecimal bigS = personPerform.get("S").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("S", bigS);
                BigDecimal bigA = personPerform.get("A").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("A", bigA);
                BigDecimal bigB = personPerform.get("B").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("B", bigB);
                BigDecimal bigC = personPerform.get("C").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("C", bigC);
                BigDecimal bigD = personPerform.get("D").divide(big100, 4, 4).multiply(alls).setScale(0, 4);
                bigsList.put("D", bigD);
                System.out.println("bigsList:" + bigsList);
                BigDecimal lens = BigDecimal.ZERO;
                BigDecimal personSize = BigDecimal.ZERO;
                BigDecimal personMaxSize = BigDecimal.ZERO;
                BigDecimal personMinSize = BigDecimal.ZERO;
                BigDecimal personMaxASize = BigDecimal.ZERO;
                BigDecimal personMaxSSize = BigDecimal.ZERO;
                BigDecimal personMinCSize = BigDecimal.ZERO;
                BigDecimal personMinDSize = BigDecimal.ZERO;
                BigDecimal personMinVSize = BigDecimal.ZERO;
                ArrayList ldrs = Lists.newArrayList();
                HashMap ldrcd = Maps.newHashMap();
                switch (auditGradeLevel) {
                    case "A": {
                        personSize = personSize.add(bigA).subtract(aLens);
                        lens = lens.add(aLens);
                        personMaxSize = "A".equals(auditGradeLevel) ? personMaxSize.add(bigA) : personMaxSize.add(bigA.subtract(aLens));
                        personMaxASize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("A\u6700\u591a" + personMaxASize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "S": {
                        personSize = personSize.add(bigS).subtract(sLens);
                        lens = lens.add(sLens);
                        personMaxSize = "S".equals(auditGradeLevel) ? personMaxSize.add(bigS) : personMaxSize.add(bigS.subtract(sLens));
                        personMaxSSize = new BigDecimal(personMaxSize.toPlainString());
                        ldrs.add("S\u6700\u591a" + personMaxSSize.toPlainString() + "\u4eba\uff0c");
                    }
                    case "B": 
                    case "C": {
                        personMinVSize = personMinVSize.add(bigC).subtract(cLens);
                        personMinSize = "C".equals(auditGradeLevel) ? personMinSize.add(bigC) : personMinSize.add(bigC.subtract(cLens));
                        personMinCSize = new BigDecimal(bigC.toPlainString());
                    }
                    case "D": {
                        personMinVSize = personMinVSize.add(bigD).subtract(dLens);
                        personMinSize = "D".equals(auditGradeLevel) ? personMinSize.add(bigD) : personMinSize.add(bigD.subtract(dLens));
                        personMinDSize = new BigDecimal(bigD.add(bigC).toPlainString());
                    }
                }
                switch (auditGradeLevel) {
                    case "A": 
                    case "S": 
                    case "B": {
                        ldrcd.put("C", "C\u6700\u5c11" + (personMinCSize.compareTo(BigDecimal.ZERO) > 0 ? personMinCSize.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "C": {
                        ldrcd.put("C", "C\u6700\u5c11" + (bigC.compareTo(BigDecimal.ZERO) > 0 ? bigC.toPlainString() : Character.valueOf('0')) + "\u4eba\u6216\u8005D\u6700\u5c11" + (personMinDSize.compareTo(BigDecimal.ZERO) > 0 ? personMinDSize.toPlainString() : "0") + "\u4eba\uff0c");
                        break;
                    }
                    case "D": {
                        ldrcd.put("D", "D\u6700\u5c11" + bigD + "\u4eba\uff0c");
                    }
                }
                String ld = "\u5f53\u524d\u5468\u671f\u7ee9\u6548\u7b49\u7ea7\u4e3a%l\u7684\u4eba\u6570\u4e3a%maxs\u4eba,";
                if (personMinVSize.compareTo(BigDecimal.ZERO) <= 0 && personSize.compareTo(BigDecimal.ZERO) >= 0) continue;
                if (ldrs.size() > 0) {
                    String ldrstr = (String)ldrs.get(0);
                    ld = ld + ldrstr;
                    ld = ld.replace("%" + auditGradeLevel, (personMaxSize.compareTo(BigDecimal.ZERO) > 0 ? personMaxSize : BigDecimal.ZERO).toPlainString());
                }
                ld = ld.replace("%l", auditGradeLevel);
                ld = ld.replace("%maxs", (leveList.get(auditGradeLevel) == null ? BigDecimal.ZERO : (BigDecimal)leveList.get(auditGradeLevel)).toPlainString());
                for (Map.Entry entry : ldrcd.entrySet()) {
                    String eKey = (String)entry.getKey();
                    String ldr = (String)entry.getValue();
                    ld = ld + ldr;
                }
                ld = ld + "\u8bf7\u4fee\u6b63\u540e\u91cd\u65b0\u5ba1\u6838.";
                batchMessage.put(fid, ld);
            }
        }
        return batchMessage;
    }

    protected void verifyModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
    }
}

