/*
 * Decompiled with CFR 0.152.
 */
package bos.org.apache.commons.dbutils;

import bos.org.apache.commons.dbutils.RowProcessor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicRowProcessor
implements RowProcessor {
    private static final Map primitiveDefaults = new HashMap();
    private static final int PROPERTY_NOT_FOUND = -1;
    private static final BasicRowProcessor instance;

    public static BasicRowProcessor instance() {
        return instance;
    }

    protected BasicRowProcessor() {
    }

    @Override
    public Object[] toArray(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        Object[] result = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            result[i] = rs.getObject(i + 1);
        }
        return result;
    }

    @Override
    public Object toBean(ResultSet rs, Class type) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        int cols = rsmd.getColumnCount();
        return this.createBean(rs, type, props, columnToProperty, cols);
    }

    @Override
    public List toBeanList(ResultSet rs, Class type) throws SQLException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (!rs.next()) {
            return results;
        }
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        int cols = rsmd.getColumnCount();
        do {
            results.add(this.createBean(rs, type, props, columnToProperty, cols));
        } while (rs.next());
        return results;
    }

    private Object createBean(ResultSet rs, Class type, PropertyDescriptor[] props, int[] columnToProperty, int cols) throws SQLException {
        Object bean = this.newInstance(type);
        for (int i = 1; i <= cols; ++i) {
            if (columnToProperty[i] == -1) continue;
            Object value = rs.getObject(i);
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<?> propType = prop.getPropertyType();
            if (propType != null && value == null && propType.isPrimitive()) {
                value = primitiveDefaults.get(propType);
            }
            this.callSetter(bean, prop, value);
        }
        return bean;
    }

    private int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        block0: for (int col = 1; col <= cols; ++col) {
            String columnName = rsmd.getColumnName(col);
            for (int i = 0; i < props.length; ++i) {
                if (columnName.equalsIgnoreCase(props[i].getName())) {
                    columnToProperty[col] = i;
                    continue block0;
                }
                columnToProperty[col] = -1;
            }
        }
        return columnToProperty;
    }

    @Override
    public Map toMap(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap result = new CaseInsensitiveHashMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            result.put(rsmd.getColumnName(i), rs.getObject(i));
        }
        return result;
    }

    private void callSetter(Object target, PropertyDescriptor prop, Object value) throws SQLException {
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            return;
        }
        Class<?>[] params = setter.getParameterTypes();
        try {
            if (this.isCompatibleType(value, params[0])) {
                setter.invoke(target, value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
    }

    private boolean isCompatibleType(Object value, Class type) {
        if (value == null || type.isInstance(value)) {
            return true;
        }
        if (type.equals(Integer.TYPE) && Integer.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Long.TYPE) && Long.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Double.TYPE) && Double.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Float.TYPE) && Float.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Short.TYPE) && Short.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Byte.TYPE) && Byte.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Character.TYPE) && Character.class.isInstance(value)) {
            return true;
        }
        return type.equals(Boolean.TYPE) && Boolean.class.isInstance(value);
    }

    private Object newInstance(Class c) throws SQLException {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class c) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    static {
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
        instance = new BasicRowProcessor();
    }

    private static class CaseInsensitiveHashMap
    extends HashMap {
        private CaseInsensitiveHashMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key.toString().toLowerCase());
        }

        @Override
        public Object get(Object key) {
            return super.get(key.toString().toLowerCase());
        }

        @Override
        public Object put(Object key, Object value) {
            return super.put(key.toString().toLowerCase(), value);
        }

        @Override
        public void putAll(Map m) {
            for (Object key : m.keySet()) {
                Object value = m.get(key);
                this.put(key, value);
            }
        }

        @Override
        public Object remove(Object key) {
            return super.remove(key.toString().toLowerCase());
        }
    }
}

