/*
 * Decompiled with CFR 0.152.
 */
package bos.org.apache.commons.dbutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class QueryLoader {
    private static Logger logger = Logger.getLogger(QueryLoader.class);
    private static final QueryLoader instance = new QueryLoader();
    private Map queries = new HashMap();

    public static QueryLoader instance() {
        return instance;
    }

    protected QueryLoader() {
    }

    public synchronized Map load(String path) throws IOException {
        Map queryMap = (Map)this.queries.get(path);
        if (queryMap == null) {
            queryMap = this.loadQueries(path);
            this.queries.put(path, queryMap);
        }
        return queryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadQueries(String path) throws IOException {
        InputStream in = null;
        try {
            in = QueryLoader.class.getResourceAsStream(path);
            if (in == null) {
                throw new IllegalArgumentException(path + " not found.");
            }
            Properties props = new Properties();
            props.load(in);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(props);
            return hashMap;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close inputStream error!", (Throwable)e);
            }
        }
    }

    public synchronized void unload(String path) {
        this.queries.remove(path);
    }
}

