/*
 * Decompiled with CFR 0.152.
 */
package bos.org.apache.commons.dbutils;

import bos.org.apache.commons.dbutils.DbUtils;
import bos.org.apache.commons.dbutils.ResultSetHandler;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;

public class QueryRunner {
    protected DataSource ds = null;

    public QueryRunner() {
    }

    public QueryRunner(DataSource ds) {
        this.ds = ds;
    }

    public void fillStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) {
                stmt.setObject(i + 1, params[i]);
                continue;
            }
            stmt.setNull(i + 1, 1111);
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    public Object query(Connection conn, String sql, Object param, ResultSetHandler rsh) throws SQLException {
        return this.query(conn, sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object query(Connection conn, String sql, Object[] params, ResultSetHandler rsh) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Object result = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rs = this.wrap(stmt.executeQuery());
            result = rsh.handle(rs);
            try {
                this.close(rs);
                return result;
            }
            finally {
                this.close(stmt);
            }
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
            return result;
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
            }
        }
    }

    public Object query(Connection conn, String sql, ResultSetHandler rsh) throws SQLException {
        return this.query(conn, sql, null, rsh);
    }

    public Object query(String sql, Object param, ResultSetHandler rsh) throws SQLException {
        return this.query(sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(String sql, Object[] params, ResultSetHandler rsh) throws SQLException {
        Connection conn = this.ds.getConnection();
        try {
            Object object = this.query(conn, sql, params, rsh);
            return object;
        }
        finally {
            this.close(conn);
        }
    }

    public Object query(String sql, ResultSetHandler rsh) throws SQLException {
        return this.query(sql, (Object[])null, rsh);
    }

    protected void rethrow(SQLException cause, String sql, Object[] params) throws SQLException {
        StringBuffer msg = new StringBuffer(cause.getMessage());
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.asList(params));
        }
        SQLException e = new SQLException(msg.toString());
        e.setNextException(cause);
        throw e;
    }

    public void setDataSource(DataSource dataSource) {
        this.ds = dataSource;
    }

    public int update(Connection conn, String sql) throws SQLException {
        return this.update(conn, sql, null);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        return this.update(conn, sql, new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rows = stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    public int update(String sql) throws SQLException {
        return this.update(sql, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCall(String sql) throws SQLException {
        Connection conn = this.ds.getConnection();
        try {
            CallableStatement cstmt = conn.prepareCall(sql);
            cstmt.executeUpdate();
        }
        finally {
            this.close(conn);
        }
    }

    public int update(String sql, Object param) throws SQLException {
        return this.update(sql, new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object[] params) throws SQLException {
        Connection conn = this.ds.getConnection();
        try {
            int n = this.update(conn, sql, params);
            return n;
        }
        finally {
            this.close(conn);
        }
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryIsExist(Connection conn, String sql, Object[] params) throws SQLException {
        boolean result;
        block5: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            result = false;
            try {
                stmt = this.prepareStatement(conn, sql);
                this.fillStatement(stmt, params);
                rs = stmt.executeQuery();
                result = rs.next();
                DbUtils.close(rs);
            }
            catch (SQLException e) {
                this.rethrow(e, sql, params);
                break block5;
            }
            finally {
                DbUtils.close(rs);
                DbUtils.close(stmt);
            }
            DbUtils.close(stmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryIsExist(String sql, Object[] params) throws SQLException {
        Connection conn = this.ds.getConnection();
        try {
            boolean bl = this.queryIsExist(conn, sql, params);
            return bl;
        }
        finally {
            this.close(conn);
        }
    }

    public boolean queryIsExist(String sql) throws SQLException {
        return this.queryIsExist(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        PreparedStatement stmt = null;
        int[] rows = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            for (int i = 0; i < params.length; ++i) {
                this.fillStatement(stmt, params[i]);
                stmt.addBatch();
            }
            rows = stmt.executeBatch();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, (Object[])params);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(String sql, Object[][] params) throws SQLException {
        Connection conn = this.prepareConnection();
        try {
            int[] nArray = this.batch(conn, sql, params);
            return nArray;
        }
        finally {
            this.close(conn);
        }
    }

    protected Connection prepareConnection() throws SQLException {
        if (this.getDataSource() == null) {
            throw new SQLException("QueryRunner requires a DataSource to be invoked in this way, or a Connection should be passed in");
        }
        return this.getDataSource().getConnection();
    }

    protected void close(Connection conn) throws SQLException {
        DbUtils.close(conn);
    }

    protected void close(Statement stmt) throws SQLException {
        DbUtils.close(stmt);
    }

    protected void close(ResultSet rs) throws SQLException {
        DbUtils.close(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batchByList(String sql, List paramsList) throws SQLException {
        Connection conn = this.prepareConnection();
        try {
            int[] nArray = this.batchByList(conn, sql, paramsList);
            return nArray;
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batchByList(Connection conn, String sql, List paramsList) throws SQLException {
        PreparedStatement stmt = null;
        int[] rows = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            Object[] params = null;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        stmt.setObject(j + 1, params[j]);
                        continue;
                    }
                    stmt.setNull(j + 1, 12);
                }
                stmt.addBatch();
            }
            rows = stmt.executeBatch();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, null);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet Query(String sql, Object[] params) throws SQLException {
        Connection conn = this.prepareConnection();
        try {
            ResultSet resultSet = this.Query(conn, sql, params);
            return resultSet;
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ResultSet Query(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        stmt = this.prepareStatement(conn, sql);
        this.fillStatement(stmt, params);
        rs = stmt.executeQuery();
        try {
            this.close(rs);
        }
        finally {
            this.close(stmt);
        }
        catch (SQLException e) {
            try {
                this.rethrow(e, sql, params);
            }
            catch (Throwable throwable) {
                try {
                    this.close(rs);
                }
                finally {
                    this.close(stmt);
                }
                throw throwable;
            }
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
            }
        }
        return rs;
    }
}

