/*
 * Decompiled with CFR 0.152.
 */
package bos.org.apache.commons.pool.impl;

import bos.org.apache.commons.pool.BaseObjectPool;
import bos.org.apache.commons.pool.ObjectPool;
import bos.org.apache.commons.pool.PoolableObjectFactory;
import bos.org.apache.commons.pool.impl.CursorableLinkedList;
import bos.org.apache.commons.pool.impl.EvictionTimer;
import bos.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimerTask;

public class GenericObjectPool
extends BaseObjectPool
implements ObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final boolean DEFAULT_LIFO = true;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final long DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = -1L;
    private int _maxIdle = 8;
    private int _minIdle = 0;
    private int _maxActive = 8;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private volatile boolean _testOnBorrow = false;
    private volatile boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private long _softMinEvictableIdleTimeMillis = -1L;
    private boolean _lifo = true;
    private CursorableLinkedList _pool = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;
    private Evictor _evictor = null;

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle, config.softMinEvictableIdleTimeMillis, config.lifo);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, -1L);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle, long softMinEvictableIdleTimeMillis) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, softMinEvictableIdleTimeMillis, true);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle, long softMinEvictableIdleTimeMillis, boolean lifo) {
        this._factory = factory;
        this._maxActive = maxActive;
        this._lifo = lifo;
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
        this._maxWait = maxWait;
        this._maxIdle = maxIdle;
        this._minIdle = minIdle;
        this._testOnBorrow = testOnBorrow;
        this._testOnReturn = testOnReturn;
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this._softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
        this._testWhileIdle = testWhileIdle;
        this._pool = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
        this.notifyAll();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte whenExhaustedAction) {
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
        this.notifyAll();
    }

    public synchronized int getMaxIdle() {
        return this._maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
        this.notifyAll();
    }

    public synchronized void setMinIdle(int minIdle) {
        this._minIdle = minIdle;
        this.notifyAll();
    }

    public synchronized int getMinIdle() {
        return this._minIdle;
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this._testOnBorrow = testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this._testOnReturn = testOnReturn;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this._softMinEvictableIdleTimeMillis;
    }

    public synchronized void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this._softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this._testWhileIdle = testWhileIdle;
    }

    public synchronized boolean getLifo() {
        return this._lifo;
    }

    public synchronized void setLifo(boolean lifo) {
        this._lifo = lifo;
    }

    public synchronized void setConfig(Config conf) {
        this.setMaxIdle(conf.maxIdle);
        this.setMinIdle(conf.minIdle);
        this.setMaxActive(conf.maxActive);
        this.setMaxWait(conf.maxWait);
        this.setWhenExhaustedAction(conf.whenExhaustedAction);
        this.setTestOnBorrow(conf.testOnBorrow);
        this.setTestOnReturn(conf.testOnReturn);
        this.setTestWhileIdle(conf.testWhileIdle);
        this.setNumTestsPerEvictionRun(conf.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(conf.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(conf.timeBetweenEvictionRunsMillis);
        this.setSoftMinEvictableIdleTimeMillis(conf.softMinEvictableIdleTimeMillis);
        this.setLifo(conf.lifo);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object borrowObject() throws Exception {
        long starttime = System.currentTimeMillis();
        block28: while (true) {
            GenericKeyedObjectPool.ObjectTimestampPair pair = null;
            GenericObjectPool genericObjectPool = this;
            synchronized (genericObjectPool) {
                this.assertOpen();
                try {
                    pair = (GenericKeyedObjectPool.ObjectTimestampPair)this._pool.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                if (null == pair && this._maxActive >= 0 && this._numActive >= this._maxActive) {
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException("Pool exhausted");
                        }
                        case 1: {
                            try {
                                if (this._maxWait <= 0L) {
                                    this.wait();
                                } else {
                                    long elapsed = System.currentTimeMillis() - starttime;
                                    long waitTime = this._maxWait - elapsed;
                                    if (waitTime > 0L) {
                                        this.wait(waitTime);
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw e;
                            }
                            if (this._maxWait > 0L && System.currentTimeMillis() - starttime >= this._maxWait) {
                                throw new NoSuchElementException("Timeout waiting for idle object");
                            }
                            continue block28;
                        }
                        default: {
                            throw new IllegalArgumentException("WhenExhaustedAction property " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
                ++this._numActive;
            }
            boolean newlyCreated = false;
            if (null == pair) {
                Object obj;
                try {
                    obj = this._factory.makeObject();
                    pair = new GenericKeyedObjectPool.ObjectTimestampPair(obj);
                    newlyCreated = true;
                }
                finally {
                    if (!newlyCreated) {
                        obj = this;
                        synchronized (obj) {
                            --this._numActive;
                            this.notifyAll();
                        }
                    }
                }
            }
            try {
                this._factory.activateObject(pair.value);
                if (!this._testOnBorrow || this._factory.validateObject(pair.value)) return pair.value;
                throw new Exception("ValidateObject failed");
            }
            catch (Throwable e) {
                try {
                    this._factory.destroyObject(pair.value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                GenericObjectPool genericObjectPool2 = this;
                synchronized (genericObjectPool2) {
                    --this._numActive;
                    this.notifyAll();
                }
                if (newlyCreated) throw new NoSuchElementException("Could not create a validated object, cause: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(Object obj) throws Exception {
        try {
            if (this._factory != null) {
                this._factory.destroyObject(obj);
            }
        }
        finally {
            GenericObjectPool genericObjectPool = this;
            synchronized (genericObjectPool) {
                --this._numActive;
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void clear() {
        Iterator it = this._pool.iterator();
        while (it.hasNext()) {
            try {
                this._factory.destroyObject(((GenericKeyedObjectPool.ObjectTimestampPair)it.next()).value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            it.remove();
        }
        this._pool.clear();
        this.notifyAll();
    }

    @Override
    public synchronized int getNumActive() {
        return this._numActive;
    }

    @Override
    public synchronized int getNumIdle() {
        return this._pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object obj) throws Exception {
        block7: {
            try {
                this.addObjectToPool(obj, true);
            }
            catch (Exception e) {
                if (this._factory == null) break block7;
                try {
                    this._factory.destroyObject(obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GenericObjectPool genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numActive;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectToPool(Object obj, boolean decrementNumActive) throws Exception {
        boolean success = true;
        if (this._testOnReturn && !this._factory.validateObject(obj)) {
            success = false;
        } else {
            this._factory.passivateObject(obj);
        }
        boolean shouldDestroy = !success;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            if (this.isClosed()) {
                shouldDestroy = true;
            } else if (this._maxIdle >= 0 && this._pool.size() >= this._maxIdle) {
                shouldDestroy = true;
            } else if (success) {
                if (this._lifo) {
                    this._pool.addFirst(new GenericKeyedObjectPool.ObjectTimestampPair(obj));
                } else {
                    this._pool.addLast(new GenericKeyedObjectPool.ObjectTimestampPair(obj));
                }
            }
        }
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (decrementNumActive) {
            genericObjectPool = this;
            synchronized (genericObjectPool) {
                --this._numActive;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        super.close();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.clear();
            this.startEvictor(-1L);
        }
    }

    @Override
    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    public synchronized void evict() throws Exception {
        this.assertOpen();
        if (!this._pool.isEmpty()) {
            if (null == this._evictionCursor) {
                this._evictionCursor = this._pool.cursor(this._lifo ? this._pool.size() : 0);
            }
            int m = this.getNumTests();
            for (int i = 0; i < m; ++i) {
                if (this._lifo && !this._evictionCursor.hasPrevious() || !this._lifo && !this._evictionCursor.hasNext()) {
                    this._evictionCursor.close();
                    this._evictionCursor = this._pool.cursor(this._lifo ? this._pool.size() : 0);
                }
                boolean removeObject = false;
                GenericKeyedObjectPool.ObjectTimestampPair pair = this._lifo ? (GenericKeyedObjectPool.ObjectTimestampPair)this._evictionCursor.previous() : (GenericKeyedObjectPool.ObjectTimestampPair)this._evictionCursor.next();
                long idleTimeMilis = System.currentTimeMillis() - pair.tstamp;
                if (this._minEvictableIdleTimeMillis > 0L && idleTimeMilis > this._minEvictableIdleTimeMillis) {
                    removeObject = true;
                } else if (this._softMinEvictableIdleTimeMillis > 0L && idleTimeMilis > this._softMinEvictableIdleTimeMillis && this.getNumIdle() > this.getMinIdle()) {
                    removeObject = true;
                }
                if (this._testWhileIdle && !removeObject) {
                    boolean active = false;
                    try {
                        this._factory.activateObject(pair.value);
                        active = true;
                    }
                    catch (Exception e) {
                        removeObject = true;
                    }
                    if (active) {
                        if (!this._factory.validateObject(pair.value)) {
                            removeObject = true;
                        } else {
                            try {
                                this._factory.passivateObject(pair.value);
                            }
                            catch (Exception e) {
                                removeObject = true;
                            }
                        }
                    }
                }
                if (!removeObject) continue;
                try {
                    this._evictionCursor.remove();
                    this._factory.destroyObject(pair.value);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void ensureMinIdle() throws Exception {
        int objectDeficit = this.calculateDeficit();
        for (int j = 0; j < objectDeficit && this.calculateDeficit() > 0; ++j) {
            this.addObject();
        }
    }

    private synchronized int calculateDeficit() {
        int objectDeficit = this.getMinIdle() - this.getNumIdle();
        if (this._maxActive > 0) {
            int growLimit = Math.max(0, this.getMaxActive() - this.getNumActive() - this.getNumIdle());
            objectDeficit = Math.min(objectDeficit, growLimit);
        }
        return objectDeficit;
    }

    @Override
    public synchronized void addObject() throws Exception {
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        Object obj = this._factory.makeObject();
        try {
            this.assertOpen();
            this.addObjectToPool(obj, false);
        }
        catch (IllegalStateException ex) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected synchronized void startEvictor(long delay) {
        if (null != this._evictor) {
            EvictionTimer.cancel(this._evictor);
            this._evictor = null;
        }
        if (delay > 0L) {
            this._evictor = new Evictor();
            EvictionTimer.schedule(this._evictor, delay, delay);
        }
    }

    synchronized String debugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Active: ").append(this.getNumActive()).append("\n");
        buf.append("Idle: ").append(this.getNumIdle()).append("\n");
        buf.append("Idle Objects:\n");
        Iterator it = this._pool.iterator();
        long time = System.currentTimeMillis();
        while (it.hasNext()) {
            GenericKeyedObjectPool.ObjectTimestampPair pair = (GenericKeyedObjectPool.ObjectTimestampPair)it.next();
            buf.append("\t").append(pair.value).append("\t").append(time - pair.tstamp).append("\n");
        }
        return buf.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return Math.min(this._numTestsPerEvictionRun, this._pool.size());
        }
        return (int)Math.ceil((double)this._pool.size() / Math.abs((double)this._numTestsPerEvictionRun));
    }

    public static class Config {
        public int maxIdle = 8;
        public int minIdle = 0;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
        public long softMinEvictableIdleTimeMillis = -1L;
        public boolean lifo = true;
    }

    private class Evictor
    extends TimerTask {
        private Evictor() {
        }

        @Override
        public void run() {
            try {
                GenericObjectPool.this.evict();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                GenericObjectPool.this.ensureMinIdle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

