/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config;

import com.kingdee.bos.Context;
import com.kingdee.bos.config.IConfigService;
import com.kingdee.bos.config.IScopeNode;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import com.kingdee.bos.config.impl.client.ClientConfigServiceImpl;
import com.kingdee.bos.config.impl.server.ServerConfigServiceImpl;

public final class ConfigServiceFactory {
    private static boolean isClientEnv;
    private static boolean isInited;
    private static ConfigServiceImpl service;

    public static synchronized void clear() {
        isInited = false;
        service = null;
    }

    public static synchronized void initClientConfigService() {
        if (!isInited) {
            isClientEnv = true;
            service = new ClientConfigServiceImpl();
            service.start();
            isInited = true;
        } else if (!isClientEnv) {
            throw new IllegalStateException("Config Service is NOT ClientImpl.");
        }
    }

    public static synchronized IConfigService getConfigService() {
        if (isInited) {
            return service;
        }
        throw new IllegalStateException("Config Service NOT inited, 1.\u8bf7\u68c0\u67e5RPC\u7aef\u53e3\u662f\u5426\u76f4\u8fde\u4e86server1.\n2.\u82e5RPC\u7aef\u53e3\u672a\u76f4\u8fdeserver1\uff0c\u68c0\u67e5\u670d\u52a1\u7aef\u5404\u4e2a\u5b9e\u4f8b\u4e0beas/server/profiles/server(N)/config/listenerconfig.data\u6587\u4ef6\uff0c\n\u4e0elistenerconfig_ll.data\u6587\u4ef6\u914d\u7f6e\u662f\u5426\u4e00\u81f4\uff08\u4ee5listenerconfig_ll.data\u4e3a\u51c6\uff09\u3002");
    }

    public static synchronized void initServerConfigService() {
        if (!isInited) {
            isClientEnv = false;
            service = new ServerConfigServiceImpl();
            service.start();
            isInited = true;
        } else if (isClientEnv) {
            throw new IllegalStateException("Config Service is NOT ServerImpl.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IScopeNode findScope(String level) {
        if (level == null) {
            throw new IllegalStateException("Level is null, can NOT found Scope.");
        }
        if (!isInited) {
            throw new IllegalStateException("ConfigService NOT Inited, please init first.");
        }
        if ("default".equals(level)) {
            throw new IllegalStateException("Can NOT found Default Scope.");
        }
        if ("install".equals(level)) {
            return service.getInstallScope();
        }
        if ("instance".equals(level)) {
            return service.getInstanceScope();
        }
        if (!isClientEnv) throw new IllegalStateException("Server Side Need Context.");
        ClientConfigServiceImpl client = (ClientConfigServiceImpl)service;
        if ("session".equals(level)) {
            return client.getSessionScope();
        }
        if (!client.canConnection2Server()) throw new IllegalStateException("Client NOT Login.");
        if ("dc".equals(level)) {
            return client.getDcScope();
        }
        if (!"user".equals(level)) throw new IllegalStateException("Incorrect Level.");
        return client.getUserScope();
    }

    public static IScopeNode findScope(Context ctx, String level) {
        if (level == null) {
            throw new IllegalStateException("Level is null, can NOT found Scope.");
        }
        if (!isInited) {
            throw new IllegalStateException("ConfigService NOT Inited, please init first.");
        }
        if ("default".equals(level)) {
            throw new IllegalStateException("Can NOT found Default Scope.");
        }
        if ("install".equals(level)) {
            return service.getInstallScope();
        }
        if ("instance".equals(level)) {
            return service.getInstanceScope();
        }
        if (!isClientEnv) {
            ServerConfigServiceImpl server = (ServerConfigServiceImpl)service;
            if ("session".equals(level)) {
                return server.getSessionScope(ctx);
            }
            if ("dc".equals(level)) {
                return server.getDcScope(ctx);
            }
            if ("user".equals(level)) {
                return server.getUserScope(ctx);
            }
        } else {
            throw new IllegalStateException("Client Side NO Context, invoke findScope(String level) instead.");
        }
        throw new IllegalStateException("Incorrect Level.");
    }

    public static IScopeNode[] findScopes(String[] levels) {
        if (levels == null || levels.length == 0) {
            throw new IllegalStateException("Levels is null, can NOT found Scope.");
        }
        IScopeNode[] rtv = new IScopeNode[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            rtv[i] = ConfigServiceFactory.findScope(levels[i]);
        }
        return rtv;
    }

    public static IScopeNode[] findScopes(Context ctx, String[] levels) {
        if (levels == null || levels.length == 0) {
            throw new IllegalStateException("Levels is null, can NOT found Scope.");
        }
        IScopeNode[] rtv = new IScopeNode[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            rtv[i] = ConfigServiceFactory.findScope(ctx, levels[i]);
        }
        return rtv;
    }

    static {
        isInited = false;
    }
}

