/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config;

import com.kingdee.bos.config.ConfigServiceFactory;
import com.kingdee.bos.config.listener.CommonListenerManager;
import com.kingdee.bos.shell.ScriptServer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class ServerConfigServiceInitializer
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(ServerConfigServiceInitializer.class);

    public void contextInitialized(ServletContextEvent e) {
        try {
            logger.info((Object)"+++ set system property");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.setProperty("BOS_HOME", System.getProperty("EAS_HOME"));
                }
            });
            logger.info((Object)"+++ init server config service");
            ConfigServiceFactory.initServerConfigService();
        }
        catch (Throwable t) {
            logger.warn((Object)"init server config error.", t);
        }
        try {
            logger.info((Object)"+++ init CommonListenerManager");
            new CommonListenerManager().contextInitialized(e);
        }
        catch (Throwable t) {
            logger.warn((Object)("CommonListenerManager.contextInitialized error: " + (t.getClass() != null ? t.getClass().getName() : "") + ":" + t.getMessage()));
            logger.debug((Object)"CommonListenerManager.contextInitialized error: ", t);
        }
        logger.info((Object)"+++ init plugin service");
        ServerConfigServiceInitializer.initPluginService(e);
        ServerConfigServiceInitializer.initScriptServer();
    }

    public static void initPluginService(ServletContextEvent e) {
        ServerConfigServiceInitializer.contextInitialized("com.kingdee.eas.ep.plugin.PluginServiceListener", e);
    }

    private static void initScriptServer() {
        ScriptServer.start();
    }

    private static void contextInitialized(String listenerName, ServletContextEvent e) {
        logger.info((Object)("BEGIN INIT LISTENER [" + listenerName + "]"));
        try {
            Class<?> clazz = Class.forName(listenerName);
            Object obj = clazz.newInstance();
            Method m = clazz.getMethod("contextInitialized", ServletContextEvent.class);
            m.invoke(obj, e);
        }
        catch (Throwable t) {
            logger.warn((Object)(listenerName + ".contextInitialized error: " + (t.getClass() != null ? t.getClass().getName() : "") + ":" + t.getMessage()));
            logger.debug((Object)(listenerName + ".contextInitialized error: "), t);
        }
        logger.info((Object)("END INIT LISTENER [" + listenerName + "]"));
    }

    public void contextDestroyed(ServletContextEvent e) {
        ScriptServer.stop();
    }
}

