/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl;

import com.kingdee.bos.config.IModuleNode;
import com.kingdee.bos.config.IScopeNode;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericModule
implements IModuleNode {
    private final String name;
    private final IScopeNode scope;
    protected Map values = new HashMap();
    protected volatile long lastModified = 0L;

    public GenericModule(IScopeNode scopeNode, String moduleName) {
        this.scope = scopeNode;
        this.name = moduleName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map getKeyValues() {
        return this.values;
    }

    @Override
    public synchronized String get(String key) {
        this.lastModified = System.currentTimeMillis();
        return (String)this.values.get(key);
    }

    @Override
    public synchronized void set(String key, String value) {
        this.lastModified = System.currentTimeMillis();
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
    }

    public void fill(Map initConfigs) {
        if (initConfigs == null || initConfigs.isEmpty()) {
            return;
        }
        for (Map.Entry entry : initConfigs.entrySet()) {
            String key = (String)entry.getKey();
            ConfigServiceImpl servImpl = (ConfigServiceImpl)this.scope.getService();
            key = servImpl.internString(key);
            String value = (String)entry.getValue();
            value = servImpl.internString(value);
            this.values.put(key, value);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }
}

