/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl;

import com.kingdee.bos.config.IConfigService;
import com.kingdee.bos.config.IModuleNode;
import com.kingdee.bos.config.IScopeNode;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class GenericScope
implements IScopeNode {
    protected final String name;
    protected final String level;
    protected final ConfigServiceImpl service;
    protected Map modules = new HashMap();
    protected Map missionModuleNames = new HashMap();
    private static final long MODULE_EXPRIOD = 1800000L;

    protected GenericScope(String level, String name, ConfigServiceImpl service) {
        this.level = level;
        this.name = name;
        this.service = service;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getScopeLevel() {
        return this.level;
    }

    @Override
    public final IConfigService getService() {
        return this.service;
    }

    protected synchronized IModuleNode getModule(String module) {
        IModuleNode rtv = (IModuleNode)this.modules.get(module);
        if (rtv != null) {
            return rtv;
        }
        if (this.missionModuleNames.containsKey(module)) {
            return null;
        }
        rtv = this.initModule(module);
        return rtv;
    }

    @Override
    public synchronized String get(String key, String module) {
        IModuleNode moduleNode = this.getModule(module);
        if (moduleNode != null) {
            return moduleNode.get(key);
        }
        return null;
    }

    @Override
    public synchronized void set(String key, String module, String value) {
        IModuleNode moduleNode = (IModuleNode)this.modules.get(module);
        if (moduleNode == null) {
            moduleNode = this.createModule(module);
        }
        moduleNode.set(key, value);
    }

    @Override
    public synchronized void maintain() {
        boolean isDerty = false;
        LinkedList removeNames = new LinkedList();
        long ex = System.currentTimeMillis() - 1800000L;
        for (Map.Entry entry : this.modules.entrySet()) {
            IModuleNode module = (IModuleNode)entry.getValue();
            if (module.isDerty()) {
                isDerty = true;
                continue;
            }
            if (!module.isEmpty() && module.lastModified() >= ex) continue;
            removeNames.add(entry.getKey());
        }
        for (int i = 0; i < removeNames.size(); ++i) {
            this.modules.remove(removeNames.get(i));
        }
        if (isDerty) {
            this.flush();
        }
    }

    protected IModuleNode createModule(String moduleName) {
        IModuleNode rtv = this.createModule0(moduleName);
        assert (rtv != null) : "Create Module NOT OK!";
        this.modules.put(moduleName, rtv);
        this.missionModuleNames.remove(moduleName);
        this.service.moduleDefaultScopeInit(moduleName);
        return rtv;
    }

    protected abstract IModuleNode createModule0(String var1);

    protected IModuleNode initModule(String moduleName) {
        IModuleNode rtv = this.initModule0(moduleName);
        if (rtv != null) {
            this.modules.put(moduleName, rtv);
            this.missionModuleNames.remove(moduleName);
            this.service.moduleDefaultScopeInit(moduleName);
        } else {
            this.missionModuleNames.put(moduleName, moduleName);
        }
        return rtv;
    }

    protected abstract IModuleNode initModule0(String var1);
}

