/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.config.impl.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.impl.ConfigServiceImpl;
import com.kingdee.bos.config.impl.server.ServerDcScope;
import com.kingdee.bos.config.impl.server.ServerSessionScopeWrapper;
import com.kingdee.bos.config.impl.server.ServerUserScope;
import com.kingdee.bos.config.server.ConfigFacadeFactory;
import com.kingdee.bos.config.server.IConfigFacade;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ServerConfigServiceImpl
extends ConfigServiceImpl {
    private Map dcs = new HashMap();
    private Map users = new HashMap();
    private static final long USER_EXPRIOD = 3600000L;
    private static final long SCAN_INTERVAL = 2000L;
    private volatile long lastScan = 0L;

    public ServerSessionScopeWrapper getSessionScope(Context ctx) {
        return new ServerSessionScopeWrapper(ctx, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDcScope getDcScope(Context ctx) {
        String key = ctx.getAIS();
        ServerDcScope dc = (ServerDcScope)this.dcs.get(key);
        if (dc == null) {
            Map map = this.dcs;
            synchronized (map) {
                dc = (ServerDcScope)this.dcs.get(key);
                if (dc == null) {
                    dc = new ServerDcScope(ctx, this);
                    this.dcs.put(key, dc);
                }
            }
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerUserScope getUserScope(Context ctx) {
        String key = ctx.getUserName();
        ServerUserScope user = (ServerUserScope)this.users.get(key);
        if (user == null) {
            Map map = this.users;
            synchronized (map) {
                user = (ServerUserScope)this.users.get(key);
                if (user == null) {
                    user = new ServerUserScope(ctx, key, (ConfigServiceImpl)this);
                    this.users.put(key, user);
                }
            }
        }
        return user;
    }

    @Override
    public IConfigFacade getFacade() throws BOSException {
        throw new IllegalStateException("Please Incoke in CLIENT Side.");
    }

    @Override
    public synchronized IConfigFacade getFacade(Context ctx) throws BOSException {
        return ConfigFacadeFactory.getLocalInstance(ctx);
    }

    @Override
    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scan() {
        while (true) {
            try {
                this.installScope.maintain();
                this.instanceScope.maintain();
                for (ServerDcScope dc : this.dcs.keySet()) {
                    dc.maintain();
                }
                LinkedList removeUsers = new LinkedList();
                Map map = this.users;
                synchronized (map) {
                    for (Map.Entry entry : this.users.entrySet()) {
                        ServerUserScope user = (ServerUserScope)entry.getValue();
                        user.maintain();
                        if (user.lastModified() >= System.currentTimeMillis() - 3600000L) continue;
                        removeUsers.add(entry.getKey());
                    }
                    for (int i = 0; i < removeUsers.size(); ++i) {
                        this.users.remove(removeUsers.get(i));
                    }
                }
            }
            catch (Throwable removeUsers) {
                // empty catch block
            }
            this.lastScan = System.currentTimeMillis();
            long sleep = 2000L;
            do {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((sleep = sleep + this.lastScan - System.currentTimeMillis()) > 100L);
        }
    }
}

