/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.mdquery;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.mdquery.IMDQueryProvider;
import com.kingdee.bos.dao.mdquery.MDQueryException;
import com.kingdee.bos.dao.mdquery.MDQueryOption;
import com.kingdee.bos.dao.mdquery.MDQueryViewInfo;
import com.kingdee.bos.dao.mdquery.server.IMDQueryAccess;
import com.kingdee.bos.dao.mdquery.server.MDQueryAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import java.util.Hashtable;

public class MDQueryProvider
implements IMDQueryProvider {
    private final Context ctx;
    private final Context objectCtx;
    private final IMetaDataPK pk;
    private MDQueryViewInfo view;
    protected final Hashtable parameters;
    protected final MDQueryOption option;

    public MDQueryProvider(IMetaDataPK pk) {
        this(null, pk);
    }

    public MDQueryProvider(IMetaDataPK pk, Context objectCtx) {
        this.ctx = null;
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        this.objectCtx = objectCtx;
        this.pk = pk;
        this.view = new MDQueryViewInfo();
        this.parameters = new Hashtable();
        this.option = new MDQueryOption();
    }

    public MDQueryProvider(Context ctx, IMetaDataPK pk) {
        this.ctx = ctx;
        this.objectCtx = null;
        this.pk = pk;
        this.view = new MDQueryViewInfo();
        this.parameters = new Hashtable();
        this.option = new MDQueryOption();
    }

    @Override
    public void setParameter(int index, Object value) {
        this.parameters.put(index, value);
    }

    @Override
    public MDQueryOption getMDQueryOption() {
        return this.option;
    }

    @Override
    public MDQueryViewInfo getMDQueryView() {
        return this.view;
    }

    @Override
    public void setMDQueryView(MDQueryViewInfo view) {
        this.view = view;
    }

    @Override
    public OLAPDatabase executeMDQuery() throws MDQueryException {
        IMDQueryAccess mqa = MDQueryAccessFactory.getInstance(this.ctx, this.objectCtx);
        return mqa.getOLAPDatabase(this.pk, this.view, this.option);
    }

    @Override
    public void setQuerySQL(String sql) {
        throw new UnsupportedOperationException();
    }
}

