/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessEvent;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IDataAccessListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.FindedTooMuchRecordsException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.impl.BatchConnection;
import com.kingdee.bos.dao.ormapping.impl.IObjectCreator;
import com.kingdee.bos.dao.ormapping.impl.IObjectRemover;
import com.kingdee.bos.dao.ormapping.impl.IObjectUpdater;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ObjectCUDFactory;
import com.kingdee.bos.dao.ormapping.impl.ObjectCUDFactory2;
import com.kingdee.bos.dao.ormapping.impl.ObjectMatcher;
import com.kingdee.bos.dao.ormapping.impl.ObjectReader;
import com.kingdee.bos.dao.ormapping.impl.ObjectRemover;
import com.kingdee.bos.dao.ormapping.impl.ObjectUpdater;
import com.kingdee.bos.dao.ormapping.impl.RTFilter;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorBuilder;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfoCreator;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.rule.formula.FormulaExecuteException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.util.ThreadScopeLogger;
import com.kingdee.util.profile.ObjectProfileInterceptor;
import com.kingdee.util.profile.ProfileConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ORMappingDAO
implements IORMappingDAO {
    public static final String VISIBLE_FIELD = "_V";
    private final BOSObjectType bosType;
    private final Context ctx;
    protected final EntityObjectInfo bo;
    protected final SolutionInfo solution;
    protected final Connection cn;
    protected ArrayList<IDataAccessListener> listeners = null;
    private static Logger logger = Logger.getLogger(ORMappingDAO.class);
    private static final String LOG_ADD = " add: ";
    private static final String LOG_DELETE = " delete: ";
    private static final String LOG_UPDATE = " update: ";
    private static final String LOG_GETCOLLECTIOM = " getCollection: ";
    private static final String LOG_GETVALUE = " getValue: ";
    private static final String LOG_EXIST = " check exist: ";
    private static final String LOG_GETPKLIST = " get PK list: ";
    private List<BatchParam> batchParams = null;

    public static IORMappingDAO getInstance(BOSObjectType bosType, Context ctx, Connection cn) {
        return ORMappingDAO.getInstance(bosType, ctx, cn, null);
    }

    public static IORMappingDAO getInstance(BOSObjectType bosType, Context ctx, Connection cn, IMetaDataPK pk) {
        IORMappingDAO dao = new ORMappingDAO(bosType, ctx, cn, pk);
        if (ProfileConfig.getInstance().logORMapping) {
            dao = (IORMappingDAO)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{IORMappingDAO.class}, (InvocationHandler)new ObjectProfileInterceptor((Object)dao));
        }
        return dao;
    }

    public ORMappingDAO(BOSObjectType bosType, Context ctx, Connection cn) {
        this(bosType, ctx, cn, null);
    }

    public ORMappingDAO(BOSObjectType bosType, Context ctx, Connection cn, IMetaDataPK pk) {
        this.bosType = bosType;
        this.ctx = ctx;
        this.cn = cn;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        this.bo = pk != null ? loader.getEntity(pk) : loader.getEntity(bosType);
        this.solution = loader.getSolution();
    }

    public Context getContext() {
        return this.ctx;
    }

    public BOSObjectType getType() {
        return this.bosType;
    }

    public IObjectValue getValue(IObjectPK pk) throws DataAccessException {
        SelectorItemCollection selector = null;
        if (this.bo.getDefaultView() != null) {
            selector = this.bo.getDefaultView().getSelector();
        }
        return this.getValue(pk, selector);
    }

    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector) throws DataAccessException {
        return this.getValue(pk, selector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, boolean isBaseOnSelector) throws DataAccessException {
        FilterInfo filterData = ImplUtils.createFilter(this.bo, pk);
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getValue(IObjectPK pk, SelectorItemCollection selector,boolean isBaseOnSelector)";
                String comment = "start:";
                comment = comment + "PK:" + pk.toString() + ",SelectorItemCollection:" + selector + ",isBaseOnSelector:" + isBaseOnSelector;
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            IObjectValue iObjectValue = this.innerGetValue(filterData, selector, null, isBaseOnSelector);
            return iObjectValue;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValue(IObjectPK pk, SelectorItemCollection selector,boolean isBaseOnSelector)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public IObjectValue getValue(IObjectPK pk, SorterItemCollection sorter) throws DataAccessException {
        SelectorItemCollection selector = null;
        if (this.bo.getDefaultView() != null) {
            selector = this.bo.getDefaultView().getSelector();
        }
        return this.getValue(pk, selector, sorter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getValue(IObjectPK pk, SelectorItemCollection selector,\tSorterItemCollection sorter)";
                String comment = "start:";
                comment = comment + "PK:" + pk.toString() + ",SelectorItemCollection:" + selector;
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            FilterInfo filterData = ImplUtils.createFilter(this.bo, pk);
            IObjectValue iObjectValue = this.innerGetValue(filterData, selector, sorter, false);
            return iObjectValue;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValue(IObjectPK pk, SelectorItemCollection selector,SorterItemCollection sorter)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter, boolean isBaseOnSelector) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getValue(IObjectPK pk, SelectorItemCollection selector,SorterItemCollection sorter, boolean isBaseOnSelector)";
                String comment = "start:";
                comment = comment + "PK:" + pk.toString() + ",SelectorItemCollection:" + selector + "SorterItemCollection" + sorter + ",isBaseOnSelector:" + isBaseOnSelector;
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            FilterInfo filterData = ImplUtils.createFilter(this.bo, pk);
            IObjectValue iObjectValue = this.innerGetValue(filterData, selector, sorter, isBaseOnSelector);
            return iObjectValue;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValue(IObjectPK pk, SelectorItemCollection selector,SorterItemCollection sorter, boolean isBaseOnSelector)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public IObjectValue getValue(String oql) throws DataAccessException {
        return this.getValue(oql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectValue getValue(String oql, boolean isBaseOnSelector) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getValue(String oql, boolean isBaseOnSelector)";
                String comment = "start:";
                comment = comment + "OQL:" + oql.toString() + ",isBaseOnSelector:" + isBaseOnSelector;
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            EntityViewInfo view = EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.getType(), (EntityObjectInfo)this.bo);
            IObjectValue iObjectValue = this.innerGetValue(view, isBaseOnSelector);
            return iObjectValue;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValue(String oql, boolean isBaseOnSelector)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectValue getValue(EntityViewInfo view) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getValue(EntityViewInfo view)";
                String comment = "start:";
                comment = comment + "EntityViewInfo:" + view.toString();
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            IObjectValue iObjectValue = this.innerGetValue(view, view.isBaseOnSelector());
            return iObjectValue;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValue(EntityViewInfo view)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectValue getValue(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getValue(EntityViewInfo view, boolean isBaseOnSelector)";
                String comment = "start:";
                comment = comment + "EntityViewInfo:" + view.toString();
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            IObjectValue iObjectValue = this.innerGetValue(view, isBaseOnSelector);
            return iObjectValue;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValue(EntityViewInfo view, boolean isBaseOnSelector)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    private IObjectValue innerGetValue(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        assert (view != null);
        FilterInfo filterInfo = view.getFilter();
        String strFilter = filterInfo == null ? "" : filterInfo.toString();
        IObjectCollection selectData = this.innerGetCollection(view, null, isBaseOnSelector, false, 0, 0);
        this.checkSize(selectData, strFilter);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(LOG_GETVALUE + this.bo.getDisplayName()));
        }
        return selectData.getObject(0);
    }

    private IObjectValue innerGetValue(FilterInfo filterData, SelectorItemCollection selector, SorterItemCollection sorter, boolean isBaseOnSelector) throws DataAccessException {
        EntityViewInfo view = EntityViewInfo.getInstance((FilterInfo)filterData, (SelectorItemCollection)selector, (SorterItemCollection)sorter);
        return this.innerGetValue(view, isBaseOnSelector);
    }

    private IObjectValue innerGetValue(FilterInfo filterData, RTSelector rtSelector, SorterItemCollection sorter) throws DataAccessException {
        assert (rtSelector != null);
        EntityViewInfo view = EntityViewInfo.getInstance((FilterInfo)filterData, null, (SorterItemCollection)sorter);
        IObjectCollection selectData = this.innerGetCollection(view, rtSelector, false);
        this.checkSize(selectData, filterData.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(LOG_GETVALUE + this.bo.getDisplayName()));
        }
        return selectData.getObject(0);
    }

    @Override
    public IObjectValue getValueNoChild(IObjectPK pk) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "getValueNoChild";
                ThreadScopeLogger.loggerCommentItem((String)method, (String)"start getValueNoChild()", (long)startTime, (long)0L);
            }
            FilterInfo filterData = ImplUtils.createFilter(this.bo, pk);
            RTSelector selectorData = RTSelectorBuilder.buildSelfPropSelector(null, this.bo);
            assert (selectorData != null);
            try {
                IObjectCollection selectData = this.reader().selectNoChild(this.bo, filterData, null, selectorData);
                this.checkSize(selectData, filterData.toString());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(LOG_GETVALUE + this.bo.getDisplayName()));
                }
                IObjectValue iObjectValue = selectData.getObject(0);
                return iObjectValue;
            }
            catch (SQLException sqle) {
                throw new SQLAccessException("select data error." + sqle.getMessage(), sqle);
            }
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValueNoChild(IObjectPK pk)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    private final void checkSize(IObjectCollection selectData, String filter) throws DataAccessException {
        if (selectData.size() != 1) {
            String msg = this.bo.getName() + " " + Utils.removeSpecialTAG(filter, "~9^Nz");
            if (selectData.size() == 0) {
                throw new ObjectNotFoundException("MissingRecord:" + msg + "  AIS:" + this.ctx.getAIS() + " username:" + this.ctx.getUserName());
            }
            throw new InvalidEntityViewException("TooManyRecord:" + msg);
        }
    }

    public IObjectPK[] getPKList() throws DataAccessException {
        return this.getPKList(null, null);
    }

    @Override
    public IObjectPK[] getPKList(String oql) throws DataAccessException {
        EntityViewInfo view = EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo);
        return this.innerGetPKList(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectPK[] getPKList(FilterInfo filter, SorterItemCollection sorter) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            EntityViewInfo defaultView = new EntityViewInfo();
            defaultView.setFilter(filter);
            if (sorter != null && sorter.size() != 0) {
                defaultView.getSorter().addObjectCollection((IObjectCollection)sorter);
            }
            IObjectPK[] iObjectPKArray = this.innerGetPKList(defaultView);
            return iObjectPKArray;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getPKList(FilterInfo filter, SorterItemCollection sorter)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getPKList", (long)startTime, (long)endTime);
            }
        }
    }

    private IObjectPK[] innerGetPKList(EntityViewInfo defaultView) throws DataAccessException {
        RTSelector selector = RTSelectorBuilder.buildSelfPKSelector(this.ctx, this.bo);
        IObjectPK[] pks = null;
        try {
            pks = this.reader().getPkList(this.bo, defaultView.getFilter(), defaultView.getSorter(), selector);
        }
        catch (SQLException e) {
            logger.error((Object)("getPkList() occur error " + e));
            throw new DataAccessException((Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(LOG_GETPKLIST + this.bo.getDisplayName()));
        }
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection getCollection() throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getCollection()";
                String comment = "Start:";
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            EntityViewInfo view = this.bo.getDefaultView();
            IObjectCollection iObjectCollection = this.innerGetCollection(view, null, false);
            return iObjectCollection;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getCollection()";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getCollection", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public IObjectCollection getCollection(String oqlExpr) throws DataAccessException {
        return this.getCollection(oqlExpr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectCollection getCollection(String oql, boolean isBaseOnSelector) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getCollection(String oql, boolean isBaseOnSelector)";
                String comment = "start getCollection()";
                comment = comment + "oql:" + oql;
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            EntityViewInfo view = EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.getType(), (EntityObjectInfo)this.bo);
            IObjectCollection iObjectCollection = this.innerGetCollection(view, null, isBaseOnSelector);
            return iObjectCollection;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getCollection(String oql, boolean isBaseOnSelector)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getCollection", (long)startTime, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectCollection getCollection(EntityViewInfo view) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getCollection(EntityViewInfo view)";
                String comment = "Start:";
                comment = comment + view.toString();
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            IObjectCollection iObjectCollection = this.innerGetCollection(view, null, view.isBaseOnSelector());
            return iObjectCollection;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getCollection(EntityViewInfo view)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getCollection", (long)startTime, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectCollection getCollection(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getCollection(EntityViewInfo view,boolean isBaseOnSelector)";
                String comment = "start getCollection():";
                comment = comment + view.toString();
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            IObjectCollection iObjectCollection = this.innerGetCollection(view, null, isBaseOnSelector);
            return iObjectCollection;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getCollection(EntityViewInfo view,boolean isBaseOnSelector)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getCollection", (long)startTime, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectCollection getCollection(EntityViewInfo view, int start, int length) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "ORMappingDAO.getCollection(EntityViewInfo view)";
                String comment = "Start:";
                comment = comment + view.toString();
                ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
            }
            IObjectCollection iObjectCollection = this.innerGetCollection(view, null, view.isBaseOnSelector(), true, start, length);
            return iObjectCollection;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getCollection(EntityViewInfo view)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getCollection", (long)startTime, (long)endTime);
            }
        }
    }

    private IObjectCollection innerGetCollection(EntityViewInfo view, RTSelector rtSelector, boolean isBaseOnSelector) throws DataAccessException {
        return this.innerGetCollection(view, rtSelector, isBaseOnSelector, false, 0, 0);
    }

    private IObjectCollection innerGetCollection(EntityViewInfo view, RTSelector rtSelector, boolean isBaseOnSelector, boolean needPaging, int start, int length) throws DataAccessException {
        RTSelector sc;
        int topCount = Integer.MIN_VALUE;
        int offset = 0;
        if (view != null && view.getTopCount() > 0) {
            topCount = view.getTopCount();
        }
        if (view != null && view.getOffset() > 0) {
            offset = view.getOffset();
        }
        long startTime = System.currentTimeMillis();
        if (rtSelector != null) {
            sc = rtSelector;
        } else {
            SelectorItemCollection s;
            SelectorItemCollection selectorItemCollection = s = view == null ? null : view.getSelector();
            if (s == null || s.size() == 0) {
                RTSelector.checkSelector(this.bo.getFullName());
            }
            sc = isBaseOnSelector ? RTSelectorBuilder.buildSelfPropSelector(s, this.bo) : RTSelectorBuilder.buildSelfPropAndAllPKSelector(s, this.bo);
        }
        long endTime = System.currentTimeMillis();
        if (ThreadScopeLogger.isEnable()) {
            String method = "ORMappingDAO.innerGetCollection.buildSelector)";
            String comment = "Cost " + (endTime - startTime) + "ms.";
            ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
        }
        startTime = System.currentTimeMillis();
        IObjectCollection selectData = null;
        try {
            if (view != null) {
                ObjectReader reader;
                if (view.getEntryFilters() != null && view.getEntryFilters().size() != 0) {
                    reader = this.reader();
                    reader.setEntryPermCol(view.isEntryPermCol());
                    selectData = reader.selectByEntryWhere(this.bo, view.getFilter(), (IObjectCollection)view.getEntryFilters(), view.getSorter(), sc, topCount, offset);
                } else {
                    reader = this.reader();
                    reader.setEntryPermCol(view.isEntryPermCol());
                    selectData = needPaging ? reader.select(this.bo, view.getFilter(), view.getSorter(), sc, start, length) : reader.select(this.bo, view.getFilter(), view.getSorter(), sc, topCount, offset, true);
                }
                startTime = System.currentTimeMillis();
                if (!view.isEntryPermCol() && view.isIncludeExpressFilter()) {
                    this.filterWholeObject(selectData, view);
                }
                endTime = System.currentTimeMillis();
                if (ThreadScopeLogger.isEnable()) {
                    String method = "ORMappingDAO.innerGetCollection.perm)";
                    String comment = "Cost " + (endTime - startTime) + "ms.";
                    ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
                }
            } else {
                selectData = this.reader().select(this.bo, null, null, RTSelectorBuilder.buildSelfPropSelector(null, this.bo), topCount);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_GETCOLLECTIOM + this.bo.getDisplayName()));
            }
        }
        catch (FetchedTooMuchRowsException fe) {
            throw new FindedTooMuchRecordsException((Exception)((Object)fe));
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("select data error." + sqle.getMessage(), sqle);
        }
        selectData.intern();
        return selectData;
    }

    @Override
    public IObjectCollection getCollectionNoChild(EntityViewInfo view) throws DataAccessException {
        IObjectCollection selectData = null;
        long startTime = System.currentTimeMillis();
        try {
            if (ThreadScopeLogger.isEnable()) {
                String method = "getCollectionNoChild";
                ThreadScopeLogger.loggerCommentItem((String)method, (String)"start getCollectionNoChild()", (long)startTime, (long)0L);
            }
            selectData = view != null ? this.reader().selectNoChild(this.bo, view.getFilter(), view.getSorter(), RTSelectorBuilder.buildSelfPropAndAllPKSelector(view.getSelector(), this.bo)) : this.reader().selectNoChild(this.bo, null, null, RTSelectorBuilder.buildSelfPropAndAllPKSelector(null, this.bo));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_GETCOLLECTIOM + this.bo.getDisplayName()));
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException("select data error." + e.getMessage(), e);
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.addnew()";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getCollection", (long)startTime, (long)endTime);
            }
        }
        return selectData;
    }

    private void filterWholeObject(IObjectCollection selectData, EntityViewInfo view) throws DataAccessException {
        int size = selectData.size();
        for (int m = 0; m < size; ++m) {
            IObjectValue value = selectData.getObject(m);
            if (value == null) continue;
            this.processObjectValue(value, view);
        }
    }

    private void processObjectValue(IObjectValue value, EntityViewInfo view) throws DataAccessException {
        int n = view.getEntryFilters().size();
        for (int i = 0; i < n; ++i) {
            FilterInfo filter = view.getEntryFilters().get(i);
            IObjectCollection values = (IObjectCollection)value.get(filter.getEntryName());
            if (values == null || values.size() <= 0) continue;
            if (filter.getEntryFilterType().equals((Object)EntryFilterType.ENTRYALLWHERE)) {
                this.processObjectCollectionForAll(values, filter, view);
                continue;
            }
            if (filter.getEntryFilterType().equals((Object)EntryFilterType.ENTRYANYWHERE)) {
                this.processObjectCollectionForAny(values, filter, view);
                continue;
            }
            this.recursionProcessObjectValue(true, values, view);
        }
    }

    private void processObjectCollectionForAny(IObjectCollection cols, FilterInfo filter, EntityViewInfo view) throws DataAccessException {
        boolean flag = false;
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue value = cols.getObject(i);
            if (!this.accept(value, filter)) continue;
            flag = true;
            break;
        }
        this.recursionProcessObjectValue(flag, cols, view);
    }

    private void processObjectCollectionForAll(IObjectCollection cols, FilterInfo filter, EntityViewInfo view) throws DataAccessException {
        boolean flag = true;
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue value = cols.getObject(i);
            if (this.accept(value, filter)) continue;
            flag = false;
            break;
        }
        this.recursionProcessObjectValue(flag, cols, view);
    }

    private void recursionProcessObjectValue(boolean flag, IObjectCollection cols, EntityViewInfo view) throws DataAccessException {
        if (flag) {
            int n = cols.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue value = cols.getObject(i);
                this.processObjectValue(value, view);
            }
        } else {
            cols.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK addnew(IObjectValue value) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            IObjectPK iObjectPK = this.innerAddnew(null, value);
            return iObjectPK;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.addnew(IObjectValue value)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"addnew", (long)startTime, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addnew(IObjectPK pk, IObjectValue value) throws DataAccessException {
        if (pk == null) {
            throw new IllegalArgumentException("parameter 'pk' can't be null");
        }
        long startTime = System.currentTimeMillis();
        try {
            ImplUtils.setPKValue(this.bo, pk, value);
            this.innerAddnew(pk, value);
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.addnew(IObjectPK pk, IObjectValue value)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"addnew", (long)startTime, (long)endTime);
            }
        }
    }

    private IObjectPK innerAddnew(IObjectPK pk, IObjectValue value) throws DataAccessException {
        IObjectPK objPk = pk;
        try {
            this.fireEvent(0, objPk, value, value);
            IObjectCreator oc = ObjectCUDFactory2.getObjectCreator(this.ctx, this.cn, this.solution);
            objPk = oc.create(this.bo, value);
            ObjectCUDFactory2.close(oc);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_ADD + this.bo.getDisplayName()));
            }
            IObjectPK iObjectPK = objPk;
            return iObjectPK;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("create data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
        }
        catch (BOSException fee) {
            throw new DataAccessException((Throwable)fee);
        }
        finally {
            this.fireEvent(1, objPk, value, value);
        }
    }

    @Override
    public void updatePartial(IObjectValue value, SelectorItemCollection selector) throws DataAccessException {
        try {
            this.fireEvent(3, value);
            IObjectUpdater updater = ObjectCUDFactory2.getObjectUpdater(this.ctx, this.cn, this.solution);
            updater.updatePartial(this.bo, value, selector);
            ObjectCUDFactory2.close(updater);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_UPDATE + this.bo.getDisplayName()));
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("update data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
        }
        catch (BOSException fee) {
            throw new DataAccessException((Throwable)fee);
        }
        finally {
            this.fireEvent(3, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IObjectPK pk, IObjectValue value) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            IObjectValue oldValue = this.innerGetValueForUpdate(pk);
            try {
                this.fireEvent(3, pk, oldValue, value);
                IObjectUpdater updater = ObjectCUDFactory2.getObjectUpdater(this.ctx, this.cn, this.solution);
                updater.update(this.bo, value, oldValue);
                ObjectCUDFactory2.close(updater);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(LOG_UPDATE + this.bo.getDisplayName()));
                }
            }
            catch (SQLException sqle) {
                throw new SQLAccessException("update data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
            }
            catch (BOSException fee) {
                throw new DataAccessException((Throwable)fee);
            }
            finally {
                this.fireEvent(3, pk, oldValue, value);
            }
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.update(IObjectPK pk, IObjectValue value)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"update", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public void updateBigObject(IObjectPK pk, IObjectValue value) throws DataAccessException {
        IObjectValue oldValue = this.innerGetValueForUpdate(pk);
        try {
            this.fireEvent(3, pk, oldValue, value);
            ObjectUpdater updater = ObjectCUDFactory.getObjectUpdater(this.ctx, this.cn, this.solution);
            updater.updateBigObject(this.bo, value, oldValue);
            ObjectCUDFactory.close(updater);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_UPDATE + this.bo.getDisplayName()));
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("update data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
        }
        catch (FormulaExecuteException fee) {
            throw new DataAccessException((Throwable)fee);
        }
        finally {
            this.fireEvent(3, pk, oldValue, value);
        }
    }

    private IObjectValue innerGetValueForUpdate(IObjectPK pk) throws DataAccessException {
        if (this.bo.hasCompositeProp()) {
            return this.innerGetValue(ImplUtils.createFilter(this.bo, pk), RTSelectorBuilder.buildAllPKSelector(this.ctx, this.bo), null);
        }
        IObjectValue ov = Utils.newObjectValueInstance(this.bo);
        ImplUtils.setPKValue(this.bo, pk, ov);
        return ov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(IObjectPK pk) throws DataAccessException {
        if (pk == null) {
            throw new IllegalArgumentException("parameter 'pk' cannot be null.");
        }
        long startTime = System.currentTimeMillis();
        try {
            RTFilter filterData = null;
            filterData = this.bo.hasOneToOneCompsition() ? new RTFilter(this.getValue(pk)) : new RTFilter(this.bo, pk);
            try {
                this.fireEvent(4, pk, null, null);
                IObjectRemover remover = ObjectCUDFactory2.getObjectRemover(this.ctx, this.cn, this.solution);
                remover.delete(this.bo, (IObjectValue)filterData);
                ObjectCUDFactory2.close(remover);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(LOG_DELETE + this.bo.getDisplayName()));
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException("delete data error." + e.getMessage(), e);
            }
            catch (BOSException e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
            finally {
                this.fireEvent(5, pk, null, null);
            }
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "delete(IObjectPK pk)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"delete", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public IObjectPK[] delete(String oql) throws DataAccessException {
        return this.delete(EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo).getFilter());
    }

    @Override
    public IObjectPK[] delete(FilterInfo filter) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            IObjectPK[] arrayPK;
            block9: {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                arrayPK = this.innerGetPKList(view);
                try {
                    if (filter != null && filter.getFilterItems().size() != 0) break block9;
                    IObjectPK[] iObjectPKArray = arrayPK;
                    return iObjectPKArray;
                }
                catch (SQLException e) {
                    throw new SQLAccessException("delete data error." + e.getMessage(), e);
                }
            }
            ObjectRemover remover = ObjectCUDFactory.getObjectRemover(this.ctx, this.cn, this.solution);
            remover.deleteBySQL(this.bo, filter);
            ObjectCUDFactory.close(remover);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_DELETE + this.bo.getDisplayName()));
            }
            IObjectPK[] iObjectPKArray = arrayPK;
            return iObjectPKArray;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.delete(FilterInfo filter)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"delete", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public void delete(IObjectPK[] arrayPK) throws DataAccessException {
        if (arrayPK == null || arrayPK.length == 0) {
            return;
        }
        for (int i = arrayPK.length - 1; i >= 0; --i) {
            this.delete(arrayPK[i]);
        }
    }

    public boolean exists(IObjectPK pk) throws DataAccessException {
        return this.exists(ImplUtils.createFilter(this.bo, pk));
    }

    @Override
    public boolean exists(String oql) throws DataAccessException {
        return this.exists(EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo).getFilter());
    }

    @Override
    public boolean exists(FilterInfo filterInfo) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            boolean ex = this.reader().exist(this.bo, filterInfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_EXIST + this.bo.getDisplayName()));
            }
            boolean bl = ex;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.exists(FilterInfo filterInfo)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"exists", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public int getCount(String oql) throws DataAccessException {
        return this.getCount(EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo).getFilter());
    }

    @Override
    public int getCount(FilterInfo filterInfo) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.reader().getCount(this.bo, filterInfo);
            return n;
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getCount(FilterInfo filterInfo)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getCount", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public boolean accept(IObjectPK pk, FilterInfo rule) throws DataAccessException {
        ObjectMatcher.ObjectPattern pattern = new ObjectMatcher.ObjectPattern(rule);
        return this.matcher().match(pk, pattern);
    }

    @Override
    public boolean accept(IObjectValue value, EntityViewInfo view) throws DataAccessException {
        ObjectMatcher.ObjectPattern pattern = new ObjectMatcher.ObjectPattern(view.getFilter(), view.getEntryFilters());
        return this.matcher().match(value, pattern);
    }

    @Override
    public boolean accept(IObjectValue value, FilterInfo rule) throws DataAccessException {
        ObjectMatcher.ObjectPattern pattern = new ObjectMatcher.ObjectPattern(rule);
        return this.matcher().match(value, pattern);
    }

    @Override
    public boolean accept(IObjectPK pk, FilterInfo rule, boolean isExcludeRule) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    private final ObjectMatcher matcher() {
        return new ObjectMatcher(this.ctx, this.cn, this.solution, this.bo);
    }

    private final void batchParamNullCheck() {
        if (this.batchParams == null) {
            this.batchParams = new ArrayList<BatchParam>();
        }
    }

    @Override
    public void addNewBatch(IObjectValue value) throws DataAccessException {
        if (value == null) {
            return;
        }
        this.batchParamNullCheck();
        this.batchParams.add(BatchParam.addnew(value));
    }

    @Override
    public void updateBatch(IObjectPK pk, IObjectValue value) throws DataAccessException {
        if (pk == null || value == null) {
            return;
        }
        this.batchParamNullCheck();
        this.batchParams.add(BatchParam.update(pk, value));
    }

    @Override
    public void updatePartialBatch(IObjectPK pk, IObjectValue value, SelectorItemCollection selector) throws DataAccessException {
        if (pk == null || value == null) {
            return;
        }
        this.batchParamNullCheck();
        this.batchParams.add(BatchParam.updatePartial(pk, value, selector));
    }

    @Override
    public void deleteBatch(IObjectPK pk) throws DataAccessException {
        if (pk == null) {
            return;
        }
        this.batchParamNullCheck();
        this.batchParams.add(BatchParam.delete(pk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectPK[] executeBatchWithReturn() throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            IObjectPK[] method;
            if (ThreadScopeLogger.isEnable()) {
                method = "executeBatchWithReturn";
                ThreadScopeLogger.loggerCommentItem((String)method, (String)"start executeBatch()", (long)startTime, (long)0L);
            }
            if (this.batchParams == null || this.batchParams.size() == 0) {
                method = new IObjectPK[]{};
                return method;
            }
            IObjectPK[] rtn = new IObjectPK[this.batchParams.size()];
            BatchConnection batchCn = BatchConnection.getInstance(this.cn);
            IObjectCreator creator = null;
            IObjectRemover remover = null;
            IObjectUpdater updater = null;
            try {
                int n = this.batchParams.size();
                for (int i = 0; i < n; ++i) {
                    BatchParam param = this.batchParams.get(i);
                    if (param.type == 0) {
                        IObjectPK rtn1;
                        if (creator == null) {
                            creator = ObjectCUDFactory2.getObjectCreator(this.ctx, batchCn, this.solution);
                        }
                        rtn[i] = rtn1 = creator.create(this.bo, param.objectValue);
                        continue;
                    }
                    if (param.type == 1) {
                        if (updater == null) {
                            updater = ObjectCUDFactory2.getObjectUpdater(this.ctx, batchCn, this.solution);
                        }
                        if (param.selector == null) {
                            IObjectValue oldValue = this.innerGetValueForUpdate(param.objectPK);
                            updater.update(this.bo, param.objectValue, oldValue);
                            rtn[i] = param.objectPK;
                            continue;
                        }
                        updater.updatePartial(this.bo, param.objectValue, param.selector);
                        rtn[i] = param.objectPK;
                        continue;
                    }
                    if (param.type == 2) {
                        if (remover == null) {
                            remover = ObjectCUDFactory2.getObjectRemover(this.ctx, batchCn, this.solution);
                        }
                        RTFilter filterData = null;
                        filterData = this.bo.hasOneToOneCompsition() ? new RTFilter(this.getValue(param.objectPK)) : new RTFilter(this.bo, param.objectPK);
                        remover.delete(this.bo, (IObjectValue)filterData);
                        rtn[i] = param.objectPK;
                        continue;
                    }
                    assert (false);
                }
                batchCn.closeStatements();
                this.batchParams = null;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new DataAccessException((Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new DataAccessException((Throwable)JDBCExceptionHandler.convertException((SQLException)e));
            }
            IObjectPK[] iObjectPKArray = rtn;
            return iObjectPKArray;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.executeBatchWithReturn()";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"executeBatch", (long)startTime, (long)endTime);
            }
        }
    }

    @Override
    public void executeBatch() throws DataAccessException {
        this.executeBatchWithReturn();
    }

    public void addEventListener(IDataAccessListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
    }

    public IDataAccessListener[] getEventListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        return this.listeners.toArray(new IDataAccessListener[this.listeners.size()]);
    }

    public void removeEventListener(IDataAccessListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireEvent(int actionType, IObjectPK pk, IObjectValue oldValue, IObjectValue newValue) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            DataAccessEvent ev = new DataAccessEvent(actionType, (Object)this, pk, oldValue, newValue, this.ctx, this.bosType);
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                this.listeners.get(i).perform(ev);
            }
        }
    }

    private void fireEvent(int actionType, IObjectValue newValue) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            DataAccessEvent ev = new DataAccessEvent(actionType, (Object)this, newValue, this.ctx, this.bosType);
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                this.listeners.get(i).perform(ev);
            }
        }
    }

    private final ObjectReader reader() {
        return new ObjectReader(this.ctx, this.cn, this.solution);
    }

    @Override
    public String getSql(EntityViewInfo view) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            block13: {
                ObjectReader reader;
                SelectorItemCollection s;
                FilterInfo filterInfo;
                if (ThreadScopeLogger.isEnable()) {
                    String method = "ORMappingDAO.getSql(EntityViewInfo view)";
                    String comment = "start:";
                    comment = comment + "EntityViewInfo:" + view.toString();
                    ThreadScopeLogger.loggerCommentItem((String)method, (String)comment, (long)startTime, (long)0L);
                }
                String strFilter = (filterInfo = view.getFilter()) == null ? "" : filterInfo.toString();
                SelectorItemCollection selectorItemCollection = s = view == null ? null : view.getSelector();
                if (s == null || s.size() == 0) {
                    RTSelector.checkSelector(this.bo.getFullName());
                }
                RTSelector sc = RTSelectorBuilder.buildSelfPropSelector(s, this.bo);
                try {
                    if (view == null) break block13;
                    if (view.getEntryFilters() != null && view.getEntryFilters().size() != 0) {
                        ObjectReader reader2 = this.reader();
                        reader2.setEntryPermCol(view.isEntryPermCol());
                        String string = reader2.getSql(this.bo, view.getFilter(), (IObjectCollection)view.getEntryFilters(), view.getSorter(), sc, Integer.MIN_VALUE);
                        return string;
                    }
                    reader = this.reader();
                }
                catch (FetchedTooMuchRowsException fe) {
                    throw new FindedTooMuchRecordsException((Exception)((Object)fe));
                }
                catch (SQLException sqle) {
                    throw new SQLAccessException("select data error." + sqle.getMessage(), sqle);
                }
                reader.setEntryPermCol(view.isEntryPermCol());
                String string = reader.getSql(this.bo, view.getFilter(), (IObjectCollection)view.getEntryFilters(), view.getSorter(), sc, Integer.MIN_VALUE);
                return string;
            }
            String reader = this.reader().getSql(this.bo, null, null, null, RTSelectorBuilder.buildSelfPropSelector(null, this.bo), Integer.MIN_VALUE);
            return reader;
        }
        finally {
            if (ThreadScopeLogger.isEnable()) {
                long endTime = System.currentTimeMillis();
                String method = "ORMappingDAO.getValue(EntityViewInfo view)";
                ThreadScopeLogger.loggerOrmappingItem((String)method, (String)"getValue", (long)startTime, (long)endTime);
            }
        }
    }

    private static class BatchParam {
        public final int type;
        public static final int ADDNEW = 0;
        public static final int UPDATE = 1;
        public static final int DELETE = 2;
        public final IObjectPK objectPK;
        public final IObjectValue objectValue;
        public final SelectorItemCollection selector;

        private BatchParam(int type, IObjectPK pk, IObjectValue value) {
            this.type = type;
            this.objectPK = pk;
            this.objectValue = value;
            this.selector = null;
        }

        private BatchParam(int type, IObjectPK pk, IObjectValue value, SelectorItemCollection selector) {
            this.type = type;
            this.objectPK = pk;
            this.objectValue = value;
            this.selector = selector;
        }

        public static BatchParam addnew(IObjectValue value) {
            return new BatchParam(0, null, value);
        }

        public static BatchParam update(IObjectPK pk, IObjectValue value) {
            return new BatchParam(1, pk, value);
        }

        public static BatchParam updatePartial(IObjectPK pk, IObjectValue value, SelectorItemCollection selector) {
            return new BatchParam(1, pk, value, selector);
        }

        public static BatchParam delete(IObjectPK pk) {
            return new BatchParam(2, pk, null);
        }
    }
}

